/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert;

import com.basho.riak.client.convert.RiakKey;
import com.basho.riak.client.convert.RiakLinks;
import com.basho.riak.client.convert.RiakUsermeta;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializerModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakBeanSerializerModifier
extends BeanSerializerModifier {
    private static final RiakBeanSerializerModifier INSTANCE = new RiakBeanSerializerModifier();

    private RiakBeanSerializerModifier() {
    }

    public static RiakBeanSerializerModifier getInstance() {
        return INSTANCE;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        LinkedList<BeanPropertyWriter> keptProperties = new LinkedList<BeanPropertyWriter>();
        for (BeanPropertyWriter w : beanProperties) {
            if (!this.keepProperty(w)) continue;
            keptProperties.add(w);
        }
        return keptProperties;
    }

    private boolean keepProperty(BeanPropertyWriter beanPropertyWriter) {
        RiakKey key = null;
        RiakUsermeta usermeta = null;
        RiakLinks links = null;
        AnnotatedMember member = beanPropertyWriter.getMember();
        if (member instanceof AnnotatedField) {
            key = (RiakKey)beanPropertyWriter.getAnnotation(RiakKey.class);
            usermeta = (RiakUsermeta)beanPropertyWriter.getAnnotation(RiakUsermeta.class);
            links = (RiakLinks)beanPropertyWriter.getAnnotation(RiakLinks.class);
        } else {
            Class clazz = member.getDeclaringClass();
            try {
                Field field = clazz.getDeclaredField(beanPropertyWriter.getName());
                key = field.getAnnotation(RiakKey.class);
                usermeta = field.getAnnotation(RiakUsermeta.class);
                links = field.getAnnotation(RiakLinks.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        return key == null && usermeta == null && links == null;
    }
}

