/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.LinkWalkStep;
import com.basho.riak.client.query.WalkResult;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.query.LinkWalkSpec;
import java.io.IOException;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkWalk
implements RiakOperation<WalkResult> {
    private final RawClient client;
    private final String startBucket;
    private final String startKey;
    private final LinkedList<LinkWalkStep> steps = new LinkedList();

    public LinkWalk(RawClient client, IRiakObject startObject) {
        this.client = client;
        this.startBucket = startObject.getBucket();
        this.startKey = startObject.getKey();
    }

    @Override
    public WalkResult execute() throws RiakException {
        try {
            return this.client.linkWalk(new LinkWalkSpec(this.steps, this.startBucket, this.startKey));
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkWalk addStep(String bucket, String tag, LinkWalkStep.Accumulate accumulate) {
        LinkedList<LinkWalkStep> linkedList = this.steps;
        synchronized (linkedList) {
            this.steps.add(new LinkWalkStep(bucket, tag, accumulate));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkWalk addStep(String bucket, String tag, boolean keep) {
        LinkedList<LinkWalkStep> linkedList = this.steps;
        synchronized (linkedList) {
            this.steps.add(new LinkWalkStep(bucket, tag, keep));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkWalk addStep(String bucket, String tag) {
        LinkedList<LinkWalkStep> linkedList = this.steps;
        synchronized (linkedList) {
            this.steps.add(new LinkWalkStep(bucket, tag));
        }
        return this;
    }
}

