/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw;

import com.basho.riak.client.RiakException;
import com.basho.riak.client.raw.query.MapReduceTimeoutException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONErrorParser {
    private static final String PARSE_ERROR = ". Additionally, an error was thrown parsing the error response.";
    private static final String ERROR_KEY = "error";
    private static final String TIMEOUT_VALUE = "timeout";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static RiakException parseException(String json) {
        RiakException ex = null;
        try {
            Map<String, String> exceptionData = JSONErrorParser.parseError(json);
            ex = JSONErrorParser.isTimeoutError(exceptionData) ? new MapReduceTimeoutException() : new RiakException(json);
        }
        catch (IOException e) {
            ex = new RiakException(json + PARSE_ERROR, e);
        }
        return ex;
    }

    public static boolean isTimeoutException(String json) {
        try {
            Map<String, String> exceptionData = JSONErrorParser.parseError(json);
            return JSONErrorParser.isTimeoutError(exceptionData);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static final Map<String, String> parseError(String json) throws IOException {
        return (Map)objectMapper.readValue(json, TypeFactory.mapType(HashMap.class, String.class, String.class));
    }

    private static boolean isTimeoutError(Map<String, String> exceptionData) {
        return exceptionData.containsKey(ERROR_KEY) && TIMEOUT_VALUE.equals(exceptionData.get(ERROR_KEY));
    }
}

