/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.raw.config.Configuration;

public class PBClientConfig
implements Configuration {
    private final int socketBufferSizeKb;
    private final String host;
    private final int port;
    private final int poolSize;
    private final int initialPoolSize;
    private final long idleConnectionTTLMillis;
    private final long connectionWaitTimeoutMillis;

    private PBClientConfig(int socketBufferSizeKb, String host, int port, int poolSize, int initialPoolSize, long idleConnectionTTLMillis, long connectionWaitTimeoutMillis) {
        this.socketBufferSizeKb = socketBufferSizeKb;
        this.host = host;
        this.port = port;
        this.poolSize = poolSize;
        this.initialPoolSize = initialPoolSize;
        this.idleConnectionTTLMillis = idleConnectionTTLMillis;
        this.connectionWaitTimeoutMillis = connectionWaitTimeoutMillis;
    }

    public static PBClientConfig defaults() {
        return new Builder().build();
    }

    public int getSocketBufferSizeKb() {
        return this.socketBufferSizeKb;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public long getIdleConnectionTTLMillis() {
        return this.idleConnectionTTLMillis;
    }

    public long getConnectionWaitTimeoutMillis() {
        return this.connectionWaitTimeoutMillis;
    }

    public static final class Builder {
        private int socketBufferSizeKb = 16;
        private String host = "127.0.0.1";
        private int port = 8097;
        private int poolSize = 0;
        private int initialPoolSize = 0;
        private long idleConnectionTTLMillis = 1000L;
        private long connectionWaitTimeoutMillis = 1000L;

        public PBClientConfig build() {
            return new PBClientConfig(this.socketBufferSizeKb, this.host, this.port, this.poolSize, this.initialPoolSize, this.idleConnectionTTLMillis, this.connectionWaitTimeoutMillis);
        }

        public static Builder from(PBClientConfig copyConfig) {
            Builder b = new Builder();
            b.socketBufferSizeKb = copyConfig.socketBufferSizeKb;
            b.host = copyConfig.host;
            b.port = copyConfig.port;
            b.poolSize = copyConfig.poolSize;
            b.initialPoolSize = copyConfig.initialPoolSize;
            b.idleConnectionTTLMillis = copyConfig.idleConnectionTTLMillis;
            b.connectionWaitTimeoutMillis = copyConfig.connectionWaitTimeoutMillis;
            return new Builder();
        }

        public Builder withSocketBufferSizeKb(int socketBufferSizeKb) {
            this.socketBufferSizeKb = socketBufferSizeKb;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public Builder withInitialPoolSize(int initialPoolSize) {
            this.initialPoolSize = initialPoolSize;
            return this;
        }

        public Builder withIdleConnectionTTLMillis(long idleConnectionTTLMillis) {
            this.idleConnectionTTLMillis = idleConnectionTTLMillis;
            return this;
        }

        public Builder withConnectionTimeoutMillis(long connectionTimeoutMillis) {
            this.connectionWaitTimeoutMillis = connectionTimeoutMillis;
            return this;
        }
    }
}

