/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import com.basho.riak.client.RiakConfig;
import com.basho.riak.client.RiakObject;
import com.basho.riak.client.request.RequestMeta;
import com.basho.riak.client.response.DefaultHttpResponse;
import com.basho.riak.client.response.RiakExceptionHandler;
import com.basho.riak.client.response.RiakIORuntimeException;
import com.basho.riak.client.response.RiakResponseRuntimeException;
import com.basho.riak.client.response.StreamHandler;
import com.basho.riak.client.util.CharsetUtils;
import com.basho.riak.client.util.ClientUtils;
import com.basho.riak.client.util.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

@Deprecated
public class ClientHelper {
    private RiakConfig config;
    private HttpClient httpClient;
    private String clientId = null;
    private RiakExceptionHandler exceptionHandler = null;

    public ClientHelper(RiakConfig config, String clientId) {
        this.config = config;
        this.httpClient = ClientUtils.newHttpClient(config);
        this.setClientId(clientId);
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public byte[] getClientId() {
        return Base64.decodeBase64((byte[])CharsetUtils.utf8StringToBytes(this.clientId));
    }

    public void setClientId(String clientId) {
        this.clientId = clientId != null ? ClientUtils.encodeClientId(clientId) : ClientUtils.randomClientId();
    }

    public com.basho.riak.client.response.HttpResponse setBucketSchema(String bucket, JSONObject schema, RequestMeta meta) {
        if (schema == null) {
            schema = new JSONObject();
        }
        if (meta == null) {
            meta = new RequestMeta();
        }
        meta.setHeader("accept", "application/json");
        HttpPut put = new HttpPut(ClientUtils.makeURI(this.config, bucket));
        ByteArrayEntity entity = new ByteArrayEntity(CharsetUtils.utf8StringToBytes(schema.toString()));
        entity.setContentType("application/json");
        put.setEntity((HttpEntity)entity);
        return this.executeMethod(bucket, null, (HttpRequestBase)put, meta);
    }

    public com.basho.riak.client.response.HttpResponse getBucketSchema(String bucket, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("keys") == null) {
            meta.setQueryParam("keys", "false");
        }
        return this.listBucket(bucket, meta, false);
    }

    public com.basho.riak.client.response.HttpResponse listBuckets() {
        RequestMeta meta = new RequestMeta();
        meta.setQueryParam("buckets", "true");
        HttpGet get = new HttpGet(this.config.getUrl());
        return this.executeMethod(null, null, (HttpRequestBase)get, meta);
    }

    public com.basho.riak.client.response.HttpResponse listBucket(String bucket, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("keys") == null) {
            if (streamResponse) {
                meta.setQueryParam("keys", "stream");
            } else {
                meta.setQueryParam("keys", "true");
            }
        }
        if (meta.getHeader("content-type") == null) {
            meta.setHeader("content-type", "application/json");
        }
        if (meta.getHeader("accept") == null) {
            meta.setHeader("accept", "application/json");
        }
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket));
        return this.executeMethod(bucket, null, (HttpRequestBase)get, meta, streamResponse);
    }

    public com.basho.riak.client.response.HttpResponse store(RiakObject object, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getClientId() == null) {
            meta.setClientId(this.clientId);
        }
        if (meta.getHeader("connection") == null) {
            meta.setHeader("connection", "keep-alive");
        }
        String bucket = object.getBucket();
        String key = object.getKey();
        String url = ClientUtils.makeURI(this.config, bucket, key);
        HttpPut put = new HttpPut(url);
        object.writeToHttpMethod((HttpRequestBase)put);
        return this.executeMethod(bucket, key, (HttpRequestBase)put, meta);
    }

    public com.basho.riak.client.response.HttpResponse fetchMeta(String bucket, String key, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("r") == null) {
            meta.setQueryParam("r", Constants.DEFAULT_R.toString());
        }
        HttpHead head = new HttpHead(ClientUtils.makeURI(this.config, bucket, key));
        return this.executeMethod(bucket, key, (HttpRequestBase)head, meta);
    }

    public com.basho.riak.client.response.HttpResponse fetch(String bucket, String key, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("r") == null) {
            meta.setQueryParam("r", Constants.DEFAULT_R.toString());
        }
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, key));
        return this.executeMethod(bucket, key, (HttpRequestBase)get, meta, streamResponse);
    }

    public com.basho.riak.client.response.HttpResponse fetch(String bucket, String key, RequestMeta meta) {
        return this.fetch(bucket, key, meta, false);
    }

    public boolean stream(String bucket, String key, StreamHandler handler, RequestMeta meta) throws IOException {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("r") == null) {
            meta.setQueryParam("r", Constants.DEFAULT_R.toString());
        }
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, key));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            boolean result = true;
            if (handler != null) {
                result = handler.process(bucket, key, response.getStatusLine().getStatusCode(), ClientUtils.asHeaderMap(response.getAllHeaders()), entity.getContent(), response);
            }
            EntityUtils.consume((HttpEntity)entity);
            return result;
        }
        catch (IOException e) {
            get.abort();
            throw e;
        }
    }

    public com.basho.riak.client.response.HttpResponse delete(String bucket, String key, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        String url = ClientUtils.makeURI(this.config, bucket, key);
        HttpDelete delete = new HttpDelete(url);
        return this.executeMethod(bucket, key, (HttpRequestBase)delete, meta);
    }

    public com.basho.riak.client.response.HttpResponse walk(String bucket, String key, String walkSpec, RequestMeta meta) {
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, key, walkSpec));
        return this.executeMethod(bucket, key, (HttpRequestBase)get, meta);
    }

    public com.basho.riak.client.response.HttpResponse mapReduce(String job, RequestMeta meta) {
        HttpPost post = new HttpPost(this.config.getMapReduceUrl());
        try {
            StringEntity entity = new StringEntity(job, "application/json", CharsetUtils.UTF_8.name());
            post.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("StringEntity should always support UTF-8 charset", e);
        }
        return this.executeMethod(null, null, (HttpRequestBase)post, meta);
    }

    public RiakExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(RiakExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public com.basho.riak.client.response.HttpResponse toss(RiakIORuntimeException e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
            return new DefaultHttpResponse(null, null, 0, null, null, null, null, null);
        }
        throw e;
    }

    public com.basho.riak.client.response.HttpResponse toss(RiakResponseRuntimeException e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
            return new DefaultHttpResponse(null, null, 0, null, null, null, null, null);
        }
        throw e;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public RiakConfig getConfig() {
        return this.config;
    }

    com.basho.riak.client.response.HttpResponse executeMethod(String bucket, String key, HttpRequestBase httpMethod, RequestMeta meta, boolean streamResponse) {
        if (meta != null) {
            Map<String, String> headers = meta.getHeaders();
            for (String header : headers.keySet()) {
                httpMethod.addHeader(header, headers.get(header));
            }
            Map<String, String> queryParams = meta.getQueryParamMap();
            if (!queryParams.isEmpty()) {
                URI newURI;
                URI originalURI = httpMethod.getURI();
                List currentQuery = URLEncodedUtils.parse((URI)originalURI, (String)CharsetUtils.UTF_8.name());
                LinkedList<BasicNameValuePair> newQuery = new LinkedList<BasicNameValuePair>(currentQuery);
                for (Map.Entry<String, String> qp : queryParams.entrySet()) {
                    newQuery.add(new BasicNameValuePair(qp.getKey(), qp.getValue()));
                }
                try {
                    newURI = URIUtils.createURI((String)originalURI.getScheme(), (String)originalURI.getHost(), (int)originalURI.getPort(), (String)originalURI.getPath(), (String)URLEncodedUtils.format(newQuery, (String)"UTF-8"), null);
                }
                catch (URISyntaxException e) {
                    throw new RiakIORuntimeException(e);
                }
                httpMethod.setURI(newURI);
            }
        }
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpMethod);
            int status = 0;
            if (response.getStatusLine() != null) {
                status = response.getStatusLine().getStatusCode();
            }
            Map<String, String> headers = ClientUtils.asHeaderMap(response.getAllHeaders());
            byte[] body = null;
            InputStream stream = null;
            HttpEntity entity = response.getEntity();
            if (streamResponse) {
                stream = entity.getContent();
            } else if (null != entity) {
                body = EntityUtils.toByteArray((HttpEntity)entity);
            }
            if (!streamResponse) {
                EntityUtils.consume((HttpEntity)entity);
            }
            return new DefaultHttpResponse(bucket, key, status, headers, body, stream, response, httpMethod);
        }
        catch (IOException e) {
            httpMethod.abort();
            return this.toss(new RiakIORuntimeException(e));
        }
    }

    com.basho.riak.client.response.HttpResponse executeMethod(String bucket, String key, HttpRequestBase httpMethod, RequestMeta meta) {
        return this.executeMethod(bucket, key, httpMethod, meta, false);
    }
}

