/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RPB;

public class BucketProperties {
    private Boolean allowMult;
    private Integer nValue;

    public void init(RPB.RpbGetBucketResp resp) {
        if (resp.hasProps()) {
            RPB.RpbBucketProps props = resp.getProps();
            if (props.hasAllowMult()) {
                this.allowMult = props.getAllowMult();
            }
            if (props.hasNVal()) {
                this.nValue = new Integer(props.getNVal());
            }
        }
    }

    public Boolean getAllowMult() {
        return this.allowMult;
    }

    public Integer getNValue() {
        return this.nValue;
    }

    public BucketProperties allowMult(boolean val) {
        this.allowMult = val;
        return this;
    }

    public BucketProperties nValue(int val) {
        this.nValue = val;
        return this;
    }

    RPB.RpbBucketProps build() {
        RPB.RpbBucketProps.Builder builder = RPB.RpbBucketProps.newBuilder();
        if (this.allowMult != null) {
            builder.setAllowMult(this.allowMult);
        }
        if (this.nValue != null) {
            builder.setNVal(this.nValue);
        }
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowMult == null ? 0 : this.allowMult.hashCode());
        result = 31 * result + (this.nValue == null ? 0 : this.nValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketProperties)) {
            return false;
        }
        BucketProperties other = (BucketProperties)obj;
        if (this.allowMult == null ? other.allowMult != null : !this.allowMult.equals(other.allowMult)) {
            return false;
        }
        return !(this.nValue == null ? other.nValue != null : !this.nValue.equals(other.nValue));
    }

    public String toString() {
        return String.format("BucketProperties [allowMult=%s, nValue=%s]", this.allowMult, this.nValue);
    }
}

