/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RPB;
import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnection;
import com.basho.riak.pbc.RiakStreamClient;
import com.basho.riak.pbc.mapreduce.MapReduceResponse;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceResponseSource
extends RiakStreamClient<MapReduceResponse> {
    private RPB.RpbMapRedResp r;
    private boolean is_given;
    private final ByteString contentType;

    protected MapReduceResponseSource(RiakClient client, RiakConnection conn, ByteString contentType) throws IOException {
        super(client, conn);
        this.contentType = contentType;
        this.get_next_response();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.isClosed()) {
            return false;
        }
        if (this.is_given) {
            this.get_next_response();
        }
        return !this.isClosed();
    }

    @Override
    public MapReduceResponse next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.is_given = true;
        return new MapReduceResponse(this.r, this.contentType);
    }

    private void get_next_response() throws IOException {
        if (this.isClosed()) {
            return;
        }
        assert (this.r == null || this.is_given);
        if (this.r != null && this.is_given && this.r.hasDone() && this.r.getDone()) {
            this.close();
            return;
        }
        byte[] data = this.conn.receive(24);
        if (data == null) {
            this.close();
            throw new IOException("received empty response");
        }
        this.r = RPB.RpbMapRedResp.parseFrom(data);
        this.is_given = false;
    }

    public static JSONArray readAllResults(MapReduceResponseSource response) throws IOException {
        JSONArray results;
        LinkedHashMap<Integer, JSONArray> phases = new LinkedHashMap<Integer, JSONArray>();
        int phase = 0;
        while (response.hasNext()) {
            MapReduceResponse mrr = response.next();
            try {
                JSONArray latest = mrr.getJSON();
                if (latest == null) continue;
                phase = mrr.getPhase();
                if (phases.containsKey(phase)) {
                    results = (JSONArray)phases.get(phase);
                } else {
                    results = new JSONArray();
                    phases.put(phase, results);
                }
                for (int i = 0; i < latest.length(); ++i) {
                    results.put(latest.get(i));
                }
            }
            catch (JSONException e) {
                throw new IOException(mrr.response.toStringUtf8(), e);
            }
        }
        if (phases.size() == 1) {
            results = (JSONArray)phases.get(phase);
        } else {
            results = new JSONArray();
            for (JSONArray p : phases.values()) {
                results.put(p);
            }
        }
        return results;
    }
}

