/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RPB;
import com.basho.riak.pbc.RiakConnectionPool;
import com.basho.riak.pbc.RiakError;
import com.google.protobuf.MessageLite;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

class RiakConnection {
    static final int DEFAULT_RIAK_PB_PORT = 8087;
    private Socket sock;
    private DataOutputStream dout;
    private DataInputStream din;
    private final RiakConnectionPool pool;
    private byte[] clientId;
    private volatile long idleStart;

    public RiakConnection(InetAddress addr, int port, int bufferSizeKb, RiakConnectionPool pool) throws IOException {
        this.pool = pool;
        this.sock = new Socket(addr, port);
        this.sock.setSendBufferSize(1024 * bufferSizeKb);
        this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 1024 * bufferSizeKb));
        this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 1024 * bufferSizeKb));
    }

    void send(int code, MessageLite req) throws IOException {
        int len = req.getSerializedSize();
        this.dout.writeInt(len + 1);
        this.dout.write(code);
        req.writeTo((OutputStream)this.dout);
        this.dout.flush();
    }

    void send(int code) throws IOException {
        this.dout.writeInt(1);
        this.dout.write(code);
        this.dout.flush();
    }

    byte[] receive(int code) throws IOException {
        int len = this.din.readInt();
        int get_code = this.din.read();
        byte[] data = null;
        if (len > 1) {
            data = new byte[len - 1];
            this.din.readFully(data);
        }
        if (get_code == 0) {
            RPB.RpbErrorResp err = RPB.RpbErrorResp.parseFrom(data);
            throw new RiakError(err);
        }
        if (code != get_code) {
            throw new IOException("bad message code. Expected: " + code + " actual: " + get_code);
        }
        return data;
    }

    void receive_code(int code) throws IOException, RiakError {
        int len = this.din.readInt();
        int get_code = this.din.read();
        if (code == 0) {
            RPB.RpbErrorResp err = RPB.RpbErrorResp.parseFrom(this.din);
            throw new RiakError(err);
        }
        if (len != 1 || code != get_code) {
            throw new IOException("bad message code");
        }
    }

    void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.sock.close();
            this.din = null;
            this.dout = null;
            this.sock = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean checkValid() {
        return this.isClosed();
    }

    public DataOutputStream getOutputStream() {
        return this.dout;
    }

    public boolean isClosed() {
        return this.sock == null || this.sock.isClosed();
    }

    public synchronized void beginIdle() {
        this.idleStart = System.nanoTime();
    }

    public long getIdleStartTimeNanos() {
        return this.idleStart;
    }

    public void release() {
        this.pool.releaseConnection(this);
    }

    public synchronized byte[] getClientId() {
        return this.clientId == null ? null : (byte[])this.clientId.clone();
    }

    public synchronized void setClientId(byte[] clientId) {
        this.clientId = clientId == null ? null : (byte[])clientId.clone();
    }

    public synchronized boolean hasClientId() {
        return this.clientId != null && this.clientId.length > 0;
    }
}

