(ns com.beardandcode.components.email
  (:require [clojure.tools.logging :as log]
            [com.stuartsierra.component :as component]
            [clj-http.client :as client]))


(defprotocol IEmail
  (send-email [this to subject message]))

(defrecord Mailgun [base-url key from]
  IEmail
  (send-email [this to subject message]
    (let [response (client/post (str base-url "/messages")
                                {:basic-auth ["api" key]
                                 :form-params {:from from
                                               :to to
                                               :subject subject
                                               :text (:text message)
                                               :html (:html message)}})]
      response)))

(defn new-mailgun-email-service [base-url key from]
  (Mailgun. base-url key from))

(defrecord Logging []
  IEmail
  (send-email [_ to subject message]
    (log/info to subject message)))

(defn new-logging-email-service []
  (Logging.))
