(defproject com.beardandcode/forms "0.1.7"
  :description "A library to generate and validate HTML forms based on JSON Schema"
  :url "https://github.com/beardandcode/forms"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}

  :min-lein-version "2.0.0"

  :plugins [[lein-cljsbuild "1.1.4"]]

  :hooks [leiningen.cljsbuild]

  :dependencies [[org.clojure/clojure "1.8.0"]
                 [cheshire "5.5.0"]
                 [com.github.fge/json-schema-validator "2.2.6"]
                 [hiccup "1.0.5"]

                 [org.clojure/clojurescript "1.9.229"]
                 [prismatic/dommy "1.1.0"]]

  :source-paths ["src/clj" "src/cljs"]
  :test-paths ["test/clj"]
  :java-source-paths ["src/java"]
  :resource-paths ["src"]

  :javac-options ["-target" "1.8" "-source" "1.8"]

  :cljsbuild {:builds [{:source-paths ["src/cljs"]
                        :compiler {:output-to "test/public/main.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}]}

  :profiles {:dev {:dependencies [[org.clojure/tools.namespace "0.2.11"]
                                  [leiningen #=(leiningen.core.main/leiningen-version)]
                                  [im.chit/vinyasa.reimport "0.4.7"]
                                  [reloaded.repl "0.1.0"]

                                  ;; for tests
                                  [hickory "0.5.4"]

                                  ;; for test webapp
                                  [ch.qos.logback/logback-classic "1.1.3"]
                                  [com.beardandcode/components "0.1.0"]
                                  [ring/ring-anti-forgery "1.0.0"]
                                  [compojure "1.4.0"]]
                   :source-paths ["dev"]
                   :resource-paths ["test"]}})
