-- name: register-user<!
INSERT INTO users (username, email_address, name, password)
  VALUES (:username, :email_address, :name, crypt(:password, gen_salt('bf', 8)));

-- name: authenticate-user
SELECT * FROM users WHERE username = :username AND crypt(:password, password) = password;

-- name: get-user-by-email-address
SELECT * FROM users WHERE email_address = :email_address;

-- name: get-user-by-username
SELECT * FROM users WHERE username = :username;

-- name: delete-user-by-id!
DELETE FROM users WHERE id = :id;

-- name: create-token<!
WITH new_token AS (
  SELECT encode(gen_random_bytes(32), 'hex') as token
), added_token AS (
  INSERT INTO tokens (token, user_id, type)
    SELECT crypt(token, gen_salt('bf', 8)), :user_id, :token_type::token_type FROM new_token
)
SELECT token FROM new_token; -- should do an expiry

-- name: find-token
SELECT * FROM tokens WHERE token = crypt(:token, token) AND type = :token_type::token_type;

-- name: delete-token!
DELETE FROM tokens WHERE token = crypt(:token, token);

-- name: confirm-user<!
UPDATE users
    SET confirmed = TRUE
    FROM (SELECT user_id FROM tokens WHERE type = 'confirmation' AND token = crypt(:token, token)) AS token_list
    WHERE users.id = token_list.user_id;

-- name: reset-user-password<!
UPDATE users
    SET password = crypt(:password, gen_salt('bf', 8)), confirmed = TRUE
    FROM (SELECT user_id FROM tokens WHERE type = 'reset' AND token = crypt(:token, token)) AS token_list
    WHERE users.id = token_list.user_id;
