(ns com.ben-allred.app-simulator.utils.colls)

(defn force-sequential [v]
  (if (or (nil? v) (sequential? v))
    v
    [v]))

(defn replace-by [compare-fn value coll]
  (let [comparator (compare-fn value)]
    (cond->> coll
      :always (map #(if (= comparator (compare-fn %)) value %))
      (not (list? coll)) (into (empty coll)))))

(defn prepend
  ([x]
   (fn [rf]
     (let [prepended? (volatile! false)]
       (fn
         ([]
          (rf (rf) x))
         ([result]
          (if @prepended?
            (rf result)
            (rf (rf result x))))
         ([result input]
          (if @prepended?
            (rf result input)
            (do (vreset! prepended? true)
                (rf (rf result x) input))))))))
  ([coll x]
   (if (vector? coll)
     (into [x] coll)
     (cons x coll))))

(defn append
  ([x]
   (fn [rf]
     (fn
       ([]
        (rf))
       ([result]
        (rf (unreduced (rf result x))))
       ([result input]
        (rf result input)))))
  ([coll x]
   (if (vector? coll)
     (conj coll x)
     (concat coll [x]))))

(defn onto [coll]
  (fn [& vs]
    (into coll vs)))

(defn cut-with [f coll]
  (loop [head [] tail [] head? (f coll) [item :as items] coll]
    (cond
      (empty? items) [head tail]
      head? (recur (conj head item) tail (f (rest items)) (rest items))
      :else (recur head (conj tail item) false (rest items)))))

(defn supdate [seq-fn f & f-args+coll]
  (let [[f-args [coll]] (cut-with next f-args+coll)]
    (seq-fn (fn [item] (apply f item f-args)) coll)))
