/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.springframework.build.aws.maven.AbstractWagon;
import org.springframework.build.aws.maven.AuthenticationInfoAWSCredentials;
import org.springframework.build.aws.maven.IoUtils;
import org.springframework.build.aws.maven.Region;
import org.springframework.build.aws.maven.S3Utils;
import org.springframework.build.aws.maven.TransferProgress;
import org.springframework.build.aws.maven.TransferProgressFileInputStream;
import org.springframework.build.aws.maven.TransferProgressFileOutputStream;

public final class PrivateS3Wagon
extends AbstractWagon {
    private static final String KEY_FORMAT = "%s%s";
    private static final String RESOURCE_FORMAT = "%s(.*)";
    private volatile AmazonS3 amazonS3;
    private volatile String bucketName;
    private volatile String baseDirectory;

    public PrivateS3Wagon() {
        super(true);
    }

    PrivateS3Wagon(AmazonS3 amazonS3, String bucketName, String baseDirectory) {
        super(true);
        this.amazonS3 = amazonS3;
        this.bucketName = bucketName;
        this.baseDirectory = baseDirectory;
    }

    protected void connectToRepository(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws AuthenticationException {
        if (this.amazonS3 == null) {
            AuthenticationInfoAWSCredentials awsCredentials = authenticationInfo == null ? null : new AuthenticationInfoAWSCredentials(authenticationInfo);
            ClientConfiguration clientConfiguration = S3Utils.getClientConfiguration((ProxyInfoProvider)proxyInfoProvider);
            this.bucketName = S3Utils.getBucketName((Repository)repository);
            this.baseDirectory = S3Utils.getBaseDirectory((Repository)repository);
            this.amazonS3 = new AmazonS3Client((AWSCredentials)awsCredentials, clientConfiguration);
            Region region = Region.fromLocationConstraint((String)this.amazonS3.getBucketLocation(this.bucketName));
            this.amazonS3.setEndpoint(region.getEndpoint());
        }
    }

    protected void disconnectFromRepository() {
        this.amazonS3 = null;
        this.bucketName = null;
        this.baseDirectory = null;
    }

    protected boolean doesRemoteResourceExist(String resourceName) {
        try {
            this.getObjectMetadata(resourceName);
            return true;
        }
        catch (AmazonServiceException e) {
            return false;
        }
    }

    protected boolean isRemoteResourceNewer(String resourceName, long timestamp) throws ResourceDoesNotExistException {
        try {
            Date lastModified = this.getObjectMetadata(resourceName).getLastModified();
            return lastModified == null ? true : lastModified.getTime() > timestamp;
        }
        catch (AmazonServiceException e) {
            throw new ResourceDoesNotExistException(String.format("'%s' does not exist", resourceName), (Throwable)e);
        }
    }

    protected List<String> listDirectory(String directory) throws ResourceDoesNotExistException {
        ArrayList<String> directoryContents = new ArrayList<String>();
        try {
            String prefix = this.getKey(directory);
            Pattern pattern = Pattern.compile(String.format(RESOURCE_FORMAT, prefix));
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(prefix).withDelimiter("/");
            ObjectListing objectListing = this.amazonS3.listObjects(listObjectsRequest);
            directoryContents.addAll(this.getResourceNames(objectListing, pattern));
            while (objectListing.isTruncated()) {
                objectListing = this.amazonS3.listObjects(listObjectsRequest);
                directoryContents.addAll(this.getResourceNames(objectListing, pattern));
            }
            return directoryContents;
        }
        catch (AmazonServiceException e) {
            throw new ResourceDoesNotExistException(String.format("'%s' does not exist", directory), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getResource(String resourceName, File destination, TransferProgress transferProgress) throws TransferFailedException, ResourceDoesNotExistException {
        S3ObjectInputStream in = null;
        TransferProgressFileOutputStream out = null;
        try {
            S3Object s3Object = this.amazonS3.getObject(this.bucketName, this.getKey(resourceName));
            in = s3Object.getObjectContent();
            out = new TransferProgressFileOutputStream(destination, transferProgress);
            IoUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (AmazonServiceException e) {
            try {
                throw new ResourceDoesNotExistException(String.format("'%s' does not exist", resourceName), (Throwable)e);
                catch (FileNotFoundException e2) {
                    throw new TransferFailedException(String.format("Cannot write file to '%s'", destination), (Throwable)e2);
                }
                catch (IOException e3) {
                    throw new TransferFailedException(String.format("Cannot read from '%s' and write to '%s'", resourceName, destination), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly((Closeable[])new Closeable[]{in, out});
                throw throwable;
            }
        }
        IoUtils.closeQuietly((Closeable[])new Closeable[]{in, out});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void putResource(File source, String destination, TransferProgress transferProgress) throws TransferFailedException, ResourceDoesNotExistException {
        String key = this.getKey(destination);
        this.mkdirs(key, 0);
        TransferProgressFileInputStream in = null;
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(source.length());
            objectMetadata.setContentType(Mimetypes.getInstance().getMimetype(source));
            in = new TransferProgressFileInputStream(source, transferProgress);
            this.amazonS3.putObject(new PutObjectRequest(this.bucketName, key, (InputStream)in, objectMetadata));
        }
        catch (AmazonServiceException e) {
            try {
                throw new TransferFailedException(String.format("Cannot write file to '%s'", destination), (Throwable)e);
                catch (FileNotFoundException e2) {
                    throw new ResourceDoesNotExistException(String.format("Cannot read file from '%s'", source), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        IoUtils.closeQuietly((Closeable[])new Closeable[]{in});
    }

    private ObjectMetadata getObjectMetadata(String resourceName) {
        return this.amazonS3.getObjectMetadata(this.bucketName, this.getKey(resourceName));
    }

    private String getKey(String resourceName) {
        return String.format(KEY_FORMAT, this.baseDirectory, resourceName);
    }

    private List<String> getResourceNames(ObjectListing objectListing, Pattern pattern) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (String commonPrefix : objectListing.getCommonPrefixes()) {
            resourceNames.add(this.getResourceName(commonPrefix, pattern));
        }
        for (S3ObjectSummary s3ObjectSummary : objectListing.getObjectSummaries()) {
            resourceNames.add(this.getResourceName(s3ObjectSummary.getKey(), pattern));
        }
        return resourceNames;
    }

    private String getResourceName(String key, Pattern pattern) {
        Matcher matcher = pattern.matcher(key);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return key;
    }

    private void mkdirs(String path, int index) throws TransferFailedException {
        int directoryIndex = path.indexOf(47, index) + 1;
        if (directoryIndex != 0) {
            String directory = path.substring(0, directoryIndex);
            PutObjectRequest putObjectRequest = this.createDirectoryPutObjectRequest(directory);
            try {
                this.amazonS3.putObject(putObjectRequest);
            }
            catch (AmazonServiceException e) {
                throw new TransferFailedException(String.format("Cannot write directory '%s'", directory), (Throwable)e);
            }
            this.mkdirs(path, directoryIndex);
        }
    }

    private PutObjectRequest createDirectoryPutObjectRequest(String key) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(0L);
        return new PutObjectRequest(this.bucketName, key, (InputStream)inputStream, objectMetadata);
    }
}

