(ns hom.core
  (:require
    [clojure.string :as str]
    [om.dom :as dom]))

(defmulti expand-form {:private true} #(first %))

(defn- parse-element [el]
  (let [parts (str/split (name el) #"\.")
        [tag id] (str/split (first parts) #"#")]
    {:id id
     :tag tag
     :className (str/join " " (rest parts))}))

(defn- expand-element
  [el & args]
  (let [opts? (map? (first args))
        body (if opts? (rest args) args)
        nxt (first body)
        {:keys [tag] :as parts} (parse-element el)
        attrs (merge {}
                     (when opts? (first args))
                     (select-keys parts [:id :className]))]
    `(~(symbol "om.dom" tag)
               ~(when-not (empty? attrs)
                  `(cljs.core/clj->js ~attrs))
               ~@(cond
                   (vector? nxt) (map #(apply expand-element %) body)
                   (seq? nxt) (list (expand-form nxt))
                   :else body))))

(defmethod expand-form :default
  [expr]
  `~expr)

(defmethod expand-form 'when
  [[_ condition body]]
  `(when ~condition ~(apply expand-element body)))

(defmacro component [conf]
  `~(apply expand-element conf))
