(ns bizlogic.tools.watch
  (:import [java.nio.file WatchService Watchable WatchKey]))

;; ICloseable IAutoCloseable IWatchService

(defprotocol IWatchable
  (register [path opts] "Returns a watch-key."))

(defprotocol IWatchService
  (poll [this])
  (take [this]))

(defprotocol IWatchKey
  (cancel [this])
  (valid? [this])
  (poll-events [this])
  (reset [this])
  (watchable [this opts]
    "Returns the watchable object "))

(defn watcher []
  (let [watcher (WatchService.)]
    (reify
      IWatchService
      (watch [this]))))

;; should return an object that can be used to monitor changes
;; possible types to receive for watching
;; Map String File
(defn watch-file [file event])
