(ns bizlogic.tools.utils
  (:require [clojure.string :as str]
            [clojure.string :as string]
            [bizlogic.tools.log :as log]
            [clojure.java.io :as io]
            [datomic.api :as d])
  (:import (java.io File FileOutputStream BufferedOutputStream
             ByteArrayOutputStream)
           (java.util.zip ZipInputStream)
           (java.util.jar JarFile Manifest JarEntry JarOutputStream)
           (java.util.regex Pattern)
           (datomic Util)
           (java.util.Random)))

(defn insert-at [n x coll]
  (vec (concat (take n coll) [x] (drop (inc n) coll))))

(defn deep-merge
  "Like merge, but merges maps recursively."
  {:added "1.7"}
  [& maps]
  (if (every? map? maps)
    (apply merge-with deep-merge maps)
    (last maps)))

(defn deep-merge-with
  "Like merge-with, but merges maps recursively, applying the given fn
  only when there's a non-map at a particular level."
  {:added "1.7"}
  [f & maps]
  (apply
    (fn m [& maps]
      (if (every? map? maps)
        (apply merge-with m maps)
        (apply f maps)))
    maps))

(defn- ensure-ends-with-sep [p]
  (if (.endsWith p File/separator) p (str p File/separator)))

(defn trim-left-right [coll]
  (map (fn [x]
         (-> (#(str/replace-first (str/reverse x) "-" ""))
             (#(str/replace-first (str/reverse %) "-" ""))))
       coll))

(def email-re #"\b[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}\b")

(defn ensure-dir
  "Ensures that a directory exists at the given path, throwing if one does not."
  [^String dir-path]
  (let [dir (java.io.File. dir-path)]
    (if-not (.exists dir)
      (throw (Exception. (format "Directory does not exist: %s" dir-path))))))

;; possibly make maniffest from project.clj or some other config
(defn jar [dir target & manifest]
  (let [zipinput (ZipInputStream. dir)
        file-output (io/file target)
        jar-output (-> file-output
                     (FileOutputStream.)
                     (BufferedOutputStream.)
                     (JarOutputStream. manifest))
        zip-entries (cond
                      )]))

(def tomcat-webapps "/opt/tomcat/tomcat7/base/webapps")

(defn deploy-tomcat [jarname])

;; datomic ================================================================
(defn build-schema [[ident type card doc & [unique index comp?]] & [partition]]
  (merge {:db/id (d/tempid :db.part/db)
          :db/ident ident
          :db/valueType (keyword (str "db.type/" (name type)))
          :db/cardinality (keyword (str "db.cardinality/" (name card)))
          :db.install/_attribute (or partition :db.part/db)}
    (if doc {:db/doc doc})
    (if comp? {:db/isComponent true})
    (or (and unique {:db/unique (keyword (str "db.unique/" (name unique)))})
      (or (and index {:db/index true}) nil))))

(defn read-all
  "Read all forms in f, where f is any resource that can
   be opened by io/reader"
  [f]
  (Util/readAll (io/reader f)))

(defn transact-all
  "Load and run all transactions from f, where f is any
   resource that can be opened by io/reader."
  [conn f]
  (loop [n 0
         [tx & more] (read-all f)]
    (if tx
      (recur (+ n (count (:tx-data  @(d/transact conn tx))))
             more)
      {:datoms n})))
