/*
 * Decompiled with CFR 0.152.
 */
package taoensso.nippy.compression;

import clojure.lang.IFn;
import clojure.lang.IPersistentVector;
import clojure.lang.IType;
import clojure.lang.Keyword;
import clojure.lang.Numbers;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import taoensso.nippy.compression.ICompressor;

public final class LZMA2Compressor
implements ICompressor,
IType {
    public final Object compression_level;
    public static final Keyword const__0 = RT.keyword(null, (String)"lzma2");
    public static final Var const__6 = RT.var((String)"clojure.core", (String)"ex-info");
    public static final Keyword const__7 = RT.keyword(null, (String)"ba");

    public LZMA2Compressor(Object object) {
        this.compression_level = object;
    }

    public static IPersistentVector getBasis() {
        return Tuple.create((Object)Symbol.intern(null, (String)"compression-level"));
    }

    @Override
    public Object decompress(Object ba) {
        DataInputStream dis;
        Object object = ba;
        ba = null;
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])object);
        DataInputStream dataInputStream = dis = new DataInputStream(bais);
        dis = null;
        int len_decomp = dataInputStream.readInt();
        byte[] ba2 = Numbers.byte_array((Object)len_decomp);
        ByteArrayInputStream byteArrayInputStream = bais;
        bais = null;
        XZInputStream xzs = new XZInputStream((InputStream)byteArrayInputStream);
        xzs.read(ba2, RT.intCast((long)0L), len_decomp);
        XZInputStream xZInputStream = xzs;
        xzs = null;
        if (-1L != (long)xZInputStream.read()) {
            throw (Throwable)((IFn)const__6.getRawRoot()).invoke((Object)"LZMA2 Decompress failed: corrupt data?", (Object)RT.mapUniqueKeys((Object[])new Object[]{const__7, ba2}));
        }
        byte[] byArray = ba2;
        ba2 = null;
        return byArray;
    }

    @Override
    public Object compress(Object ba) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int len_decomp = ((byte[])ba).length;
        DataOutputStream dataOutputStream = dos;
        dos = null;
        dataOutputStream.writeInt(len_decomp);
        XZOutputStream xzs = new XZOutputStream((OutputStream)baos, (FilterOptions)new LZMA2Options(RT.intCast((Object)((Number)this.compression_level))));
        Object object = ba;
        ba = null;
        ((OutputStream)xzs).write((byte[])object);
        XZOutputStream xZOutputStream = xzs;
        xzs = null;
        xZOutputStream.close();
        ByteArrayOutputStream byteArrayOutputStream = baos;
        baos = null;
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public Object header_id() {
        return const__0;
    }
}

