--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = babble, pg_catalog;

DROP INDEX babble.radical_variant_numbering_idx;
DROP INDEX babble.radical_variant_crc32_idx;
DROP INDEX babble.radical_idx;
DROP TABLE babble.radical_variants;
SET search_path = babble, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: radical_variants; Type: TABLE; Schema: babble; Owner: -; Tablespace: 
--

CREATE TABLE radical_variants (
    n integer NOT NULL,
    v integer NOT NULL,
    r text NOT NULL,
    crc32 text NOT NULL,
    CONSTRAINT crc32_length CHECK ((length(crc32) = 8)),
    CONSTRAINT single_radical CHECK ((length(r) = 1))
);


--
-- Data for Name: radical_variants; Type: TABLE DATA; Schema: babble; Owner: -
--

COPY radical_variants (n, v, r, crc32) FROM stdin;
5	1	乙	ed7e9f7f
6	1	亅	d25290f3
7	1	二	ab8e2857
9	1	人	6434bdce
10	1	儿	5459380b
11	1	入	b020f030
12	1	八	5798dd37
14	1	冖	24ddc2e5
15	1	冫	7cb58ef4
16	1	几	f27c663d
18	1	刀	4e8a5a3a
19	1	力	f6d9f154
20	1	勹	3aa281f1
22	1	匚	d7846644
23	1	匸	02e427a0
24	1	十	44fa9ee9
25	1	卜	27fcf230
27	1	厂	f6de9c90
28	1	厶	d76a6825
29	1	又	0f1044cf
31	1	囗	acb69e6f
32	1	土	ed2c809a
33	1	士	94465e13
35	1	夊	976ed88a
36	1	夕	1a66d57f
37	1	大	d2b184ff
38	1	女	d17061c3
40	1	宀	8d54d91e
41	1	寸	bc4d50c1
42	1	小	c9aafb50
44	1	尸	71175e5f
45	1	屮	9cd8da4f
46	1	山	11d0d7ba
48	1	工	5d50a441
49	1	己	478a703c
50	1	巾	d7356dad
51	1	干	40000c08
53	1	广	3eb170b5
54	1	廴	9b55cbbf
55	1	廾	7b8022a1
57	1	弓	711ee813
58	1	彐	f10c88e8
59	1	彡	a0d288d2
61	1	心	4784abb4
62	1	戈	42176c51
63	1	戶	837671fa
64	1	手	c2050caa
66	1	攴	8b0f4d8b
67	1	文	06e94e1f
68	1	斗	1b5e5e7b
70	1	方	c78853b4
71	1	无	baf8ca35
72	1	日	ca923eba
74	1	月	6cb9bb04
75	1	木	57d79bcc
76	1	欠	864a250d
77	1	止	715f7560
79	1	殳	30c20651
80	1	毋	01db8f8e
81	1	比	8cd3827b
83	1	氏	cbec4509
84	1	气	41898ce5
85	1	水	7ae7ac2d
87	1	爪	96b54782
88	1	父	82b41bcd
89	1	爻	fc056770
90	1	爿	fb68a369
92	1	牙	307e17d5
93	1	牛	de7076f9
94	1	犬	4de08035
96	1	玉	62889176
97	1	瓜	f0391981
98	1	瓦	3635c033
100	1	生	2671defc
101	1	用	9ecc7bf3
102	1	田	8da0e3a5
103	1	疋	0e9d6803
105	1	癶	d16d38dd
106	1	白	46bfe155
107	1	皮	e92cf348
109	1	目	f037c209
110	1	矛	c2e8c32e
111	1	矢	9ded4b26
113	1	示	b2333c48
114	1	禸	6e0b3fe6
115	1	禾	87689ad3
116	1	穴	e0256f02
118	1	竹	aca2713d
119	1	米	fc5a62f8
120	1	糸	59bed9f2
122	1	网	858f6c10
123	1	羊	24c7f63f
124	1	羽	9c7a5330
126	1	而	873d0f4a
127	1	耒	7d323229
128	1	耳	315b2277
129	1	聿	21f65f1d
131	1	臣	63ada4d4
132	1	自	1a711c70
133	1	至	7e1ab4b0
135	1	舌	4fe48542
136	1	舛	cc370085
137	1	舟	cb5ac49c
5	2	⺄	a1d8dcd7
3	1	丶	5fb49367
182	1	风	d6587330
183	1	飞	cbef6354
184	2	饣	c5dd88c3
184	1	食	bce853c2
185	1	首	b8431f23
186	1	香	28fc02b2
195	1	鱼	667b5263
188	1	骨	d5974d84
189	1	高	ea554c69
141	1	虍	6b3a96c4
142	1	虫	b9371339
143	1	血	02145682
144	1	行	0ba21aa9
145	1	衣	a07327f0
146	1	襾	a7198e2d
149	2	讠	bee26a85
148	1	角	a7f7804c
149	1	言	d3d6edcb
150	1	谷	e970d09d
151	1	豆	a1b5e1e6
152	1	豕	250ba038
153	1	豸	60d4fc4d
159	1	车	366e8e22
155	1	赤	10b96506
156	1	走	0a63b17b
157	1	足	b847b302
158	1	身	079e6458
167	2	钅	87d7ad0a
160	1	辛	452b91f0
161	1	辰	e99768b0
162	1	辵	99fd9c3f
163	1	邑	d7cf6b26
164	1	酉	8be265b7
165	1	釆	296b1aa4
166	1	里	c9bef3ba
167	1	金	aab89f63
169	1	门	bf7f053a
178	1	韦	901ea235
170	1	阜	1953ed40
171	1	隶	f0de4614
172	1	隹	60615b85
173	1	雨	13ca4a36
174	1	青	839c3402
175	1	非	8a2a7829
176	1	面	a54504ae
177	1	革	3297dd26
181	1	页	5565f896
179	1	韭	07cc7bbd
180	1	音	fdc346de
190	1	髟	7431d9ca
191	1	鬥	fd7c96bf
192	1	鬯	1da97fa1
193	1	鬲	7eaf1378
194	1	鬼	99173e7f
196	1	鸟	15de9858
197	1	卤	0ffe4aae
199	1	麦	78ed72d2
198	1	鹿	37ab89d1
205	1	黾	729adbc5
200	1	麻	1beb1e0b
201	1	黃	2af297d4
202	1	黍	cd4abad3
203	1	黑	d94be69c
204	1	黹	ecfe4e66
210	1	齐	f816718c
206	1	鼎	1b027dae
207	1	鼓	78041177
208	1	鼠	c7d47061
209	1	鼻	4db1b98d
211	1	齿	53c74cd5
212	1	龙	aae79aeb
213	1	龟	43843fde
214	1	龠	f5e212e3
147	1	见	2349c192
154	1	贝	56a7dc4f
168	1	长	0e9ae27f
187	1	马	f9d7da5e
5	3	乚	7477cec5
146	3	覀	4d55c045
156	2	赱	7d6481ed
162	2	辶	00f4cd85
162	3	⻌	b61865a4
162	4	⻍	c11f5532
168	2	镸	90fe77dc
170	2	⻖	4b7a9cde
176	2	靣	d2423438
182	2	𠘨	1fcfbf13
189	2	髙	9d527cff
4	1	丿	26682bc3
8	1	亠	995644b4
13	1	冂	3e071698
17	1	凵	9fa182d6
21	1	匕	473b7bd5
26	1	卩	714f3613
30	1	口	a3acbd8f
34	1	夂	99b550b8
39	1	子	bbce9ab9
43	1	尢	8c75a725
52	1	幺	4edb843a
56	1	弋	62727045
60	1	彳	536bf99a
65	1	支	016a8467
69	1	斤	a48e3f6d
73	1	曰	0bfa955d
78	1	歹	fb3abc8c
82	1	毛	1c6c9fea
86	1	火	3070cc5d
91	1	片	ca712ab6
95	1	玄	1c39edcb
99	1	甘	b8154b5f
108	1	皿	839cd3ba
112	1	石	f75d6bd4
117	1	立	647520bd
121	1	缶	399ee83a
125	1	老	f98c73f7
130	1	肉	c5619947
134	1	臼	eea5a921
138	1	艮	839ff5e7
139	1	色	979ea9a8
140	1	艸	774b40b6
9	2	亻	13338d58
9	3	𠆢	2b5b69d2
18	2	刂	a0843b16
42	2	⺌	af0354e5
42	3	⺍	d8046473
43	2	尣	fb7297b3
47	2	川	75521cdf
47	3	巜	02552c49
58	2	彑	860bb87e
61	2	忄	d9e03e17
61	3	⺗	25669d09
63	2	户	f471416c
63	3	戸	64ce5cfd
64	2	扌	5c619909
64	3	龵	983ff608
71	2	旡	cdfffaa3
26	2	㔾	6d11667e
66	2	攵	fc087d1d
78	2	歺	6233ed36
80	2	母	e8b82abb
80	3	⺟	2bbd153b
85	2	氺	9d5f812a
85	3	氵	0de09cbb
86	2	灬	ae1459fe
87	2	爫	e1b27714
90	2	丬	a2d66a1d
93	2	牜	4014e35a
93	3	⺧	03bfada5
94	2	犭	3ae7b0a3
96	2	玊	fb81c0cc
96	3	王	8c86f05a
96	4	⺩	e40780a2
103	2	⺪	7d0ed118
113	2	礻	c5340cde
118	2	⺮	7a631501
122	2	罒	1c863daa
122	3	⺲	6e62494e
122	4	罓	6b810d3c
122	5	⺳	196579d8
123	2	⺶	690f8d57
123	3	⺷	1e08bdc1
125	2	耂	6085224d
129	2	⺻	17bef1ea
130	2	⺼	89da6449
2	1	丨	a5bbae04
140	2	艹	004c7020
145	2	衤	3e17b253
146	2	西	d01ebebb
157	2	⻊	5f7bc091
163	2	⻏	2f11341e
174	2	靑	1a9565b8
1	1	一	900e06fe
47	1	巛	9c31b9ea
104	1	疒	6af6c0c3
120	2	纟	2d76d7d0
\.


--
-- Name: radical_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX radical_idx ON radical_variants USING btree (r);


--
-- Name: radical_variant_crc32_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX radical_variant_crc32_idx ON radical_variants USING btree (crc32);


--
-- Name: radical_variant_numbering_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX radical_variant_numbering_idx ON radical_variants USING btree (n, v);


--
-- PostgreSQL database dump complete
--

