--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = babble, pg_catalog;

DROP RULE no_duplicate_translations ON babble.translations;
DROP INDEX babble.ltrg_idx;
DROP INDEX babble.lsrc_idx;
DROP INDEX babble.lower_unique_idx;
DROP INDEX babble.lower_trg_idx;
DROP INDEX babble.lower_src_idx;
ALTER TABLE ONLY babble.translations DROP CONSTRAINT translations_pkey;
ALTER TABLE babble.translations ALTER COLUMN id DROP DEFAULT;
DROP SEQUENCE babble.translations_id_seq;
DROP TABLE babble.translations;
SET search_path = babble, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: translations; Type: TABLE; Schema: babble; Owner: -; Tablespace: 
--

CREATE TABLE translations (
    id bigint NOT NULL,
    src text NOT NULL,
    trg text,
    lsrc text,
    ltrg text NOT NULL,
    created_at timestamp with time zone DEFAULT now()
);


--
-- Name: translations_id_seq; Type: SEQUENCE; Schema: babble; Owner: -
--

CREATE SEQUENCE translations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: translations_id_seq; Type: SEQUENCE OWNED BY; Schema: babble; Owner: -
--

ALTER SEQUENCE translations_id_seq OWNED BY translations.id;


--
-- Name: id; Type: DEFAULT; Schema: babble; Owner: -
--

ALTER TABLE ONLY translations ALTER COLUMN id SET DEFAULT nextval('translations_id_seq'::regclass);


--
-- Data for Name: translations; Type: TABLE DATA; Schema: babble; Owner: -
--

COPY translations (id, src, trg, lsrc, ltrg, created_at) FROM stdin;
1	見	见	zh-TW	zh-CN	2015-07-07 23:21:56.728579+00
2	妈妈	Mom	zh-CN	en	2015-07-07 23:40:51.127132+00
3	亲爱的	Dear	zh-CN	en	2015-07-07 23:44:14.580239+00
4	尊敬的	Dear	zh-CN	en	2015-07-07 23:50:54.97546+00
5	老妈	Mom	zh-CN	en	2015-07-08 02:41:29.085142+00
6	I like this song	我喜欢这首歌	en	zh-CN	2015-07-08 03:01:41.676229+00
7	敬上	Yours truly	zh-CN	en	2015-07-08 06:23:29.924401+00
8	敬祝	Sincerely	zh-CN	en	2015-07-08 06:24:13.386172+00
9	小明	Xiao Ming	zh-CN	en	2015-07-08 06:26:50.287786+00
10	儿	Child	zh-CN	en	2015-07-08 06:27:15.681808+00
11	安康	Good health	zh-CN	en	2015-07-08 06:27:33.52852+00
12	学生	Student	zh-CN	en	2015-07-08 22:36:44.055355+00
13	分享到	Share to	zh-CN	en	2015-07-09 02:35:59.763946+00
14	那些花儿	Those flowers	zh-CN	en	2015-07-09 03:26:26.178314+00
15	鸡	Chicken	zh-CN	en	2015-07-09 04:38:27.333763+00
16	雞	Chicken	zh-TW	en	2015-07-09 04:39:35.171885+00
17	肉	Meat	zh-CN	en	2015-07-09 05:05:24.960636+00
18	请	Please	zh-CN	en	2015-07-09 17:05:02.552268+00
19	讠	Yan	zh-CN	en	2015-07-09 17:11:16.996841+00
20	我叫	My name is	zh-CN	en	2015-07-09 17:14:42.293428+00
21	金盾工程	Golden Shield Project	zh-CN	en	2015-07-10 18:05:04.456655+00
22	防火长城	Great Firewall of China	zh-CN	en	2015-07-10 18:05:39.478673+00
23	黄建国	黃建國	zh-CN	zh-TW	2015-07-10 18:50:09.337285+00
24	旧金山湾区	San Francisco Bay Area	zh-CN	en	2015-07-10 19:27:07.981522+00
25	人不離人, 劍不離劍	People leave people, leave the sword sword	zh-CN	en	2015-07-10 20:41:33.057015+00
26	菜市場名	菜市场名	zh-TW	zh-CN	2015-07-11 00:11:58.064879+00
27	菜市場名	Grocer name	zh-TW	en	2015-07-11 00:12:09.551452+00
28	中国	中國	zh-CN	zh-TW	2015-07-11 03:16:12.450159+00
29	普通话	普通話	zh-CN	zh-TW	2015-07-11 03:16:59.314607+00
30	个	個	zh-CN	zh-TW	2015-07-11 03:17:21.055532+00
31	很	很	zh-CN	zh-TW	2015-07-11 03:17:57.274599+00
32	的	的	zh-CN	zh-TW	2015-07-11 03:18:08.008367+00
33	不	不	zh-CN	zh-TW	2015-07-11 03:18:19.895766+00
34	黄建國	黄建国	zh-TW	zh-CN	2015-07-11 03:18:54.372978+00
35	願月	愿月	zh-TW	zh-CN	2015-07-11 03:19:12.899317+00
36	食	Food	zh-CN	en	2015-07-11 17:48:53.068378+00
37	吃	Eating	zh-CN	en	2015-07-11 17:56:41.914086+00
38	力	Force	zh-CN	en	2015-07-11 18:22:00.083515+00
39	九	Nine	zh-CN	en	2015-07-11 18:22:18.770051+00
40	住	Live	zh-CN	en	2015-07-11 22:07:26.878024+00
41	谁	Who	zh-CN	en	2015-07-11 22:10:27.160809+00
42	会	Meeting	zh-CN	en	2015-07-11 22:16:43.980853+00
43	金	Gold	zh-CN	en	2015-07-11 22:17:13.535875+00
44	汉语水平考试	HSK	zh-CN	en	2015-07-11 22:31:49.071858+00
45	汉语水平考试一级	HSK one	zh-CN	en	2015-07-11 22:36:08.635691+00
46	新汉语水平考试一级	新汉语水平考试一级	zh-TW	zh-CN	2015-07-11 23:16:10.706054+00
47	新汉语水平考试一级	A new HSK	zh-CN	en	2015-07-11 23:16:39.054076+00
48	月亮代表我的心	月亮代表我的心	zh-TW	zh-CN	2015-07-12 00:39:44.180325+00
49	月亮代表我的心	The moon represents my heart	zh-CN	en	2015-07-12 00:39:57.63845+00
50	下载	Download	zh-CN	en	2015-07-12 21:28:19.142865+00
51	静夜思	Nostalgia	zh-CN	en	2015-07-13 18:49:10.986791+00
52	李白	李白	zh-TW	zh-CN	2015-07-13 18:58:57.537535+00
53	静夜思	静夜思	zh-TW	zh-CN	2015-07-13 18:59:14.04949+00
54	杜甫	杜甫	zh-TW	zh-CN	2015-07-13 19:04:12.929308+00
55	書	书	zh-TW	zh-CN	2015-07-13 19:51:57.187217+00
56	愛	愛	zh-CN	zh-TW	2015-07-13 19:56:55.192188+00
57	信用卡	Credit card	zh-CN	en	2015-07-13 23:25:28.824195+00
58	新华南	新华南	zh-TW	zh-CN	2015-07-13 23:37:27.012213+00
59	一	一	zh-TW	zh-CN	2015-07-13 23:45:08.473495+00
60	後	后	zh-TW	zh-CN	2015-07-13 23:45:08.599482+00
61	廣州	广州	zh-TW	zh-CN	2015-07-14 00:37:53.414398+00
62	广州	广州	zh-TW	zh-CN	2015-07-14 00:38:04.704332+00
63	黄建国	黄建国	zh-TW	zh-CN	2015-07-14 01:35:02.577338+00
64	後	後	zh-CN	zh-TW	2015-07-14 01:38:14.47379+00
65	国	國	zh-CN	zh-TW	2015-07-14 01:38:14.584713+00
66	黃建國	黃建國	zh-CN	zh-TW	2015-07-14 01:50:18.595343+00
67	广州	廣州	zh-CN	zh-TW	2015-07-14 01:51:44.447739+00
68	廣州	廣州	zh-CN	zh-TW	2015-07-14 01:52:06.893073+00
69	广州	Canton	zh-CN	en	2015-07-14 01:53:06.234466+00
70	澳门	澳门	zh-TW	zh-CN	2015-07-14 01:56:50.734719+00
71	澳门	Macao	zh-CN	en	2015-07-14 01:57:12.814713+00
72	澳门	澳門	zh-CN	zh-TW	2015-07-14 01:57:19.68318+00
73	澳門	澳门	zh-TW	zh-CN	2015-07-14 01:57:29.716995+00
74	澳門	澳門	zh-CN	zh-TW	2015-07-14 01:58:10.201222+00
75	实例化	实例化	zh-TW	zh-CN	2015-07-14 02:15:49.561831+00
76	实例化	實例化	zh-CN	zh-TW	2015-07-14 02:15:57.635592+00
77	实例化	Instantiation	zh-CN	en	2015-07-14 02:16:04.191546+00
78	多型	多型	zh-TW	zh-CN	2015-07-14 02:16:33.176694+00
79	多型	Polymorphism	zh-CN	en	2015-07-14 02:16:37.910533+00
80	递归	递归	zh-TW	zh-CN	2015-07-14 02:16:53.527429+00
81	递归	Recursive	zh-CN	en	2015-07-14 02:16:56.463587+00
82	强制类型转换	强制类型转换	zh-TW	zh-CN	2015-07-14 02:17:10.745325+00
83	强制类型转换	Casts	zh-CN	en	2015-07-14 02:17:14.140095+00
84	天珠	天珠	zh-TW	zh-CN	2015-07-14 03:43:15.880443+00
85	天珠	天珠	zh-CN	zh-TW	2015-07-14 03:43:21.700005+00
86	天珠	Dzi	zh-CN	en	2015-07-14 03:43:25.53858+00
87	个人中心	Personal Center	zh-CN	en	2015-07-14 04:59:33.925234+00
88	个人中心	个人中心	zh-TW	zh-CN	2015-07-14 04:59:45.446359+00
89	个人中心	個人中心	zh-CN	zh-TW	2015-07-14 04:59:51.970627+00
90	百度	百度	zh-TW	zh-CN	2015-07-14 06:00:36.861243+00
91	百度	百度	zh-CN	zh-TW	2015-07-14 06:00:41.582544+00
92	百度	Baidu	zh-CN	en	2015-07-14 06:00:44.71395+00
93	欢迎	Welcome	zh-CN	en	2015-07-14 06:40:26.319534+00
94	欢迎	欢迎	zh-TW	zh-CN	2015-07-14 06:40:31.485028+00
95	欢迎	歡迎	zh-CN	zh-TW	2015-07-14 06:40:37.238548+00
96	一	一	zh-CN	zh-TW	2015-07-14 06:56:07.511017+00
97	一	One	zh-CN	en	2015-07-14 06:56:07.578935+00
98	健	健	zh-TW	zh-CN	2015-07-14 07:08:47.40027+00
99	健	健	zh-CN	zh-TW	2015-07-14 07:08:47.536027+00
100	健	Healthy	zh-CN	en	2015-07-14 07:08:47.623935+00
101	私信	私信	zh-TW	zh-CN	2015-07-14 07:13:57.944745+00
102	私信	私信	zh-CN	zh-TW	2015-07-14 07:13:58.085233+00
103	私信	Private letters	zh-CN	en	2015-07-14 07:13:58.181782+00
104	退出	退出	zh-TW	zh-CN	2015-07-14 07:16:56.21216+00
105	退出	退出	zh-CN	zh-TW	2015-07-14 07:16:56.318403+00
106	退出	Drop out	zh-CN	en	2015-07-14 07:16:56.47936+00
107	广州市	广州市	zh-TW	zh-CN	2015-07-14 07:32:07.119915+00
108	广州市	廣州市	zh-CN	zh-TW	2015-07-14 07:32:07.304383+00
109	广州市	Guangzhou City	zh-CN	en	2015-07-14 07:32:07.476431+00
110	上海	上海	zh-TW	zh-CN	2015-07-14 07:34:12.507486+00
111	上海	上海	zh-CN	zh-TW	2015-07-14 07:34:12.604906+00
112	上海	Shanghai	zh-CN	en	2015-07-14 07:34:12.696253+00
113	新天地	新天地	zh-TW	zh-CN	2015-07-14 15:44:45.498235+00
114	新天地	新天地	zh-CN	zh-TW	2015-07-14 15:44:45.601407+00
115	新天地	Xintiandi	zh-CN	en	2015-07-14 15:44:45.740376+00
116	个	个	zh-TW	zh-CN	2015-07-14 15:48:48.599292+00
117	个	A	zh-CN	en	2015-07-14 15:48:48.723047+00
118	北京	北京	zh-TW	zh-CN	2015-07-14 15:56:51.940697+00
119	北京	北京	zh-CN	zh-TW	2015-07-14 15:56:52.091095+00
120	北京	Beijing	zh-CN	en	2015-07-14 15:56:52.180872+00
121	一卡通	一卡通	zh-TW	zh-CN	2015-07-14 16:01:22.045799+00
122	一卡通	一卡通	zh-CN	zh-TW	2015-07-14 16:01:22.20044+00
123	一卡通	Card	zh-CN	en	2015-07-14 16:01:22.354662+00
124	老	老	zh-TW	zh-CN	2015-07-14 17:01:48.192438+00
125	老	老	zh-CN	zh-TW	2015-07-14 17:01:48.364289+00
126	老	Old	zh-CN	en	2015-07-14 17:01:48.471898+00
127	在	在	zh-TW	zh-CN	2015-07-14 17:02:06.441689+00
128	在	在	zh-CN	zh-TW	2015-07-14 17:02:06.575522+00
129	在	In	zh-CN	en	2015-07-14 17:02:06.680299+00
130	喜欢	喜欢	zh-TW	zh-CN	2015-07-14 17:04:28.947587+00
131	喜欢	喜歡	zh-CN	zh-TW	2015-07-14 17:04:29.03989+00
132	喜欢	Love	zh-CN	en	2015-07-14 17:04:29.168071+00
133	先生	先生	zh-TW	zh-CN	2015-07-14 17:06:46.656264+00
134	先生	先生	zh-CN	zh-TW	2015-07-14 17:06:46.738951+00
135	先生	Mr	zh-CN	en	2015-07-14 17:06:46.820586+00
136	星期	星期	zh-TW	zh-CN	2015-07-14 17:08:55.525505+00
137	星期	星期	zh-CN	zh-TW	2015-07-14 17:08:55.621223+00
138	星期	Week	zh-CN	en	2015-07-14 17:08:55.703637+00
139	电	电	zh-TW	zh-CN	2015-07-14 17:11:07.998884+00
140	电	電	zh-CN	zh-TW	2015-07-14 17:11:08.058456+00
141	电	Electric	zh-CN	en	2015-07-14 17:11:08.156527+00
142	喂	喂	zh-TW	zh-CN	2015-07-15 05:08:05.29826+00
143	喂	餵	zh-CN	zh-TW	2015-07-15 05:08:05.376326+00
144	喂	Hey	zh-CN	en	2015-07-15 05:08:05.446428+00
145	木	木	zh-TW	zh-CN	2015-07-15 16:43:02.190652+00
146	木	木	zh-CN	zh-TW	2015-07-15 16:43:02.263705+00
147	木	Wood	zh-CN	en	2015-07-15 16:43:02.319613+00
148	走	走	zh-TW	zh-CN	2015-07-15 16:48:14.240811+00
149	走	走	zh-CN	zh-TW	2015-07-15 16:48:14.319855+00
150	走	Go	zh-CN	en	2015-07-15 16:48:14.409586+00
151	住	住	zh-TW	zh-CN	2015-07-15 16:51:19.915946+00
152	住	住	zh-CN	zh-TW	2015-07-15 16:51:20.017461+00
153	商店	商店	zh-TW	zh-CN	2015-07-15 16:59:44.913291+00
154	商店	商店	zh-CN	zh-TW	2015-07-15 16:59:44.993747+00
155	商店	Store	zh-CN	en	2015-07-15 16:59:45.069097+00
156	隹	隹	zh-TW	zh-CN	2015-07-15 17:00:34.365409+00
157	隹	隹	zh-CN	zh-TW	2015-07-15 17:00:34.486917+00
158	隹	Short-tailed bird	zh-CN	en	2015-07-15 17:00:34.596112+00
159	菜	菜	zh-TW	zh-CN	2015-07-15 17:02:20.608377+00
160	菜	菜	zh-CN	zh-TW	2015-07-15 17:02:20.729332+00
161	菜	Dish	zh-CN	en	2015-07-15 17:02:20.830544+00
162	漂亮	漂亮	zh-TW	zh-CN	2015-07-15 17:04:27.894221+00
163	漂亮	漂亮	zh-CN	zh-TW	2015-07-15 17:04:27.973805+00
164	漂亮	Beautiful	zh-CN	en	2015-07-15 17:04:28.048799+00
165	汉语	汉语	zh-TW	zh-CN	2015-07-15 17:07:06.483189+00
166	汉语	漢語	zh-CN	zh-TW	2015-07-15 17:07:06.603419+00
167	汉语	Chinese	zh-CN	en	2015-07-15 17:07:06.723412+00
168	号	号	zh-TW	zh-CN	2015-07-15 17:08:20.465332+00
169	号	號	zh-CN	zh-TW	2015-07-15 17:08:20.552531+00
170	号	Number	zh-CN	en	2015-07-15 17:08:20.645769+00
171	黄建国	Huang Jianguo	zh-CN	en	2015-07-15 17:33:24.196387+00
172	见	见	zh-TW	zh-CN	2015-07-15 18:27:23.11045+00
173	见	見	zh-CN	zh-TW	2015-07-15 18:27:23.266711+00
174	见	See	zh-CN	en	2015-07-15 18:27:23.387086+00
175	桌	桌	zh-TW	zh-CN	2015-07-15 18:48:52.825974+00
176	桌	桌	zh-CN	zh-TW	2015-07-15 18:48:52.939703+00
177	桌	Desk	zh-CN	en	2015-07-15 18:48:53.001564+00
178	店	店	zh-TW	zh-CN	2015-07-15 18:50:08.922867+00
179	店	店	zh-CN	zh-TW	2015-07-15 18:50:09.03044+00
180	店	Shop	zh-CN	en	2015-07-15 18:50:09.115824+00
181	Huáng Jiàn Guó	Huáng Jiàn Guó	zh-TW	zh-CN	2015-07-15 18:57:18.701607+00
182	Huáng Jiàn Guó	Huáng Jiàn Guó	zh-CN	zh-TW	2015-07-15 18:57:18.792082+00
183	Huáng Jiàn Guó	Huáng Jiàn Guó	zh-CN	en	2015-07-15 18:57:18.890777+00
184	黃建國	黄建国	zh-TW	zh-CN	2015-07-15 18:59:21.268681+00
185	北	北	zh-TW	zh-CN	2015-07-15 19:07:24.904816+00
186	北	北	zh-CN	zh-TW	2015-07-15 19:07:25.031985+00
187	北	North	zh-CN	en	2015-07-15 19:07:25.121236+00
188	京	京	zh-TW	zh-CN	2015-07-15 19:09:31.698642+00
189	京	京	zh-CN	zh-TW	2015-07-15 19:09:31.818441+00
190	京	Beijing	zh-CN	en	2015-07-15 19:09:31.914317+00
191	没关系	没关系	zh-TW	zh-CN	2015-07-15 19:10:24.350351+00
192	没关系	沒關係	zh-CN	zh-TW	2015-07-15 19:10:24.43526+00
193	没关系	It's ok	zh-CN	en	2015-07-15 19:10:24.570467+00
194	坐	坐	zh-TW	zh-CN	2015-07-15 19:11:23.953648+00
195	坐	坐	zh-CN	zh-TW	2015-07-15 19:11:24.105824+00
196	坐	Sit	zh-CN	en	2015-07-15 19:11:24.199687+00
197	飞机	飞机	zh-TW	zh-CN	2015-07-15 19:12:50.311953+00
198	飞机	飛機	zh-CN	zh-TW	2015-07-15 19:12:50.533951+00
199	飞机	Aircraft	zh-CN	en	2015-07-15 19:12:50.649634+00
200	几	几	zh-TW	zh-CN	2015-07-15 19:13:41.11841+00
201	几	幾	zh-CN	zh-TW	2015-07-15 19:13:41.263288+00
202	几	A few	zh-CN	en	2015-07-15 19:13:41.431559+00
203	打电话	打电话	zh-TW	zh-CN	2015-07-15 19:25:14.807237+00
204	打电话	打電話	zh-CN	zh-TW	2015-07-15 19:25:14.943433+00
205	打电话	Phone	zh-CN	en	2015-07-15 19:25:15.068984+00
206	金	金	zh-TW	zh-CN	2015-07-15 19:34:25.933779+00
207	金	金	zh-CN	zh-TW	2015-07-15 19:34:26.019333+00
208	医	医	zh-TW	zh-CN	2015-07-15 20:28:56.262978+00
209	医	醫	zh-CN	zh-TW	2015-07-15 20:28:56.384896+00
210	医	Treatment	zh-CN	en	2015-07-15 20:28:56.48614+00
211	院	院	zh-TW	zh-CN	2015-07-15 20:29:06.927303+00
212	院	院	zh-CN	zh-TW	2015-07-15 20:29:06.996581+00
213	院	Hospital	zh-CN	en	2015-07-15 20:29:07.070309+00
214	电脑	电脑	zh-TW	zh-CN	2015-07-15 20:31:29.980895+00
215	电脑	電腦	zh-CN	zh-TW	2015-07-15 20:31:30.098486+00
216	电脑	Computer	zh-CN	en	2015-07-15 20:31:30.230707+00
217	车	车	zh-TW	zh-CN	2015-07-15 20:33:46.207764+00
218	车	車	zh-CN	zh-TW	2015-07-15 20:33:46.310262+00
219	车	Car	zh-CN	en	2015-07-15 20:33:46.409014+00
220	出租	出租	zh-TW	zh-CN	2015-07-15 20:34:13.787658+00
221	出租	出租	zh-CN	zh-TW	2015-07-15 20:34:13.894143+00
222	出租	Rent	zh-CN	en	2015-07-15 20:34:13.973737+00
223	做	做	zh-TW	zh-CN	2015-07-15 20:38:41.53594+00
224	做	做	zh-CN	zh-TW	2015-07-15 20:38:41.609096+00
225	做	Do	zh-CN	en	2015-07-15 20:38:41.6753+00
226	左	左	zh-TW	zh-CN	2015-07-15 20:39:35.974289+00
227	左	左	zh-CN	zh-TW	2015-07-15 20:39:36.087275+00
228	左	Left	zh-CN	en	2015-07-15 20:39:36.158677+00
229	饭	饭	zh-TW	zh-CN	2015-07-15 20:53:57.121787+00
230	饭	飯	zh-CN	zh-TW	2015-07-15 20:53:57.303262+00
231	饭	Rice	zh-CN	en	2015-07-15 20:53:57.436585+00
232	拼音	拼音	zh-TW	zh-CN	2015-07-15 21:35:56.304001+00
233	拼音	拼音	zh-CN	zh-TW	2015-07-15 21:35:56.401408+00
234	拼音	Pinyin	zh-CN	en	2015-07-15 21:35:56.476888+00
235	客	客	zh-TW	zh-CN	2015-07-16 21:13:24.514434+00
236	客	客	zh-CN	zh-TW	2015-07-16 21:13:24.59733+00
237	客	Passenger	zh-CN	en	2015-07-16 21:13:24.647591+00
238	气	气	zh-TW	zh-CN	2015-07-16 21:15:32.7989+00
239	气	氣	zh-CN	zh-TW	2015-07-16 21:15:32.926079+00
240	气	Gas	zh-CN	en	2015-07-16 21:15:33.031589+00
241	简化字	简化字	zh-TW	zh-CN	2015-07-16 21:43:38.381595+00
242	简化字	簡化字	zh-CN	zh-TW	2015-07-16 21:43:38.465965+00
243	简化字	Simplified	zh-CN	en	2015-07-16 21:43:38.626894+00
244	快	快	zh-TW	zh-CN	2015-07-16 23:47:25.156795+00
245	快	快	zh-CN	zh-TW	2015-07-16 23:47:25.223608+00
246	快	Fast	zh-CN	en	2015-07-16 23:47:25.288175+00
247	仔	仔	zh-TW	zh-CN	2015-07-17 00:20:43.814284+00
248	仔	仔	zh-CN	zh-TW	2015-07-17 00:20:43.900399+00
249	仔	Young	zh-CN	en	2015-07-17 00:20:43.97652+00
250	蒜仔花生	蒜仔花生	zh-TW	zh-CN	2015-07-17 00:21:22.204762+00
251	蒜仔花生	蒜仔花生	zh-CN	zh-TW	2015-07-17 00:21:22.269967+00
252	蒜仔花生	Peanut garlic Aberdeen	zh-CN	en	2015-07-17 00:21:22.374829+00
253	友	友	zh-TW	zh-CN	2015-07-17 02:10:46.836967+00
254	友	友	zh-CN	zh-TW	2015-07-17 02:10:46.915131+00
255	友	Friendly	zh-CN	en	2015-07-17 02:10:46.989444+00
256	朋	朋	zh-TW	zh-CN	2015-07-17 02:10:57.76712+00
257	朋	朋	zh-CN	zh-TW	2015-07-17 02:10:57.884172+00
258	朋	Friend	zh-CN	en	2015-07-17 02:10:57.969679+00
259	再	再	zh-TW	zh-CN	2015-07-17 02:22:06.330725+00
260	再	再	zh-CN	zh-TW	2015-07-17 02:22:06.401827+00
261	再	Again	zh-CN	en	2015-07-17 02:22:06.47446+00
262	又	又	zh-TW	zh-CN	2015-07-17 02:33:14.350569+00
263	又	又	zh-CN	zh-TW	2015-07-17 02:33:14.481526+00
264	又	And	zh-CN	en	2015-07-17 02:33:14.550994+00
265	幺	幺	zh-TW	zh-CN	2015-07-17 02:34:17.251841+00
266	幺	么	zh-CN	zh-TW	2015-07-17 02:34:17.364892+00
267	幺	Unitary	zh-CN	en	2015-07-17 02:34:17.460633+00
268	有	有	zh-TW	zh-CN	2015-07-17 02:36:14.184123+00
269	有	有	zh-CN	zh-TW	2015-07-17 02:36:14.256053+00
270	有	Have	zh-CN	en	2015-07-17 02:36:14.328855+00
271	没	没	zh-TW	zh-CN	2015-07-17 02:40:59.253215+00
272	没	沒	zh-CN	zh-TW	2015-07-17 02:40:59.323348+00
273	没	No	zh-CN	en	2015-07-17 02:40:59.415644+00
274	饭dian	饭dian	zh-TW	zh-CN	2015-07-17 03:00:57.065781+00
275	饭dian	飯dian	zh-CN	zh-TW	2015-07-17 03:00:57.135051+00
276	饭dian	Rice dian	zh-CN	en	2015-07-17 03:00:57.469148+00
277	饭店	饭店	zh-TW	zh-CN	2015-07-17 03:01:22.723056+00
278	饭店	飯店	zh-CN	zh-TW	2015-07-17 03:01:22.843804+00
279	饭店	Restaurant	zh-CN	en	2015-07-17 03:01:22.993495+00
280	米饭	米饭	zh-TW	zh-CN	2015-07-17 03:01:40.563477+00
281	米饭	米飯	zh-CN	zh-TW	2015-07-17 03:01:40.755369+00
282	米饭	Rice	zh-CN	en	2015-07-17 03:01:40.885749+00
283	苹果	苹果	zh-TW	zh-CN	2015-07-17 03:08:05.779055+00
284	苹果	蘋果	zh-CN	zh-TW	2015-07-17 03:08:05.871042+00
285	苹果	Apple	zh-CN	en	2015-07-17 03:08:05.992301+00
286	前面	前面	zh-TW	zh-CN	2015-07-17 03:09:42.093542+00
287	前面	前面	zh-CN	zh-TW	2015-07-17 03:09:42.162378+00
288	前面	Front	zh-CN	en	2015-07-17 03:09:42.224042+00
289	乞	乞	zh-TW	zh-CN	2015-07-17 03:14:09.376276+00
290	乞	乞	zh-CN	zh-TW	2015-07-17 03:14:09.453862+00
291	乞	Begging	zh-CN	en	2015-07-17 03:14:10.033993+00
292	后退	后退	zh-TW	zh-CN	2015-07-17 04:31:09.248496+00
293	后退	後退	zh-CN	zh-TW	2015-07-17 04:31:09.334705+00
294	后退	Retreat	zh-CN	en	2015-07-17 04:31:09.410219+00
295	用户名	用户名	zh-TW	zh-CN	2015-07-17 04:39:38.520604+00
296	用户名	用戶名	zh-CN	zh-TW	2015-07-17 04:39:38.58717+00
297	用户名	Username	zh-CN	en	2015-07-17 04:39:38.67781+00
298	密码	密码	zh-TW	zh-CN	2015-07-17 04:40:17.817519+00
299	密码	密碼	zh-CN	zh-TW	2015-07-17 04:40:17.917126+00
300	密码	Password	zh-CN	en	2015-07-17 04:40:18.004904+00
301	姓名	姓名	zh-TW	zh-CN	2015-07-17 04:42:51.311668+00
302	姓名	姓名	zh-CN	zh-TW	2015-07-17 04:42:51.387674+00
303	姓名	Full name	zh-CN	en	2015-07-17 04:42:51.458402+00
304	您	您	zh-TW	zh-CN	2015-07-17 04:43:17.693759+00
305	您	您	zh-CN	zh-TW	2015-07-17 04:43:17.763235+00
306	您	You	zh-CN	en	2015-07-17 04:43:17.819422+00
307	的	的	zh-TW	zh-CN	2015-07-17 04:43:36.88242+00
308	的	Of	zh-CN	en	2015-07-17 04:43:37.001541+00
309	继	继	zh-TW	zh-CN	2015-07-17 04:47:23.093825+00
310	继	繼	zh-CN	zh-TW	2015-07-17 04:47:23.166775+00
311	继	Continue	zh-CN	en	2015-07-17 04:47:23.260586+00
312	继续	继续	zh-TW	zh-CN	2015-07-17 04:48:19.285447+00
313	继续	繼續	zh-CN	zh-TW	2015-07-17 04:48:19.353167+00
314	继续	Carry on	zh-CN	en	2015-07-17 04:48:19.444492+00
315	正	正	zh-TW	zh-CN	2015-07-17 04:55:59.751182+00
316	正	正	zh-CN	zh-TW	2015-07-17 04:55:59.820348+00
317	正	Positive	zh-CN	en	2015-07-17 04:55:59.884228+00
318	版本	版本	zh-TW	zh-CN	2015-07-17 05:54:43.490832+00
319	版本	版本	zh-CN	zh-TW	2015-07-17 05:54:43.573911+00
320	版本	Release	zh-CN	en	2015-07-17 05:54:43.641946+00
321	否	否	zh-TW	zh-CN	2015-07-17 06:22:57.46983+00
322	否	否	zh-CN	zh-TW	2015-07-17 06:22:57.547556+00
323	否	No	zh-CN	en	2015-07-17 06:22:57.612599+00
324	音乐	音乐	zh-TW	zh-CN	2015-07-17 06:45:54.622121+00
325	音乐	音樂	zh-CN	zh-TW	2015-07-17 06:45:54.703498+00
326	音乐	Music	zh-CN	en	2015-07-17 06:45:54.795785+00
327	图片	图片	zh-TW	zh-CN	2015-07-17 06:47:49.140799+00
328	图片	圖片	zh-CN	zh-TW	2015-07-17 06:47:49.215143+00
329	图片	Picture	zh-CN	en	2015-07-17 06:47:49.327887+00
330	桌面	桌面	zh-TW	zh-CN	2015-07-17 06:49:45.927099+00
331	桌面	桌面	zh-CN	zh-TW	2015-07-17 06:49:46.01934+00
332	桌面	Desktop	zh-CN	en	2015-07-17 06:49:46.108907+00
333	点心	点心	zh-TW	zh-CN	2015-07-17 21:24:35.521723+00
334	点心	點心	zh-CN	zh-TW	2015-07-17 21:24:35.64134+00
335	点心	Dessert	zh-CN	en	2015-07-17 21:24:35.767097+00
336	出租车	出租车	zh-TW	zh-CN	2015-07-17 21:33:41.336211+00
337	出租车	出租車	zh-CN	zh-TW	2015-07-17 21:33:41.469189+00
338	出租车	Taxi	zh-CN	en	2015-07-17 21:33:41.573441+00
339	电话	电话	zh-TW	zh-CN	2015-07-17 21:41:27.34906+00
340	电话	電話	zh-CN	zh-TW	2015-07-17 21:41:27.435563+00
341	电话	Phone	zh-CN	en	2015-07-17 21:41:27.582737+00
342	爱	爱	zh-TW	zh-CN	2015-07-17 21:47:15.004408+00
343	爱	愛	zh-CN	zh-TW	2015-07-17 21:47:15.082076+00
344	爱	Love	zh-CN	en	2015-07-17 21:47:15.181128+00
345	医院	医院	zh-TW	zh-CN	2015-07-17 21:49:26.229149+00
346	医院	醫院	zh-CN	zh-TW	2015-07-17 21:49:26.306747+00
347	医院	Hospital	zh-CN	en	2015-07-17 21:49:26.406509+00
348	老师	老师	zh-TW	zh-CN	2015-07-17 21:55:01.627902+00
349	老师	老師	zh-CN	zh-TW	2015-07-17 21:55:01.762898+00
350	老师	Teacher	zh-CN	en	2015-07-17 21:55:01.863849+00
351	里	里	zh-TW	zh-CN	2015-07-17 22:00:00.23424+00
352	里	裡	zh-CN	zh-TW	2015-07-17 22:00:00.31595+00
353	里	In	zh-CN	en	2015-07-17 22:00:00.411695+00
354	睡觉	睡觉	zh-TW	zh-CN	2015-07-17 22:00:40.006136+00
355	睡觉	睡覺	zh-CN	zh-TW	2015-07-17 22:00:40.078697+00
356	睡觉	Go to bed	zh-CN	en	2015-07-17 22:00:40.171622+00
357	叫	叫	zh-TW	zh-CN	2015-07-17 22:02:00.137236+00
358	叫	叫	zh-CN	zh-TW	2015-07-17 22:02:00.348864+00
359	叫	Called	zh-CN	en	2015-07-17 22:02:00.435518+00
360	工作	工作	zh-TW	zh-CN	2015-07-17 22:10:24.143176+00
361	工作	工作	zh-CN	zh-TW	2015-07-17 22:10:24.339481+00
362	工作	Jobs	zh-CN	en	2015-07-17 22:10:24.423451+00
363	呢	呢	zh-TW	zh-CN	2015-07-17 22:12:38.437844+00
364	呢	呢	zh-CN	zh-TW	2015-07-17 22:12:38.518746+00
365	呢	It	zh-CN	en	2015-07-17 22:12:38.601804+00
366	听	听	zh-TW	zh-CN	2015-07-17 22:12:50.414182+00
367	听	聽	zh-CN	zh-TW	2015-07-17 22:12:50.540787+00
368	听	Listen	zh-CN	en	2015-07-17 22:13:02.5618+00
369	纟	纟	zh-TW	zh-CN	2015-07-19 16:32:42.815474+00
370	纟	纟	zh-CN	zh-TW	2015-07-19 16:32:43.133312+00
371	纟	Si	zh-CN	en	2015-07-19 16:32:43.284268+00
372	龙虾	龙虾	zh-TW	zh-CN	2015-07-19 22:48:01.83286+00
373	龙虾	龍蝦	zh-CN	zh-TW	2015-07-19 22:48:02.122672+00
374	龙虾	Lobster	zh-CN	en	2015-07-19 22:48:02.323933+00
375	㣺	㣺	zh-TW	zh-CN	2015-07-20 04:55:37.056857+00
376	㣺	㣺	zh-CN	zh-TW	2015-07-20 04:55:37.300847+00
377	㣺	㣺	zh-CN	en	2015-07-20 04:55:37.428024+00
378	郑曼青	郑曼青	zh-TW	zh-CN	2015-07-20 05:43:17.963557+00
379	郑曼青	鄭曼青	zh-CN	zh-TW	2015-07-20 05:43:18.098599+00
380	郑曼青	Cheng Man-ching	zh-CN	en	2015-07-20 05:43:18.340111+00
381	杨澄甫	杨澄甫	zh-TW	zh-CN	2015-07-20 05:51:12.350765+00
382	杨澄甫	楊澄甫	zh-CN	zh-TW	2015-07-20 05:51:12.476536+00
383	杨澄甫	Yang Cheng-fu	zh-CN	en	2015-07-20 05:51:12.749381+00
384	您好	您好	zh-TW	zh-CN	2015-07-20 18:56:12.705557+00
385	您好	您好	zh-CN	zh-TW	2015-07-20 18:56:13.950906+00
386	您好	Hello	zh-CN	en	2015-07-20 18:56:14.100548+00
387	大家好	大家好	zh-TW	zh-CN	2015-07-20 22:58:40.232145+00
388	大家好	大家好	zh-CN	zh-TW	2015-07-20 22:58:40.307345+00
389	大家好	Hello everyone	zh-CN	en	2015-07-20 22:58:40.388346+00
390	我现在学习汉语是为了参加汉语水平一级考试	我现在学习汉语是为了参加汉语水平一级考试	zh-TW	zh-CN	2015-07-20 23:09:32.10547+00
391	我现在学习汉语是为了参加汉语水平一级考试	我現在學習漢語是為了參加漢語水平一級考試	zh-CN	zh-TW	2015-07-20 23:09:32.228929+00
392	我现在学习汉语是为了参加汉语水平一级考试	I am now learning Chinese is a Chinese proficiency test in order to participate	zh-CN	en	2015-07-20 23:09:32.583709+00
393	贴吧	贴吧	zh-TW	zh-CN	2015-07-21 17:01:54.201023+00
394	贴吧	貼吧	zh-CN	zh-TW	2015-07-21 17:01:54.415031+00
395	贴吧	Post Bar	zh-CN	en	2015-07-21 17:01:54.691179+00
396	您当前使用的账号存在异常，请完成以下操作解除异常状态	您当前使用的账号存在异常，请完成以下操作解除异常状态	zh-TW	zh-CN	2015-07-21 21:50:05.433116+00
397	您当前使用的账号存在异常，请完成以下操作解除异常状态	您當前使用的賬號存在異常，請完成以下操作解除異常狀態	zh-CN	zh-TW	2015-07-21 21:50:05.670557+00
398	您当前使用的账号存在异常，请完成以下操作解除异常状态	The account you are currently using is abnormal, please complete the following actions to lift the abnormal state	zh-CN	en	2015-07-21 21:50:05.95809+00
399	对不起，你还不是微博会员，你可以开通会员享受自定义封面图特权。	对不起，你还不是微博会员，你可以开通会员享受自定义封面图特权。	zh-TW	zh-CN	2015-07-21 21:57:40.2641+00
400	对不起，你还不是微博会员，你可以开通会员享受自定义封面图特权。	對不起，你還不是微博會員，你可以開通會員享受自定義封面圖特權。	zh-CN	zh-TW	2015-07-21 21:57:40.347406+00
401	对不起，你还不是微博会员，你可以开通会员享受自定义封面图特权。	Sorry, you do not microblogging member, you can open a member to enjoy custom cover art privileges.	zh-CN	en	2015-07-21 21:57:40.635454+00
402	还没有人@提到你，要加油哦！	还没有人@提到你，要加油哦！	zh-TW	zh-CN	2015-07-21 22:05:37.581413+00
403	还没有人@提到你，要加油哦！	還沒有人@提到你，要加油哦！	zh-CN	zh-TW	2015-07-21 22:05:39.821532+00
404	还没有人@提到你，要加油哦！	No one @ mention you, to refuel Oh!	zh-CN	en	2015-07-21 22:05:39.97965+00
405	安全验证	安全验证	zh-TW	zh-CN	2015-07-21 22:13:14.59886+00
406	安全验证	安全驗證	zh-CN	zh-TW	2015-07-21 22:13:14.675187+00
407	安全验证	Security verification	zh-CN	en	2015-07-21 22:13:14.864217+00
408	本次登录存在安全风险，为确保chris.oei@gmail.com安全，请完成验证：	本次登录存在安全风险，为确保chris.oei@gmail.com安全，请完成验证：	zh-TW	zh-CN	2015-07-21 22:13:43.052812+00
409	本次登录存在安全风险，为确保chris.oei@gmail.com安全，请完成验证：	本次登錄存在安全風險，為確保chris.oei@gmail.com安全，請完成驗證：	zh-CN	zh-TW	2015-07-21 22:13:43.126296+00
410	本次登录存在安全风险，为确保chris.oei@gmail.com安全，请完成验证：	The sign is a security risk, in order to ensure chris.oei@gmail.com security, complete verification:	zh-CN	en	2015-07-21 22:13:43.37587+00
411	注册新帐号	注册新帐号	zh-TW	zh-CN	2015-07-21 22:15:15.074888+00
412	注册新帐号	註冊新帳號	zh-CN	zh-TW	2015-07-21 22:15:15.121669+00
413	注册新帐号	Register new account	zh-CN	en	2015-07-21 22:15:15.251185+00
414	意见反馈	意见反馈	zh-TW	zh-CN	2015-07-21 22:15:40.293486+00
415	意见反馈	意見反饋	zh-CN	zh-TW	2015-07-21 22:15:40.38187+00
416	意见反馈	Feedback	zh-CN	en	2015-07-21 22:15:40.460611+00
553	登录中	登錄中	zh-CN	zh-TW	2015-07-22 03:48:08.498087+00
927	找	Find	zh-CN	en	2015-08-04 00:48:55.826586+00
417	请用 QQ安全中心 扫描二维码，或点击头像登录	请用QQ安全中心扫描二维码，或点击头像登录	zh-TW	zh-CN	2015-07-21 22:16:01.80886+00
418	请用 QQ安全中心 扫描二维码，或点击头像登录	請用QQ安全中心掃描二維碼，或點擊頭像登錄	zh-CN	zh-TW	2015-07-21 22:16:01.880089+00
419	请用 QQ安全中心 扫描二维码，或点击头像登录	Please use the QQ Security Center to scan two-dimensional code, or click on picture Login	zh-CN	en	2015-07-21 22:16:02.110124+00
420	邮我	邮我	zh-TW	zh-CN	2015-07-21 22:28:10.000498+00
421	邮我	郵我	zh-CN	zh-TW	2015-07-21 22:28:10.238922+00
422	邮我	Mail me	zh-CN	en	2015-07-21 22:28:10.469229+00
423	电子邮件链接打开方式	电子邮件链接打开方式	zh-TW	zh-CN	2015-07-21 22:29:16.104698+00
424	电子邮件链接打开方式	電子郵件鏈接打開方式	zh-CN	zh-TW	2015-07-21 22:29:16.242911+00
425	电子邮件链接打开方式	Email link Open	zh-CN	en	2015-07-21 22:29:16.450167+00
426	设置	设置	zh-TW	zh-CN	2015-07-21 22:30:20.821838+00
427	设置	設置	zh-CN	zh-TW	2015-07-21 22:30:21.013159+00
428	设置	Set up	zh-CN	en	2015-07-21 22:30:21.246532+00
429	解绑	解绑	zh-TW	zh-CN	2015-07-21 22:32:45.513267+00
430	解绑	解綁	zh-CN	zh-TW	2015-07-21 22:32:45.74672+00
431	解绑	Unbundling	zh-CN	en	2015-07-21 22:32:45.955219+00
432	关闭邮箱	关闭邮箱	zh-TW	zh-CN	2015-07-21 22:33:04.860335+00
433	关闭邮箱	關閉郵箱	zh-CN	zh-TW	2015-07-21 22:33:04.968108+00
434	关闭邮箱	Close mailbox	zh-CN	en	2015-07-21 22:33:05.144879+00
435	域名邮箱	域名邮箱	zh-TW	zh-CN	2015-07-21 22:33:30.899721+00
436	域名邮箱	域名郵箱	zh-CN	zh-TW	2015-07-21 22:33:31.102545+00
437	域名邮箱	Domain mail	zh-CN	en	2015-07-21 22:33:31.360495+00
438	默认帐户昵称	默认帐户昵称	zh-TW	zh-CN	2015-07-21 22:34:08.719372+00
439	默认帐户昵称	默認帳戶暱稱	zh-CN	zh-TW	2015-07-21 22:34:08.8267+00
440	默认帐户昵称	The default account nickname	zh-CN	en	2015-07-21 22:34:08.977047+00
441	我的生日	我的生日	zh-TW	zh-CN	2015-07-21 22:34:19.56333+00
442	我的生日	我的生日	zh-CN	zh-TW	2015-07-21 22:34:19.648729+00
443	我的生日	My birthday	zh-CN	en	2015-07-21 22:34:19.778709+00
444	好友可见我的生日	好友可见我的生日	zh-TW	zh-CN	2015-07-21 22:34:31.216206+00
445	好友可见我的生日	好友可見我的生日	zh-CN	zh-TW	2015-07-21 22:34:31.333019+00
446	好友可见我的生日	Friends can see my birthday	zh-CN	en	2015-07-21 22:34:31.526483+00
447	英文邮箱帐号	英文邮箱帐号	zh-TW	zh-CN	2015-07-21 22:34:48.832042+00
448	英文邮箱帐号	英文郵箱帳號	zh-CN	zh-TW	2015-07-21 22:34:48.910263+00
449	英文邮箱帐号	English mail account	zh-CN	en	2015-07-21 22:34:49.018767+00
450	邮箱帐号	邮箱帐号	zh-TW	zh-CN	2015-07-21 22:35:03.608886+00
451	邮箱帐号	郵箱帳號	zh-CN	zh-TW	2015-07-21 22:35:03.696074+00
452	邮箱帐号	E-mail account	zh-CN	en	2015-07-21 22:35:03.884333+00
453	数字帐号	数字帐号	zh-TW	zh-CN	2015-07-21 22:35:21.254658+00
454	数字帐号	數字帳號	zh-CN	zh-TW	2015-07-21 22:35:21.343877+00
455	数字帐号	Digital Account	zh-CN	en	2015-07-21 22:35:21.473661+00
456	帐户安全	帐户安全	zh-TW	zh-CN	2015-07-21 22:35:46.098783+00
457	帐户安全	帳戶安全	zh-CN	zh-TW	2015-07-21 22:35:46.183766+00
458	帐户安全	Account Security	zh-CN	en	2015-07-21 22:35:46.315891+00
459	独立密码	独立密码	zh-TW	zh-CN	2015-07-21 22:35:55.037446+00
460	独立密码	獨立密碼	zh-CN	zh-TW	2015-07-21 22:35:55.1209+00
461	独立密码	Independent password	zh-CN	en	2015-07-21 22:35:55.247516+00
462	文件夹区域加锁	文件夹区域加锁	zh-TW	zh-CN	2015-07-21 22:36:04.445386+00
463	文件夹区域加锁	文件夾區域加鎖	zh-CN	zh-TW	2015-07-21 22:36:04.506338+00
464	文件夹区域加锁	Folder area lock	zh-CN	en	2015-07-21 22:36:04.668873+00
465	你已绑定的网盘	你已绑定的网盘	zh-TW	zh-CN	2015-07-21 22:36:33.829936+00
466	你已绑定的网盘	你已綁定的網盤	zh-CN	zh-TW	2015-07-21 22:36:33.923482+00
467	你已绑定的网盘	You have bound network disk	zh-CN	en	2015-07-21 22:36:34.12631+00
468	绑定网盘	绑定网盘	zh-TW	zh-CN	2015-07-21 22:36:43.684264+00
469	绑定网盘	綁定網盤	zh-CN	zh-TW	2015-07-21 22:36:43.766962+00
470	绑定网盘	Binding network disk	zh-CN	en	2015-07-21 22:36:43.930479+00
471	邮箱设置	邮箱设置	zh-TW	zh-CN	2015-07-21 22:37:24.174391+00
472	邮箱设置	郵箱設置	zh-CN	zh-TW	2015-07-21 22:37:24.263728+00
473	邮箱设置	Mail settings	zh-CN	en	2015-07-21 22:37:24.392329+00
474	设置保存成功	设置保存成功	zh-TW	zh-CN	2015-07-21 22:37:50.375013+00
475	设置保存成功	設置保存成功	zh-CN	zh-TW	2015-07-21 22:37:50.471576+00
476	设置保存成功	Settings saved successfully	zh-CN	en	2015-07-21 22:37:50.671889+00
477	文字大小	文字大小	zh-TW	zh-CN	2015-07-21 22:40:02.060444+00
478	文字大小	文字大小	zh-CN	zh-TW	2015-07-21 22:40:03.984958+00
479	文字大小	Text Size	zh-CN	en	2015-07-21 22:40:04.107761+00
480	语言	语言	zh-TW	zh-CN	2015-07-21 22:40:17.99614+00
481	语言	語言	zh-CN	zh-TW	2015-07-21 22:40:18.080936+00
482	语言	Language	zh-CN	en	2015-07-21 22:40:18.187818+00
483	为确保您能及时收到邮件，请使用主流邮箱	为确保您能及时收到邮件，请使用主流邮箱	zh-TW	zh-CN	2015-07-21 22:50:19.787554+00
484	为确保您能及时收到邮件，请使用主流邮箱	為確保您能及時收到郵件，請使用主流郵箱	zh-CN	zh-TW	2015-07-21 22:50:19.854374+00
485	为确保您能及时收到邮件，请使用主流邮箱	To ensure that you receive e-mail in a timely manner, please use the mainstream mailbox	zh-CN	en	2015-07-21 22:50:20.07193+00
486	亲爱的用户	亲爱的用户	zh-TW	zh-CN	2015-07-21 22:54:16.393955+00
487	亲爱的用户	親愛的用戶	zh-CN	zh-TW	2015-07-21 22:54:16.452026+00
488	亲爱的用户	Dear user	zh-CN	en	2015-07-21 22:54:16.548536+00
489	您已经将百度帐号	您已经将百度帐号	zh-TW	zh-CN	2015-07-21 22:54:36.524826+00
490	您已经将百度帐号	您已經將百度帳號	zh-CN	zh-TW	2015-07-21 22:54:36.60761+00
491	您已经将百度帐号	You have to Baidu account	zh-CN	en	2015-07-21 22:54:36.769515+00
492	设置安全邮箱，可找回丢失密码。	设置安全邮箱，可找回丢失密码。	zh-TW	zh-CN	2015-07-21 22:57:17.545093+00
493	设置安全邮箱，可找回丢失密码。	設置安全郵箱，可找回丟失密碼。	zh-CN	zh-TW	2015-07-21 22:57:17.707592+00
494	设置安全邮箱，可找回丢失密码。	Set security mailbox, you can recover lost passwords.	zh-CN	en	2015-07-21 22:57:17.897045+00
495	当前安全邮箱	当前安全邮箱	zh-TW	zh-CN	2015-07-21 22:57:29.476111+00
496	当前安全邮箱	當前安全郵箱	zh-CN	zh-TW	2015-07-21 22:57:29.561287+00
497	当前安全邮箱	The current security-mail	zh-CN	en	2015-07-21 22:57:29.707473+00
554	登录中	Log in	zh-CN	en	2015-07-22 03:48:08.672314+00
498	设置安全邮箱，可找回丢失密码。\n当前安全邮箱\n\n微博登录密码	设置安全邮箱，可找回丢失密码。\n当前安全邮箱\n\n微博登录密码	zh-TW	zh-CN	2015-07-21 22:57:49.35239+00
499	设置安全邮箱，可找回丢失密码。\n当前安全邮箱\n\n微博登录密码	設置安全郵箱，可找回丟失密碼。\n當前安全郵箱\n\n微博登錄密碼	zh-CN	zh-TW	2015-07-21 22:57:49.431095+00
500	设置安全邮箱，可找回丢失密码。\n当前安全邮箱\n\n微博登录密码	Set security mailbox, you can recover lost passwords.\nThe current security-mail\n\nTwitter Password	zh-CN	en	2015-07-21 22:57:49.615986+00
501	微博登录密码	微博登录密码	zh-TW	zh-CN	2015-07-21 22:58:10.875616+00
502	微博登录密码	微博登錄密碼	zh-CN	zh-TW	2015-07-21 22:58:10.981758+00
503	微博登录密码	Twitter Password	zh-CN	en	2015-07-21 22:58:11.130659+00
504	邮箱/会员帐号/手机号	邮箱/会员帐号/手机号	zh-TW	zh-CN	2015-07-21 23:03:08.423574+00
505	邮箱/会员帐号/手机号	郵箱/會員帳號/手機號	zh-CN	zh-TW	2015-07-21 23:03:08.515744+00
506	邮箱/会员帐号/手机号	E-mail / Member ID / phone number	zh-CN	en	2015-07-21 23:03:08.680385+00
507	登录名或密码错误	登录名或密码错误	zh-TW	zh-CN	2015-07-21 23:03:42.081839+00
508	登录名或密码错误	登錄名或密碼錯誤	zh-CN	zh-TW	2015-07-21 23:03:42.197049+00
509	登录名或密码错误	Wrong username or password	zh-CN	en	2015-07-21 23:03:42.470782+00
510	解救，从这里开始	解救，从这里开始	zh-TW	zh-CN	2015-07-21 23:22:33.603643+00
511	解救，从这里开始	解救，從這裡開始	zh-CN	zh-TW	2015-07-21 23:22:33.712182+00
512	解救，从这里开始	Rescued from here	zh-CN	en	2015-07-21 23:22:33.890911+00
513	不能登录的帐号	不能登录的帐号	zh-TW	zh-CN	2015-07-21 23:22:48.405264+00
514	不能登录的帐号	不能登錄的帳號	zh-CN	zh-TW	2015-07-21 23:22:48.471919+00
515	不能登录的帐号	You can not login account	zh-CN	en	2015-07-21 23:22:48.584479+00
516	QQ安全中心为您拦截异常1次，您的帐号疑似被盗，正处于保护模式中。	QQ安全中心为您拦截异常1次，您的帐号疑似被盗，正处于保护模式中。	zh-TW	zh-CN	2015-07-21 23:28:00.301323+00
517	QQ安全中心为您拦截异常1次，您的帐号疑似被盗，正处于保护模式中。	QQ安全中心為您攔截異常1次，您的帳號疑似被盜，正處於保護模式中。	zh-CN	zh-TW	2015-07-21 23:28:00.382241+00
518	QQ安全中心为您拦截异常1次，您的帐号疑似被盗，正处于保护模式中。	QQ Security Center to intercept an exception for you once your account suspected of theft, it is in protected mode.	zh-CN	en	2015-07-21 23:28:00.740001+00
519	请您先发短信，再点“查看结果”按钮	请您先发短信，再点“查看结果”按钮	zh-TW	zh-CN	2015-07-21 23:28:37.891807+00
520	请您先发短信，再点“查看结果”按钮	請您先發短信，再點“查看結果”按鈕	zh-CN	zh-TW	2015-07-21 23:28:37.950869+00
521	请您先发短信，再点“查看结果”按钮	Please send your first message, and then click "View Results" button	zh-CN	en	2015-07-21 23:28:38.145881+00
522	通过发短信恢复使用	通过发短信恢复使用	zh-TW	zh-CN	2015-07-21 23:29:02.067667+00
523	通过发短信恢复使用	通過發短信恢復使用	zh-CN	zh-TW	2015-07-21 23:29:02.13884+00
524	通过发短信恢复使用	By texting resume use	zh-CN	en	2015-07-21 23:29:02.284336+00
525	如果发送多次仍不成功，您可以尝试将短信发送到	如果发送多次仍不成功，您可以尝试将短信发送到	zh-TW	zh-CN	2015-07-21 23:39:45.247746+00
526	如果发送多次仍不成功，您可以尝试将短信发送到	如果發送多次仍不成功，您可以嘗試將短信發送到	zh-CN	zh-TW	2015-07-21 23:39:45.307437+00
527	如果发送多次仍不成功，您可以尝试将短信发送到	If you send multiple unsuccessful, you can try to send a message to	zh-CN	en	2015-07-21 23:39:45.54652+00
528	请您先发短信，再点“查看结果”按钮。	请您先发短信，再点“查看结果”按钮。	zh-TW	zh-CN	2015-07-21 23:40:00.313977+00
529	请您先发短信，再点“查看结果”按钮。	請您先發短信，再點“查看結果”按鈕。	zh-CN	zh-TW	2015-07-21 23:40:00.497912+00
530	请您先发短信，再点“查看结果”按钮。	Please send your first message, and then click "View Results" button.	zh-CN	en	2015-07-21 23:40:00.679185+00
531	编辑短信	编辑短信	zh-TW	zh-CN	2015-07-21 23:40:12.752899+00
532	编辑短信	編輯短信	zh-CN	zh-TW	2015-07-21 23:40:12.815355+00
533	编辑短信	Edit SMS	zh-CN	en	2015-07-21 23:40:12.957877+00
534	发送到	发送到	zh-TW	zh-CN	2015-07-21 23:40:23.478368+00
535	发送到	發送到	zh-CN	zh-TW	2015-07-21 23:40:23.568201+00
536	发送到	Send to	zh-CN	en	2015-07-21 23:40:23.650487+00
537	通过QQ邮箱发垃圾邮件	通过QQ邮箱发垃圾邮件	zh-TW	zh-CN	2015-07-21 23:48:47.447954+00
538	通过QQ邮箱发垃圾邮件	通過QQ郵箱發垃圾郵件	zh-CN	zh-TW	2015-07-21 23:48:47.511673+00
539	通过QQ邮箱发垃圾邮件	Spam mail through QQ	zh-CN	en	2015-07-21 23:48:47.649363+00
540	正在进行短信验证，信号不好时会有延迟，请稍等片刻。	正在进行短信验证，信号不好时会有延迟，请稍等片刻。	zh-TW	zh-CN	2015-07-21 23:59:59.490964+00
541	正在进行短信验证，信号不好时会有延迟，请稍等片刻。	正在進行短信驗證，信號不好時會有延遲，請稍等片刻。	zh-CN	zh-TW	2015-07-21 23:59:59.575581+00
542	正在进行短信验证，信号不好时会有延迟，请稍等片刻。	SMS verification in progress, a bad signal will be delayed, please wait a moment.	zh-CN	en	2015-07-21 23:59:59.808186+00
543	操作超时，由于您长时间未操作，为确保安全，请返回首页重试。	操作超时，由于您长时间未操作，为确保安全，请返回首页重试。	zh-TW	zh-CN	2015-07-22 00:29:33.474484+00
544	操作超时，由于您长时间未操作，为确保安全，请返回首页重试。	操作超時，由於您長時間未操作，為確保安全，請返回首頁重試。	zh-CN	zh-TW	2015-07-22 00:29:33.534121+00
545	操作超时，由于您长时间未操作，为确保安全，请返回首页重试。	The operation timed out because you do not operate for a long time, to ensure safety, return home and try again.	zh-CN	en	2015-07-22 00:29:33.820822+00
546	查看结果	查看结果	zh-TW	zh-CN	2015-07-22 03:30:00.974739+00
547	查看结果	查看結果	zh-CN	zh-TW	2015-07-22 03:30:01.112612+00
548	查看结果	View Results	zh-CN	en	2015-07-22 03:30:01.305114+00
549	正在进行短信验证，信号不好时会有延迟，请稍等片刻	正在进行短信验证，信号不好时会有延迟，请稍等片刻	zh-TW	zh-CN	2015-07-22 03:30:20.034844+00
550	正在进行短信验证，信号不好时会有延迟，请稍等片刻	正在進行短信驗證，信號不好時會有延遲，請稍等片刻	zh-CN	zh-TW	2015-07-22 03:30:20.167244+00
551	正在进行短信验证，信号不好时会有延迟，请稍等片刻	SMS verification in progress, a bad signal will be delayed, please wait a moment	zh-CN	en	2015-07-22 03:30:20.444478+00
552	登录中	登录中	zh-TW	zh-CN	2015-07-22 03:48:08.387641+00
555	您的帐号暂时无法登录，请点击这里恢复正常使用。	您的帐号暂时无法登录，请点击这里恢复正常使用。	zh-TW	zh-CN	2015-07-22 03:48:15.552146+00
556	您的帐号暂时无法登录，请点击这里恢复正常使用。	您的帳號暫時無法登錄，請點擊這裡恢復正常使用。	zh-CN	zh-TW	2015-07-22 03:48:15.651342+00
557	您的帐号暂时无法登录，请点击这里恢复正常使用。	Your account is temporarily unable to login, please click here back to normal use.	zh-CN	en	2015-07-22 03:48:15.976877+00
558	为了保证您的帐号安全，更换密保邮箱前请先进行安全验证	为了保证您的帐号安全，更换密保邮箱前请先进行安全验证	zh-TW	zh-CN	2015-07-22 03:49:54.874094+00
559	为了保证您的帐号安全，更换密保邮箱前请先进行安全验证	為了保證您的帳號安全，更換密保郵箱前請先進行安全驗證	zh-CN	zh-TW	2015-07-22 03:49:54.959119+00
560	为了保证您的帐号安全，更换密保邮箱前请先进行安全验证	To ensure the security of your account, please replace secret security mailbox for secure authentication before	zh-CN	en	2015-07-22 03:49:55.353464+00
561	更换密保申请表	更换密保申请表	zh-TW	zh-CN	2015-07-22 03:50:53.630164+00
562	更换密保申请表	更換密保申請表	zh-CN	zh-TW	2015-07-22 03:50:53.764815+00
563	更换密保申请表	Replacing secret security application form	zh-CN	en	2015-07-22 03:50:54.118287+00
564	号码格式不正确	号码格式不正确	zh-TW	zh-CN	2015-07-22 03:54:30.664346+00
565	号码格式不正确	號碼格式不正確	zh-CN	zh-TW	2015-07-22 03:54:30.761459+00
566	号码格式不正确	Number format is incorrect	zh-CN	en	2015-07-22 03:54:30.916075+00
567	密保邮箱可以用来登录百度贴吧、音乐、糯米、钱包、文库、知道等所有百度产品	密保邮箱可以用来登录百度贴吧、音乐、糯米、钱包、文库、知道等所有百度产品	zh-TW	zh-CN	2015-07-22 03:55:30.865628+00
568	密保邮箱可以用来登录百度贴吧、音乐、糯米、钱包、文库、知道等所有百度产品	密保郵箱可以用來登錄百度貼吧、音樂、糯米、錢包、文庫、知道等所有百度產品	zh-CN	zh-TW	2015-07-22 03:55:30.944439+00
569	密保邮箱可以用来登录百度贴吧、音乐、糯米、钱包、文库、知道等所有百度产品	Secret security mailbox can be used to log on Baidu Post Bar, music, rice, wallets, library, Baidu know, etc. All products	zh-CN	en	2015-07-22 03:55:31.315033+00
570	请勿泄露邮箱信息，轻信他人邮件，以防不法分子利用，造成个人损失	请勿泄露邮箱信息，轻信他人邮件，以防不法分子利用，造成个人损失	zh-TW	zh-CN	2015-07-22 03:55:47.008497+00
571	请勿泄露邮箱信息，轻信他人邮件，以防不法分子利用，造成个人损失	請勿洩露郵箱信息，輕信他人郵件，以防不法分子利用，造成個人損失	zh-CN	zh-TW	2015-07-22 03:55:47.112251+00
572	请勿泄露邮箱信息，轻信他人邮件，以防不法分子利用，造成个人损失	Do not disclose the mailbox information, rely on others message, to prevent unscrupulous elements, resulting in personal losses	zh-CN	en	2015-07-22 03:55:47.38066+00
573	重新检测	重新检测	zh-TW	zh-CN	2015-07-22 04:00:25.375034+00
574	重新检测	重新檢測	zh-CN	zh-TW	2015-07-22 04:00:25.483844+00
575	重新检测	Re-test	zh-CN	en	2015-07-22 04:00:25.624139+00
576	绑定密保手机，帐号安全一步到位	绑定密保手机，帐号安全一步到位	zh-TW	zh-CN	2015-07-22 04:00:43.501028+00
577	绑定密保手机，帐号安全一步到位	綁定密保手機，帳號安全一步到位	zh-CN	zh-TW	2015-07-22 04:00:43.660638+00
578	绑定密保手机，帐号安全一步到位	Bound secret security phone account security step	zh-CN	en	2015-07-22 04:00:43.954676+00
579	安全提醒设置	安全提醒设置	zh-TW	zh-CN	2015-07-22 04:05:15.512367+00
580	安全提醒设置	安全提醒設置	zh-CN	zh-TW	2015-07-22 04:05:15.59681+00
581	安全提醒设置	Security alert settings	zh-CN	en	2015-07-22 04:05:15.755732+00
582	当帐号发生异常情况时，系统自动发送的通知提醒	当帐号发生异常情况时，系统自动发送的通知提醒	zh-TW	zh-CN	2015-07-22 04:05:35.873855+00
583	当帐号发生异常情况时，系统自动发送的通知提醒	當帳號發生異常情況時，系統自動發送的通知提醒	zh-CN	zh-TW	2015-07-22 04:05:35.971848+00
584	当帐号发生异常情况时，系统自动发送的通知提醒	When the account exception occurs, the system automatically sends notification reminders	zh-CN	en	2015-07-22 04:05:36.256778+00
585	登录历史	登录历史	zh-TW	zh-CN	2015-07-22 04:06:22.255587+00
586	登录历史	登錄歷史	zh-CN	zh-TW	2015-07-22 04:06:22.331489+00
587	登录历史	Login History	zh-CN	en	2015-07-22 04:06:22.487072+00
588	以下为您最近3次登录记录，若存在异常情况，请在核实后尽快修改密码	以下为您最近3次登录记录，若存在异常情况，请在核实后尽快修改密码	zh-TW	zh-CN	2015-07-22 04:06:42.426651+00
589	以下为您最近3次登录记录，若存在异常情况，请在核实后尽快修改密码	以下為您最近3次登錄記錄，若存在異常情況，請在核實後儘快修改密碼	zh-CN	zh-TW	2015-07-22 04:06:42.518383+00
590	以下为您最近3次登录记录，若存在异常情况，请在核实后尽快修改密码	Here is the log in your last three records, if there is an abnormality, please change your password as soon as possible after verification	zh-CN	en	2015-07-22 04:06:42.916376+00
591	恢复正常使用	恢复正常使用	zh-TW	zh-CN	2015-07-22 04:11:13.167106+00
592	恢复正常使用	恢復正常使用	zh-CN	zh-TW	2015-07-22 04:11:13.271003+00
593	恢复正常使用	Resume normal use	zh-CN	en	2015-07-22 04:11:13.449447+00
594	请选择您遇到的问题，我们会尽快完善产品方案	请选择您遇到的问题，我们会尽快完善产品方案	zh-TW	zh-CN	2015-07-22 04:17:24.199856+00
595	请选择您遇到的问题，我们会尽快完善产品方案	請選擇您遇到的問題，我們會盡快完善產品方案	zh-CN	zh-TW	2015-07-22 04:17:24.270381+00
596	请选择您遇到的问题，我们会尽快完善产品方案	Please select the issue you're experiencing, we will expedite the development of product solutions	zh-CN	en	2015-07-22 04:17:24.537616+00
597	发短信遇到问题？	发短信遇到问题？	zh-TW	zh-CN	2015-07-22 04:18:10.952072+00
598	发短信遇到问题？	發短信遇到問題？	zh-CN	zh-TW	2015-07-22 04:18:11.019561+00
599	发短信遇到问题？	Texting Problems?	zh-CN	en	2015-07-22 04:18:11.170255+00
600	我不会发短信，从来不用短信	我不会发短信，从来不用短信	zh-TW	zh-CN	2015-07-22 04:19:16.121879+00
601	我不会发短信，从来不用短信	我不會發短信，從來不用短信	zh-CN	zh-TW	2015-07-22 04:19:16.22085+00
602	我不会发短信，从来不用短信	I do not send text messages, never use text messaging	zh-CN	en	2015-07-22 04:19:16.402208+00
603	这个QQ号对我不重要，不想发短信	这个QQ号对我不重要，不想发短信	zh-TW	zh-CN	2015-07-22 04:19:33.717245+00
604	这个QQ号对我不重要，不想发短信	這個QQ號對我不重要，不想發短信	zh-CN	zh-TW	2015-07-22 04:19:33.808123+00
605	这个QQ号对我不重要，不想发短信	The QQ number is not important for me, I do not want to send text messages	zh-CN	en	2015-07-22 04:19:34.022215+00
606	看不懂页面内容，不知道发什么	看不懂页面内容，不知道发什么	zh-TW	zh-CN	2015-07-22 04:19:47.473758+00
607	看不懂页面内容，不知道发什么	看不懂頁面內容，不知道發什麼	zh-CN	zh-TW	2015-07-22 04:19:47.542096+00
608	看不懂页面内容，不知道发什么	Read page content, do not know what hair	zh-CN	en	2015-07-22 04:19:47.719518+00
609	短信发了很多次，都不成功	短信发了很多次，都不成功	zh-TW	zh-CN	2015-07-22 04:20:05.180083+00
610	短信发了很多次，都不成功	短信發了很多次，都不成功	zh-CN	zh-TW	2015-07-22 04:20:05.279811+00
611	短信发了很多次，都不成功	SMS made a lot of times, without success	zh-CN	en	2015-07-22 04:20:05.487606+00
612	其他	其他	zh-TW	zh-CN	2015-07-22 04:20:17.45859+00
613	其他	其他	zh-CN	zh-TW	2015-07-22 04:20:17.613604+00
614	其他	Other	zh-CN	en	2015-07-22 04:20:17.699664+00
615	非常满意	非常满意	zh-TW	zh-CN	2015-07-22 04:22:14.573209+00
616	非常满意	非常滿意	zh-CN	zh-TW	2015-07-22 04:22:14.682706+00
617	非常满意	Very satisfied	zh-CN	en	2015-07-22 04:22:14.858591+00
618	次	次	zh-TW	zh-CN	2015-07-22 04:30:41.239608+00
619	次	次	zh-CN	zh-TW	2015-07-22 04:30:41.359572+00
620	次	Secondary	zh-CN	en	2015-07-22 04:30:41.495702+00
621	论坛	论坛	zh-TW	zh-CN	2015-07-22 04:45:59.691376+00
622	论坛	論壇	zh-CN	zh-TW	2015-07-22 04:45:59.761215+00
623	论坛	Forum	zh-CN	en	2015-07-22 04:45:59.855701+00
624	中文俱樂部	中文俱乐部	zh-TW	zh-CN	2015-07-22 05:23:09.875827+00
625	中文俱樂部	中文俱樂部	zh-CN	zh-TW	2015-07-22 05:23:09.933117+00
626	中文俱樂部	Chinese club	zh-CN	en	2015-07-22 05:23:10.024202+00
627	中文俱乐部	中文俱乐部	zh-TW	zh-CN	2015-07-22 05:23:50.58994+00
628	中文俱乐部	中文俱樂部	zh-CN	zh-TW	2015-07-22 05:23:50.657923+00
629	中文俱乐部	Chinese club	zh-CN	en	2015-07-22 05:23:50.777044+00
630	大赛简介	大赛简介	zh-TW	zh-CN	2015-07-22 06:32:15.878646+00
631	大赛简介	大賽簡介	zh-CN	zh-TW	2015-07-22 06:32:16.009233+00
632	大赛简介	Competition Introduction	zh-CN	en	2015-07-22 06:32:16.21181+00
633	冻结对第三方应用的授权	冻结对第三方应用的授权	zh-TW	zh-CN	2015-07-22 16:50:17.139341+00
634	冻结对第三方应用的授权	凍結對第三方應用的授權	zh-CN	zh-TW	2015-07-22 16:50:17.383021+00
635	冻结对第三方应用的授权	Freeze authorize third-party applications	zh-CN	en	2015-07-22 16:50:17.649386+00
636	清空定时微博	清空定时微博	zh-TW	zh-CN	2015-07-22 16:50:37.560246+00
637	清空定时微博	清空定時微博	zh-CN	zh-TW	2015-07-22 16:50:37.691743+00
638	清空定时微博	Empty timed microblogging	zh-CN	en	2015-07-22 16:50:37.994905+00
639	修改密码	修改密码	zh-TW	zh-CN	2015-07-22 16:50:55.226721+00
640	修改密码	修改密碼	zh-CN	zh-TW	2015-07-22 16:50:55.388396+00
641	修改密码	Change Password	zh-CN	en	2015-07-22 16:50:55.658958+00
642	验证码已发送至邮箱，去邮箱查看	验证码已发送至邮箱，去邮箱查看	zh-TW	zh-CN	2015-07-22 16:53:25.812172+00
643	验证码已发送至邮箱，去邮箱查看	驗證碼已發送至郵箱，去郵箱查看	zh-CN	zh-TW	2015-07-22 16:53:25.931768+00
644	验证码已发送至邮箱，去邮箱查看	Verification code has been sent to the mailbox, go to the mailbox view	zh-CN	en	2015-07-22 16:53:26.239087+00
645	帐号登录	帐号登录	zh-TW	zh-CN	2015-07-22 17:01:29.653744+00
646	帐号登录	帳號登錄	zh-CN	zh-TW	2015-07-22 17:01:29.812695+00
647	帐号登录	Account login	zh-CN	en	2015-07-22 17:01:30.072731+00
648	通过邮箱验证	通过邮箱验证	zh-TW	zh-CN	2015-07-22 17:03:50.476168+00
649	通过邮箱验证	通過郵箱驗證	zh-CN	zh-TW	2015-07-22 17:03:50.676474+00
650	通过邮箱验证	By mail authentication	zh-CN	en	2015-07-22 17:03:50.940613+00
651	系统已经向您的邮箱ch*******@gmail.com发送了验证邮件，请于1小时内完成验证	系统已经向您的邮箱ch*******@gmail.com发送了验证邮件，请于1小时内完成验证	zh-TW	zh-CN	2015-07-22 17:05:13.443823+00
652	系统已经向您的邮箱ch*******@gmail.com发送了验证邮件，请于1小时内完成验证	系統已經向您的郵箱ch*******@gmail.com發送了驗證郵件，請於1小時內完成驗證	zh-CN	zh-TW	2015-07-22 17:05:13.599467+00
653	系统已经向您的邮箱ch*******@gmail.com发送了验证邮件，请于1小时内完成验证	System verification message has been sent to your mailbox ch*******@gmail.com, please complete the verification within one hour	zh-CN	en	2015-07-22 17:05:14.003846+00
654	没有旧密码可以不填。	没有旧密码可以不填。	zh-TW	zh-CN	2015-07-22 17:07:13.824165+00
655	没有旧密码可以不填。	沒有舊密碼可以不填。	zh-CN	zh-TW	2015-07-22 17:07:13.918076+00
656	没有旧密码可以不填。	No old password can not fill.	zh-CN	en	2015-07-22 17:07:14.1164+00
657	集齐C币，召唤神龙！	集齐C币，召唤神龙！	zh-TW	zh-CN	2015-07-22 17:16:22.827485+00
658	集齐C币，召唤神龙！	集齊C幣，召喚神龍！	zh-CN	zh-TW	2015-07-22 17:16:22.936819+00
659	集齐C币，召唤神龙！	Collect coins C, call Dragon!	zh-CN	en	2015-07-22 17:16:23.100137+00
660	宀	宀	zh-TW	zh-CN	2015-07-22 18:50:28.663854+00
661	宀	宀	zh-CN	zh-TW	2015-07-22 18:50:28.744073+00
662	宀	Rock	zh-CN	en	2015-07-22 18:50:28.827383+00
663	小姐	小姐	zh-TW	zh-CN	2015-07-22 21:01:50.873639+00
664	小姐	小姐	zh-CN	zh-TW	2015-07-22 21:01:51.152908+00
665	小姐	Miss	zh-CN	en	2015-07-22 21:01:51.285623+00
666	我计划访问上海在2015年10月下旬。	我计划访问上海在2015年10月下旬。	zh-TW	zh-CN	2015-07-22 23:46:40.703636+00
667	我计划访问上海在2015年10月下旬。	我計劃訪問上海在2015年10月下旬。	zh-CN	zh-TW	2015-07-22 23:46:40.830993+00
668	我计划访问上海在2015年10月下旬。	I plan to visit Shanghai in late October 2015.	zh-CN	en	2015-07-22 23:46:41.142246+00
669	我计划在2015年10月下旬访问上海.	我计划在2015年10月下旬访问上海.	zh-TW	zh-CN	2015-07-23 01:36:55.268512+00
670	我计划在2015年10月下旬访问上海.	我計劃在2015年10月下旬訪問上海.	zh-CN	zh-TW	2015-07-23 01:36:55.369851+00
671	我计划在2015年10月下旬访问上海.	I plan to visit Shanghai in late October 2015.	zh-CN	en	2015-07-23 01:36:55.672814+00
672	我计划在2015年10月下旬去趟上海。	我计划在2015年10月下旬去趟上海。	zh-TW	zh-CN	2015-07-23 01:37:09.984382+00
673	我计划在2015年10月下旬去趟上海。	我計劃在2015年10月下旬去趟上海。	zh-CN	zh-TW	2015-07-23 01:37:10.083724+00
674	我计划在2015年10月下旬去趟上海。	In 2015, I plan to go to Shanghai in late October.	zh-CN	en	2015-07-23 01:37:10.382229+00
675	我计划2015年10月下旬访问上	我计划2015年10月下旬访问上	zh-TW	zh-CN	2015-07-23 01:38:07.558776+00
830	不会	不会	zh-TW	zh-CN	2015-07-30 03:20:22.946584+00
676	我计划2015年10月下旬访问上	我計劃2015年10月下旬訪問上	zh-CN	zh-TW	2015-07-23 01:38:07.654693+00
677	我计划2015年10月下旬访问上	I plan to visit in late October 2015 on	zh-CN	en	2015-07-23 01:38:07.929459+00
678	我计划2015年10月下旬访问上海。	我计划2015年10月下旬访问上海。	zh-TW	zh-CN	2015-07-23 01:39:09.718733+00
679	我计划2015年10月下旬访问上海。	我計劃2015年10月下旬訪問上海。	zh-CN	zh-TW	2015-07-23 01:39:09.816044+00
680	我计划2015年10月下旬访问上海。	I plan to visit in late October 2015, Shanghai.	zh-CN	en	2015-07-23 01:39:10.06781+00
681	我计划在2015年10月下旬访问上海。	我计划在2015年10月下旬访问上海。	zh-TW	zh-CN	2015-07-23 15:58:08.519705+00
682	我计划在2015年10月下旬访问上海。	我計劃在2015年10月下旬訪問上海。	zh-CN	zh-TW	2015-07-23 15:58:08.733525+00
683	我计划在2015年10月下旬访问上海。	I plan to visit Shanghai in late October 2015.	zh-CN	en	2015-07-23 15:58:08.923297+00
684	尸	尸	zh-TW	zh-CN	2015-07-24 06:23:22.428701+00
685	尸	屍	zh-CN	zh-TW	2015-07-24 06:23:22.906193+00
686	尸	Corpse	zh-CN	en	2015-07-24 06:23:23.167936+00
687	面子	面子	zh-TW	zh-CN	2015-07-24 17:33:30.249041+00
688	面子	面子	zh-CN	zh-TW	2015-07-24 17:33:30.45775+00
689	面子	Face	zh-CN	en	2015-07-24 17:33:30.561259+00
690	关系	关系	zh-TW	zh-CN	2015-07-24 17:34:03.022451+00
691	关系	關係	zh-CN	zh-TW	2015-07-24 17:34:03.129957+00
692	关系	Relationship	zh-CN	en	2015-07-24 17:34:03.242985+00
693	人情	人情	zh-TW	zh-CN	2015-07-24 17:34:22.349879+00
694	人情	人情	zh-CN	zh-TW	2015-07-24 17:34:22.425911+00
695	人情	Human	zh-CN	en	2015-07-24 17:34:22.490833+00
696	素质)	素质)	zh-TW	zh-CN	2015-07-24 17:39:31.246227+00
697	素质)	素質)	zh-CN	zh-TW	2015-07-24 17:39:31.347939+00
698	素质)	Quality)	zh-CN	en	2015-07-24 17:39:31.532946+00
699	领导	领导	zh-TW	zh-CN	2015-07-24 17:42:37.559027+00
700	领导	領導	zh-CN	zh-TW	2015-07-24 17:42:37.680037+00
701	领导	Leadership	zh-CN	en	2015-07-24 17:42:37.82883+00
702	缘分	缘分	zh-TW	zh-CN	2015-07-24 17:50:41.70063+00
703	缘分	緣分	zh-CN	zh-TW	2015-07-24 17:50:41.868737+00
704	缘分	Fate	zh-CN	en	2015-07-24 17:50:42.031966+00
705	从2015年10月20日至2015年10月31日，我会在上海（进行商务活动）。	从2015年10月20日至2015年10月31日，我会在上海（进行商务活动）。	zh-TW	zh-CN	2015-07-25 03:48:59.068952+00
706	从2015年10月20日至2015年10月31日，我会在上海（进行商务活动）。	從2015年10月20日至2015年10月31日，我會在上海（進行商務活動）。	zh-CN	zh-TW	2015-07-25 03:48:59.130655+00
707	从2015年10月20日至2015年10月31日，我会在上海（进行商务活动）。	From October 20, 2015 to October 31, 2015, I will be in Shanghai (for business).	zh-CN	en	2015-07-25 03:48:59.365458+00
708	微信	微信	zh-TW	zh-CN	2015-07-25 04:33:07.506679+00
709	微信	微信	zh-CN	zh-TW	2015-07-25 04:33:12.16004+00
710	微信	Wechat	zh-CN	en	2015-07-25 04:33:12.219389+00
711	从2015年10月20日至2015年10月31日，我会一直在上海。	从2015年10月20日至2015年10月31日，我会一直在上海。	zh-TW	zh-CN	2015-07-25 06:24:47.101448+00
712	从2015年10月20日至2015年10月31日，我会一直在上海。	從2015年10月20日至2015年10月31日，我會一直在上海。	zh-CN	zh-TW	2015-07-25 06:24:47.167241+00
713	从2015年10月20日至2015年10月31日，我会一直在上海。	From October 20, 2015 to October 31, 2015, I would have been in Shanghai.	zh-CN	en	2015-07-25 06:24:47.401342+00
714	从2015年10月20日至2015年10月31日，我会在上海。	从2015年10月20日至2015年10月31日，我会在上海。	zh-TW	zh-CN	2015-07-25 07:05:31.853906+00
715	从2015年10月20日至2015年10月31日，我会在上海。	從2015年10月20日至2015年10月31日，我會在上海。	zh-CN	zh-TW	2015-07-25 07:05:31.921634+00
716	从2015年10月20日至2015年10月31日，我会在上海。	From October 20, 2015 to October 31, 2015, I will be in Shanghai.	zh-CN	en	2015-07-25 07:05:32.072054+00
717	我从2015年10月20日至2015年10月31日会一直在上海。	我从2015年10月20日至2015年10月31日会一直在上海。	zh-TW	zh-CN	2015-07-25 16:25:33.407321+00
718	我从2015年10月20日至2015年10月31日会一直在上海。	我從2015年10月20日至2015年10月31日會一直在上海。	zh-CN	zh-TW	2015-07-25 16:25:33.653055+00
719	我从2015年10月20日至2015年10月31日会一直在上海。	I October 20, 2015 to October 31, 2015 would have been in Shanghai.	zh-CN	en	2015-07-25 16:25:33.838825+00
720	从2015年10月20日至10月31日,我会在上海。	从2015年10月20日至10月31日,我会在上海。	zh-TW	zh-CN	2015-07-25 17:58:35.279714+00
721	从2015年10月20日至10月31日,我会在上海。	從2015年10月20日至10月31日,我會在上海。	zh-CN	zh-TW	2015-07-25 17:58:35.38159+00
722	从2015年10月20日至10月31日,我会在上海。	From 2015 October 20 to October 31, I will be in Shanghai.	zh-CN	en	2015-07-25 17:58:35.645485+00
723	上海黄浦区北京东路398号	上海黄浦区北京东路398号	zh-TW	zh-CN	2015-07-26 07:03:54.284454+00
724	上海黄浦区北京东路398号	上海黃浦區北京東路398號	zh-CN	zh-TW	2015-07-26 07:03:54.41561+00
725	上海黄浦区北京东路398号	Beijing East Road, Huangpu District, Shanghai No. 398	zh-CN	en	2015-07-26 07:03:54.667626+00
726	上海新协通国际大酒店	上海新协通国际大酒店	zh-TW	zh-CN	2015-07-26 07:04:31.765764+00
727	上海新协通国际大酒店	上海新協通國際大酒店	zh-CN	zh-TW	2015-07-26 07:04:31.845772+00
728	上海新协通国际大酒店	Shanghai Bund Riverside Hotel	zh-CN	en	2015-07-26 07:04:32.039758+00
729	湖酒家	湖酒家	zh-TW	zh-CN	2015-07-26 16:29:25.217338+00
730	太湖酒家	太湖酒家	zh-TW	zh-CN	2015-07-26 16:29:47.513727+00
731	太湖酒家	太湖酒家	zh-CN	zh-TW	2015-07-26 16:30:13.321975+00
732	太湖酒家	Taihu Lake Restaurant	zh-CN	en	2015-07-26 16:30:13.426569+00
733	湾区华人创业协会	湾区华人创业协会	zh-TW	zh-CN	2015-07-27 05:17:53.144874+00
734	湾区华人创业协会	灣區華人創業協會	zh-CN	zh-TW	2015-07-27 05:17:53.34593+00
735	湾区华人创业协会	Bay Area Chinese Venture Association	zh-CN	en	2015-07-27 05:17:53.453681+00
736	浙大学子创业团队赴硅谷谈投资，马云你怎么看？	浙大学子创业团队赴硅谷谈投资，马云你怎么看？	zh-TW	zh-CN	2015-07-27 05:19:18.006601+00
737	浙大学子创业团队赴硅谷谈投资，马云你怎么看？	浙大學子創業團隊赴矽谷談投資，馬雲你怎麼看？	zh-CN	zh-TW	2015-07-27 05:19:18.059702+00
738	浙大学子创业团队赴硅谷谈投资，马云你怎么看？	Zhejiang University students venture team went to Silicon Valley to talk about investment, Ma how do you see?	zh-CN	en	2015-07-27 05:19:18.262249+00
739	劳工就业法热点问题讲座，齐鲁会馆	劳工就业法热点问题讲座，齐鲁会馆	zh-TW	zh-CN	2015-07-27 05:19:50.721288+00
740	劳工就业法热点问题讲座，齐鲁会馆	勞工就業法熱點問題講座，齊魯會館	zh-CN	zh-TW	2015-07-27 05:19:50.77187+00
741	劳工就业法热点问题讲座，齐鲁会馆	Hot issues of labor employment law seminars, Qilu Hall	zh-CN	en	2015-07-27 05:19:50.919328+00
742	礻	礻	zh-TW	zh-CN	2015-07-27 19:04:04.06172+00
743	礻	礻	zh-CN	zh-TW	2015-07-27 19:04:04.299884+00
744	礻	Woo	zh-CN	en	2015-07-27 19:04:04.375604+00
745	搜狗输入法	搜狗输入法	zh-TW	zh-CN	2015-07-28 03:04:18.571849+00
746	搜狗输入法	搜狗輸入法	zh-CN	zh-TW	2015-07-28 03:04:18.947725+00
747	搜狗输入法	Sogou Input	zh-CN	en	2015-07-28 03:04:19.178076+00
748	中国惊奇先生	中国惊奇先生	zh-TW	zh-CN	2015-07-28 19:58:41.078225+00
749	中国惊奇先生	中國驚奇先生	zh-CN	zh-TW	2015-07-28 19:58:41.426535+00
750	中国惊奇先生	Mr. China surprise	zh-CN	en	2015-07-28 19:58:41.590605+00
751	#腾讯动漫	#腾讯动漫	zh-TW	zh-CN	2015-07-28 19:59:08.043526+00
752	#腾讯动漫	#騰訊動漫	zh-CN	zh-TW	2015-07-28 19:59:08.154897+00
753	#腾讯动漫	# Tencent animation	zh-CN	en	2015-07-28 19:59:08.32103+00
754	腾讯动漫	腾讯动漫	zh-TW	zh-CN	2015-07-28 19:59:32.403981+00
755	腾讯动漫	騰訊動漫	zh-CN	zh-TW	2015-07-28 19:59:32.525357+00
756	腾讯动漫	Tencent animation	zh-CN	en	2015-07-28 19:59:32.67218+00
757	动漫	动漫	zh-TW	zh-CN	2015-07-28 20:00:24.320682+00
758	动漫	動漫	zh-CN	zh-TW	2015-07-28 20:00:24.517883+00
759	动漫	Animation	zh-CN	en	2015-07-28 20:00:24.731366+00
760	王牌御史	王牌御史	zh-TW	zh-CN	2015-07-28 20:00:59.923621+00
761	王牌御史	王牌御史	zh-CN	zh-TW	2015-07-28 20:01:00.070447+00
762	王牌御史	Ace Censor	zh-CN	en	2015-07-28 20:01:00.257317+00
763	晚上	晚上	zh-TW	zh-CN	2015-07-29 04:11:20.053955+00
764	晚上	晚上	zh-CN	zh-TW	2015-07-29 04:11:20.348958+00
765	晚上	In the evening	zh-CN	en	2015-07-29 04:11:20.622583+00
766	课	课	zh-TW	zh-CN	2015-07-29 04:12:34.854232+00
767	课	課	zh-CN	zh-TW	2015-07-29 04:12:35.052119+00
768	课	Lesson	zh-CN	en	2015-07-29 04:12:35.174241+00
769	海生	海生	zh-TW	zh-CN	2015-07-29 05:23:34.84056+00
770	海生	海生	zh-CN	zh-TW	2015-07-29 05:23:35.096116+00
771	海生	Haisheng	zh-CN	en	2015-07-29 05:23:35.199836+00
772	艸	艸	zh-TW	zh-CN	2015-07-29 16:54:20.537025+00
773	艸	艸	zh-CN	zh-TW	2015-07-29 16:54:20.769797+00
774	艸	Cottage	zh-CN	en	2015-07-29 16:54:20.831729+00
775	知道	知道	zh-TW	zh-CN	2015-07-29 16:54:50.813719+00
776	知道	知道	zh-CN	zh-TW	2015-07-29 16:54:50.961899+00
777	知道	Know	zh-CN	en	2015-07-29 16:54:51.051463+00
778	竹	竹	zh-TW	zh-CN	2015-07-29 17:00:19.542404+00
779	竹	竹	zh-CN	zh-TW	2015-07-29 17:00:19.725046+00
780	竹	Bamboo	zh-CN	en	2015-07-29 17:00:19.87834+00
781	士	士	zh-TW	zh-CN	2015-07-29 17:08:33.881185+00
782	士	士	zh-CN	zh-TW	2015-07-29 17:08:34.037725+00
783	士	Scholar	zh-CN	en	2015-07-29 17:08:34.134464+00
784	扌	扌	zh-TW	zh-CN	2015-07-29 17:09:27.087222+00
785	扌	扌	zh-CN	zh-TW	2015-07-29 17:09:27.238603+00
786	扌	Rolling	zh-CN	en	2015-07-29 17:09:27.325592+00
787	干	干	zh-TW	zh-CN	2015-07-29 17:26:55.559107+00
788	干	幹	zh-CN	zh-TW	2015-07-29 17:26:55.660121+00
789	干	Dry	zh-CN	en	2015-07-29 17:26:55.770072+00
790	犭	犭	zh-TW	zh-CN	2015-07-29 17:30:56.463851+00
791	犭	犭	zh-CN	zh-TW	2015-07-29 17:30:56.628593+00
792	犭	Quan	zh-CN	en	2015-07-29 17:30:56.718552+00
793	百	百	zh-TW	zh-CN	2015-07-29 17:33:36.511547+00
794	百	百	zh-CN	zh-TW	2015-07-29 17:33:36.571042+00
795	百	Hundred	zh-CN	en	2015-07-29 17:33:36.622883+00
796	腾讯	腾讯	zh-TW	zh-CN	2015-07-29 20:44:18.642813+00
797	腾讯	騰訊	zh-CN	zh-TW	2015-07-29 20:44:18.99467+00
798	腾讯	Tencent	zh-CN	en	2015-07-29 20:44:19.119374+00
799	请	请	zh-TW	zh-CN	2015-07-29 20:58:32.427198+00
800	请	請	zh-CN	zh-TW	2015-07-29 20:58:32.562747+00
801	请问，你有一个微信账号？	请问，你有一个微信账号？	zh-TW	zh-CN	2015-07-29 20:59:01.248173+00
802	请问，你有一个微信账号？	請問，你有一個微信賬號？	zh-CN	zh-TW	2015-07-29 20:59:01.334626+00
803	请问，你有一个微信账号？	Excuse me, you have a micro-channel account?	zh-CN	en	2015-07-29 20:59:01.510385+00
804	请问，您有一个微信账号？	请问，您有一个微信账号？	zh-TW	zh-CN	2015-07-29 21:00:46.891255+00
805	请问，您有一个微信账号？	請問，您有一個微信賬號？	zh-CN	zh-TW	2015-07-29 21:00:47.132628+00
806	请问，您有一个微信账号？	Excuse me, you have a micro-channel account?	zh-CN	en	2015-07-29 21:00:47.395438+00
807	普通话	普通话	zh-TW	zh-CN	2015-07-29 21:09:41.713564+00
808	普通话	Mandarin	zh-CN	en	2015-07-29 21:09:41.93118+00
809	如果还需要帮助，可以加我好友！	如果还需要帮助，可以加我好友！	zh-TW	zh-CN	2015-07-29 23:07:40.334648+00
810	如果还需要帮助，可以加我好友！	如果還需要幫助，可以加我好友！	zh-CN	zh-TW	2015-07-29 23:07:40.630344+00
811	如果还需要帮助，可以加我好友！	If you need help, you can add my friend!	zh-CN	en	2015-07-29 23:07:40.869014+00
812	谢谢你	谢谢你	zh-TW	zh-CN	2015-07-29 23:09:05.949571+00
813	谢谢你	謝謝你	zh-CN	zh-TW	2015-07-29 23:09:06.09451+00
814	谢谢你	Thank you	zh-CN	en	2015-07-29 23:09:06.226174+00
815	写的很好！	写的很好！	zh-TW	zh-CN	2015-07-29 23:10:08.620555+00
816	写的很好！	寫的很好！	zh-CN	zh-TW	2015-07-29 23:10:08.721287+00
817	写的很好！	Very well written!	zh-CN	en	2015-07-29 23:10:08.862462+00
818	你不用问中国人有没有微信，这是多余 的话。直接问微信号是多少就行了。要么你就问，你有微信吗？	你不用问中国人有没有微信，这是多余的话。直接问微信号是多少就行了。要么你就问，你有微信吗？	zh-TW	zh-CN	2015-07-30 02:43:20.963857+00
819	你不用问中国人有没有微信，这是多余 的话。直接问微信号是多少就行了。要么你就问，你有微信吗？	你不用問中國人有沒有微信，這是多餘的話。直接問微信號是多少就行了。要么你就問，你有微信嗎？	zh-CN	zh-TW	2015-07-30 02:43:21.078622+00
820	你不用问中国人有没有微信，这是多余 的话。直接问微信号是多少就行了。要么你就问，你有微信吗？	You do not ask the Chinese people have no micro-channel, which is superfluous words. Micro Signal directly asked how much on the line. Either you ask, you have micro-letters?	zh-CN	en	2015-07-30 02:43:21.404062+00
821	这	这	zh-TW	zh-CN	2015-07-30 03:15:15.77149+00
822	这	這	zh-CN	zh-TW	2015-07-30 03:15:15.864439+00
823	这	This	zh-CN	en	2015-07-30 03:15:15.984509+00
824	开	开	zh-TW	zh-CN	2015-07-30 03:15:44.294936+00
825	开	開	zh-CN	zh-TW	2015-07-30 03:15:44.364905+00
826	开	Open	zh-CN	en	2015-07-30 03:15:44.475147+00
827	了	了	zh-TW	zh-CN	2015-07-30 03:17:19.400214+00
828	了	了	zh-CN	zh-TW	2015-07-30 03:17:19.572559+00
829	了	The	zh-CN	en	2015-07-30 03:17:19.710721+00
831	不会	不會	zh-CN	zh-TW	2015-07-30 03:20:23.057614+00
832	不会	Will not	zh-CN	en	2015-07-30 03:20:23.166283+00
833	请问，您有微信吗？	请问，您有微信吗？	zh-TW	zh-CN	2015-07-30 07:00:16.920009+00
834	请问，您有微信吗？	請問，您有微信嗎？	zh-CN	zh-TW	2015-07-30 07:00:16.992933+00
835	请问，您有微信吗？	Excuse me, you have a micro-letters?	zh-CN	en	2015-07-30 07:00:17.154898+00
836	一般这么问就可以了，你有微信吗？你的微信是什么？同样的可以说你有QQ吗？	一般这么问就可以了，你有微信吗？你的微信是什么？同样的可以说你有QQ吗？	zh-TW	zh-CN	2015-07-30 07:00:29.85132+00
837	一般这么问就可以了，你有微信吗？你的微信是什么？同样的可以说你有QQ吗？	一般這麼問就可以了，你有微信嗎？你的微信是什麼？同樣的可以說你有QQ嗎？	zh-CN	zh-TW	2015-07-30 07:00:29.911302+00
838	一般这么问就可以了，你有微信吗？你的微信是什么？同样的可以说你有QQ吗？	Usually such a question can be, you have micro-letters? What is your micro-channel? The same can be said that you have QQ?	zh-CN	en	2015-07-30 07:00:30.18386+00
839	道	道	zh-TW	zh-CN	2015-07-30 14:51:04.586434+00
840	道	道	zh-CN	zh-TW	2015-07-30 14:51:04.659044+00
841	道	Road	zh-CN	en	2015-07-30 14:51:04.727967+00
842	⺮	⺮	zh-TW	zh-CN	2015-07-31 07:48:02.694355+00
843	⺮	⺮	zh-CN	zh-TW	2015-07-31 07:48:02.960243+00
844	⺮	⺮	zh-CN	en	2015-07-31 07:48:03.078627+00
845	户口	户口	zh-TW	zh-CN	2015-07-31 20:41:01.409418+00
846	户口	戶口	zh-CN	zh-TW	2015-07-31 20:41:01.585876+00
847	户口	Account	zh-CN	en	2015-07-31 20:41:01.705552+00
848	身份证	身份证	zh-TW	zh-CN	2015-07-31 20:42:58.355981+00
849	身份证	身份證	zh-CN	zh-TW	2015-07-31 20:42:58.498891+00
850	身份证	ID card	zh-CN	en	2015-07-31 20:42:58.620261+00
851	可以	可以	zh-TW	zh-CN	2015-08-01 20:10:38.343825+00
852	可以	可以	zh-CN	zh-TW	2015-08-01 20:10:38.661986+00
853	可以	Can	zh-CN	en	2015-08-01 20:10:38.76633+00
854	所以	所以	zh-TW	zh-CN	2015-08-01 20:20:06.706573+00
855	所以	所以	zh-CN	zh-TW	2015-08-01 20:20:06.827932+00
856	所以	And so	zh-CN	en	2015-08-01 20:20:06.889231+00
857	每	每	zh-TW	zh-CN	2015-08-01 20:21:20.766555+00
858	每	每	zh-CN	zh-TW	2015-08-01 20:21:20.849262+00
859	每	Per	zh-CN	en	2015-08-01 20:21:20.945137+00
860	世间的事真正奇妙	世间的事真正奇妙	zh-TW	zh-CN	2015-08-02 01:07:35.387214+00
861	世间的事真正奇妙	世間的事真正奇妙	zh-CN	zh-TW	2015-08-02 01:07:35.490658+00
862	世间的事真正奇妙	Worldly things truly wonderful	zh-CN	en	2015-08-02 01:07:35.653587+00
863	从	从	zh-TW	zh-CN	2015-08-02 06:55:13.294924+00
864	从	從	zh-CN	zh-TW	2015-08-02 06:55:13.403572+00
865	从	From	zh-CN	en	2015-08-02 06:55:13.52805+00
866	衤	衤	zh-TW	zh-CN	2015-08-02 20:19:58.791115+00
867	衤	衤	zh-CN	zh-TW	2015-08-02 20:19:58.911632+00
868	衤	Yi	zh-CN	en	2015-08-02 20:19:59.004907+00
869	軟件工程師	软件工程师	zh-TW	zh-CN	2015-08-02 22:32:35.937274+00
870	軟件工程師	軟件工程師	zh-CN	zh-TW	2015-08-02 22:32:36.02863+00
871	軟件工程師	Software engineer	zh-CN	en	2015-08-02 22:32:36.169966+00
872	中文什么说	中文什么说	zh-TW	zh-CN	2015-08-02 22:36:26.039301+00
873	中文什么说	中文什麼說	zh-CN	zh-TW	2015-08-02 22:36:26.116557+00
874	中文什么说	What say Chinese	zh-CN	en	2015-08-02 22:36:26.264163+00
875	中文怎么说	中文怎么说	zh-TW	zh-CN	2015-08-02 22:37:58.010499+00
876	中文怎么说	中文怎麼說	zh-CN	zh-TW	2015-08-02 22:37:58.076637+00
877	中文怎么说	Chinese how say	zh-CN	en	2015-08-02 22:37:58.22501+00
878	聚会	聚会	zh-TW	zh-CN	2015-08-02 22:43:37.252367+00
879	聚会	聚會	zh-CN	zh-TW	2015-08-02 22:43:37.364311+00
880	聚会	Get together	zh-CN	en	2015-08-02 22:43:37.48747+00
881	会议	会议	zh-TW	zh-CN	2015-08-02 22:43:49.511417+00
882	会议	會議	zh-CN	zh-TW	2015-08-02 22:43:49.600192+00
883	会议	Conference	zh-CN	en	2015-08-02 22:43:49.70573+00
884	你学学中文多久	你学学中文多久	zh-TW	zh-CN	2015-08-02 22:47:34.565892+00
885	你学学中文多久	你學學中文多久	zh-CN	zh-TW	2015-08-02 22:47:34.635953+00
886	你学学中文多久	How long you learn Chinese	zh-CN	en	2015-08-02 22:47:34.79219+00
887	你学中文多久	你学中文多久	zh-TW	zh-CN	2015-08-02 22:48:30.623517+00
888	你学中文多久	你學中文多久	zh-CN	zh-TW	2015-08-02 22:48:30.687208+00
889	你学中文多久	How long you learn Chinese	zh-CN	en	2015-08-02 22:48:30.801455+00
890	多久	多久	zh-TW	zh-CN	2015-08-02 22:50:00.660885+00
891	多久	多久	zh-CN	zh-TW	2015-08-02 22:50:00.76674+00
892	多久	How long	zh-CN	en	2015-08-02 22:50:00.832581+00
893	我在二另一	我在二另一	zh-TW	zh-CN	2015-08-02 22:53:01.721725+00
894	我在二另一	我在二另一	zh-CN	zh-TW	2015-08-02 22:53:01.808522+00
895	我在二另一	I have two other	zh-CN	en	2015-08-02 22:53:01.911755+00
896	二零十五	二零十五	zh-TW	zh-CN	2015-08-02 22:58:04.031493+00
897	二零十五	二零十五	zh-CN	zh-TW	2015-08-02 22:58:04.105382+00
898	二零十五	Twenty fifteen	zh-CN	en	2015-08-02 22:58:04.195488+00
899	上个月	上个月	zh-TW	zh-CN	2015-08-02 23:00:49.031646+00
900	上个月	上個月	zh-CN	zh-TW	2015-08-02 23:00:49.126327+00
901	上个月	Last month	zh-CN	en	2015-08-02 23:00:49.298824+00
902	几年后	几年后	zh-TW	zh-CN	2015-08-02 23:03:41.655709+00
903	几年后	幾年後	zh-CN	zh-TW	2015-08-02 23:03:41.757881+00
904	几年后	A few years later	zh-CN	en	2015-08-02 23:03:41.912204+00
905	脑袋	脑袋	zh-TW	zh-CN	2015-08-02 23:08:03.671271+00
906	脑袋	腦袋	zh-CN	zh-TW	2015-08-02 23:08:03.804593+00
907	脑袋	Head	zh-CN	en	2015-08-02 23:08:03.894234+00
908	饣	饣	zh-TW	zh-CN	2015-08-03 01:24:34.582608+00
909	饣	饣	zh-CN	zh-TW	2015-08-03 01:24:34.656407+00
910	饣	Shi	zh-CN	en	2015-08-03 01:24:34.72997+00
911	厶	厶	zh-TW	zh-CN	2015-08-03 01:26:51.408784+00
912	厶	厶	zh-CN	zh-TW	2015-08-03 01:26:51.495276+00
913	厶	Si	zh-CN	en	2015-08-03 01:26:51.562919+00
914	艹	艹	zh-TW	zh-CN	2015-08-03 01:29:11.443257+00
915	艹	艹	zh-CN	zh-TW	2015-08-03 01:29:11.59505+00
916	艹	Lv	zh-CN	en	2015-08-03 01:29:11.663867+00
917	还	还	zh-TW	zh-CN	2015-08-03 01:41:44.224091+00
918	还	還	zh-CN	zh-TW	2015-08-03 01:41:44.293153+00
919	还	Yet	zh-CN	en	2015-08-03 01:41:44.381038+00
920	讠	讠	zh-TW	zh-CN	2015-08-03 02:49:18.479873+00
921	讠	讠	zh-CN	zh-TW	2015-08-03 02:49:18.586331+00
922	酉	酉	zh-TW	zh-CN	2015-08-04 00:05:34.38944+00
923	酉	酉	zh-CN	zh-TW	2015-08-04 00:05:34.64044+00
924	酉	Unitary	zh-CN	en	2015-08-04 00:05:34.730829+00
925	找	找	zh-TW	zh-CN	2015-08-04 00:48:55.627374+00
926	找	找	zh-CN	zh-TW	2015-08-04 00:48:55.747582+00
928	我	我	zh-TW	zh-CN	2015-08-04 00:49:06.504843+00
929	我	我	zh-CN	zh-TW	2015-08-04 00:49:06.591817+00
930	我	I	zh-CN	en	2015-08-04 00:49:06.682339+00
931	已	已	zh-TW	zh-CN	2015-08-04 00:56:47.852818+00
932	已	已	zh-CN	zh-TW	2015-08-04 00:56:47.993173+00
933	已	Already	zh-CN	en	2015-08-04 00:56:48.104186+00
934	己	己	zh-TW	zh-CN	2015-08-04 00:57:05.746538+00
935	己	己	zh-CN	zh-TW	2015-08-04 00:57:05.855704+00
936	己	Already	zh-CN	en	2015-08-04 00:57:05.937651+00
937	经	经	zh-TW	zh-CN	2015-08-04 00:59:25.982777+00
938	经	經	zh-CN	zh-TW	2015-08-04 00:59:26.070253+00
939	经	Through	zh-CN	en	2015-08-04 00:59:26.181854+00
940	错	错	zh-TW	zh-CN	2015-08-04 18:09:38.603453+00
941	错	錯	zh-CN	zh-TW	2015-08-04 18:09:38.97101+00
942	错	Wrong	zh-CN	en	2015-08-04 18:09:39.095577+00
943	禾	禾	zh-TW	zh-CN	2015-08-04 21:03:33.884087+00
944	禾	禾	zh-CN	zh-TW	2015-08-04 21:03:34.142647+00
945	禾	Grain	zh-CN	en	2015-08-04 21:03:34.285544+00
946	艮	艮	zh-TW	zh-CN	2015-08-04 21:04:31.195731+00
947	艮	艮	zh-CN	zh-TW	2015-08-04 21:04:31.299536+00
948	艮	Gen	zh-CN	en	2015-08-04 21:04:31.377918+00
949	糸	糸	zh-TW	zh-CN	2015-08-04 23:31:57.692638+00
950	食	食	zh-TW	zh-CN	2015-08-04 23:33:07.535101+00
951	馬	马	zh-TW	zh-CN	2015-08-04 23:33:40.492914+00
952	𠂉	𠂉	zh-TW	zh-CN	2015-08-10 20:22:32.813718+00
953	𠂉	𠂉	zh-CN	zh-TW	2015-08-10 20:22:33.035837+00
954	𠂉	𠂉	zh-CN	en	2015-08-10 20:22:33.152192+00
955	Здравствуйте	Hello	ru	en	2015-08-14 23:40:46.24547+00
956	Увидимся	See you	ru	en	2015-08-14 23:42:16.092978+00
957	до свида́ния	bye	ru	en	2015-08-14 23:44:35.898161+00
958	⺍	⺍	zh-TW	zh-CN	2015-08-15 18:54:54.15285+00
959	⺍	⺍	zh-CN	zh-TW	2015-08-15 18:54:54.932144+00
960	⺍	⺍	zh-CN	en	2015-08-15 18:54:55.012407+00
\.


--
-- Name: translations_id_seq; Type: SEQUENCE SET; Schema: babble; Owner: -
--

SELECT pg_catalog.setval('translations_id_seq', 960, true);


--
-- Name: translations_pkey; Type: CONSTRAINT; Schema: babble; Owner: -; Tablespace: 
--

ALTER TABLE ONLY translations
    ADD CONSTRAINT translations_pkey PRIMARY KEY (id);


--
-- Name: lower_src_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX lower_src_idx ON translations USING btree (lower(src) text_pattern_ops);


--
-- Name: lower_trg_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX lower_trg_idx ON translations USING btree (lower(trg) text_pattern_ops);


--
-- Name: lower_unique_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE UNIQUE INDEX lower_unique_idx ON translations USING btree (lower(src) text_pattern_ops, lsrc, ltrg);


--
-- Name: lsrc_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX lsrc_idx ON translations USING btree (lsrc);


--
-- Name: ltrg_idx; Type: INDEX; Schema: babble; Owner: -; Tablespace: 
--

CREATE INDEX ltrg_idx ON translations USING btree (ltrg);


--
-- Name: no_duplicate_translations; Type: RULE; Schema: babble; Owner: -
--

CREATE RULE no_duplicate_translations AS
    ON INSERT TO translations
   WHERE (EXISTS ( SELECT 1
           FROM translations
          WHERE (((translations.lsrc = new.lsrc) AND (translations.ltrg = new.ltrg)) AND (lower(translations.src) = lower(new.src))))) DO INSTEAD NOTHING;


--
-- PostgreSQL database dump complete
--

