(defproject com.cemerick/clojurescript.test "0.3.3"
  :description "Port of clojure.test targeting ClojureScript."
  :url "http://github.com/cemerick/clojurescript.test"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :test-paths ["target/generated/clj"]
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-2411"]]

  :cljsbuild {:builds [{:source-paths ["src" "test" "target/generated/cljs"]
                        :compiler {:output-to "target/cljs/whitespace.js"
                                   :optimizations :whitespace
                                   :pretty-print true}}
                       #_#_
                       {:source-paths ["src" "test" "target/generated/cljs"]
                        :compiler {:output-to "target/cljs/simple.js"
                                   :optimizations :simple
                                   :pretty-print true}}
                       {:source-paths ["src" "test" "target/generated/cljs"]
                        :compiler {:output-to "target/cljs/advanced.js"
                                   :optimizations :advanced
                                   :pretty-print true}}]
              :test-commands {"slimer-whitespace" ["xvfb-run" "-a" "slimerjs" :runner
                                                   "window.literal_js_was_evaluated=true"
                                                   "target/cljs/whitespace.js"
                                                   "test/cemerick/cljs/test/extra_test_command_file.js" "/foo/wat.js"]
}}

  :cljx {:builds [{:source-paths ["test"]
                   :output-path "target/generated/clj"
                   :rules :clj}
                  {:source-paths ["test"]
                   :output-path "target/generated/cljs"
                   :rules :cljs}]}
  
  :profiles {:dev {:dependencies [[org.clojure/core.async "0.1.346.0-17112a-alpha"]]
                   :plugins [[lein-cljsbuild "1.0.3"]
                             [com.keminglabs/cljx "0.5.0"]
                             [com.cemerick/austin "0.1.5-SNAPSHOT"]]}
             ; self-reference and chained `lein install; lein test` invocation
             ; needed to use the project as its own plugin. Leiningen :-(
             :self-plugin [:default {:plugins [[com.cemerick/clojurescript.test "0.3.3"]]}]}

  :aliases  {"cleantest" ["with-profile" "self-plugin"
                          "do" "clean," "cljx" "once," "test," "cljsbuild" "test"]
             "release" ["do" "clean," "deploy" "clojars," "deploy"]}

  :deploy-repositories {"releases" {:url "https://oss.sonatype.org/service/local/staging/deploy/maven2/" :creds :gpg}
                        "snapshots" {:url "https://oss.sonatype.org/content/repositories/snapshots/" :creds :gpg}}

  ;;maven central requirements
  :scm {:url "git@github.com:cemerick/clojurescript.test.git"}
  :pom-addition [:developers [:developer
                              [:name "Chas Emerick"]
                              [:url "http://cemerick.com"]
                              [:email "chas@cemerick.com"]
                              [:timezone "-5"]]])
