/*
 * Decompiled with CFR 0.152.
 */
package eventpassport;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

class Chunk<T> {
    final AtomicReferenceArray<T> eventStates;
    final AtomicLongArray eventTimestamps;
    final AtomicReference<Chunk<T>> next = new AtomicReference<Object>(null);

    Chunk(int n) {
        this.eventStates = new AtomicReferenceArray(n);
        this.eventTimestamps = new AtomicLongArray(n);
    }

    int size() {
        return this.eventStates.length();
    }

    Chunk<T> getNext() {
        Chunk<T> chunk = this.next.get();
        if (chunk != null) {
            return chunk;
        }
        Chunk<T> chunk2 = new Chunk<T>(this.size() * 2);
        return this.next.compareAndSet(null, chunk2) ? chunk2 : this.next.get();
    }

    T getState(int n) {
        return this.eventStates.get(n);
    }

    long getTimestamp(int n) {
        return this.eventTimestamps.get(n);
    }

    void put(int n, T t, long l) {
        this.eventStates.set(n, t);
        this.eventTimestamps.set(n, l);
    }
}

