/*
 * Decompiled with CFR 0.152.
 */
package eventpassport;

import eventpassport.Chunk;
import eventpassport.Event;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Passport<T> {
    private static final int FIRST_CHUNK_SIZE = 8;
    private final Chunk<T> firstChunk = new Chunk(8);
    private final AtomicInteger stampCount = new AtomicInteger(0);
    private final long issuedTimeMs = System.currentTimeMillis();

    public Passport(T t) {
        this.firstChunk.put(0, t, System.nanoTime());
        this.stampCount.getAndIncrement();
    }

    public Passport stamp(T t) {
        return this.stamp(t, System.nanoTime());
    }

    public Passport stamp(T t, long l) {
        int n = this.stampCount.getAndIncrement();
        Chunk<T> chunk = this.firstChunk;
        while (n >= chunk.size()) {
            n -= chunk.size();
            chunk = chunk.getNext();
        }
        chunk.put(n, t, l);
        return this;
    }

    public Event<T> findEventByState(T t) {
        return this.findEventByState(t, 0);
    }

    public Event<T> findEventByState(T t, int n) {
        int n2 = this.stampCount.get();
        Chunk<T> chunk = this.firstChunk;
        int n3 = n;
        while (n3 >= chunk.size()) {
            n3 -= chunk.size();
            chunk = chunk.getNext();
        }
        int n4 = n;
        int n5 = n3;
        while (n4 < n2) {
            T t2;
            if (n5 == chunk.size()) {
                n5 = 0;
                chunk = chunk.getNext();
            }
            if (t.equals(t2 = chunk.getState(n5))) {
                return new Event<T>(t2, chunk.getTimestamp(n5), n4);
            }
            ++n4;
            ++n5;
        }
        return null;
    }

    public long timeBetween(T t, T t2) {
        int n = this.stampCount.get();
        int n2 = 0;
        long l = -1L;
        long l2 = -1L;
        Chunk<T> chunk = this.firstChunk;
        while (n-- > 0) {
            if (n2 == chunk.size()) {
                n2 = 0;
                chunk = chunk.getNext();
            }
            if (t.equals(chunk.getState(n2))) {
                l = chunk.getTimestamp(n2);
                break;
            }
            ++n2;
        }
        if (l == -1L) {
            return -1L;
        }
        ++n2;
        while (n-- > 0) {
            if (n2 == chunk.size()) {
                n2 = 0;
                chunk = chunk.getNext();
            }
            if (t2.equals(chunk.getState(n2))) {
                l2 = chunk.getTimestamp(n2);
                break;
            }
            ++n2;
        }
        return l2 == -1L ? -1L : l2 - l;
    }

    private static String formatNsDelta(long l) {
        if (l < 1000L) {
            return "" + l + "ns";
        }
        if (l < 1000000L) {
            return "" + l / 1000L + "us";
        }
        return "" + l / 1000000L + "ms";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Instant.ofEpochMilli(this.issuedTimeMs).toString();
        Chunk<T> chunk = this.firstChunk;
        long l = chunk.getTimestamp(0);
        T t = chunk.getState(0);
        String string2 = "\n%" + string.length() + "s - %s";
        int n = this.stampCount.get() - 1;
        stringBuilder.append(string).append(" - ").append((Object)(t == null ? "<created>" : t));
        int n2 = 1;
        while (n-- > 0) {
            if (n2 == chunk.size()) {
                n2 = 0;
                chunk = chunk.getNext();
            }
            stringBuilder.append(String.format(string2, "+" + Passport.formatNsDelta(chunk.getTimestamp(n2) - l), chunk.getState(n2)));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public List<Event<T>> getEvents() {
        int n = this.stampCount.get();
        int n2 = 0;
        ArrayList<Event<T>> arrayList = new ArrayList<Event<T>>(n);
        Chunk<T> chunk = this.firstChunk;
        while (true) {
            for (int i = 0; i < chunk.size() && n2 < n; ++n2, ++i) {
                arrayList.add(new Event<T>(chunk.getState(i), chunk.getTimestamp(i), n2));
            }
            if (n2 == n) break;
            chunk = chunk.getNext();
        }
        return arrayList;
    }
}

