/*
 * Decompiled with CFR 0.152.
 */
package charred;

import charred.CanonicalStrings;
import charred.CharBuffer;
import charred.CharReader;
import charred.CharredException;
import clojure.lang.ITransientMap;
import clojure.lang.ITransientVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentVector;
import java.io.EOFException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public final class JSONReader
implements AutoCloseable {
    CharReader reader;
    public static final ObjReader immutableObjReader = new ObjReader(){

        @Override
        public Object newObj() {
            return PersistentHashMap.EMPTY.asTransient();
        }

        @Override
        public Object onKV(Object object, Object object2, Object object3) {
            return ((ITransientMap)object).assoc(object2, object3);
        }

        @Override
        public Object finalizeObj(Object object) {
            return ((ITransientMap)object).persistent();
        }
    };
    public static final ObjReader mutableObjReader = new ObjReader(){

        @Override
        public Object newObj() {
            return new HashMap();
        }

        @Override
        public Object onKV(Object object, Object object2, Object object3) {
            ((HashMap)object).put(object2, object3);
            return object;
        }
    };
    public static final ObjReader rawObjReader = new ObjReader(){

        @Override
        public Object newObj() {
            return new ArrayList(8);
        }

        @Override
        public Object onKV(Object object, Object object2, Object object3) {
            List list = (List)object;
            list.add(object2);
            list.add(object3);
            return list;
        }

        @Override
        public Object finalizeObj(Object object) {
            return new JSONObj((ArrayList)object);
        }
    };
    public static final ArrayReader immutableArrayReader = new ArrayReader(){

        @Override
        public Object newArray() {
            return PersistentVector.EMPTY.asTransient();
        }

        @Override
        public Object onValue(Object object, Object object2) {
            return ((ITransientVector)object).conj(object2);
        }

        @Override
        public Object finalizeArray(Object object) {
            return ((ITransientVector)object).persistent();
        }
    };
    public static final ArrayReader mutableArrayReader = new ArrayReader(){

        @Override
        public Object newArray() {
            return new ArrayList(8);
        }

        @Override
        public Object onValue(Object object, Object object2) {
            ((List)object).add(object2);
            return object;
        }
    };
    public final Function<String, Object> doubleFn;
    public final Supplier<Object> eofFn;
    public final ObjReader objReader;
    public final ArrayReader aryReader;
    public final CanonicalStrings keyBuffer;
    final CharBuffer charBuffer = new CharBuffer();
    public static final Function<String, Object> defaultDoubleParser = string -> Double.parseDouble(string);
    public static final Supplier<Object> defaultEOFFn = () -> {
        throw new RuntimeException("EOF encounted while reading stream.");
    };
    public static final Keyword elidedValue = Keyword.intern((String)"charred.api", (String)"elided");

    public static final <T> T orDefault(T t, T t2) {
        return t != null ? t : t2;
    }

    public JSONReader(Function<String, Object> function, ArrayReader arrayReader, ObjReader objReader, Supplier<Object> supplier, CanonicalStrings canonicalStrings) {
        this.doubleFn = JSONReader.orDefault(function, defaultDoubleParser);
        this.aryReader = arrayReader != null ? arrayReader : immutableArrayReader;
        this.objReader = objReader != null ? objReader : immutableObjReader;
        this.eofFn = JSONReader.orDefault(supplier, defaultEOFFn);
        this.keyBuffer = canonicalStrings != null ? canonicalStrings : new CanonicalStrings();
    }

    public static boolean numberChar(char c) {
        return c >= '0' && c <= '9' || c == '-';
    }

    public static boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    final char[] tempRead(int n) throws EOFException {
        char[] cArray = new char[n];
        if (this.reader.read(cArray, 0, n) == -1) {
            throw new EOFException();
        }
        return cArray;
    }

    final CharBuffer getCharBuffer() {
        CharBuffer charBuffer = this.charBuffer;
        charBuffer.clear();
        return charBuffer;
    }

    final String readString() throws Exception {
        return this.readString(null);
    }

    final String readString(CanonicalStrings canonicalStrings) throws Exception {
        CharBuffer charBuffer = this.getCharBuffer();
        char[] cArray = this.reader.buffer();
        while (cArray != null) {
            int n = this.reader.position();
            int n2 = cArray.length;
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (c == '\"') {
                    String string = charBuffer.toString(cArray, n, i, canonicalStrings);
                    this.reader.position(i + 1);
                    return string;
                }
                if (c != '\\') continue;
                charBuffer.append(cArray, n, i);
                int n3 = this.reader.readFrom(i + 1);
                if (n3 == -1) {
                    throw new EOFException();
                }
                char c2 = (char)n3;
                switch (c2) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        charBuffer.append(c2);
                        break;
                    }
                    case 'b': {
                        charBuffer.append('\b');
                        break;
                    }
                    case 'f': {
                        charBuffer.append('\f');
                        break;
                    }
                    case 'r': {
                        charBuffer.append('\r');
                        break;
                    }
                    case 'n': {
                        charBuffer.append('\n');
                        break;
                    }
                    case 't': {
                        charBuffer.append('\t');
                        break;
                    }
                    case 'u': {
                        char[] cArray2 = this.tempRead(4);
                        charBuffer.append((char)Integer.parseInt(new String(cArray2, 0, 4), 16));
                        break;
                    }
                    default: {
                        throw new CharredException("JSON parse error - Unrecognized escape character: " + c2);
                    }
                }
                cArray = this.reader.buffer();
                n = this.reader.position();
                i = n - 1;
            }
            charBuffer.append(cArray, n, n2);
            cArray = this.reader.nextBuffer();
        }
        throw new EOFException("JSON parse error - EOF while reading string: " + charBuffer.toString());
    }

    final Object finalizeNumber(CharBuffer charBuffer, boolean bl, char c, int n) throws Exception {
        char[] cArray = charBuffer.buffer();
        int n2 = charBuffer.length();
        if (bl) {
            if (n2 > 1 && c == '0' || n2 > 2 && c == '-' && cArray[1] == '0') {
                throw new CharredException("JSON parse error - integer starting with 0: " + charBuffer.toString());
            }
            if (n2 == 1) {
                long l = Character.digit(cArray[0], 10);
                if (l < 0L) {
                    throw new CharredException("JSON parse error - invalid integer: " + charBuffer.toString());
                }
                return l;
            }
            String string = charBuffer.toString();
            if (n2 < 18) {
                return Long.parseLong(string);
            }
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                return new BigInteger(string);
            }
        }
        String string = charBuffer.toString();
        if (n != -1) {
            char c2 = cArray[n];
            if (c2 != '.') {
                throw new RuntimeException("Programming error - dotIndex incorrect: " + String.valueOf(n) + " - " + string);
            }
            if (n == n2 - 1 || !JSONReader.isAsciiDigit(cArray[n + 1]) || n == 0 || !JSONReader.isAsciiDigit(cArray[n - 1])) {
                throw new CharredException("JSON parse error - period must be preceded and followed by a digit: " + string);
            }
        }
        return this.doubleFn.apply(string);
    }

    final Object readNumber(char c) throws Exception {
        CharBuffer charBuffer = this.getCharBuffer();
        charBuffer.clear();
        charBuffer.append(c);
        boolean bl = true;
        char[] cArray = this.reader.buffer();
        int n = -1;
        while (cArray != null) {
            int n2;
            int n3;
            int n4 = cArray.length;
            for (n3 = n2 = this.reader.position(); n3 < n4; ++n3) {
                char c2 = cArray[n3];
                if (Character.isWhitespace(c2) || c2 == ']' || c2 == '}' || c2 == ',') {
                    charBuffer.append(cArray, n2, n3);
                    this.reader.position(n3);
                    return this.finalizeNumber(charBuffer, bl, c, n);
                }
                if (c2 != 'e' && c2 != 'E' && c2 != '.') continue;
                if (c2 == '.') {
                    n = charBuffer.length() + n3 - n2;
                }
                bl = false;
            }
            charBuffer.append(cArray, n2, n3);
            cArray = this.reader.nextBuffer();
        }
        return this.finalizeNumber(charBuffer, bl, c, n);
    }

    public final String context() throws Exception {
        return this.reader.context(200);
    }

    public final Object readList() throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        Object object = this.aryReader.newArray();
        while (!this.reader.eof()) {
            char c = this.reader.eatwhite();
            if (c == ']') {
                if (bl && !bl2) {
                    throw new CharredException("JSON parse error - One too many commas in your list my friend");
                }
                return this.aryReader.finalizeArray(object);
            }
            if (c == '\u0000') continue;
            if (!bl) {
                throw new CharredException("JSON parse error - One too few commas in your list my friend");
            }
            bl2 = false;
            this.reader.unread();
            object = this.aryReader.onValue(object, this.readObject());
            bl = this.reader.eatwhite() == ',';
            if (bl) continue;
            this.reader.unread();
        }
        throw new EOFException("JSON parse error - EOF while reading list");
    }

    public final Object readMap() throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        Object object = this.objReader.newObj();
        while (!this.reader.eof()) {
            char c = this.reader.eatwhite();
            if (c == '}') {
                if (bl && !bl2) {
                    throw new CharredException("JSON parse error - One too many commas in your map my friend: " + String.valueOf(this.objReader.finalizeObj(object)) + "context:\n" + this.context());
                }
                return this.objReader.finalizeObj(object);
            }
            bl2 = false;
            if (!bl) {
                throw new CharredException("JSON parse error - One too few commas in your map my friend: " + String.valueOf(this.objReader.finalizeObj(object)) + "context:\n" + this.context());
            }
            String string = null;
            if (c != '\"') {
                throw new CharredException("JSON parse error - JSON keys must be quoted strings.");
            }
            string = this.readString(this.keyBuffer);
            c = this.reader.eatwhite();
            if (c != ':') {
                throw new CharredException("JSON parse error - Map keys must be followed by a ':'");
            }
            Object object2 = this.readObject();
            object = this.objReader.onKV(object, string, object2);
            c = this.reader.eatwhite();
            if (c == '\u0000') {
                throw new EOFException("JSON parse error - EOF while reading map: " + String.valueOf(this.objReader.finalizeObj(object)));
            }
            bl = c == ',';
            if (bl) continue;
            this.reader.unread();
        }
        throw new EOFException("JSON parse error - EOF while reading map.");
    }

    public final Object readObject() throws Exception {
        if (this.reader == null) {
            return null;
        }
        char c = this.reader.eatwhite();
        if (JSONReader.numberChar(c)) {
            return this.readNumber(c);
        }
        switch (c) {
            case '\"': {
                return this.readString();
            }
            case 't': {
                char[] cArray = this.tempRead(3);
                if (cArray[0] == 'r' && cArray[1] == 'u' && cArray[2] == 'e') {
                    return true;
                }
                throw new CharredException("JSON parse error - bad boolean value.");
            }
            case 'f': {
                char[] cArray = this.tempRead(4);
                if (cArray[0] == 'a' && cArray[1] == 'l' && cArray[2] == 's' && cArray[3] == 'e') {
                    return false;
                }
                throw new CharredException("JSON parse error - bad boolean value.");
            }
            case 'n': {
                char[] cArray = this.tempRead(3);
                if (cArray[0] == 'u' && cArray[1] == 'l' && cArray[2] == 'l') {
                    return null;
                }
                throw new CharredException("JSON parse error - unrecognized 'null' entry - " + new String(cArray) + " - context:\n" + this.context());
            }
            case '[': {
                return this.readList();
            }
            case '{': {
                return this.readMap();
            }
            case '\u0000': {
                if (!this.reader.eof()) break;
                this.close();
                return this.eofFn.get();
            }
        }
        throw new CharredException("JSON parse error - Unexpected character - " + c);
    }

    public void beginParse(CharReader charReader) {
        this.reader = charReader;
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    public static interface ArrayReader {
        public Object newArray();

        public Object onValue(Object var1, Object var2);

        default public Object finalizeArray(Object object) {
            return object;
        }
    }

    public static interface ObjReader {
        public Object newObj();

        public Object onKV(Object var1, Object var2, Object var3);

        default public Object finalizeObj(Object object) {
            return object;
        }
    }

    public static class JSONObj {
        public final ArrayList<Object> data;

        public JSONObj(ArrayList<Object> arrayList) {
            this.data = arrayList;
        }
    }
}

