/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Associative;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.IReduceInit;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.Casts;
import ham_fisted.DoubleMutList;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.ImmutList;
import ham_fisted.ImmutSort;
import ham_fisted.LongMutList;
import ham_fisted.RangeList;
import ham_fisted.Transformables;
import ham_fisted.TypedList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntFunction;
import java.util.function.LongBinaryOperator;

public class ArrayLists {
    static int wrapCheckIndex(int n, int n2) {
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            throw new RuntimeException("Index out of range: " + String.valueOf(n));
        }
        return n;
    }

    static int checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new RuntimeException("Index out of range: " + String.valueOf(n));
        }
        return n;
    }

    static void checkIndexRange(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n3 >= n2) {
            throw new RuntimeException("Index out of range: " + String.valueOf(n3));
        }
        if (n4 < n3 || n4 > n2) {
            throw new RuntimeException("Index out of range: " + String.valueOf(n4));
        }
    }

    public static void fillRangeDefault(List list, int n, int n2, Object object) {
        while (n < n2) {
            list.set(n, object);
            ++n;
        }
    }

    public static void fillRangeDefault(List list, int n, List list2) {
        int n2 = n + list2.size();
        int n3 = 0;
        while (n < n2) {
            list.set(n3 + n, list2.get(n3));
            ++n;
            ++n3;
        }
    }

    public static void removeRangeDefault(List list, int n, int n2) {
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            list.remove(n);
        }
    }

    public static void addRangeDefault(List list, int n, int n2, Object object) {
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            list.add(i + n, object);
        }
    }

    public static void fill(Object[] objectArray, int n, int n2, IntFunction intFunction) {
        while (n < n2) {
            objectArray[n] = intFunction.apply(n);
            ++n;
        }
    }

    public static Object[] toArray(Collection collection) {
        ObjectArrayList objectArrayList = new ObjectArrayList();
        objectArrayList.addAll(collection);
        return objectArrayList.toArray();
    }

    public static List<Object> toList(Object[] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new ObjectArraySubList(objectArray, n, n2, iPersistentMap);
    }

    public static List<Object> toList(Object[] objectArray) {
        return ArrayLists.toList(objectArray, 0, objectArray.length, null);
    }

    public static List<Object> toList(final byte[] byArray, final int n, final int n2, final IPersistentMap iPersistentMap) {
        final int n3 = n2 - n;
        return new ILongArrayList(){

            public String toString() {
                return Transformables.sequenceToString(this);
            }

            @Override
            public boolean equals(Object object) {
                return this.equiv(object);
            }

            @Override
            public int hashCode() {
                return this.hasheq();
            }

            @Override
            public ArraySection getArray() {
                return new ArraySection(byArray, n, n2);
            }

            @Override
            public Class containedType() {
                return byArray.getClass().getComponentType();
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public Byte get(int n4) {
                return byArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public long getLong(int n4) {
                return byArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public Byte set(int n4, Object object) {
                return (byte)this.setLong(n4, Casts.longCast(object));
            }

            @Override
            public IntComparator indexComparator() {
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Byte.compare(byArray[n + n], byArray[n2 + n]);
                    }
                };
            }

            @Override
            public long setLong(int n4, long l) {
                byte by = RT.byteCast((long)l);
                n4 = ArrayLists.wrapCheckIndex(n4, n3) + n;
                byte by2 = byArray[n4];
                byArray[n4] = by;
                return by2;
            }

            @Override
            public List<Object> subList(int n4, int n22) {
                ArrayLists.checkIndexRange(n, n3, n4, n22);
                return ArrayLists.toList(byArray, n4 + n, n22 + n, this.meta());
            }

            @Override
            public IPersistentMap meta() {
                return iPersistentMap;
            }

            @Override
            public IObj withMeta(IPersistentMap iPersistentMap2) {
                return (IObj)ArrayLists.toList(byArray, n, n2, iPersistentMap2);
            }

            @Override
            public Object[] toArray() {
                int n4 = this.size();
                Object[] objectArray = new Object[this.size()];
                for (int i = 0; i < n4; ++i) {
                    objectArray[i] = byArray[i + n];
                }
                return objectArray;
            }

            @Override
            public Object reduce(IFn iFn) {
                if (n3 == 0) {
                    return iFn.invoke();
                }
                int n4 = n3;
                int n22 = n;
                byte[] byArray2 = byArray;
                Object object = byArray2[n22];
                for (int i = 1; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)byArray2[i + n22]);
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public Object reduce(IFn iFn, Object object) {
                if (n3 == 0) {
                    return object;
                }
                int n4 = n3;
                int n22 = n;
                byte[] byArray2 = byArray;
                for (int i = 0; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)byArray2[i + n22]);
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
                int n4 = n3;
                int n22 = n;
                for (int i = 0; i < n4; ++i) {
                    l = longBinaryOperator.applyAsLong(l, byArray[i + n22]);
                }
                return l;
            }

            @Override
            public List immutShuffle(Random random) {
                int n4 = this.size();
                int[] nArray = IntArrays.shuffle((int[])ArrayLists.iarange(0, n4, 1), (Random)random);
                byte[] byArray2 = new byte[n4];
                for (int i = 0; i < n4; ++i) {
                    byArray2[i] = byArray[nArray[i]];
                }
                return ArrayLists.toList(byArray2);
            }
        };
    }

    public static List<Object> toList(byte[] byArray) {
        return ArrayLists.toList(byArray, 0, byArray.length, null);
    }

    public static List<Object> toList(final short[] sArray, final int n, final int n2, final IPersistentMap iPersistentMap) {
        final int n3 = n2 - n;
        return new ILongArrayList(){

            public String toString() {
                return Transformables.sequenceToString(this);
            }

            @Override
            public boolean equals(Object object) {
                return this.equiv(object);
            }

            @Override
            public int hashCode() {
                return this.hasheq();
            }

            @Override
            public ArraySection getArray() {
                return new ArraySection(sArray, n, n2);
            }

            @Override
            public Class containedType() {
                return sArray.getClass().getComponentType();
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public Short get(int n4) {
                return sArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public long getLong(int n4) {
                return sArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public Short set(int n4, Object object) {
                return (short)this.setLong(n4, Casts.longCast(object));
            }

            @Override
            public long setLong(int n4, long l) {
                short s = RT.shortCast((long)Casts.longCast(l));
                n4 = ArrayLists.wrapCheckIndex(n4, n3) + n;
                short s2 = sArray[n4];
                sArray[n4] = s;
                return s2;
            }

            @Override
            public IntComparator indexComparator() {
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Short.compare(sArray[n + n], sArray[n2 + n]);
                    }
                };
            }

            @Override
            public List<Object> subList(int n4, int n22) {
                ArrayLists.checkIndexRange(n, n3, n4, n22);
                return ArrayLists.toList(sArray, n4 + n, n22 + n, this.meta());
            }

            @Override
            public IPersistentMap meta() {
                return iPersistentMap;
            }

            @Override
            public IObj withMeta(IPersistentMap iPersistentMap2) {
                return (IObj)ArrayLists.toList(sArray, n, n2, iPersistentMap2);
            }

            @Override
            public Object[] toArray() {
                int n4 = this.size();
                Object[] objectArray = new Object[this.size()];
                for (int i = 0; i < n4; ++i) {
                    objectArray[i] = sArray[i + n];
                }
                return objectArray;
            }

            @Override
            public List immutSort() {
                short[] sArray2 = Arrays.copyOfRange(sArray, n, n2);
                Arrays.sort(sArray2);
                return ArrayLists.toList(sArray2, 0, sArray2.length, iPersistentMap);
            }

            @Override
            public Object reduce(IFn iFn) {
                if (n3 == 0) {
                    return iFn.invoke();
                }
                int n4 = n3;
                int n22 = n;
                short[] sArray2 = sArray;
                Object object = sArray2[n22];
                for (int i = 1; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)sArray2[i + n22]);
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public Object reduce(IFn iFn, Object object) {
                if (n3 == 0) {
                    return object;
                }
                int n4 = n3;
                int n22 = n;
                short[] sArray2 = sArray;
                for (int i = 0; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)sArray2[i + n22]);
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
                int n4 = n3;
                int n22 = n;
                for (int i = 0; i < n4; ++i) {
                    l = longBinaryOperator.applyAsLong(l, sArray[i + n22]);
                }
                return l;
            }

            @Override
            public List immutShuffle(Random random) {
                int n4 = this.size();
                int[] nArray = IntArrays.shuffle((int[])ArrayLists.iarange(0, n4, 1), (Random)random);
                short[] sArray2 = new short[n4];
                for (int i = 0; i < n4; ++i) {
                    sArray2[i] = sArray[nArray[i]];
                }
                return ArrayLists.toList(sArray2);
            }
        };
    }

    public static List<Object> toList(short[] sArray) {
        return ArrayLists.toList(sArray, 0, sArray.length, null);
    }

    public static IntComparator intIndexComparator(final List list, final Comparator comparator) {
        if (comparator != null) {
            if (list instanceof IMutList) {
                return ((IMutList)list).indexComparator(comparator);
            }
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return comparator.compare(list.get(n), list.get(n2));
                }
            };
        }
        if (list instanceof IMutList) {
            return ((IMutList)list).indexComparator();
        }
        return new IntComparator(){

            public int compare(int n, int n2) {
                return ((Comparable)list.get(n)).compareTo(list.get(n2));
            }
        };
    }

    public static List<Object> toList(int[] nArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new IntArraySubList(nArray, n, n2, iPersistentMap);
    }

    public static List<Object> toList(int[] nArray) {
        return ArrayLists.toList(nArray, 0, nArray.length, null);
    }

    public static List<Object> toList(long[] lArray, int n, int n2, IPersistentMap iPersistentMap) {
        return new LongArraySubList(lArray, n, n2, iPersistentMap);
    }

    public static List<Object> toList(long[] lArray) {
        return ArrayLists.toList(lArray, 0, lArray.length, null);
    }

    public static List<Object> toList(final float[] fArray, final int n, final int n2, final IPersistentMap iPersistentMap) {
        final int n3 = n2 - n;
        return new IDoubleArrayList(){

            public String toString() {
                return Transformables.sequenceToString(this);
            }

            @Override
            public boolean equals(Object object) {
                return this.equiv(object);
            }

            @Override
            public int hashCode() {
                return this.hasheq();
            }

            @Override
            public ArraySection getArray() {
                return new ArraySection(fArray, n, n2);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public Float get(int n4) {
                return Float.valueOf(fArray[ArrayLists.checkIndex(n4, n3) + n]);
            }

            @Override
            public double getDouble(int n4) {
                return fArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public Float set(int n4, Object object) {
                return Float.valueOf((float)this.setDouble(n4, Casts.doubleCast(object)));
            }

            @Override
            public double setDouble(int n4, double d) {
                float f = (float)d;
                n4 = ArrayLists.wrapCheckIndex(n4, n3) + n;
                float f2 = fArray[n4];
                fArray[n4] = f;
                return f2;
            }

            @Override
            public List<Object> subList(int n4, int n22) {
                ArrayLists.checkIndexRange(n, n3, n4, n22);
                return ArrayLists.toList(fArray, n4 + n, n22 + n, this.meta());
            }

            @Override
            public IPersistentMap meta() {
                return iPersistentMap;
            }

            @Override
            public IObj withMeta(IPersistentMap iPersistentMap2) {
                return (IObj)ArrayLists.toList(fArray, n, n2, iPersistentMap2);
            }

            @Override
            public Object[] toArray() {
                int n4 = this.size();
                Object[] objectArray = new Object[this.size()];
                for (int i = 0; i < n4; ++i) {
                    objectArray[i] = Float.valueOf(fArray[i + n]);
                }
                return objectArray;
            }

            @Override
            public float[] toFloatArray() {
                return Arrays.copyOfRange(fArray, n, n2);
            }

            @Override
            public IntComparator indexComparator() {
                if (n == 0) {
                    return new IntComparator(){

                        public int compare(int n, int n2) {
                            return Float.compare(fArray[n], fArray[n2]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Float.compare(fArray[n + n], fArray[n2 + n]);
                    }
                };
            }

            @Override
            public IntComparator indexComparator(Comparator comparator) {
                if (comparator == null) {
                    return this.indexComparator();
                }
                if (comparator instanceof DoubleComparator) {
                    final DoubleComparator doubleComparator = (DoubleComparator)comparator;
                    if (n == 0) {
                        return new IntComparator(){

                            public int compare(int n, int n2) {
                                return doubleComparator.compare((double)fArray[n], (double)fArray[n2]);
                            }
                        };
                    }
                    return new IntComparator(){

                        public int compare(int n, int n2) {
                            return doubleComparator.compare((double)fArray[n + n], (double)fArray[n2 + n]);
                        }
                    };
                }
                return IDoubleArrayList.super.indexComparator(comparator);
            }

            @Override
            public List immutSort() {
                float[] fArray2 = Arrays.copyOfRange(fArray, n, n2);
                Arrays.sort(fArray2);
                return ArrayLists.toList(fArray2, 0, fArray2.length, iPersistentMap);
            }

            @Override
            public Object reduce(IFn iFn) {
                if (n3 == 0) {
                    return iFn.invoke();
                }
                int n4 = n3;
                int n22 = n;
                float[] fArray2 = fArray;
                Object object = Float.valueOf(fArray2[n22]);
                for (int i = 1; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)Float.valueOf(fArray2[i + n22]));
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public Object reduce(IFn iFn, Object object) {
                if (n3 == 0) {
                    return object;
                }
                int n4 = n3;
                int n22 = n;
                float[] fArray2 = fArray;
                for (int i = 0; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)Float.valueOf(fArray2[i + n22]));
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public double doubleReduction(DoubleBinaryOperator doubleBinaryOperator, double d) {
                int n4 = this.size();
                for (int i = 0; i < n4; ++i) {
                    d = doubleBinaryOperator.applyAsDouble(d, fArray[i + n]);
                }
                return d;
            }

            @Override
            public List immutShuffle(Random random) {
                int n4 = this.size();
                int[] nArray = IntArrays.shuffle((int[])ArrayLists.iarange(0, n4, 1), (Random)random);
                float[] fArray2 = new float[n4];
                for (int i = 0; i < n4; ++i) {
                    fArray2[i] = fArray[nArray[i]];
                }
                return ArrayLists.toList(fArray2);
            }
        };
    }

    public static List<Object> toList(float[] fArray) {
        return ArrayLists.toList(fArray, 0, fArray.length, null);
    }

    public static List<Object> toList(double[] dArray, int n, int n2, IPersistentMap iPersistentMap) {
        return new DoubleArraySubList(dArray, n, n2, iPersistentMap);
    }

    public static List<Object> toList(double[] dArray) {
        return ArrayLists.toList(dArray, 0, dArray.length, null);
    }

    public static List<Object> toList(final char[] cArray, final int n, final int n2, final IPersistentMap iPersistentMap) {
        final int n3 = n2 - n;
        return new ILongArrayList(){

            public String toString() {
                return Transformables.sequenceToString(this);
            }

            @Override
            public boolean equals(Object object) {
                return this.equiv(object);
            }

            @Override
            public int hashCode() {
                return this.hasheq();
            }

            @Override
            public ArraySection getArray() {
                return new ArraySection(cArray, n, n2);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public Character get(int n4) {
                return Character.valueOf(cArray[ArrayLists.checkIndex(n4, n3) + n]);
            }

            @Override
            public long getLong(int n4) {
                return cArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public Character set(int n4, Character c) {
                return Character.valueOf((char)this.setLong(n4, Casts.longCast(c)));
            }

            @Override
            public long setLong(int n4, long l) {
                char c = RT.charCast((long)l);
                n4 = ArrayLists.wrapCheckIndex(n4, n3) + n;
                char c2 = cArray[n4];
                cArray[n4] = c;
                return c2;
            }

            @Override
            public List<Object> subList(int n4, int n22) {
                ArrayLists.checkIndexRange(n, n3, n4, n22);
                return ArrayLists.toList(cArray, n4 + n, n22 + n, this.meta());
            }

            @Override
            public IPersistentMap meta() {
                return iPersistentMap;
            }

            @Override
            public IObj withMeta(IPersistentMap iPersistentMap2) {
                return (IObj)ArrayLists.toList(cArray, n, n2, iPersistentMap2);
            }

            @Override
            public Object[] toArray() {
                int n4 = this.size();
                Object[] objectArray = new Object[this.size()];
                for (int i = 0; i < n4; ++i) {
                    objectArray[i] = Character.valueOf(cArray[i + n]);
                }
                return objectArray;
            }

            @Override
            public List immutSort() {
                char[] cArray2 = Arrays.copyOfRange(cArray, n, n2);
                Arrays.sort(cArray2);
                return ArrayLists.toList(cArray2, 0, cArray2.length, iPersistentMap);
            }

            @Override
            public Object reduce(IFn iFn) {
                if (n3 == 0) {
                    return iFn.invoke();
                }
                int n4 = n3;
                int n22 = n;
                char[] cArray2 = cArray;
                Object object = Character.valueOf(cArray2[n22]);
                for (int i = 1; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)Character.valueOf(cArray2[i + n22]));
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }

            @Override
            public Object reduce(IFn iFn, Object object) {
                if (n3 == 0) {
                    return object;
                }
                int n4 = n3;
                int n22 = n;
                char[] cArray2 = cArray;
                for (int i = 0; i < n4 && !RT.isReduced((Object)object); ++i) {
                    object = iFn.invoke(object, (Object)Character.valueOf(cArray2[i + n22]));
                }
                if (RT.isReduced((Object)object)) {
                    return ((IDeref)object).deref();
                }
                return object;
            }
        };
    }

    public static List<Object> toList(char[] cArray) {
        return ArrayLists.toList(cArray, 0, cArray.length, null);
    }

    public static List<Object> toList(final boolean[] blArray, final int n, final int n2, final IPersistentMap iPersistentMap) {
        final int n3 = n2 - n;
        return new ILongArrayList(){

            public String toString() {
                return Transformables.sequenceToString(this);
            }

            @Override
            public boolean equals(Object object) {
                return this.equiv(object);
            }

            @Override
            public int hashCode() {
                return this.hasheq();
            }

            @Override
            public ArraySection getArray() {
                return new ArraySection(blArray, n, n2);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public Boolean get(int n4) {
                return blArray[ArrayLists.checkIndex(n4, n3) + n];
            }

            @Override
            public long getLong(int n4) {
                return blArray[ArrayLists.checkIndex(n4, n3) + n] ? 1L : 0L;
            }

            @Override
            public Boolean set(int n4, Object object) {
                boolean bl = Casts.booleanCast(object);
                n4 = ArrayLists.wrapCheckIndex(n4, n3) + n;
                Boolean bl2 = blArray[n4];
                blArray[n4] = bl;
                return bl2;
            }

            @Override
            public long setLong(int n4, long l) {
                boolean bl = Casts.booleanCast(l);
                n4 = ArrayLists.wrapCheckIndex(n4, n3) + n;
                boolean bl2 = blArray[n4];
                blArray[n4] = bl;
                return Casts.longCast(bl2);
            }

            @Override
            public List<Object> subList(int n4, int n22) {
                ArrayLists.checkIndexRange(n, n3, n4, n22);
                return ArrayLists.toList(blArray, n4 + n, n22 + n, this.meta());
            }

            @Override
            public IPersistentMap meta() {
                return iPersistentMap;
            }

            @Override
            public IObj withMeta(IPersistentMap iPersistentMap2) {
                return (IObj)ArrayLists.toList(blArray, n, n2, iPersistentMap2);
            }

            @Override
            public Object[] toArray() {
                int n4 = this.size();
                Object[] objectArray = new Object[this.size()];
                for (int i = 0; i < n4; ++i) {
                    objectArray[i] = blArray[i + n];
                }
                return objectArray;
            }
        };
    }

    public static List<Object> toList(boolean[] blArray) {
        return ArrayLists.toList(blArray, 0, blArray.length, null);
    }

    public static List toList(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Object is not an array: " + String.valueOf(object));
        }
        if (object instanceof Object[]) {
            return ArrayLists.toList((Object[])object);
        }
        if (clazz == byte[].class) {
            return ArrayLists.toList((byte[])object);
        }
        if (clazz == short[].class) {
            return ArrayLists.toList((short[])object);
        }
        if (clazz == int[].class) {
            return ArrayLists.toList((int[])object);
        }
        if (clazz == long[].class) {
            return ArrayLists.toList((long[])object);
        }
        if (clazz == float[].class) {
            return ArrayLists.toList((float[])object);
        }
        if (clazz == double[].class) {
            return ArrayLists.toList((double[])object);
        }
        if (clazz == char[].class) {
            return ArrayLists.toList((char[])object);
        }
        if (clazz == boolean[].class) {
            return ArrayLists.toList((boolean[])object);
        }
        throw new RuntimeException("Invalid array type.");
    }

    public static int[] iarange(int n, int n2, int n3) {
        int n4 = (n2 - n) / n3;
        if (n4 < 0) {
            throw new RuntimeException("Invalid range - start: " + String.valueOf(n) + " end: " + String.valueOf(n2) + " step: " + String.valueOf(n3));
        }
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = n + i * n3;
        }
        return nArray;
    }

    public static long[] larange(long l, long l2, long l3) {
        int n = RT.intCast((long)((l2 - l) / l3));
        if (n < 0) {
            throw new RuntimeException("Invalid range.");
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = l + (long)i * l3;
        }
        return lArray;
    }

    public static double[] darange(double d, double d2, double d3) {
        int n = RT.intCast((double)((d2 - d) / d3));
        if (n < 0) {
            throw new RuntimeException("Invalid range.");
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + (double)i * d3;
        }
        return dArray;
    }

    public static class DoubleArrayList
    implements IDoubleArrayList {
        double[] data;
        int nElems;
        IPersistentMap meta;

        public DoubleArrayList(double[] dArray, int n, IPersistentMap iPersistentMap) {
            this.data = dArray;
            this.nElems = n;
        }

        public DoubleArrayList(int n) {
            this(new double[n], 0, null);
        }

        public DoubleArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public double getDouble(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public Object set(int n, Object object) {
            return DoubleArraySubList.setDouble(this.data, 0, this.nElems, n, Casts.longCast(object));
        }

        @Override
        public double setDouble(int n, double d) {
            return DoubleArraySubList.setDouble(this.data, 0, this.nElems, n, d);
        }

        public int capacity() {
            return this.data.length;
        }

        double[] ensureCapacity(int n) {
            double[] dArray = this.data;
            if (n >= dArray.length) {
                dArray = this.data = Arrays.copyOf(dArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
            }
            return dArray;
        }

        @Override
        public boolean addDouble(double d) {
            int n = RT.intCast((double)d);
            int n2 = this.nElems;
            double[] dArray = this.ensureCapacity(n2 + 1);
            dArray[n2] = n;
            this.nElems = n2 + 1;
            return true;
        }

        @Override
        public boolean add(Object object) {
            return this.addDouble(Casts.longCast(object));
        }

        @Override
        public void add(int n, Object object) {
            if (n == this.nElems) {
                this.add(object);
                return;
            }
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            double d = Casts.doubleCast(object);
            int n2 = this.nElems;
            double[] dArray = this.ensureCapacity(n2 + 1);
            System.arraycopy(dArray, n, dArray, n + 1, n2 - n);
            dArray[n] = d;
            this.nElems = n2 + 1;
        }

        @Override
        public boolean addAll(Collection<? extends Object> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection instanceof RandomAccess) {
                int n = collection.size();
                int n2 = this.size();
                this.ensureCapacity(n + n2);
                this.nElems += n;
                this.fillRange(n2, (List)collection);
            } else {
                for (Object object : collection) {
                    this.add(object);
                }
            }
            return true;
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public Object remove(int n) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            int n2 = this.nElems;
            int n3 = n2 - 1;
            double[] dArray = this.data;
            double d = dArray[n];
            if (n != n3) {
                int n4 = n2 - n - 1;
                System.arraycopy(dArray, n + 1, dArray, n, n4);
            }
            --this.nElems;
            return d;
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return this.subList(0, this.nElems).toArray();
        }

        @Override
        public double[] toDoubleArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, n2, object);
        }

        @Override
        public void fillRange(int n, List list) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, list);
        }

        @Override
        public void addRange(int n, int n2, Object object) {
            int n3 = this.nElems;
            ArrayLists.checkIndexRange(0, n3, n, n2);
            int n4 = n2 - n;
            int n5 = n3 + n4;
            this.ensureCapacity(n5);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return ((IReduce)this.subList(0, this.nElems)).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return ((IReduceInit)this.subList(0, this.nElems)).reduce(iFn, object);
        }

        @Override
        public double doubleReduction(DoubleBinaryOperator doubleBinaryOperator, double d) {
            return DoubleArraySubList.doubleReduction(this.data, 0, this.size(), doubleBinaryOperator, d);
        }

        @Override
        public void forEach(Consumer consumer) {
            DoubleArraySubList.forEach(this.data, 0, this.nElems, consumer);
        }

        @Override
        public IntComparator indexComparator() {
            return DoubleArraySubList.indexComparator(this.data, 0, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return DoubleArraySubList.indexComparator(this.data, 0, comparator);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public List immutSort(Comparator comparator) {
            return ((ImmutSort)this.subList(0, this.nElems)).immutSort(comparator);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            return ((IMutList)this.subList(0, this.nElems)).sortIndirect(comparator);
        }

        @Override
        public List immutShuffle(Random random) {
            return ((IMutList)this.subList(0, this.nElems)).immutShuffle(random);
        }

        public static DoubleArrayList wrap(double[] dArray, int n, IPersistentMap iPersistentMap) {
            if (dArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new DoubleArrayList(dArray, n, iPersistentMap);
        }

        public static DoubleArrayList wrap(double[] dArray, IPersistentMap iPersistentMap) {
            return new DoubleArrayList(dArray, dArray.length, iPersistentMap);
        }
    }

    public static class DoubleArraySubList
    extends ArraySection
    implements IDoubleArrayList {
        public final double[] data;
        public final int nElems;
        public final IPersistentMap meta;

        public DoubleArraySubList(double[] dArray, int n, int n2, IPersistentMap iPersistentMap) {
            super(dArray, n, n2);
            this.data = dArray;
            this.nElems = n2 - n;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return this;
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        @Override
        public double getDouble(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        static double setDouble(double[] dArray, int n, int n2, int n3, double d) {
            n3 = ArrayLists.wrapCheckIndex(n3, n2) + n;
            double d2 = dArray[n3];
            dArray[n3] = d;
            return d2;
        }

        @Override
        public Object set(int n, Object object) {
            return DoubleArraySubList.setDouble(this.data, this.sidx, this.nElems, n, Casts.doubleCast(object));
        }

        @Override
        public double setDouble(int n, double d) {
            return DoubleArraySubList.setDouble(this.data, this.sidx, this.nElems, n, d);
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return (IObj)ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            double[] dArray = this.data;
            int n = this.sidx;
            int n2 = this.nElems;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = dArray[i + n];
            }
            return objectArray;
        }

        @Override
        public double[] toDoubleArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            Arrays.fill(this.data, n + this.sidx, n2 + this.sidx, (double)Casts.longCast(object));
        }

        @Override
        public void fillRange(int n, List list) {
            int n2 = list.size();
            int n3 = n + n2;
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n3);
            if (list instanceof ArrayOwner) {
                ArraySection arraySection = ((ArrayOwner)((Object)list)).getArray();
                if (arraySection.array instanceof double[]) {
                    System.arraycopy((double[])arraySection.array, arraySection.sidx, this.data, this.sidx, n2);
                    return;
                }
            }
            int n4 = this.sidx;
            double[] dArray = this.data;
            if (list instanceof IMutList) {
                IMutList iMutList = (IMutList)list;
                for (int i = 0; i < n2; ++i) {
                    dArray[i + this.sidx] = iMutList.getDouble(i);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    dArray[i + this.sidx] = Casts.longCast(list.get(i));
                }
            }
        }

        @Override
        public Object reduce(IFn iFn) {
            if (this.isEmpty()) {
                return iFn.invoke();
            }
            int n = this.nElems;
            int n2 = this.sidx;
            double[] dArray = this.data;
            Object object = dArray[n2];
            for (int i = 1; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)dArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            if (this.isEmpty()) {
                return object;
            }
            int n = this.nElems;
            int n2 = this.sidx;
            double[] dArray = this.data;
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)dArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        public static double doubleReduction(double[] dArray, int n, int n2, DoubleBinaryOperator doubleBinaryOperator, double d) {
            if (n == 0) {
                for (int i = 0; i < n2; ++i) {
                    d = doubleBinaryOperator.applyAsDouble(d, dArray[i]);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    d = doubleBinaryOperator.applyAsDouble(d, dArray[i + n]);
                }
            }
            return d;
        }

        @Override
        public double doubleReduction(DoubleBinaryOperator doubleBinaryOperator, double d) {
            return DoubleArraySubList.doubleReduction(this.data, this.sidx, this.size(), doubleBinaryOperator, d);
        }

        public static void forEach(double[] dArray, int n, int n2, Consumer consumer) {
            if (consumer instanceof DoubleConsumer) {
                DoubleConsumer doubleConsumer = (DoubleConsumer)((Object)consumer);
                if (n == 0) {
                    for (int i = 0; i < n2; ++i) {
                        doubleConsumer.accept(dArray[i]);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        doubleConsumer.accept(dArray[i + n]);
                    }
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    consumer.accept(dArray[i + n]);
                }
            }
        }

        @Override
        public void forEach(Consumer consumer) {
            DoubleArraySubList.forEach(this.data, this.sidx, this.nElems, consumer);
        }

        public static IntComparator indexComparator(final double[] dArray, final int n, final Comparator comparator) {
            if (comparator == null) {
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return Double.compare(dArray[n3 + n], dArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Double.compare(dArray[n], dArray[n2]);
                    }
                };
            }
            if (comparator instanceof DoubleComparator) {
                final DoubleComparator doubleComparator = (DoubleComparator)comparator;
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return doubleComparator.compare(dArray[n3 + n], dArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return doubleComparator.compare(dArray[n], dArray[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n3, int n2) {
                    return comparator.compare(dArray[n3 + n], dArray[n2 + n]);
                }
            };
        }

        @Override
        public IntComparator indexComparator() {
            return DoubleArraySubList.indexComparator(this.data, this.sidx, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return DoubleArraySubList.indexComparator(this.data, this.sidx, comparator);
        }

        public static DoubleComparator toDoubleComparator(Comparator comparator) {
            if (comparator instanceof DoubleComparator) {
                return (DoubleComparator)comparator;
            }
            return null;
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                DoubleArrays.parallelQuickSort((double[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                DoubleComparator doubleComparator = DoubleArraySubList.toDoubleComparator(comparator);
                if (doubleComparator != null) {
                    DoubleArrays.parallelQuickSort((double[])this.data, (int)this.sidx, (int)this.eidx, (DoubleComparator)DoubleArraySubList.toDoubleComparator(comparator));
                } else {
                    Object[] objectArray = this.toArray();
                    Arrays.sort(objectArray, comparator);
                    int n = this.size();
                    for (int i = 0; i < n; ++i) {
                        this.setDouble(i, (Double)objectArray[i]);
                    }
                }
            }
        }

        @Override
        public List immutSort(Comparator comparator) {
            List<Object> list = ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx), 0, this.eidx - this.sidx, this.meta());
            list.sort(comparator);
            return list;
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            int n = this.size();
            int[] nArray = ArrayLists.iarange(0, n, 1);
            if (n < 2) {
                return nArray;
            }
            if (comparator == null) {
                DoubleArrays.parallelQuickSortIndirect((int[])nArray, (double[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])nArray, (IntComparator)this.indexComparator(comparator));
            }
            return nArray;
        }
    }

    public static class LongArrayList
    implements ILongArrayList {
        long[] data;
        int nElems;
        IPersistentMap meta;

        public LongArrayList(long[] lArray, int n, IPersistentMap iPersistentMap) {
            this.data = lArray;
            this.nElems = n;
        }

        public LongArrayList(int n) {
            this(new long[n], 0, null);
        }

        public LongArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public Object set(int n, Object object) {
            return LongArraySubList.setLong(this.data, 0, this.nElems, n, Casts.longCast(object));
        }

        @Override
        public long setLong(int n, long l) {
            return LongArraySubList.setLong(this.data, 0, this.nElems, n, l);
        }

        public int capacity() {
            return this.data.length;
        }

        long[] ensureCapacity(int n) {
            long[] lArray = this.data;
            if (n >= lArray.length) {
                lArray = this.data = Arrays.copyOf(lArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
            }
            return lArray;
        }

        @Override
        public boolean addLong(long l) {
            int n = RT.intCast((long)l);
            int n2 = this.nElems;
            long[] lArray = this.ensureCapacity(n2 + 1);
            lArray[n2] = n;
            this.nElems = n2 + 1;
            return true;
        }

        @Override
        public boolean add(Object object) {
            return this.addLong(Casts.longCast(object));
        }

        @Override
        public void add(int n, Object object) {
            if ((n = ArrayLists.wrapCheckIndex(n, this.nElems)) == this.nElems) {
                this.add(object);
                return;
            }
            int n2 = RT.intCast((long)Casts.longCast(object));
            int n3 = this.nElems;
            long[] lArray = this.ensureCapacity(n3 + 1);
            System.arraycopy(lArray, n, lArray, n + 1, n3 - n);
            lArray[n] = n2;
            this.nElems = n3 + 1;
        }

        @Override
        public boolean addAll(Collection<? extends Object> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection instanceof RandomAccess) {
                int n = collection.size();
                int n2 = this.size();
                this.ensureCapacity(n + n2);
                this.nElems += n;
                this.fillRange(n2, (List)collection);
            } else {
                for (Object object : collection) {
                    this.add(object);
                }
            }
            return true;
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public Object remove(int n) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            int n2 = this.nElems;
            int n3 = n2 - 1;
            long[] lArray = this.data;
            long l = lArray[n];
            if (n != n3) {
                int n4 = n2 - n - 1;
                System.arraycopy(lArray, n + 1, lArray, n, n4);
            }
            --this.nElems;
            return l;
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return this.subList(0, this.nElems).toArray();
        }

        @Override
        public long[] toLongArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, n2, object);
        }

        @Override
        public void fillRange(int n, List list) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, list);
        }

        @Override
        public void addRange(int n, int n2, Object object) {
            int n3 = this.nElems;
            ArrayLists.checkIndexRange(0, n3, n, n2);
            int n4 = n2 - n;
            int n5 = n3 + n4;
            this.ensureCapacity(n5);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return ((IReduce)this.subList(0, this.nElems)).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return ((IReduceInit)this.subList(0, this.nElems)).reduce(iFn, object);
        }

        @Override
        public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
            return ((IMutList)this.subList(0, this.nElems)).longReduction(longBinaryOperator, l);
        }

        @Override
        public IntComparator indexComparator() {
            return LongArraySubList.indexComparator(this.data, 0, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return LongArraySubList.indexComparator(this.data, 0, comparator);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public List immutSort(Comparator comparator) {
            return ((ImmutSort)this.subList(0, this.nElems)).immutSort(comparator);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            return ((IMutList)this.subList(0, this.nElems)).sortIndirect(comparator);
        }

        public static LongArrayList wrap(long[] lArray, int n, IPersistentMap iPersistentMap) {
            if (lArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new LongArrayList(lArray, n, iPersistentMap);
        }

        public static LongArrayList wrap(long[] lArray, IPersistentMap iPersistentMap) {
            return new LongArrayList(lArray, lArray.length, iPersistentMap);
        }
    }

    public static class LongArraySubList
    extends ArraySection
    implements ILongArrayList {
        public final long[] data;
        public final int nElems;
        public final IPersistentMap meta;

        public LongArraySubList(long[] lArray, int n, int n2, IPersistentMap iPersistentMap) {
            super(lArray, n, n2);
            this.data = lArray;
            this.nElems = n2 - n;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return this;
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        static long setLong(long[] lArray, int n, int n2, int n3, long l) {
            n3 = ArrayLists.wrapCheckIndex(n3, n2) + n;
            long l2 = lArray[n3];
            lArray[n3] = l;
            return l2;
        }

        @Override
        public Object set(int n, Object object) {
            return LongArraySubList.setLong(this.data, this.sidx, this.nElems, n, Casts.longCast(object));
        }

        @Override
        public long setLong(int n, long l) {
            return LongArraySubList.setLong(this.data, this.sidx, this.nElems, n, l);
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return (IObj)ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            long[] lArray = this.data;
            int n = this.sidx;
            int n2 = this.nElems;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = lArray[i + n];
            }
            return objectArray;
        }

        @Override
        public long[] toLongArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            Arrays.fill(this.data, n + this.sidx, n2 + this.sidx, Casts.longCast(object));
        }

        @Override
        public void fillRange(int n, List list) {
            int n2 = list.size();
            int n3 = n + n2;
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n3);
            if (list instanceof ArrayOwner) {
                ArraySection arraySection = ((ArrayOwner)((Object)list)).getArray();
                if (arraySection.array instanceof long[]) {
                    System.arraycopy((long[])arraySection.array, arraySection.sidx, this.data, this.sidx, n2);
                    return;
                }
            }
            int n4 = this.sidx;
            long[] lArray = this.data;
            if (list instanceof IMutList) {
                IMutList iMutList = (IMutList)list;
                for (int i = 0; i < n2; ++i) {
                    lArray[i + this.sidx] = iMutList.getLong(i);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    lArray[i + this.sidx] = Casts.longCast(list.get(i));
                }
            }
        }

        @Override
        public Object reduce(IFn iFn) {
            if (this.nElems == 0) {
                return iFn.invoke();
            }
            int n = this.nElems;
            int n2 = this.sidx;
            long[] lArray = this.data;
            Object object = lArray[n2];
            for (int i = 1; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)lArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            if (this.nElems == 0) {
                return object;
            }
            int n = this.nElems;
            int n2 = this.sidx;
            long[] lArray = this.data;
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)lArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                l = longBinaryOperator.applyAsLong(l, this.data[i + this.sidx]);
            }
            return l;
        }

        public static IntComparator indexComparator(final long[] lArray, final int n, final Comparator comparator) {
            if (comparator == null) {
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return Long.compare(lArray[n3 + n], lArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Long.compare(lArray[n], lArray[n2]);
                    }
                };
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return longComparator.compare(lArray[n3 + n], lArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return longComparator.compare(lArray[n], lArray[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n3, int n2) {
                    return comparator.compare(lArray[n3 + n], lArray[n2 + n]);
                }
            };
        }

        @Override
        public IntComparator indexComparator() {
            return LongArraySubList.indexComparator(this.data, this.sidx, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return LongArraySubList.indexComparator(this.data, this.sidx, comparator);
        }

        public static LongComparator toLongComparator(final Comparator comparator) {
            if (comparator instanceof LongComparator) {
                return (LongComparator)comparator;
            }
            return new LongComparator(){

                public int compare(long l, long l2) {
                    return comparator.compare(l, l2);
                }
            };
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                LongArrays.parallelQuickSort((long[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                LongArrays.parallelQuickSort((long[])this.data, (int)this.sidx, (int)this.eidx, (LongComparator)LongArraySubList.toLongComparator(comparator));
            }
        }

        @Override
        public List immutSort(Comparator comparator) {
            List<Object> list = ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx), 0, this.eidx - this.sidx, this.meta());
            list.sort(comparator);
            return list;
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            int n = this.size();
            int[] nArray = ArrayLists.iarange(0, n, 1);
            if (n < 2) {
                return nArray;
            }
            if (comparator == null) {
                LongArrays.parallelQuickSortIndirect((int[])nArray, (long[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])nArray, (IntComparator)this.indexComparator(comparator));
            }
            return nArray;
        }

        @Override
        public List immutShuffle(Random random) {
            long[] lArray = this.toLongArray();
            LongArrays.shuffle((long[])lArray, (Random)random);
            return ArrayLists.toList(lArray);
        }
    }

    public static class IntArrayList
    implements ILongArrayList {
        int[] data;
        int nElems;
        IPersistentMap meta;

        public IntArrayList(int[] nArray, int n, IPersistentMap iPersistentMap) {
            this.data = nArray;
            this.nElems = n;
        }

        public IntArrayList(int n) {
            this(new int[n], 0, null);
        }

        public IntArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public Object set(int n, Object object) {
            return IntArraySubList.setLong(this.data, 0, this.nElems, n, Casts.longCast(object));
        }

        @Override
        public long setLong(int n, long l) {
            return IntArraySubList.setLong(this.data, 0, this.nElems, n, l);
        }

        public int capacity() {
            return this.data.length;
        }

        int[] ensureCapacity(int n) {
            int[] nArray = this.data;
            if (n >= nArray.length) {
                nArray = this.data = Arrays.copyOf(nArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
            }
            return nArray;
        }

        @Override
        public boolean addLong(long l) {
            int n = RT.intCast((long)l);
            int n2 = this.nElems;
            int[] nArray = this.ensureCapacity(n2 + 1);
            nArray[n2] = n;
            this.nElems = n2 + 1;
            return true;
        }

        @Override
        public boolean add(Object object) {
            return this.addLong(Casts.longCast(object));
        }

        @Override
        public void add(int n, Object object) {
            if ((n = ArrayLists.wrapCheckIndex(n, this.nElems)) == this.nElems) {
                this.add(object);
                return;
            }
            int n2 = RT.intCast((long)Casts.longCast(object));
            int n3 = this.nElems;
            int[] nArray = this.ensureCapacity(n3 + 1);
            System.arraycopy(nArray, n, nArray, n + 1, n3 - n);
            nArray[n] = n2;
            this.nElems = n3 + 1;
        }

        @Override
        public boolean addAll(Collection<? extends Object> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection instanceof RandomAccess) {
                int n = collection.size();
                int n2 = this.size();
                this.ensureCapacity(n + n2);
                this.nElems += n;
                this.fillRange(n2, (List)collection);
            } else {
                for (Object object : collection) {
                    this.add(object);
                }
            }
            return true;
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public Object remove(int n) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            int n2 = this.nElems;
            int n3 = n2 - 1;
            int[] nArray = this.data;
            int n4 = nArray[n];
            if (n != n3) {
                int n5 = n2 - n - 1;
                System.arraycopy(nArray, n + 1, nArray, n, n5);
            }
            --this.nElems;
            return n4;
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return this.subList(0, this.nElems).toArray();
        }

        @Override
        public int[] toIntArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, n2, object);
        }

        @Override
        public void fillRange(int n, List list) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, list);
        }

        @Override
        public void addRange(int n, int n2, Object object) {
            int n3 = this.nElems;
            ArrayLists.checkIndexRange(0, n3, n, n2);
            int n4 = n2 - n;
            int n5 = n3 + n4;
            this.ensureCapacity(n5);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return ((IReduce)this.subList(0, this.nElems)).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return ((IReduceInit)this.subList(0, this.nElems)).reduce(iFn, object);
        }

        @Override
        public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
            return ((IMutList)this.subList(0, this.nElems)).longReduction(longBinaryOperator, l);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            return ((IMutList)this.subList(0, this.nElems)).sortIndirect(comparator);
        }

        @Override
        public List immutSort(Comparator comparator) {
            return ((ImmutSort)this.subList(0, this.nElems)).immutSort(comparator);
        }

        @Override
        public IntComparator indexComparator() {
            return IntArraySubList.indexComparator(this.data, 0, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return IntArraySubList.indexComparator(this.data, 0, comparator);
        }

        public static IntArrayList wrap(int[] nArray, int n, IPersistentMap iPersistentMap) {
            if (nArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new IntArrayList(nArray, n, iPersistentMap);
        }

        public static IntArrayList wrap(int[] nArray, IPersistentMap iPersistentMap) {
            return new IntArrayList(nArray, nArray.length, iPersistentMap);
        }
    }

    public static class IntArraySubList
    extends ArraySection
    implements ILongArrayList {
        public final int[] data;
        public final int nElems;
        public final IPersistentMap meta;

        public IntArraySubList(int[] nArray, int n, int n2, IPersistentMap iPersistentMap) {
            super(nArray, n, n2);
            this.data = nArray;
            this.nElems = n2 - n;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return this;
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        static int setLong(int[] nArray, int n, int n2, int n3, long l) {
            int n4 = RT.intCast((long)l);
            n3 = ArrayLists.wrapCheckIndex(n3, n2) + n;
            int n5 = nArray[n3];
            nArray[n3] = n4;
            return n5;
        }

        @Override
        public Object set(int n, Object object) {
            return IntArraySubList.setLong(this.data, this.sidx, this.nElems, n, Casts.longCast(object));
        }

        @Override
        public long setLong(int n, long l) {
            return IntArraySubList.setLong(this.data, this.sidx, this.nElems, n, l);
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return (IObj)ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int[] nArray = this.data;
            int n = this.sidx;
            int n2 = this.nElems;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = nArray[i + n];
            }
            return objectArray;
        }

        @Override
        public int[] toIntArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            Arrays.fill(this.data, n + this.sidx, n2 + this.sidx, RT.intCast((long)Casts.longCast(object)));
        }

        @Override
        public void fillRange(int n, List list) {
            int n2 = list.size();
            int n3 = n + n2;
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n3);
            if (list instanceof ArrayOwner) {
                ArraySection arraySection = ((ArrayOwner)((Object)list)).getArray();
                if (arraySection.array instanceof int[]) {
                    System.arraycopy((int[])arraySection.array, arraySection.sidx, this.data, this.sidx, n2);
                    return;
                }
            }
            int n4 = this.sidx;
            int[] nArray = this.data;
            if (list instanceof IMutList) {
                IMutList iMutList = (IMutList)list;
                for (int i = 0; i < n2; ++i) {
                    nArray[i + this.sidx] = RT.intCast((long)iMutList.getLong(i));
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    nArray[i + this.sidx] = RT.intCast((long)Casts.longCast(list.get(i)));
                }
            }
        }

        @Override
        public Object reduce(IFn iFn) {
            if (this.nElems == 0) {
                return iFn.invoke();
            }
            int n = this.nElems;
            int n2 = this.sidx;
            int[] nArray = this.data;
            Object object = nArray[n2];
            for (int i = 1; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)nArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            if (this.nElems == 0) {
                return object;
            }
            int n = this.nElems;
            int n2 = this.sidx;
            int[] nArray = this.data;
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)nArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                l = longBinaryOperator.applyAsLong(l, this.data[i + this.sidx]);
            }
            return l;
        }

        public static IntComparator indexComparator(final int[] nArray, final int n, final Comparator comparator) {
            if (comparator == null) {
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return Integer.compare(nArray[n3 + n], nArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Integer.compare(nArray[n], nArray[n2]);
                    }
                };
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return longComparator.compare((long)nArray[n3 + n], (long)nArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return longComparator.compare((long)nArray[n], (long)nArray[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n3, int n2) {
                    return comparator.compare(nArray[n3 + n], nArray[n2 + n]);
                }
            };
        }

        @Override
        public IntComparator indexComparator() {
            return IntArraySubList.indexComparator(this.data, this.sidx, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return IntArraySubList.indexComparator(this.data, this.sidx, comparator);
        }

        public static IntComparator toIntComparator(final Comparator comparator) {
            if (comparator instanceof IntComparator) {
                return (IntComparator)comparator;
            }
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return comparator.compare(n, n2);
                }
            };
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                IntArrays.parallelQuickSort((int[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])this.data, (int)this.sidx, (int)this.eidx, (IntComparator)IntArraySubList.toIntComparator(comparator));
            }
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            int n = this.size();
            int[] nArray = ArrayLists.iarange(0, n, 1);
            if (n < 2) {
                return nArray;
            }
            if (comparator == null) {
                IntArrays.parallelQuickSortIndirect((int[])nArray, (int[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])nArray, (IntComparator)this.indexComparator(comparator));
            }
            return nArray;
        }

        @Override
        public List immutSort(Comparator comparator) {
            List<Object> list = ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx), 0, this.eidx - this.sidx, this.meta());
            list.sort(comparator);
            return list;
        }

        @Override
        public List immutShuffle(Random random) {
            int[] nArray = this.toIntArray();
            IntArrays.shuffle((int[])nArray, (Random)random);
            return ArrayLists.toList(nArray);
        }
    }

    public static class ObjectArrayList
    implements IArrayList {
        Object[] data;
        int nElems;
        IPersistentMap meta;

        public ObjectArrayList(Object[] objectArray, int n, IPersistentMap iPersistentMap) {
            this.data = objectArray;
            this.nElems = n;
        }

        public ObjectArrayList(int n) {
            this(new Object[n], 0, null);
        }

        public ObjectArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public Object set(int n, Object object) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            Object object2 = this.data[n];
            this.data[n] = object;
            return object2;
        }

        public int capacity() {
            return this.data.length;
        }

        Object[] ensureCapacity(int n) {
            Object[] objectArray = this.data;
            if (n >= objectArray.length) {
                this.data = Arrays.copyOf(objectArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
                objectArray = this.data;
            }
            return objectArray;
        }

        @Override
        public boolean add(Object object) {
            int n = this.nElems;
            Object[] objectArray = this.ensureCapacity(n + 1);
            objectArray[n] = object;
            this.nElems = n + 1;
            return true;
        }

        @Override
        public void add(int n, Object object) {
            if ((n = ArrayLists.wrapCheckIndex(n, this.nElems)) == this.nElems) {
                this.add(object);
                return;
            }
            int n2 = this.nElems;
            Object[] objectArray = this.ensureCapacity(n2 + 1);
            System.arraycopy(objectArray, n, objectArray, n + 1, n2 - n);
            objectArray[n] = object;
            this.nElems = n2 + 1;
        }

        @Override
        public boolean addAll(Collection<? extends Object> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (collection instanceof RandomAccess) {
                int n = collection.size();
                int n2 = this.size();
                this.ensureCapacity(n + n2);
                this.nElems += n;
                this.fillRange(n2, (List)collection);
            } else if (collection instanceof IReduceInit) {
                ((IReduceInit)collection).reduce((IFn)new IFnDef(){

                    @Override
                    public Object invoke(Object object, Object object2) {
                        this.add(object2);
                        return this;
                    }
                }, (Object)this);
            } else {
                Iterator<? extends Object> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    int n;
                    int n3 = this.nElems;
                    Object[] objectArray = this.ensureCapacity(n3 + 16);
                    int n4 = n + 16;
                    for (n = n3; n < n4 && iterator.hasNext(); ++n) {
                        objectArray[n] = iterator.next();
                    }
                    this.nElems = n;
                }
            }
            return true;
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public Object remove(int n) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            int n2 = this.nElems;
            int n3 = n2 - 1;
            Object[] objectArray = this.data;
            Object object = objectArray[n];
            if (n == n3) {
                objectArray[n] = null;
            } else {
                int n4 = n2 - n - 1;
                System.arraycopy(objectArray, n + 1, objectArray, n, n4);
                objectArray[n3] = null;
            }
            --this.nElems;
            return object;
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, n2, object);
        }

        @Override
        public void fillRange(int n, List list) {
            ((RangeList)((Object)this.subList(0, this.nElems))).fillRange(n, list);
        }

        @Override
        public void addRange(int n, int n2, Object object) {
            int n3 = this.nElems;
            ArrayLists.checkIndexRange(0, n3, n, n2);
            int n4 = n2 - n;
            int n5 = n3 + n4;
            this.ensureCapacity(n5);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n);
            Arrays.fill(this.data, n, n2, object);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(0, this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            Arrays.fill(this.data, n2, this.nElems, null);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return ((IReduce)this.subList(0, this.nElems)).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return ((IReduceInit)this.subList(0, this.nElems)).reduce(iFn, object);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public List immutSort(Comparator comparator) {
            return ((ImmutSort)this.subList(0, this.nElems)).immutSort(comparator);
        }

        @Override
        public List immutShuffle(Random random) {
            return ((IMutList)this.subList(0, this.nElems)).immutShuffle(random);
        }

        public static ObjectArrayList wrap(Object[] objectArray, int n, IPersistentMap iPersistentMap) {
            if (objectArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new ObjectArrayList(objectArray, n, iPersistentMap);
        }

        public static ObjectArrayList wrap(Object[] objectArray, IPersistentMap iPersistentMap) {
            return new ObjectArrayList(objectArray, objectArray.length, iPersistentMap);
        }
    }

    public static class ObjectArraySubList
    extends ArraySection
    implements IArrayList {
        public final Object[] data;
        public final int nElems;
        public final IPersistentMap meta;

        public ObjectArraySubList(Object[] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
            super(objectArray, n, n2);
            this.data = objectArray;
            this.nElems = n2 - n;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArray() {
            return this;
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        @Override
        public Object set(int n, Object object) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems) + this.sidx;
            Object object2 = this.data[n];
            this.data[n] = object;
            return object2;
        }

        @Override
        public List<Object> subList(int n, int n2) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return (IObj)ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n2);
            Arrays.fill(this.data, n + this.sidx, n2 + this.sidx, object);
        }

        @Override
        public void fillRange(int n, List list) {
            int n2 = list.size();
            int n3 = n + n2;
            ArrayLists.checkIndexRange(this.sidx, this.eidx, n, n3);
            if (list instanceof ArrayOwner) {
                ArraySection arraySection = ((ArrayOwner)((Object)list)).getArray();
                if (arraySection.array instanceof Object[]) {
                    System.arraycopy((Object[])arraySection.array, arraySection.sidx, this.data, this.sidx, n2);
                    return;
                }
            }
            int n4 = this.sidx;
            Object[] objectArray = this.data;
            for (int i = 0; i < n2; ++i) {
                objectArray[i + this.sidx] = list.get(i);
            }
        }

        @Override
        public Object reduce(IFn iFn) {
            if (this.nElems == 0) {
                return iFn.invoke();
            }
            int n = this.nElems;
            int n2 = this.sidx;
            Object[] objectArray = this.data;
            Object object = objectArray[n2];
            for (int i = 1; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, objectArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            if (this.nElems == 0) {
                return object;
            }
            int n = this.nElems;
            int n2 = this.sidx;
            Object[] objectArray = this.data;
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, objectArray[i + n2]);
            }
            if (RT.isReduced((Object)object)) {
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                Arrays.sort(this.data, this.sidx, this.eidx);
            } else {
                Arrays.sort(this.data, this.sidx, this.eidx, comparator);
            }
        }

        @Override
        public List immutSort(Comparator comparator) {
            List<Object> list = ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx), 0, this.eidx - this.sidx, this.meta());
            list.sort(comparator);
            return list;
        }

        @Override
        public List immutShuffle(Random random) {
            Object[] objectArray = this.toArray();
            ObjectArrays.shuffle((Object[])objectArray, (Random)random);
            return ArrayLists.toList(objectArray);
        }
    }

    public static interface IDoubleArrayList
    extends DoubleMutList,
    ArrayOwner,
    TypedList,
    ArrayPersistentVector {
        @Override
        default public Class containedType() {
            return this.getArray().array.getClass().getComponentType();
        }

        @Override
        default public IPersistentVector unsafeImmut() {
            return ImmutList.create(true, this.meta(), this.toArray());
        }
    }

    public static interface ILongArrayList
    extends LongMutList,
    ArrayOwner,
    TypedList,
    ArrayPersistentVector {
        @Override
        default public Class containedType() {
            return this.getArray().array.getClass().getComponentType();
        }

        @Override
        default public IPersistentVector unsafeImmut() {
            return ImmutList.create(true, this.meta(), this.toArray());
        }
    }

    public static interface IArrayList
    extends IMutList<Object>,
    ArrayOwner,
    TypedList,
    ArrayPersistentVector {
        @Override
        default public Class containedType() {
            return this.getArray().array.getClass().getComponentType();
        }

        @Override
        default public IPersistentVector unsafeImmut() {
            return ImmutList.create(true, this.meta(), (Object[])this.getArray().array);
        }
    }

    public static interface ArrayPersistentVector
    extends IMutList<Object>,
    IPersistentVector {
        public IPersistentVector unsafeImmut();

        @Override
        default public boolean equiv(Object object) {
            return IMutList.super.equiv(object);
        }

        default public IPersistentVector cons(Object object) {
            return this.unsafeImmut().cons(object);
        }

        default public IPersistentVector assocN(int n, Object object) {
            return this.unsafeImmut().assocN(n, object);
        }

        @Override
        default public int length() {
            return this.size();
        }

        default public Associative assoc(Object object, Object object2) {
            return this.unsafeImmut().assoc(object, object2);
        }

        @Override
        default public IMapEntry entryAt(Object object) {
            if (Util.isInteger((Object)object)) {
                int n = RT.intCast((Object)object);
                return MapEntry.create((Object)n, this.get(n));
            }
            return null;
        }

        @Override
        default public boolean containsKey(Object object) {
            if (Util.isInteger((Object)object)) {
                int n = RT.intCast((Object)object);
                return n >= 0 && n < this.size();
            }
            return false;
        }

        @Override
        default public int count() {
            return this.size();
        }

        @Override
        default public Object valAt(Object object, Object object2) {
            int n;
            if (Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.size()) {
                return this.get(n);
            }
            return object2;
        }

        @Override
        default public Object valAt(Object object) {
            return this.valAt(object, null);
        }

        default public IPersistentStack pop() {
            int n = this.size();
            if (n == 0) {
                throw new RuntimeException("Can't pop empty vector");
            }
            if (n == 1) {
                return ImmutList.EMPTY.withMeta(this.meta());
            }
            return this.unsafeImmut().pop();
        }

        default public Object peek() {
            int n = this.size();
            if (n == 0) {
                return null;
            }
            return this.get(n - 1);
        }

        default public ImmutList empty() {
            return ImmutList.EMPTY.withMeta(this.meta());
        }
    }

    public static interface ArrayOwner {
        public ArraySection getArray();
    }

    public static class ArraySection {
        public final Object array;
        public final int sidx;
        public final int eidx;

        public ArraySection(Object object, int n, int n2) {
            this.array = object;
            this.sidx = n;
            this.eidx = n2;
        }
    }

    public static class ReductionConsumer
    implements Consumer {
        Object init;
        IFn fn;

        public ReductionConsumer(IFn iFn, Object object) {
            this.fn = iFn;
            this.init = object;
        }

        public void accept(Object object) {
            if (!RT.isReduced((Object)this.init)) {
                this.init = this.fn.invoke(this.init, object);
            }
        }

        public Object value() {
            if (RT.isReduced((Object)this.init)) {
                return ((IDeref)this.init).deref();
            }
            return this.init;
        }
    }

    public static class SummationConsumer
    implements DoubleConsumer,
    Consumer {
        public double d0 = 0.0;
        public double d1 = 0.0;
        public double simpleSum = 0.0;
        public long nElems = 0L;

        public void sumWithCompensation(double d) {
            double d2 = d - this.d1;
            double d3 = this.d0;
            double d4 = d3 + d2;
            this.d1 = d4 - d3 - d2;
            this.d0 = d4;
        }

        @Override
        public void accept(double d) {
            this.sumWithCompensation(d);
            this.simpleSum += d;
            ++this.nElems;
        }

        public void accept(Object object) {
            this.accept(Casts.doubleCast(object));
        }

        public double value() {
            double d = this.d0 + this.d1;
            if (Double.isNaN(d) && Double.isInfinite(this.simpleSum)) {
                return this.simpleSum;
            }
            return d;
        }
    }
}

