/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.ArraySeq;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.IteratorSeq;
import clojure.lang.RT;
import clojure.lang.Seqable;
import ham_fisted.ArrayLists;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.MapFn;
import ham_fisted.StringCollection;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;

public class Transformables {
    public static boolean truthy(Object object) {
        return object != null && !Objects.equals(object, RT.F);
    }

    public static Iterable toIterable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet();
        }
        if (object.getClass().isArray()) {
            return ArrayLists.toList(object);
        }
        if (object instanceof String) {
            return new StringCollection((String)object);
        }
        return (Iterable)RT.seq((Object)object);
    }

    public static int iterCount(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public static Object iterReduce(Object object, IFn iFn) {
        Object object2;
        Iterator iterator = Transformables.toIterable(object).iterator();
        Object object3 = object2 = iterator.hasNext() ? (Object)iterator.next() : null;
        while (iterator.hasNext() && !RT.isReduced(object2)) {
            object2 = iFn.invoke(object2, iterator.next());
        }
        if (RT.isReduced(object2)) {
            return ((IDeref)object2).deref();
        }
        return object2;
    }

    public static Object iterReduce(Object object, Object object2, IFn iFn) {
        Iterator iterator = Transformables.toIterable(object).iterator();
        while (iterator.hasNext() && !RT.isReduced((Object)object2)) {
            object2 = iFn.invoke(object2, iterator.next());
        }
        if (RT.isReduced((Object)object2)) {
            return ((IDeref)object2).deref();
        }
        return object2;
    }

    static void appendObjects(StringBuilder stringBuilder, Collection collection) {
        boolean bl = true;
        for (Object e : collection) {
            if (!bl) {
                stringBuilder.append(" ");
            }
            bl = false;
            stringBuilder.append(e == null ? "nil" : e.toString());
        }
    }

    public static String sequenceToString(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection instanceof RandomAccess) {
            List list = (List)collection;
            int n = list.size();
            stringBuilder.append("[");
            if (n < 50) {
                Transformables.appendObjects(stringBuilder, list);
            } else {
                Transformables.appendObjects(stringBuilder, list.subList(0, 20));
                stringBuilder.append(" ... ");
                Transformables.appendObjects(stringBuilder, list.subList(n - 20, n));
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("(");
            int n = 0;
            for (Object e : collection) {
                if (n >= 50) {
                    stringBuilder.append(" ...");
                    break;
                }
                if (n > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(e == null ? "nil" : e.toString());
                ++n;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static class CachingList
    implements IMutList {
        final List src;
        final Object[] dataCache;
        final BitSet cachedIndexes;
        final IPersistentMap meta;
        int _hash;

        public CachingList(List list, IPersistentMap iPersistentMap) {
            this.src = list;
            this.meta = iPersistentMap;
            this.dataCache = new Object[list.size()];
            this.cachedIndexes = new BitSet();
        }

        CachingList(CachingList cachingList, IPersistentMap iPersistentMap) {
            this.src = cachingList.src;
            this.dataCache = cachingList.dataCache;
            this.cachedIndexes = cachingList.cachedIndexes;
            this.meta = iPersistentMap;
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int hasheq() {
            if (this._hash == 0) {
                this._hash = IMutList.super.hasheq();
            }
            return this._hash;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(int n) {
            BitSet bitSet = this.cachedIndexes;
            synchronized (bitSet) {
                if (this.cachedIndexes.get(n)) {
                    return this.dataCache[n];
                }
                Object e = this.src.get(n);
                this.dataCache[n] = e;
                this.cachedIndexes.set(n);
                return e;
            }
        }

        @Override
        public int size() {
            return this.src.size();
        }

        @Override
        public CachingList withMeta(IPersistentMap iPersistentMap) {
            return new CachingList(this, iPersistentMap);
        }
    }

    public static class CachingIterable
    extends AbstractCollection
    implements Seqable {
        final Iterable src;
        final IPersistentMap meta;
        AtomicReference<ISeq> seq;

        public CachingIterable(Iterable iterable, IPersistentMap iPersistentMap) {
            this.src = iterable;
            this.meta = iPersistentMap;
            this.seq = new AtomicReference();
        }

        CachingIterable(CachingIterable cachingIterable, IPersistentMap iPersistentMap) {
            this.src = cachingIterable.src;
            this.meta = iPersistentMap;
            this.seq = cachingIterable.seq;
        }

        public ISeq seq() {
            return this.seq.updateAndGet(new UnaryOperator<ISeq>(){

                @Override
                public ISeq apply(ISeq iSeq) {
                    if (iSeq != null) {
                        return iSeq;
                    }
                    return src instanceof Seqable ? ((Seqable)src).seq() : IteratorSeq.create(src.iterator());
                }
            });
        }

        @Override
        public Iterator iterator() {
            return ((Collection)this.seq()).iterator();
        }

        @Override
        public int size() {
            return ((Collection)this.seq()).size();
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public CachingIterable withMeta(IPersistentMap iPersistentMap) {
            return new CachingIterable(this.src, iPersistentMap);
        }
    }

    public static class MapList
    implements IMutList,
    IMapable {
        final int nElems;
        final List[] lists;
        final IFn fn;
        final IPersistentMap meta;

        public MapList(IFn iFn, IPersistentMap iPersistentMap, List ... listArray) {
            int n = listArray.length;
            if (n == 0) {
                this.nElems = 0;
            } else {
                int n2 = listArray[0].size();
                for (int i = 1; i < n; ++i) {
                    n2 = Math.min(n2, listArray[i].size());
                }
                this.nElems = n2;
            }
            this.lists = listArray;
            this.fn = iFn;
            this.meta = iPersistentMap;
        }

        public MapList(MapList mapList, IPersistentMap iPersistentMap) {
            this.nElems = mapList.nElems;
            this.lists = mapList.lists;
            this.fn = mapList.fn;
            this.meta = iPersistentMap;
        }

        public static IMutList create(IFn iFn, IPersistentMap iPersistentMap, List ... listArray) {
            if (listArray.length == 1) {
                return new SingleMapList(iFn, iPersistentMap, listArray[0]);
            }
            if (listArray.length == 2) {
                return new DualMapList(iFn, iPersistentMap, listArray[0], listArray[1]);
            }
            return new MapList(iFn, iPersistentMap, listArray);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            if (n < 0) {
                n += this.nElems;
            }
            if (n < 0 || n >= this.nElems) {
                throw new RuntimeException("Index out of range.");
            }
            List[] listArray = this.lists;
            int n2 = listArray.length;
            switch (n2) {
                case 1: {
                    return this.fn.invoke(listArray[0].get(n));
                }
                case 2: {
                    return this.fn.invoke(listArray[0].get(n), listArray[1].get(n));
                }
                case 3: {
                    return this.fn.invoke(listArray[0].get(n), listArray[1].get(n), listArray[2].get(n));
                }
                case 4: {
                    return this.fn.invoke(listArray[0].get(n), listArray[1].get(n), listArray[2].get(n), listArray[3].get(n));
                }
            }
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[n] = this.lists[i].get(n);
            }
            return this.fn.applyTo((ISeq)ArraySeq.create((Object[])objectArray));
        }

        public IMutList subList(int n, int n2) {
            int n3 = this.size();
            if (n < 0 || n >= n3) {
                throw new RuntimeException("Start index out of range.");
            }
            if (n2 < n || n2 > n3) {
                throw new RuntimeException("End index out of range.");
            }
            int n4 = this.lists.length;
            List[] listArray = new List[n4];
            for (int i = 0; i < n4; ++i) {
                listArray[i] = this.lists[i].subList(n, n2);
            }
            return new MapList(this.fn, this.meta(), listArray);
        }

        @Override
        public MapList map(IFn iFn) {
            return new MapList(new MapFn(this.fn, iFn), this.meta(), this.lists);
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public MapList withMeta(IPersistentMap iPersistentMap) {
            return new MapList(this, iPersistentMap);
        }
    }

    public static class DualMapList
    implements IMutList,
    IMapable {
        final int nElems;
        final List lhs;
        final List rhs;
        final IFn fn;
        final IPersistentMap meta;

        public DualMapList(IFn iFn, IPersistentMap iPersistentMap, List list, List list2) {
            this.nElems = Math.min(list.size(), list2.size());
            this.lhs = list;
            this.rhs = list2;
            this.fn = iFn;
            this.meta = iPersistentMap;
        }

        public DualMapList(DualMapList dualMapList, IPersistentMap iPersistentMap) {
            this.nElems = dualMapList.nElems;
            this.lhs = dualMapList.lhs;
            this.rhs = dualMapList.rhs;
            this.fn = dualMapList.fn;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.fn.invoke(this.lhs.get(n), this.rhs.get(n));
        }

        public DualMapList subList(int n, int n2) {
            return new DualMapList(this.fn, this.meta, this.lhs.subList(n, n2), this.rhs.subList(n, n2));
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public DualMapList withMeta(IPersistentMap iPersistentMap) {
            return new DualMapList(this, iPersistentMap);
        }

        @Override
        public DualMapList map(IFn iFn) {
            return new DualMapList(new MapFn(this.fn, iFn), this.meta, this.lhs, this.rhs);
        }
    }

    public static class SingleMapList
    implements IMutList,
    IMapable {
        final int nElems;
        final List list;
        final IFn fn;
        final IPersistentMap meta;

        public SingleMapList(IFn iFn, IPersistentMap iPersistentMap, List list) {
            this.nElems = list.size();
            this.list = list;
            this.fn = iFn;
            this.meta = iPersistentMap;
        }

        public SingleMapList(SingleMapList singleMapList, IPersistentMap iPersistentMap) {
            this.nElems = singleMapList.nElems;
            this.list = singleMapList.list;
            this.fn = singleMapList.fn;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.fn.invoke(this.list.get(n));
        }

        public SingleMapList subList(int n, int n2) {
            return new SingleMapList(this.fn, this.meta, this.list.subList(n, n2));
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public SingleMapList withMeta(IPersistentMap iPersistentMap) {
            return new SingleMapList(this, iPersistentMap);
        }

        @Override
        public SingleMapList map(IFn iFn) {
            return new SingleMapList(new MapFn(this.fn, iFn), this.meta, this.list);
        }

        @Override
        public Object reduce(final IFn iFn, Object object) {
            if (this.list instanceof IReduceInit) {
                IReduceInit iReduceInit = (IReduceInit)this.list;
                final IFn iFn2 = this.fn;
                return iReduceInit.reduce((IFn)new IFnDef(){

                    @Override
                    public Object invoke(Object object, Object object2) {
                        return iFn.invoke(object, iFn2.invoke(object2));
                    }
                }, object);
            }
            return Transformables.iterReduce(this, object, iFn);
        }
    }

    public static class CatIterable
    extends AbstractCollection
    implements Seqable,
    IMapable,
    IReduce,
    IReduceInit {
        final Iterable[] data;
        final IPersistentMap meta;

        public CatIterable(IPersistentMap iPersistentMap, Iterable[] iterableArray) {
            this.data = iterableArray;
            this.meta = iPersistentMap;
        }

        public CatIterable(CatIterable catIterable, IPersistentMap iPersistentMap) {
            this.data = catIterable.data;
            this.meta = iPersistentMap;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public int size() {
            return Transformables.iterCount(this.iterator());
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Iterator iterator() {
            return new CatIterator(ArrayLists.toList(this.data).iterator());
        }

        @Override
        public IMapable cat(Iterable iterable) {
            int n = this.data.length;
            Iterable[] iterableArray = Arrays.copyOf(this.data, n + 1);
            iterableArray[n] = iterable;
            return new CatIterable(this.meta(), iterableArray);
        }

        public ISeq seq() {
            return IteratorSeq.create((Iterator)this.iterator());
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public CatIterable withMeta(IPersistentMap iPersistentMap) {
            return new CatIterable(this, iPersistentMap);
        }

        public Object reduce(IFn iFn) {
            return Transformables.iterReduce(this, iFn);
        }

        public Object reduce(IFn iFn, Object object) {
            return Transformables.iterReduce(this, object, iFn);
        }

        @Override
        public Object[] toArray() {
            return ArrayLists.toArray(this);
        }

        static class CatIterator
        implements Iterator {
            Iterator gpIter;
            Iterator parentIter;
            Iterator curIter;

            CatIterator(Iterator iterator) {
                this.gpIter = iterator;
                this.parentIter = null;
                this.curIter = null;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.curIter != null && this.curIter.hasNext();
            }

            public Object next() {
                Object e = this.curIter.next();
                if (!this.curIter.hasNext()) {
                    this.advance();
                }
                return e;
            }

            boolean advanceParent() {
                if (this.hasNext()) {
                    return true;
                }
                while (this.parentIter != null && this.parentIter.hasNext()) {
                    Iterable iterable = Transformables.toIterable(this.parentIter.next());
                    this.curIter = iterable != null ? iterable.iterator() : null;
                    if (!this.hasNext()) continue;
                    return true;
                }
                this.parentIter = null;
                this.curIter = null;
                return false;
            }

            void advance() {
                if (this.hasNext()) {
                    return;
                }
                if (this.advanceParent()) {
                    return;
                }
                while (this.gpIter != null && this.gpIter.hasNext()) {
                    this.parentIter = null;
                    Iterable iterable = (Iterable)this.gpIter.next();
                    if (iterable != null) {
                        this.parentIter = iterable.iterator();
                    }
                    if (!this.advanceParent()) continue;
                    return;
                }
                this.gpIter = null;
                this.parentIter = null;
                this.curIter = null;
            }
        }
    }

    public static class FilterIterable
    extends AbstractCollection
    implements Seqable,
    IMapable,
    IReduce,
    IReduceInit {
        final IFn pred;
        final Iterable src;
        final IPersistentMap meta;

        public FilterIterable(IFn iFn, IPersistentMap iPersistentMap, Iterable iterable) {
            this.pred = iFn;
            this.src = iterable;
            this.meta = iPersistentMap;
        }

        public FilterIterable(FilterIterable filterIterable, IPersistentMap iPersistentMap) {
            this.pred = filterIterable.pred;
            this.src = filterIterable.src;
            this.meta = iPersistentMap;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean isEmpty() {
            return this.seq() == null;
        }

        @Override
        public int size() {
            return Transformables.iterCount(this.iterator());
        }

        @Override
        public Iterator iterator() {
            return new FilterIterator(this.src.iterator(), this.pred);
        }

        public ISeq seq() {
            return IteratorSeq.create((Iterator)this.iterator());
        }

        @Override
        public IMapable filter(final IFn iFn) {
            return new FilterIterable(new IFnDef(){

                @Override
                public Object invoke(Object object) {
                    return Transformables.truthy(pred.invoke(object)) && Transformables.truthy(iFn.invoke(object));
                }
            }, this.meta(), this.src);
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public FilterIterable withMeta(IPersistentMap iPersistentMap) {
            return new FilterIterable(this, iPersistentMap);
        }

        public Object reduce(IFn iFn) {
            Iterator iterator = this.src.iterator();
            if (!iterator.hasNext()) {
                return iFn.invoke();
            }
            Object object = iterator.next();
            while (iterator.hasNext() && !RT.isReduced(object)) {
                Object t = iterator.next();
                if (!Transformables.truthy(this.pred.invoke(t))) continue;
                object = iFn.invoke(object, t);
            }
            return RT.isReduced(object) ? ((IDeref)object).deref() : object;
        }

        public Object reduce(final IFn iFn, Object object) {
            if (this.src instanceof IReduceInit) {
                return ((IReduceInit)this.src).reduce((IFn)new IFnDef(){

                    @Override
                    public Object invoke(Object object, Object object2) {
                        if (Transformables.truthy(pred.invoke(object2))) {
                            return iFn.invoke(object, object2);
                        }
                        return object;
                    }
                }, object);
            }
            Iterator iterator = this.src.iterator();
            Object object2 = object;
            while (iterator.hasNext() && !RT.isReduced((Object)object2)) {
                Object t = iterator.next();
                if (!Transformables.truthy(this.pred.invoke(t))) continue;
                object2 = iFn.invoke(object2, t);
            }
            return RT.isReduced((Object)object2) ? ((IDeref)object2).deref() : object2;
        }

        @Override
        public Object[] toArray() {
            return ArrayLists.toArray(this);
        }

        static class FilterIterator
        implements Iterator {
            final Iterator iter;
            final IFn pred;
            BitmapTrieCommon.Box nextObj = new BitmapTrieCommon.Box();

            public FilterIterator(Iterator iterator, IFn iFn) {
                this.iter = iterator;
                this.pred = iFn;
                this.advance();
            }

            void advance() {
                while (this.iter.hasNext()) {
                    Object e = this.iter.next();
                    if (!Transformables.truthy(this.pred.invoke(e))) continue;
                    this.nextObj.obj = e;
                    return;
                }
                this.nextObj = null;
            }

            @Override
            public boolean hasNext() {
                return this.nextObj != null;
            }

            public Object next() {
                if (this.nextObj == null) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextObj.obj;
                this.advance();
                return object;
            }
        }
    }

    public static class MapIterable
    extends AbstractCollection
    implements Seqable,
    IMapable,
    IReduce,
    IReduceInit {
        final Iterable[] iterables;
        final IFn fn;
        final IPersistentMap meta;

        public MapIterable(IFn iFn, IPersistentMap iPersistentMap, Iterable ... iterableArray) {
            this.fn = iFn;
            this.meta = iPersistentMap;
            this.iterables = iterableArray;
        }

        public static MapIterable createSingle(IFn iFn, IPersistentMap iPersistentMap, Iterable iterable) {
            return new MapIterable(iFn, iPersistentMap, iterable);
        }

        public MapIterable(MapIterable mapIterable, IPersistentMap iPersistentMap) {
            this.fn = mapIterable.fn;
            this.iterables = mapIterable.iterables;
            this.meta = iPersistentMap;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean isEmpty() {
            return this.seq() == null;
        }

        @Override
        public int size() {
            return Transformables.iterCount(this.iterator());
        }

        @Override
        public Iterator iterator() {
            final int n = this.iterables.length;
            switch (n) {
                case 1: {
                    return new SingleIterator(this.fn, this.iterables[0].iterator());
                }
                case 2: {
                    return new DualIterator(this.fn, this.iterables[0].iterator(), this.iterables[1].iterator());
                }
            }
            final Iterator[] iteratorArray = new Iterator[n];
            for (int i = 0; i < n; ++i) {
                iteratorArray[i] = this.iterables[i].iterator();
            }
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    for (int i = 0; i < n; ++i) {
                        if (iteratorArray[i].hasNext()) continue;
                        return false;
                    }
                    return true;
                }

                public Object next() {
                    switch (n) {
                        case 3: {
                            return fn.invoke(iteratorArray[0].next(), iteratorArray[1].next(), iteratorArray[2].next());
                        }
                        case 4: {
                            return fn.invoke(iteratorArray[0].next(), iteratorArray[1].next(), iteratorArray[2].next(), iteratorArray[3].next());
                        }
                    }
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = iteratorArray[i].next();
                    }
                    return fn.applyTo((ISeq)ArraySeq.create((Object[])objectArray));
                }
            };
        }

        public ISeq seq() {
            return IteratorSeq.create((Iterator)this.iterator());
        }

        @Override
        public MapIterable map(IFn iFn) {
            return new MapIterable(new MapFn(this.fn, iFn), this.meta(), this.iterables);
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public MapIterable withMeta(IPersistentMap iPersistentMap) {
            return new MapIterable(this, iPersistentMap);
        }

        public Object reduce(IFn iFn) {
            return Transformables.iterReduce(this, iFn);
        }

        public Object reduce(final IFn iFn, Object object) {
            if (this.iterables.length == 1 && this.iterables[0] instanceof IReduceInit) {
                IReduceInit iReduceInit = (IReduceInit)this.iterables[0];
                final IFn iFn2 = this.fn;
                return iReduceInit.reduce((IFn)new IFnDef(){

                    @Override
                    public Object invoke(Object object, Object object2) {
                        return iFn.invoke(object, iFn2.invoke(object2));
                    }
                }, object);
            }
            return Transformables.iterReduce(this, object, iFn);
        }

        @Override
        public Object[] toArray() {
            return ArrayLists.toArray(this);
        }

        static class DualIterator
        implements Iterator {
            final Iterator lhs;
            final Iterator rhs;
            final IFn fn;

            public DualIterator(IFn iFn, Iterator iterator, Iterator iterator2) {
                this.lhs = iterator;
                this.rhs = iterator2;
                this.fn = iFn;
            }

            @Override
            public boolean hasNext() {
                return this.lhs.hasNext() && this.rhs.hasNext();
            }

            public Object next() {
                return this.fn.invoke(this.lhs.next(), this.rhs.next());
            }
        }

        static class SingleIterator
        implements Iterator {
            final Iterator iter;
            final IFn fn;

            public SingleIterator(IFn iFn, Iterator iterator) {
                this.iter = iterator;
                this.fn = iFn;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.fn.invoke(this.iter.next());
            }
        }
    }

    public static interface IMapable
    extends Iterable,
    IObj {
        default public IMapable map(IFn iFn) {
            return new MapIterable(iFn, this.meta(), this);
        }

        default public IMapable filter(IFn iFn) {
            return new FilterIterable(iFn, this.meta(), this);
        }

        default public IMapable cat(Iterable iterable) {
            return new CatIterable(this.meta(), new Iterable[]{ArrayLists.toList(new Iterable[]{this}), iterable});
        }
    }
}

