/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.RT;
import ham_fisted.ArrayLists;
import ham_fisted.ChunkedList;
import ham_fisted.DoubleMutList;
import ham_fisted.IMutList;
import ham_fisted.LongMutList;
import ham_fisted.Transformables;
import ham_fisted.TypedList;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;

public class Ranges {

    public static class DoubleRange
    implements DoubleMutList,
    TypedList {
        public final double start;
        public final double end;
        public final double step;
        public final int nElems;
        public final IPersistentMap meta;
        int _hash = 0;

        public DoubleRange(double d, double d2, double d3, IPersistentMap iPersistentMap) {
            this.start = d;
            this.end = d2;
            this.step = d3;
            this.meta = iPersistentMap;
            this.nElems = RT.intCast((double)((d2 - d) / d3));
            if (this.nElems < 0) {
                throw new RuntimeException("Invalid Range - start: " + String.valueOf(d) + " end: " + String.valueOf(d2) + " step: " + String.valueOf(d3));
            }
        }

        @Override
        public IMutList cloneList() {
            return this;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int hasheq() {
            if (this._hash == 0) {
                this._hash = DoubleMutList.super.hasheq();
            }
            return this._hash;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public Class containedType() {
            return Double.TYPE;
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public double getDouble(int n) {
            int n2 = this.size();
            if (n < 0) {
                n += n2;
            }
            if (n < 0 || n >= n2) {
                throw new RuntimeException("Index out of range: " + String.valueOf(n) + " size: " + String.valueOf(n2));
            }
            return this.start + this.step * (double)n;
        }

        @Override
        public int[] toIntArray() {
            int n = RT.intCast((double)this.step);
            if (n != 0) {
                return ArrayLists.iarange(RT.intCast((double)this.start), RT.intCast((double)this.end), RT.intCast((double)this.step));
            }
            throw new RuntimeException("Infinite range: " + String.valueOf(this.step) + " : " + String.valueOf(n));
        }

        @Override
        public long[] toLongArray() {
            long l = RT.longCast((double)this.step);
            if (l != 0L) {
                return ArrayLists.larange(RT.longCast((double)this.start), RT.longCast((double)this.end), RT.longCast((double)this.step));
            }
            throw new RuntimeException("Infinite range: " + String.valueOf(this.step) + " : " + String.valueOf(l));
        }

        @Override
        public double[] toDoubleArray() {
            return ArrayLists.darange(this.start, this.end, this.step);
        }

        public DoubleMutList subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return new DoubleRange(this.start + (double)n * this.step, this.start + (double)n2 * this.step, this.step, this.meta);
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public DoubleRange withMeta(IPersistentMap iPersistentMap) {
            return new DoubleRange(this.start, this.end, this.step, iPersistentMap);
        }
    }

    public static class LongRange
    implements LongMutList,
    TypedList {
        public final long start;
        public final long end;
        public final long step;
        public final int nElems;
        public final IPersistentMap meta;
        int _hash = 0;

        public LongRange(long l, long l2, long l3, IPersistentMap iPersistentMap) {
            this.start = l;
            this.end = l2;
            this.step = l3;
            this.nElems = RT.intCast((long)((l2 - l) / l3));
            if (this.nElems < 0) {
                throw new RuntimeException("Invalid Range - start: " + String.valueOf(l) + " end: " + String.valueOf(l2) + " step: " + String.valueOf(l3));
            }
            this.meta = iPersistentMap;
        }

        @Override
        public IMutList cloneList() {
            return this;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int hasheq() {
            if (this._hash == 0) {
                this._hash = LongMutList.super.hasheq();
            }
            return this._hash;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public Class containedType() {
            return Long.TYPE;
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public long getLong(int n) {
            int n2 = this.size();
            if (n < 0) {
                n += n2;
            }
            if (n < 0 || n >= n2) {
                throw new RuntimeException("Index out of range: " + String.valueOf(n) + " size: " + String.valueOf(n2));
            }
            return this.start + this.step * (long)n;
        }

        @Override
        public int[] toIntArray() {
            return ArrayLists.iarange(RT.intCast((long)this.start), RT.intCast((long)this.end), RT.intCast((long)this.step));
        }

        @Override
        public long[] toLongArray() {
            return ArrayLists.larange(this.start, this.end, this.step);
        }

        @Override
        public double[] toDoubleArray() {
            return ArrayLists.darange(this.start, this.end, this.step);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[n];
            long l = this.start;
            long l2 = this.step;
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = l;
                ++n2;
                l += l2;
            }
            return objectArray;
        }

        public LongMutList subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return new LongRange(this.start + (long)n * this.step, this.start + (long)n2 * this.step, this.step, this.meta);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            int n = this.size();
            long l = this.start;
            long l2 = this.step;
            int n2 = 0;
            while (n2 < n && !RT.isReduced((Object)object)) {
                object = iFn.invoke(object, (Object)l);
                ++n2;
                l += l2;
            }
            return RT.isReduced((Object)object) ? ((IDeref)object).deref() : object;
        }

        @Override
        public long longReduction(LongBinaryOperator longBinaryOperator, long l) {
            int n = this.size();
            long l2 = this.step;
            long l3 = this.start;
            int n2 = 0;
            while (n2 < n) {
                l = longBinaryOperator.applyAsLong(l, l3);
                ++n2;
                l3 += l2;
            }
            return l;
        }

        @Override
        public void longForEach(LongConsumer longConsumer) {
            int n = this.size();
            long l = this.step;
            long l2 = this.start;
            int n2 = 0;
            while (n2 < n) {
                longConsumer.accept(l2);
                ++n2;
                l2 += l;
            }
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public LongRange withMeta(IPersistentMap iPersistentMap) {
            return new LongRange(this.start, this.end, this.step, iPersistentMap);
        }
    }
}

