/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.ASeq;
import clojure.lang.Associative;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Indexed;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import clojure.lang.Reversible;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import clojure.lang.Util;
import ham_fisted.ArrayImmutList;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.CljHash;
import ham_fisted.HashSet;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.ImmutSort;
import ham_fisted.IndexedConsumer;
import ham_fisted.ParallelOptions;
import ham_fisted.RandomAccessSpliterator;
import ham_fisted.RangeList;
import ham_fisted.Reductions;
import ham_fisted.ReindexList;
import ham_fisted.ReverseList;
import ham_fisted.Transformables;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface IMutList<E>
extends List<E>,
RandomAccess,
Indexed,
IFnDef,
ITypedReduce<E>,
IKVReduce,
IReduce,
IHashEq,
Seqable,
Reversible,
IObj,
ImmutSort<E>,
RangeList,
Cloneable,
Sequential,
Associative {
    default public IMutList cloneList() {
        return ArrayLists.toList(this.toArray());
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    default public boolean add(E e) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    default public void add(int n, E e) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public void addBoolean(boolean bl) {
        this.add(bl);
    }

    default public void addLong(long l) {
        this.add(l);
    }

    default public void addDouble(double d) {
        this.add(d);
    }

    @Override
    default public void removeRange(int n, int n2) {
        int n3 = n;
        while (n < n2) {
            this.remove(n3);
            ++n;
        }
    }

    @Override
    default public void fillRange(int n, int n2, Object object) {
        int n3 = this.size();
        ChunkedList.checkIndexRange(0, n3, n, n2);
        while (n < n2) {
            this.set(n, object);
            ++n;
        }
    }

    @Override
    default public void fillRange(int n, List list) {
        int n2 = this.size();
        int n3 = list.size();
        ChunkedList.checkIndexRange(0, n2, n, n + n3);
        if (list instanceof ITypedReduce) {
            ((ITypedReduce)((Object)list)).genericIndexedForEach(n, new IndexedConsumer(){

                @Override
                public void accept(long l, Object object) {
                    IMutList.this.set((int)l, object);
                }
            });
        } else {
            int n4 = n3 + n;
            int n5 = 0;
            while (n < n4) {
                this.set(n, list.get(n5));
                ++n;
                ++n5;
            }
        }
    }

    @Override
    default public E remove(int n) {
        Object e = this.get(n);
        this.removeRange(n, n + 1);
        return e;
    }

    @Override
    default public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    default public boolean addAll(Collection<? extends E> collection) {
        return this.addAllReducible(collection);
    }

    default public boolean addAllReducible(Object object) {
        int n = this.size();
        Transformables.genericReduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                ((IMutList)object).add(object2);
                return object;
            }
        }, this, object);
        return n != this.size();
    }

    @Override
    default public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        int n2 = this.size();
        if (n == n2) {
            return this.addAll(collection);
        }
        for (E e : collection) {
            this.add(n++, e);
        }
        return true;
    }

    @Override
    default public boolean removeAll(Collection<?> collection) {
        int n;
        HashSet hashSet = new HashSet();
        hashSet.addAll(collection);
        int n2 = n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!hashSet.contains(this.get(i))) continue;
            this.remove(i);
            --i;
            --n;
        }
        return this.size() == n2;
    }

    @Override
    default public boolean retainAll(Collection<?> collection) {
        int n;
        HashSet hashSet = new HashSet();
        hashSet.addAll(collection);
        int n2 = n = this.size();
        for (int i = 0; i < n; ++i) {
            if (hashSet.contains(this.get(i))) continue;
            this.remove(i);
            --i;
            --n;
        }
        return this.size() == n2;
    }

    @Override
    default public List<E> subList(int n, int n2) {
        int n3 = this.size();
        if (n == 0 && n2 == n3) {
            return this;
        }
        ChunkedList.checkIndexRange(0, n3, n, n2);
        return ReindexList.create(ArrayLists.iarange(n, n2, 1), this, this.meta());
    }

    @Override
    default public int indexOf(Object object) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(object, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object object) {
        int n = this.size();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            int n3 = n2 - i;
            if (!Objects.equals(object, this.get(n3))) continue;
            return n3;
        }
        return -1;
    }

    @Override
    default public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public ListIterator<E> listIterator(int n) {
        if (n < 0 || n >= this.size()) {
            throw new NoSuchElementException("Index(" + String.valueOf(n) + ") out of range 0-" + this.size());
        }
        return new ListIter(this, n);
    }

    @Override
    default public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    default public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    default public Iterator<E> riterator() {
        return new RIter(this);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return new RandomAccessSpliterator(this);
    }

    default public Object[] fillArray(Object[] objectArray) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    default public Object[] toArray() {
        return this.fillArray(new Object[this.size()]);
    }

    @Override
    default public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = Arrays.copyOf(TArray, this.size());
        this.fillArray(objectArray);
        return objectArray;
    }

    default public Object toNativeArray() {
        return this.toArray();
    }

    default public int[] toIntArray() {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = RT.intCast((long)this.getLong(i));
        }
        return nArray;
    }

    default public long[] toLongArray() {
        int n = this.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.getLong(i);
        }
        return lArray;
    }

    default public float[] toFloatArray() {
        int n = this.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)this.getDouble(i);
        }
        return fArray;
    }

    default public double[] toDoubleArray() {
        int n = this.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getDouble(i);
        }
        return dArray;
    }

    default public IntComparator indexComparator() {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return ((Comparable)IMutList.this.get(n)).compareTo(IMutList.this.get(n2));
            }
        };
    }

    default public IntComparator indexComparator(final Comparator comparator) {
        if (comparator instanceof DoubleComparator) {
            final DoubleComparator doubleComparator = (DoubleComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return doubleComparator.compare(IMutList.this.getDouble(n), IMutList.this.getDouble(n2));
                }
            };
        }
        if (comparator instanceof IntComparator) {
            final IntComparator intComparator = (IntComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return intComparator.compare((int)IMutList.this.getLong(n), (int)IMutList.this.getLong(n2));
                }
            };
        }
        if (comparator instanceof LongComparator) {
            final LongComparator longComparator = (LongComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return longComparator.compare(IMutList.this.getLong(n), IMutList.this.getLong(n2));
                }
            };
        }
        if (comparator instanceof FloatComparator) {
            final FloatComparator floatComparator = (FloatComparator)comparator;
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return floatComparator.compare((float)IMutList.this.getDouble(n), (float)IMutList.this.getDouble(n2));
                }
            };
        }
        return new IntComparator(){

            public int compare(int n, int n2) {
                return comparator.compare(IMutList.this.get(n), IMutList.this.get(n2));
            }
        };
    }

    default public int[] sortIndirect(final Comparator comparator) {
        int n = this.size();
        int[] nArray = ArrayLists.iarange(0, n, 1);
        final Object[] objectArray = this.toArray();
        if (comparator == null) {
            ObjectArrays.parallelQuickSortIndirect((int[])nArray, (Object[])objectArray);
        } else {
            IntArrays.parallelQuickSort((int[])nArray, (IntComparator)new IntComparator(){

                public int compare(int n, int n2) {
                    return comparator.compare(objectArray[n], objectArray[n2]);
                }
            });
        }
        return nArray;
    }

    default public Object nth(int n) {
        int n2 = this.size();
        if (n < 0) {
            n += n2;
        }
        return this.get(n);
    }

    default public Object nth(int n, Object object) {
        int n2 = this.size();
        if (n < 0) {
            n += n2;
        }
        return n < n2 && n > -1 ? this.get(n) : object;
    }

    @Override
    default public E set(int n, E e) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public void setBoolean(int n, boolean bl) {
        this.set(n, bl);
    }

    default public void setLong(int n, long l) {
        this.set(n, l);
    }

    default public void setDouble(int n, double d) {
        this.set(n, d);
    }

    default public boolean getBoolean(int n) {
        return Casts.booleanCast(this.get(n));
    }

    default public long getLong(int n) {
        return Casts.longCast(this.get(n));
    }

    default public double getDouble(int n) {
        Object e = this.get(n);
        return e != null ? Casts.doubleCast(e) : Double.NaN;
    }

    default public void accPlusLong(int n, long l) {
        this.setLong(n, this.getLong(n) + l);
    }

    default public void accPlusDouble(int n, double d) {
        this.setDouble(n, this.getDouble(n) + d);
    }

    @Override
    default public Object invoke(Object object) {
        return this.nth(RT.intCast((Object)object));
    }

    @Override
    default public Object invoke(Object object, Object object2) {
        return this.nth(RT.intCast((Object)object), object2);
    }

    default public Object valAt(Object object) {
        return this.invoke(object);
    }

    default public Object valAt(Object object, Object object2) {
        return this.invoke(object, object2);
    }

    default public IMapEntry entryAt(Object object) {
        int n;
        if (Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.size()) {
            return MapEntry.create((Object)n, this.get(n));
        }
        return null;
    }

    @Override
    default public boolean containsAll(Collection<?> collection) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(collection);
        for (E e : this) {
            if (hashSet.contains(e)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsKey(Object object) {
        int n;
        return Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.size();
    }

    default public int count() {
        return this.size();
    }

    default public int length() {
        return this.size();
    }

    default public Object reduce(IFn iFn) {
        int n = this.size();
        if (n == 0) {
            return iFn.invoke();
        }
        Object object = this.get(0);
        for (int i = 1; i < n && !RT.isReduced(object); ++i) {
            object = iFn.invoke(object, this.get(i));
        }
        return object;
    }

    default public Object reduce(IFn iFn, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, this.get(i));
        }
        return object;
    }

    default public Object kvreduce(IFn iFn, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = iFn.invoke(object, (Object)i, this.get(i));
        }
        return object;
    }

    @Override
    default public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelRandAccessReduction(iFn, iFn2, iFn3, this, parallelOptions);
    }

    @Override
    default public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }

    default public int hasheq() {
        return CljHash.listHasheq(this);
    }

    default public boolean equiv(Object object) {
        return CljHash.listEquiv(this, object);
    }

    default public ISeq seq() {
        if (this.isEmpty()) {
            return null;
        }
        return new IndexSeq(this, 0, this.meta());
    }

    default public ISeq rseq() {
        if (this.isEmpty()) {
            return null;
        }
        return new RIndexSeq(this, 0, this.meta());
    }

    default public IPersistentMap meta() {
        return null;
    }

    default public IObj withMeta(IPersistentMap iPersistentMap) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    default public Object doubleReduction(IFn.ODO oDO, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = oDO.invokePrim(object, this.getDouble(i));
        }
        return object;
    }

    @Override
    default public Object longReduction(IFn.OLO oLO, Object object) {
        int n = this.size();
        for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
            object = oLO.invokePrim(object, this.getLong(i));
        }
        return object;
    }

    @Override
    default public void sort(Comparator<? super E> comparator) {
        Object[] objectArray = this.toArray();
        if (comparator == null) {
            Arrays.sort(objectArray);
        } else {
            Arrays.sort(objectArray, comparator);
        }
        this.fillRange(0, ArrayLists.toList(objectArray));
    }

    @Override
    default public List immutSort(Comparator comparator) {
        IMutList iMutList = this.cloneList();
        iMutList.sort(comparator);
        return iMutList;
    }

    default public void shuffle(Random random) {
        Collections.shuffle(this, random);
    }

    default public List reindex(int[] nArray) {
        return ReindexList.create(nArray, this, this.meta());
    }

    default public List immutShuffle(Random random) {
        Object[] objectArray = this.toArray();
        ObjectArrays.shuffle((Object[])objectArray, (Random)random);
        return ArrayLists.toList(objectArray, 0, this.size(), this.meta());
    }

    default public List reverse() {
        return ReverseList.create(this, this.meta());
    }

    default public int binarySearch(E e, Comparator<? super E> comparator) {
        int n = comparator == null ? Collections.binarySearch(this, e, new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                return Util.compare(e, e2);
            }
        }) : Collections.binarySearch(this, e, comparator);
        return n < 0 ? -1 - n : n;
    }

    default public int binarySearch(E e) {
        return this.binarySearch(e, null);
    }

    default public IPersistentVector immut() {
        return ArrayImmutList.create(true, this.toArray(), 0, this.size(), this.meta());
    }

    default public Associative assoc(Object object, Object object2) {
        return this.immut().assoc(object, object2);
    }

    default public IPersistentVector cons(Object object) {
        return this.immut().cons(object);
    }

    default public IPersistentVector empty() {
        return ArrayImmutList.EMPTY;
    }

    default public LongStream indexStream(boolean bl) {
        LongStream longStream = LongStream.range(0L, this.size());
        return bl ? longStream.parallel() : longStream;
    }

    default public Stream objStream(boolean bl) {
        return this.indexStream(bl).mapToObj(l -> this.get((int)l));
    }

    default public DoubleStream doubleStream(boolean bl) {
        return this.indexStream(bl).mapToDouble(l -> this.getDouble((int)l));
    }

    default public LongStream longStream(boolean bl) {
        return this.indexStream(bl).map(l -> this.getLong((int)l));
    }

    public static class RIndexSeq
    extends ASeq {
        final List l;
        final int idx;
        final int ssz;
        final Object v;
        ISeq rest;

        public RIndexSeq(List list, int n, IPersistentMap iPersistentMap) {
            super(iPersistentMap);
            this.l = list;
            this.idx = n;
            this.ssz = this.l.size() - 1;
            this.v = this.l.get(this.ssz - this.idx);
        }

        public RIndexSeq(RIndexSeq rIndexSeq, IPersistentMap iPersistentMap) {
            super(iPersistentMap);
            this.l = rIndexSeq.l;
            this.idx = rIndexSeq.idx;
            this.ssz = rIndexSeq.ssz;
            this.v = rIndexSeq.v;
            this.rest = rIndexSeq.rest;
        }

        public boolean isEmpty() {
            return false;
        }

        public int size() {
            return this.ssz - this.idx + 1;
        }

        public Object first() {
            return this.v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISeq next() {
            if (this.rest != null) {
                return this.rest;
            }
            if (this.idx >= this.ssz) {
                return null;
            }
            RIndexSeq rIndexSeq = this;
            synchronized (rIndexSeq) {
                if (this.rest == null) {
                    this.rest = new RIndexSeq(this.l, this.idx + 1, this.meta());
                }
            }
            return this.rest;
        }

        public RIndexSeq withMeta(IPersistentMap iPersistentMap) {
            return new RIndexSeq(this, iPersistentMap);
        }
    }

    public static class IndexSeq
    extends ASeq {
        final List l;
        final int idx;
        final int ssz;
        final Object v;
        ISeq rest;

        public IndexSeq(List list, int n, IPersistentMap iPersistentMap) {
            super(iPersistentMap);
            this.l = list;
            this.idx = n;
            this.ssz = this.l.size() - 1;
            this.v = this.l.get(this.idx);
        }

        public IndexSeq(IndexSeq indexSeq, IPersistentMap iPersistentMap) {
            super(iPersistentMap);
            this.l = indexSeq.l;
            this.idx = indexSeq.idx;
            this.ssz = indexSeq.ssz;
            this.v = indexSeq.v;
            this.rest = indexSeq.rest;
        }

        public int size() {
            return this.ssz - this.idx + 1;
        }

        public Object first() {
            return this.v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISeq next() {
            if (this.rest != null) {
                return this.rest;
            }
            if (this.idx >= this.ssz) {
                return null;
            }
            IndexSeq indexSeq = this;
            synchronized (indexSeq) {
                if (this.rest == null) {
                    this.rest = new IndexSeq(this.l, this.idx + 1, this.meta());
                }
            }
            return this.rest;
        }

        public IndexSeq withMeta(IPersistentMap iPersistentMap) {
            return new IndexSeq(this, iPersistentMap);
        }
    }

    public static class RIter<E>
    implements Iterator<E> {
        List<E> list;
        int idx;

        public RIter(List<E> list) {
            this.list = list;
            this.idx = 0;
        }

        @Override
        public final boolean hasNext() {
            return this.idx < this.list.size();
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.list.size() - this.idx - 1;
            ++this.idx;
            return this.list.get(n);
        }
    }

    public static class ListIter<E>
    implements ListIterator<E> {
        List<E> list;
        int idx = 0;
        int previdx = 0;

        ListIter(List<E> list, int n) {
            this.list = list;
            this.idx = n;
            this.previdx = n;
        }

        @Override
        public final boolean hasNext() {
            return this.idx < this.list.size();
        }

        @Override
        public final boolean hasPrevious() {
            return this.idx > 0;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E e = this.list.get(this.idx);
            this.previdx = this.idx++;
            return e;
        }

        @Override
        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.idx;
            this.previdx = this.idx;
            return this.list.get(this.idx);
        }

        @Override
        public final int nextIndex() {
            return this.idx;
        }

        @Override
        public final int previousIndex() {
            return this.idx - 1;
        }

        @Override
        public final void remove() {
            this.list.remove(this.previdx);
        }

        @Override
        public final void set(E e) {
            this.list.set(this.previdx, e);
        }

        @Override
        public final void add(E e) {
            this.list.add(this.previdx, e);
        }
    }
}

