/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.Casts;
import ham_fisted.ForkJoinPatterns;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.ParallelOptions;
import ham_fisted.Transformables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class Reductions {
    public static Object serialReduction(IFn iFn, Object object, Object object2) {
        if (object2 instanceof ITypedReduce) {
            ITypedReduce iTypedReduce = (ITypedReduce)object2;
            if (iFn instanceof IFn.ODO) {
                return iTypedReduce.doubleReduction((IFn.ODO)iFn, object);
            }
            if (iFn instanceof IFn.OLO) {
                return iTypedReduce.longReduction((IFn.OLO)iFn, object);
            }
            return iTypedReduce.reduce(iFn, object);
        }
        if (object2 instanceof IReduceInit) {
            return ((IReduceInit)object2).reduce(iFn, object);
        }
        if (object2 instanceof Map) {
            return Transformables.iterReduce(((Map)object2).entrySet(), object, iFn);
        }
        return Transformables.iterReduce(object2, object, iFn);
    }

    public static Object parallelRandAccessReduction(final IFn iFn, final IFn iFn2, IFn iFn3, final List list, ParallelOptions parallelOptions) {
        IFnDef iFnDef = new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                int n = RT.intCast((Object)object);
                int n2 = RT.intCast((Object)object2);
                return Reductions.serialReduction(iFn2, iFn.invoke(), list.subList(n, n2));
            }
        };
        Iterable iterable = ForkJoinPatterns.parallelIndexGroups(list.size(), iFnDef, parallelOptions);
        Iterator iterator = iterable.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            object = iFn3.invoke(object, iterator.next());
        }
        return object;
    }

    public static Object parallelSpliteratorReduction(final IFn iFn, final IFn iFn2, IFn iFn3, Spliterator spliterator, ParallelOptions parallelOptions) {
        try {
            Object object;
            int n;
            Object[] objectArray;
            int n2;
            ForkJoinPool forkJoinPool = parallelOptions.pool;
            long l = Math.round(Math.log(parallelOptions.parallelism * 4) / Math.log(2.0));
            Object[] objectArray2 = new Spliterator[]{spliterator};
            int n3 = 0;
            while ((long)n3 < l) {
                n2 = objectArray2.length;
                objectArray = new Spliterator[objectArray2.length * 2];
                for (n = 0; n < n2; ++n) {
                    object = objectArray2[n];
                    Spliterator spliterator2 = object.trySplit();
                    objectArray[n * 2] = object;
                    objectArray[n * 2 + 1] = spliterator2;
                }
                objectArray2 = objectArray;
                ++n3;
            }
            ArrayBlockingQueue arrayBlockingQueue = parallelOptions.ordered ? null : new ArrayBlockingQueue(parallelOptions.parallelism + 2);
            n2 = objectArray2.length;
            objectArray = new Future[n2];
            for (n = 0; n < n2; ++n) {
                object = objectArray2[n];
                objectArray[n] = parallelOptions.ordered ? forkJoinPool.submit(new Callable((Spliterator)object){
                    final /* synthetic */ Spliterator val$sp;
                    {
                        this.val$sp = spliterator;
                    }

                    public Object call() {
                        ReduceConsumer reduceConsumer = new ReduceConsumer(iFn.invoke(), iFn2);
                        while (!reduceConsumer.isReduced() && this.val$sp.tryAdvance(reduceConsumer)) {
                        }
                        return reduceConsumer.init;
                    }
                }) : forkJoinPool.submit(new Callable((Spliterator)object, arrayBlockingQueue){
                    final /* synthetic */ Spliterator val$sp;
                    final /* synthetic */ ArrayBlockingQueue val$ab;
                    {
                        this.val$sp = spliterator;
                        this.val$ab = arrayBlockingQueue;
                    }

                    public Object call() {
                        ReduceConsumer reduceConsumer = new ReduceConsumer(iFn.invoke(), iFn2);
                        try {
                            while (!reduceConsumer.isReduced() && this.val$sp.tryAdvance(reduceConsumer)) {
                            }
                            this.val$ab.put(reduceConsumer.init);
                            return reduceConsumer.init;
                        }
                        catch (Exception exception) {
                            try {
                                this.val$ab.put(new ErrorRecord(exception));
                                return exception;
                            }
                            catch (Exception exception2) {
                                System.err.println("Error during queue put: " + String.valueOf(exception2));
                                return exception2;
                            }
                        }
                    }
                });
            }
            if (parallelOptions.ordered) {
                Object object2 = objectArray[0].get();
                for (int i = 1; i < n2; ++i) {
                    object2 = iFn3.invoke(object2, objectArray[i].get());
                }
                return object2;
            }
            Object object3 = ErrorRecord.checkError(arrayBlockingQueue.take());
            for (int i = 1; i < n2; ++i) {
                object3 = iFn3.invoke(object3, ErrorRecord.checkError(arrayBlockingQueue.take()));
            }
            return object3;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error during spliterator parallelization", exception);
        }
    }

    public static Object parallelCollectionReduction(IFn iFn, IFn iFn2, IFn iFn3, Collection collection, ParallelOptions parallelOptions) {
        if (collection.size() <= parallelOptions.minN) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), collection);
        }
        return Reductions.parallelSpliteratorReduction(iFn, iFn2, iFn3, collection.spliterator(), parallelOptions);
    }

    public static Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, Object object, ParallelOptions parallelOptions) {
        if (parallelOptions.parallelism < 2) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), object);
        }
        if (object instanceof ITypedReduce) {
            return ((ITypedReduce)object).parallelReduction(iFn, iFn2, iFn3, parallelOptions);
        }
        if (object instanceof RandomAccess) {
            return Reductions.parallelRandAccessReduction(iFn, iFn2, iFn3, (List)object, parallelOptions);
        }
        if (object instanceof IReduceInit) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), object);
        }
        if (object instanceof Map) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, ((Map)object).entrySet(), parallelOptions);
        }
        if (object instanceof Set) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, (Collection)object, parallelOptions);
        }
        if (object instanceof Iterable) {
            return Reductions.parallelSpliteratorReduction(iFn, iFn2, iFn3, ((Iterable)object).spliterator(), parallelOptions);
        }
        return Reductions.serialReduction(iFn2, iFn.invoke(), object);
    }

    static class ErrorRecord {
        public final Exception e;

        public ErrorRecord(Exception exception) {
            this.e = exception;
        }

        public static Object checkError(Object object) {
            if (object instanceof ErrorRecord) {
                throw new RuntimeException("Error during reduction", ((ErrorRecord)object).e);
            }
            return object;
        }
    }

    static class ReduceConsumer
    implements Consumer {
        Object init;
        final IFn rfn;

        public ReduceConsumer(Object object, IFn iFn) {
            this.init = object;
            this.rfn = iFn;
        }

        public void accept(Object object) {
            this.init = this.rfn.invoke(this.init, object);
        }

        public boolean isReduced() {
            return RT.isReduced((Object)this.init);
        }
    }

    public static interface LongAccum
    extends IFnDef,
    IFn.OLO {
        @Override
        default public Object invoke(Object object, Object object2) {
            return this.invokePrim(object, Casts.longCast(object2));
        }
    }

    public static interface DoubleAccum
    extends IFnDef,
    IFn.ODO {
        @Override
        default public Object invoke(Object object, Object object2) {
            return this.invokePrim(object, Casts.doubleCast(object2));
        }
    }

    public static interface OD
    extends IFnDef,
    IFn.OD {
        @Override
        default public Object invoke(Object object) {
            return this.invokePrim(object);
        }
    }

    public static interface OL
    extends IFnDef,
    IFn.OL {
        @Override
        default public Object invoke(Object object) {
            return this.invokePrim(object);
        }
    }

    public static interface LLL
    extends IFnDef,
    IFn.LLL {
        @Override
        default public Object invoke(Object object, Object object2) {
            return this.invokePrim(Casts.longCast(object), Casts.longCast(object2));
        }
    }

    public static interface DDD
    extends IFnDef,
    IFn.DDD {
        @Override
        default public Object invoke(Object object, Object object2) {
            return this.invokePrim(Casts.doubleCast(object), Casts.doubleCast(object2));
        }
    }

    public static interface DD
    extends IFnDef,
    IFn.DD {
        @Override
        default public Object invoke(Object object) {
            return this.invokePrim(Casts.doubleCast(object));
        }
    }

    public static interface DO
    extends IFnDef,
    IFn.DO {
        @Override
        default public Object invoke(Object object) {
            return this.invokePrim(Casts.doubleCast(object));
        }
    }

    public static interface LL
    extends IFnDef,
    IFn.LL {
        @Override
        default public Object invoke(Object object) {
            return this.invokePrim(Casts.longCast(object));
        }
    }

    public static interface LO
    extends IFnDef,
    IFn.LO {
        @Override
        default public Object invoke(Object object) {
            return this.invokePrim(Casts.longCast(object));
        }
    }
}

