/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.IMutList;
import ham_fisted.ITypedReduce;
import ham_fisted.IndexedLongConsumer;
import ham_fisted.Transformables;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public interface LongMutList
extends IMutList<Object> {
    @Override
    default public boolean add(Object object) {
        this.addLong(Casts.longCast(object));
        return true;
    }

    @Override
    default public void addBoolean(boolean bl) {
        this.addLong(bl ? 1L : 0L);
    }

    @Override
    default public void addDouble(double d) {
        this.addLong(Casts.longCast(d));
    }

    @Override
    default public Object set(int n, Object object) {
        long l = this.getLong(n);
        this.setLong(n, Casts.longCast(object));
        return l;
    }

    @Override
    default public void setBoolean(int n, boolean bl) {
        this.setLong(n, bl ? 1L : 0L);
    }

    @Override
    default public void setDouble(int n, double d) {
        this.setLong(n, Casts.longCast(d));
    }

    @Override
    default public Object get(int n) {
        return this.getLong(n);
    }

    @Override
    default public double getDouble(int n) {
        return this.getLong(n);
    }

    @Override
    default public void fillRange(int n, int n2, Object object) {
        long l = Casts.longCast(object);
        while (n < n2) {
            this.setLong(n, l);
            ++n;
        }
    }

    @Override
    default public void fillRange(int n, List list) {
        if (list.isEmpty()) {
            return;
        }
        int n2 = this.size();
        int n3 = n + list.size();
        ArrayLists.checkIndexRange(this.size(), n, n3);
        if (list instanceof ITypedReduce) {
            ((ITypedReduce)((Object)list)).genericIndexedForEach(n, new IndexedLongConsumer(){

                @Override
                public void accept(long l, long l2) {
                    LongMutList.this.setLong((int)l, l2);
                }
            });
        } else {
            IMutList.super.fillRange(n, list);
        }
    }

    default public void addRange(int n, int n2, Object object) {
        Long l = Casts.longCast(object);
        while (n < n2) {
            this.add(n, l);
            ++n;
        }
    }

    @Override
    default public boolean addAllReducible(Object object) {
        int n = this.size();
        Transformables.longReduce(new IFn.OLO(){

            public Object invokePrim(Object object, long l) {
                ((IMutList)object).addLong(l);
                return object;
            }
        }, this, object);
        return n != this.size();
    }

    @Override
    default public IntComparator indexComparator() {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return Long.compare(LongMutList.this.getLong(n), LongMutList.this.getLong(n2));
            }
        };
    }

    @Override
    default public void sort(Comparator<? super Object> comparator) {
        LongComparator longComparator = ArrayLists.LongArraySubList.asLongComparator(comparator);
        if (comparator == null || longComparator != null) {
            long[] lArray = this.toLongArray();
            if (comparator == null) {
                LongArrays.parallelQuickSort((long[])lArray);
            } else {
                LongArrays.parallelQuickSort((long[])lArray, (LongComparator)longComparator);
            }
            this.fillRange(0, ArrayLists.toList(lArray));
        } else {
            IMutList.super.sort(comparator);
        }
    }

    @Override
    default public void shuffle(Random random) {
        this.fillRange(0, this.immutShuffle(random));
    }

    @Override
    default public List immutShuffle(Random random) {
        long[] lArray = this.toLongArray();
        LongArrays.shuffle((long[])lArray, (Random)random);
        return ArrayLists.toList(lArray);
    }

    @Override
    default public Object doubleReduction(final IFn.ODO oDO, Object object) {
        return this.longReduction(new IFn.OLO(){

            public Object invokePrim(Object object, long l) {
                return oDO.invokePrim(object, (double)l);
            }
        }, object);
    }
}

