/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.ForkJoinPatterns;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.ParallelOptions;
import ham_fisted.Transformables;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Consumer;

public class Reductions {
    public static Object serialReduction(IFn iFn, Object object, Object object2) {
        if (object2 instanceof ITypedReduce) {
            ITypedReduce iTypedReduce = (ITypedReduce)object2;
            if (iFn instanceof IFn.ODO) {
                return iTypedReduce.doubleReduction((IFn.ODO)iFn, object);
            }
            if (iFn instanceof IFn.OLO) {
                return iTypedReduce.longReduction((IFn.OLO)iFn, object);
            }
            return iTypedReduce.reduce(iFn, object);
        }
        if (object2 instanceof IReduceInit) {
            return ((IReduceInit)object2).reduce(iFn, object);
        }
        if (object2 instanceof Map) {
            return Transformables.iterReduce(((Map)object2).entrySet(), object, iFn);
        }
        return Transformables.iterReduce(object2, object, iFn);
    }

    public static Object parallelRandAccessReduction(final IFn iFn, final IFn iFn2, IFn iFn3, final List list, ParallelOptions parallelOptions) {
        IFnDef iFnDef = new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                int n = RT.intCast((Object)object);
                int n2 = RT.intCast((Object)object2);
                return Reductions.serialReduction(iFn2, iFn.invoke(), list.subList(n, n2));
            }
        };
        Iterable iterable = ForkJoinPatterns.parallelIndexGroups(list.size(), iFnDef, parallelOptions);
        Iterator iterator = iterable.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            object = iFn3.invoke(object, iterator.next());
        }
        return object;
    }

    public static Object parallelCollectionReduction(IFn iFn, IFn iFn2, IFn iFn3, Collection collection, ParallelOptions parallelOptions) {
        if (collection.size() <= parallelOptions.minN) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), collection);
        }
        return ForkJoinPatterns.parallelSpliteratorReduce(iFn, iFn2, iFn3, collection.spliterator(), parallelOptions);
    }

    public static Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, Object object, ParallelOptions parallelOptions) {
        if (parallelOptions.parallelism < 2) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), object);
        }
        if (object instanceof ITypedReduce) {
            return ((ITypedReduce)object).parallelReduction(iFn, iFn2, iFn3, parallelOptions);
        }
        if (object instanceof RandomAccess) {
            return Reductions.parallelRandAccessReduction(iFn, iFn2, iFn3, (List)object, parallelOptions);
        }
        if (object instanceof IReduceInit) {
            return Reductions.serialReduction(iFn2, iFn.invoke(), object);
        }
        if (object instanceof Map) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, ((Map)object).entrySet(), parallelOptions);
        }
        if (object instanceof Set) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, (Collection)object, parallelOptions);
        }
        if (object instanceof Iterable) {
            return ForkJoinPatterns.parallelSpliteratorReduce(iFn, iFn2, iFn3, ((Iterable)object).spliterator(), parallelOptions);
        }
        return Reductions.serialReduction(iFn2, iFn.invoke(), object);
    }

    public static class ReduceConsumer
    implements Consumer,
    IDeref {
        Object init;
        public final IFn rfn;

        public ReduceConsumer(Object object, IFn iFn) {
            this.init = object;
            this.rfn = iFn;
        }

        public void accept(Object object) {
            this.init = this.rfn.invoke(this.init, object);
        }

        public boolean isReduced() {
            return RT.isReduced((Object)this.init);
        }

        public Object deref() {
            return this.init;
        }
    }

    public static interface LongAccum
    extends IFnDef.OLO {
    }

    public static interface DoubleAccum
    extends IFnDef.ODO {
    }
}

