/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.ILookup;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientSet;
import clojure.lang.IteratorSeq;
import clojure.lang.Seqable;
import ham_fisted.BitmapTrie;
import ham_fisted.HashSet;
import ham_fisted.IFnDef;
import ham_fisted.PersistentHashSet;
import java.util.Iterator;

public class TransientHashSet
implements ITransientSet,
IObj,
IFnDef,
ILookup,
Seqable {
    final BitmapTrie hb;
    boolean editable;

    TransientHashSet(BitmapTrie bitmapTrie) {
        this.hb = bitmapTrie.shallowClone();
        this.editable = true;
    }

    final void ensureEditable() {
        if (!this.editable) {
            throw new RuntimeException("Transient set edited after persistent!");
        }
    }

    public final int count() {
        return this.hb.size();
    }

    public final ITransientSet disjoin(Object object) {
        this.ensureEditable();
        this.hb.dissoc(object);
        return this;
    }

    public final boolean contains(Object object) {
        return this.hb.getNode(object) != null;
    }

    public final Object get(Object object) {
        return this.contains(object) ? object : null;
    }

    public final TransientHashSet conj(Object object) {
        this.ensureEditable();
        this.hb.assoc(object, HashSet.PRESENT);
        return this;
    }

    public final PersistentHashSet persistent() {
        this.editable = false;
        return new PersistentHashSet(this.hb);
    }

    public final Iterator iterator() {
        return this.hb.iterator(BitmapTrie.keyIterFn);
    }

    public final ISeq seq() {
        return IteratorSeq.create((Iterator)this.iterator());
    }

    public final IPersistentMap meta() {
        return this.hb.meta();
    }

    public final TransientHashSet withMeta(IPersistentMap iPersistentMap) {
        return new TransientHashSet(this.hb.shallowClone(iPersistentMap));
    }

    public final Object valAt(Object object) {
        return this.get(object);
    }

    public final Object valAt(Object object, Object object2) {
        return this.contains(object) ? object : object2;
    }

    @Override
    public final Object invoke(Object object) {
        return this.get(object);
    }

    @Override
    public final Object invoke(Object object, Object object2) {
        return this.contains(object) ? object : object2;
    }
}

