/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Associative;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.RT;
import ham_fisted.ArraySection;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.DoubleMutList;
import ham_fisted.IMutList;
import ham_fisted.ImmutList;
import ham_fisted.LongMutList;
import ham_fisted.Transformables;
import ham_fisted.TypedList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;

public class ArrayLists {
    public static int checkIndex(int n, int n2) {
        if (n >= 0 && n < n2) {
            return n;
        }
        return ChunkedList.indexCheck(0, n2, n);
    }

    public static int wrapCheckIndex(int n, int n2) {
        if (n < 0) {
            n += n2;
        }
        return ArrayLists.checkIndex(n, n2);
    }

    public static void checkIndexRange(int n, int n2, int n3) {
        ChunkedList.checkIndexRange(0, n, n2, n3);
    }

    public static DoubleConsumer asDoubleConsumer(Object object) {
        if (object instanceof DoubleConsumer) {
            return (DoubleConsumer)object;
        }
        return null;
    }

    public static LongConsumer asLongConsumer(Object object) {
        if (object instanceof LongConsumer) {
            return (LongConsumer)object;
        }
        return null;
    }

    static boolean fillRangeArrayCopy(Object object, int n, int n2, Class clazz, int n3, List list) {
        int n4 = list.size();
        int n5 = n3 + n4;
        ArrayLists.checkIndexRange(n2 - n, n3, n5);
        if (list instanceof ArrayOwner) {
            ArraySection arraySection = ((ArrayOwner)((Object)list)).getArraySection();
            if (clazz.isAssignableFrom(arraySection.array.getClass())) {
                System.arraycopy(arraySection.array, arraySection.sidx, object, n + n3, n4);
                return true;
            }
        }
        return false;
    }

    static List immutShuffleDefault(IMutList iMutList, Random random) {
        IMutList iMutList2 = iMutList.cloneList();
        iMutList2.shuffle(random);
        return iMutList2;
    }

    static List immutSortDefault(IMutList iMutList, Comparator comparator) {
        IMutList iMutList2 = iMutList.cloneList();
        iMutList2.sort(comparator);
        return iMutList2;
    }

    static int fixSubArrayBinarySearch(int n, int n2, int n3) {
        return n3 < 0 ? -1 - (n3 + n) : n3 - n;
    }

    public static int newArrayLen(int n) {
        return n < 100000 ? n * 2 : (int)((double)n * 1.5);
    }

    public static long newArrayLen(long l) {
        return l < 100000L ? l * 2L : (long)((double)l * 1.5);
    }

    public static Object[] toArray(Collection collection) {
        ObjectArrayList objectArrayList = new ObjectArrayList();
        objectArrayList.addAllReducible(collection);
        return objectArrayList.toArray();
    }

    public static <T> T[] toArray(Collection collection, T[] TArray) {
        ObjectArrayList objectArrayList = ObjectArrayList.wrap(TArray, 0, null);
        objectArrayList.addAllReducible(collection);
        return objectArrayList.toArray();
    }

    public static IMutList<Object> toList(Object[] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new ObjectArraySubList(objectArray, n, n2, iPersistentMap);
    }

    public static IMutList<Object> toList(Object[] objectArray) {
        return ArrayLists.toList(objectArray, 0, objectArray.length, null);
    }

    public static IMutList<Object> toList(byte[] byArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new ByteArraySubList(byArray, n, n3, iPersistentMap);
    }

    public static IMutList<Object> toList(byte[] byArray) {
        return ArrayLists.toList(byArray, 0, byArray.length, null);
    }

    public static IMutList<Object> toList(short[] sArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new ShortArraySubList(sArray, n, n3, iPersistentMap);
    }

    public static IMutList<Object> toList(short[] sArray) {
        return ArrayLists.toList(sArray, 0, sArray.length, null);
    }

    public static IntComparator intIndexComparator(final List list, final Comparator comparator) {
        if (comparator != null) {
            if (list instanceof IMutList) {
                return ((IMutList)list).indexComparator(comparator);
            }
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return comparator.compare(list.get(n), list.get(n2));
                }
            };
        }
        if (list instanceof IMutList) {
            return ((IMutList)list).indexComparator();
        }
        return new IntComparator(){

            public int compare(int n, int n2) {
                return ((Comparable)list.get(n)).compareTo(list.get(n2));
            }
        };
    }

    public static IMutList<Object> toList(int[] nArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new IntArraySubList(nArray, n, n2, iPersistentMap);
    }

    public static IMutList<Object> toList(int[] nArray) {
        return ArrayLists.toList(nArray, 0, nArray.length, null);
    }

    public static IMutList<Object> toList(long[] lArray, int n, int n2, IPersistentMap iPersistentMap) {
        return new LongArraySubList(lArray, n, n2, iPersistentMap);
    }

    public static IMutList<Object> toList(long[] lArray) {
        return ArrayLists.toList(lArray, 0, lArray.length, null);
    }

    public static IMutList<Object> toList(float[] fArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new FloatArraySubList(fArray, n, n3, iPersistentMap);
    }

    public static IMutList<Object> toList(float[] fArray) {
        return ArrayLists.toList(fArray, 0, fArray.length, null);
    }

    public static IMutList<Object> toList(double[] dArray, int n, int n2, IPersistentMap iPersistentMap) {
        return new DoubleArraySubList(dArray, n, n2, iPersistentMap);
    }

    public static IMutList<Object> toList(double[] dArray) {
        return ArrayLists.toList(dArray, 0, dArray.length, null);
    }

    public static IMutList<Object> toList(char[] cArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new CharArraySubList(cArray, n, n3, iPersistentMap);
    }

    public static IMutList<Object> toList(char[] cArray) {
        return ArrayLists.toList(cArray, 0, cArray.length, null);
    }

    public static IMutList<Object> toList(boolean[] blArray, int n, int n2, IPersistentMap iPersistentMap) {
        int n3 = n2 - n;
        return new BooleanArraySubList(blArray, n, n3, iPersistentMap);
    }

    public static IMutList<Object> toList(boolean[] blArray) {
        return ArrayLists.toList(blArray, 0, blArray.length, null);
    }

    public static IMutList<Object> toList(Object object, int n, int n2, IPersistentMap iPersistentMap) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Object is not an array: " + String.valueOf(object));
        }
        if (object instanceof Object[]) {
            return ArrayLists.toList((Object[])object, n, n2, iPersistentMap);
        }
        if (clazz == byte[].class) {
            return ArrayLists.toList((byte[])object, n, n2, iPersistentMap);
        }
        if (clazz == short[].class) {
            return ArrayLists.toList((short[])object, n, n2, iPersistentMap);
        }
        if (clazz == int[].class) {
            return ArrayLists.toList((int[])object, n, n2, iPersistentMap);
        }
        if (clazz == long[].class) {
            return ArrayLists.toList((long[])object, n, n2, iPersistentMap);
        }
        if (clazz == float[].class) {
            return ArrayLists.toList((float[])object, n, n2, iPersistentMap);
        }
        if (clazz == double[].class) {
            return ArrayLists.toList((double[])object, n, n2, iPersistentMap);
        }
        if (clazz == char[].class) {
            return ArrayLists.toList((char[])object, n, n2, iPersistentMap);
        }
        if (clazz == boolean[].class) {
            return ArrayLists.toList((boolean[])object, n, n2, iPersistentMap);
        }
        throw new RuntimeException("Invalid array type.");
    }

    public static IMutList<Object> toList(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Object is not an array: " + String.valueOf(object));
        }
        return ArrayLists.toList(object, 0, Array.getLength(object), null);
    }

    public static IMutList<Object> toList(ArraySection arraySection) {
        if (arraySection == null) {
            return null;
        }
        if (arraySection instanceof IMutList) {
            return (IMutList)((Object)arraySection);
        }
        return ArrayLists.toList(arraySection.array, arraySection.sidx, arraySection.eidx, null);
    }

    public static int[] iarange(int n, int n2, int n3) {
        int n4 = (n2 - n) / n3;
        if (n4 < 0) {
            throw new RuntimeException("Invalid range - start: " + String.valueOf(n) + " end: " + String.valueOf(n2) + " step: " + String.valueOf(n3));
        }
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = n + i * n3;
        }
        return nArray;
    }

    public static long[] larange(long l, long l2, long l3) {
        int n = RT.intCast((long)((l2 - l) / l3));
        if (n < 0) {
            throw new RuntimeException("Invalid range.");
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = l + (long)i * l3;
        }
        return lArray;
    }

    public static double[] darange(double d, double d2, double d3) {
        int n = RT.intCast((double)((d2 - d) / d3));
        if (n < 0) {
            throw new RuntimeException("Invalid range.");
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d + (double)i * d3;
        }
        return dArray;
    }

    public static class BooleanArraySubList
    implements IArrayList {
        public final boolean[] data;
        public final int sidx;
        public final int dlen;
        public final IPersistentMap meta;

        public BooleanArraySubList(boolean[] blArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = blArray;
            this.sidx = n;
            this.dlen = n2;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.sidx + this.dlen);
        }

        @Override
        public int size() {
            return this.dlen;
        }

        public boolean getBoolean(int n) {
            return this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx];
        }

        public void setBoolean(int n, boolean bl) {
            this.data[ArrayLists.checkIndex((int)n, (int)this.dlen) + this.sidx] = bl;
        }

        @Override
        public long getLong(int n) {
            return Casts.longCast(this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx]);
        }

        @Override
        public void setLong(int n, long l) {
            this.data[ArrayLists.checkIndex((int)n, (int)this.dlen) + this.sidx] = Casts.booleanCast(l);
        }

        @Override
        public Object get(int n) {
            return this.getBoolean(n);
        }

        @Override
        public Object set(int n, Object object) {
            boolean bl = this.getBoolean(n);
            this.setBoolean(n, Casts.booleanCast(object));
            return bl;
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.sidx + this.dlen));
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.sidx + this.dlen, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.data[i + this.sidx];
            }
            return objectArray;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, Casts.booleanCast(object));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class CharArraySubList
    implements ILongArrayList {
        public final char[] data;
        public final int sidx;
        public final int dlen;
        public final IPersistentMap meta;

        public CharArraySubList(char[] cArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = cArray;
            this.sidx = n;
            this.dlen = n2;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.sidx + this.dlen);
        }

        @Override
        public int size() {
            return this.dlen;
        }

        @Override
        public Character set(int n, Object object) {
            Character c = this.get(n);
            this.setLong(n, Casts.longCast(object));
            return c;
        }

        @Override
        public Character get(int n) {
            return Character.valueOf(this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx]);
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx];
        }

        @Override
        public void setLong(int n, long l) {
            char c = Casts.charCast(l);
            n = ArrayLists.checkIndex(n, this.dlen) + this.sidx;
            this.data[n] = c;
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.sidx + this.dlen, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Character.valueOf(this.data[i + this.sidx]);
            }
            return objectArray;
        }

        public static CharComparator asCharComparator(Comparator comparator) {
            if (comparator instanceof CharComparator) {
                return (CharComparator)comparator;
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                return new CharComparator(){

                    public int compare(char c, char c2) {
                        return longComparator.compare((long)c, (long)c2);
                    }
                };
            }
            return null;
        }

        @Override
        public void sort(Comparator comparator) {
            if (comparator == null) {
                CharArrays.parallelQuickSort((char[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen));
            } else {
                CharComparator charComparator = CharArraySubList.asCharComparator(comparator);
                if (charComparator != null) {
                    CharArrays.parallelQuickSort((char[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen), (CharComparator)charComparator);
                } else {
                    ILongArrayList.super.sort(comparator);
                }
            }
        }

        @Override
        public void shuffle(Random random) {
            CharArrays.shuffle((char[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen), (Random)random);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            char c = RT.charCast((long)Casts.longCast(object));
            CharComparator charComparator = CharArraySubList.asCharComparator(comparator);
            if (comparator == null || charComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), charComparator == null ? CharArrays.binarySearch((char[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (char)c) : CharArrays.binarySearch((char[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (char)c, (CharComparator)charComparator));
            }
            return ILongArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            int n = this.size();
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = iFn.invoke(object, (Object)Character.valueOf(this.data[i + this.sidx]));
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, n + this.sidx, n2 + this.sidx, RT.charCast((long)Casts.longCast(object)));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.size());
            return Arrays.copyOfRange(this.data, n + this.sidx, n2 + this.sidx);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class DoubleArrayList
    implements IDoubleArrayList {
        double[] data;
        int nElems;
        IPersistentMap meta;

        public DoubleArrayList(double[] dArray, int n, IPersistentMap iPersistentMap) {
            this.data = dArray;
            this.nElems = n;
        }

        public DoubleArrayList(int n) {
            this(new double[n], 0, null);
        }

        public DoubleArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOf(this.data, this.nElems));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public double getDouble(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public void setDouble(int n, double d) {
            DoubleArraySubList.setDouble(this.data, 0, this.nElems, n, d);
        }

        public int capacity() {
            return this.data.length;
        }

        public double[] ensureCapacity(int n) {
            double[] dArray = this.data;
            if (n >= dArray.length) {
                dArray = this.data = Arrays.copyOf(dArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
            }
            return dArray;
        }

        @Override
        public void addDouble(double d) {
            int n = this.nElems;
            double[] dArray = this.ensureCapacity(n + 1);
            dArray[n] = d;
            this.nElems = n + 1;
        }

        @Override
        public boolean add(Object object) {
            this.addDouble(Casts.longCast(object));
            return true;
        }

        @Override
        public void add(int n, Object object) {
            if (n == this.nElems) {
                this.add(object);
                return;
            }
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            double d = Casts.doubleCast(object);
            int n2 = this.nElems;
            double[] dArray = this.ensureCapacity(n2 + 1);
            System.arraycopy(dArray, n, dArray, n + 1, n2 - n);
            dArray[n] = d;
            this.nElems = n2 + 1;
        }

        @Override
        public boolean addAllReducible(Object object) {
            int n = this.size();
            if (object instanceof RandomAccess) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return false;
                }
                int n2 = list.size();
                this.ensureCapacity(n2 + n);
                this.nElems += n2;
                this.fillRange(n, list);
            } else {
                IDoubleArrayList.super.addAllReducible(object);
            }
            return n != this.size();
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public Object remove(int n) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            int n2 = this.nElems;
            int n3 = n2 - 1;
            double[] dArray = this.data;
            double d = dArray[n];
            if (n != n3) {
                int n4 = n2 - n - 1;
                System.arraycopy(dArray, n + 1, dArray, n, n4);
            }
            --this.nElems;
            return d;
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return this.subList(0, this.nElems).toArray();
        }

        @Override
        public double[] toDoubleArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return this.subList(0, this.nElems).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return this.subList(0, this.nElems).reduce(iFn, object);
        }

        @Override
        public IntComparator indexComparator() {
            return DoubleArraySubList.indexComparator(this.data, 0, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return DoubleArraySubList.indexComparator(this.data, 0, comparator);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public void shuffle(Random random) {
            this.subList(0, this.nElems).shuffle(random);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return this.subList(0, this.nElems).binarySearch(object, comparator);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            return this.subList(0, this.nElems).sortIndirect(comparator);
        }

        @Override
        public void doubleForEach(DoubleConsumer doubleConsumer) {
            int n = this.nElems;
            double[] dArray = this.data;
            for (int i = 0; i < n; ++i) {
                doubleConsumer.accept(dArray[i]);
            }
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, n, n2, Casts.doubleCast(object));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.nElems);
            return Arrays.copyOfRange(this.data, n, n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOf(this.data, n);
        }

        public static DoubleArrayList wrap(double[] dArray, int n, IPersistentMap iPersistentMap) {
            if (dArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new DoubleArrayList(dArray, n, iPersistentMap);
        }

        public static DoubleArrayList wrap(double[] dArray, IPersistentMap iPersistentMap) {
            return new DoubleArrayList(dArray, dArray.length, iPersistentMap);
        }
    }

    public static class DoubleArraySubList
    implements IDoubleArrayList {
        public final double[] data;
        public final int sidx;
        public final int eidx;
        public final int nElems;
        public final IPersistentMap meta;

        public DoubleArraySubList(double[] dArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = dArray;
            this.sidx = n;
            this.eidx = n2;
            this.nElems = this.eidx - this.sidx;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.eidx);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public double getDouble(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        static void setDouble(double[] dArray, int n, int n2, int n3, double d) {
            n3 = ArrayLists.checkIndex(n3, n2) + n;
            dArray[n3] = d;
        }

        @Override
        public void setDouble(int n, double d) {
            DoubleArraySubList.setDouble(this.data, this.sidx, this.nElems, n, d);
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            double[] dArray = this.data;
            int n = this.sidx;
            int n2 = this.nElems;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = dArray[i + n];
            }
            return objectArray;
        }

        @Override
        public double[] toDoubleArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        public static IntComparator indexComparator(final double[] dArray, final int n, final Comparator comparator) {
            if (comparator == null) {
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return Double.compare(dArray[n3 + n], dArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Double.compare(dArray[n], dArray[n2]);
                    }
                };
            }
            if (comparator instanceof DoubleComparator) {
                final DoubleComparator doubleComparator = (DoubleComparator)comparator;
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return doubleComparator.compare(dArray[n3 + n], dArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return doubleComparator.compare(dArray[n], dArray[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n3, int n2) {
                    return comparator.compare(dArray[n3 + n], dArray[n2 + n]);
                }
            };
        }

        @Override
        public IntComparator indexComparator() {
            return DoubleArraySubList.indexComparator(this.data, this.sidx, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return DoubleArraySubList.indexComparator(this.data, this.sidx, comparator);
        }

        public static DoubleComparator toDoubleComparator(Comparator comparator) {
            if (comparator instanceof DoubleComparator) {
                return (DoubleComparator)comparator;
            }
            return null;
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                DoubleArrays.parallelQuickSort((double[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                DoubleComparator doubleComparator = DoubleArraySubList.toDoubleComparator(comparator);
                if (doubleComparator != null) {
                    DoubleArrays.parallelQuickSort((double[])this.data, (int)this.sidx, (int)this.eidx, (DoubleComparator)DoubleArraySubList.toDoubleComparator(comparator));
                } else {
                    IDoubleArrayList.super.sort(comparator);
                }
            }
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            int n = this.size();
            int[] nArray = ArrayLists.iarange(0, n, 1);
            if (n < 2) {
                return nArray;
            }
            if (comparator == null) {
                DoubleArrays.parallelQuickSortIndirect((int[])nArray, (double[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])nArray, (IntComparator)this.indexComparator(comparator));
            }
            return nArray;
        }

        @Override
        public void shuffle(Random random) {
            DoubleArrays.shuffle((double[])this.data, (int)this.sidx, (int)this.eidx, (Random)random);
        }

        public static DoubleComparator asDoubleComparator(Comparator comparator) {
            if (comparator instanceof DoubleComparator) {
                return (DoubleComparator)comparator;
            }
            return null;
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            double d = RT.doubleCast((double)Casts.doubleCast(object));
            DoubleComparator doubleComparator = DoubleArraySubList.asDoubleComparator(comparator);
            if (comparator == null || doubleComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), doubleComparator == null ? DoubleArrays.binarySearch((double[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (double)d) : DoubleArrays.binarySearch((double[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (double)d, (DoubleComparator)doubleComparator));
            }
            return IDoubleArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public Object doubleReduction(IFn.ODO oDO, Object object) {
            int n = this.eidx;
            double[] dArray = this.data;
            for (int i = this.sidx; i < n && !RT.isReduced((Object)oDO); ++i) {
                object = oDO.invokePrim(object, dArray[i]);
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, Casts.doubleCast(object));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.nElems);
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class FloatArraySubList
    implements IDoubleArrayList {
        public final float[] data;
        public final int sidx;
        public final int dlen;
        public final IPersistentMap meta;

        public FloatArraySubList(float[] fArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = fArray;
            this.sidx = n;
            this.dlen = n2;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.sidx + this.dlen));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.sidx + this.dlen);
        }

        @Override
        public int size() {
            return this.dlen;
        }

        @Override
        public Float get(int n) {
            return Float.valueOf(this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx]);
        }

        @Override
        public double getDouble(int n) {
            return this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx];
        }

        @Override
        public void setDouble(int n, double d) {
            float f = (float)d;
            n = ArrayLists.checkIndex(n, this.dlen) + this.sidx;
            this.data[n] = f;
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.sidx + this.dlen, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = Float.valueOf(this.data[i + this.sidx]);
            }
            return objectArray;
        }

        @Override
        public float[] toFloatArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + this.dlen);
        }

        @Override
        public IntComparator indexComparator() {
            if (this.sidx == 0) {
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Float.compare(data[n], data[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return Float.compare(data[n + sidx], data[n2 + sidx]);
                }
            };
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            if (comparator == null) {
                return this.indexComparator();
            }
            if (comparator instanceof DoubleComparator) {
                final DoubleComparator doubleComparator = (DoubleComparator)comparator;
                if (this.sidx == 0) {
                    return new IntComparator(){

                        public int compare(int n, int n2) {
                            return doubleComparator.compare((double)data[n], (double)data[n2]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return doubleComparator.compare((double)data[n + sidx], (double)data[n2 + sidx]);
                    }
                };
            }
            return IDoubleArrayList.super.indexComparator(comparator);
        }

        public static FloatComparator asFloatComparator(Comparator comparator) {
            if (comparator instanceof FloatComparator) {
                return (FloatComparator)comparator;
            }
            if (comparator instanceof DoubleComparator) {
                final DoubleComparator doubleComparator = (DoubleComparator)comparator;
                return new FloatComparator(){

                    public int compare(float f, float f2) {
                        return doubleComparator.compare((double)f, (double)f2);
                    }
                };
            }
            return null;
        }

        @Override
        public void sort(Comparator comparator) {
            if (comparator == null) {
                FloatArrays.parallelQuickSort((float[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen));
            } else {
                FloatComparator floatComparator = FloatArraySubList.asFloatComparator(comparator);
                if (floatComparator != null) {
                    FloatArrays.parallelQuickSort((float[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen), (FloatComparator)floatComparator);
                } else {
                    IDoubleArrayList.super.sort(comparator);
                }
            }
        }

        @Override
        public void shuffle(Random random) {
            FloatArrays.shuffle((float[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen), (Random)random);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            float f = RT.floatCast((double)Casts.doubleCast(object));
            FloatComparator floatComparator = FloatArraySubList.asFloatComparator(comparator);
            if (comparator == null || floatComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), floatComparator == null ? FloatArrays.binarySearch((float[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (float)f) : FloatArrays.binarySearch((float[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (float)f, (FloatComparator)floatComparator));
            }
            return IDoubleArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public Object doubleReduction(IFn.ODO oDO, Object object) {
            int n = this.sidx + this.dlen;
            float[] fArray = this.data;
            for (int i = this.sidx; i < n && !RT.isReduced((Object)object); ++i) {
                object = oDO.invokePrim(object, (double)fArray[i]);
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, n, n2, (float)Casts.doubleCast(object));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.dlen);
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class LongArrayList
    implements ILongArrayList {
        long[] data;
        int nElems;
        IPersistentMap meta;

        public LongArrayList(long[] lArray, int n, IPersistentMap iPersistentMap) {
            this.data = lArray;
            this.nElems = n;
        }

        public LongArrayList(int n) {
            this(new long[n], 0, null);
        }

        public LongArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOf(this.data, this.nElems));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public void setLong(int n, long l) {
            LongArraySubList.setLong(this.data, 0, this.nElems, n, l);
        }

        public int capacity() {
            return this.data.length;
        }

        public long[] ensureCapacity(int n) {
            long[] lArray = this.data;
            if (n >= lArray.length) {
                lArray = this.data = Arrays.copyOf(lArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
            }
            return lArray;
        }

        @Override
        public void addLong(long l) {
            int n = RT.intCast((long)l);
            int n2 = this.nElems;
            long[] lArray = this.ensureCapacity(n2 + 1);
            lArray[n2] = n;
            this.nElems = n2 + 1;
        }

        @Override
        public boolean add(Object object) {
            this.addLong(Casts.longCast(object));
            return true;
        }

        @Override
        public void add(int n, Object object) {
            if ((n = ArrayLists.wrapCheckIndex(n, this.nElems)) == this.nElems) {
                this.add(object);
                return;
            }
            int n2 = RT.intCast((long)Casts.longCast(object));
            int n3 = this.nElems;
            long[] lArray = this.ensureCapacity(n3 + 1);
            System.arraycopy(lArray, n, lArray, n + 1, n3 - n);
            lArray[n] = n2;
            this.nElems = n3 + 1;
        }

        @Override
        public boolean addAllReducible(Object object) {
            int n = this.size();
            if (object instanceof RandomAccess) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return false;
                }
                int n2 = list.size();
                this.ensureCapacity(n2 + n);
                this.nElems += n2;
                this.fillRange(n, list);
            } else {
                ILongArrayList.super.addAllReducible(object);
            }
            return n != this.size();
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public Object remove(int n) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            int n2 = this.nElems;
            int n3 = n2 - 1;
            long[] lArray = this.data;
            long l = lArray[n];
            if (n != n3) {
                int n4 = n2 - n - 1;
                System.arraycopy(lArray, n + 1, lArray, n, n4);
            }
            --this.nElems;
            return l;
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return this.subList(0, this.nElems).toArray();
        }

        @Override
        public long[] toLongArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            this.subList(0, this.nElems).fillRange(n, n2, object);
        }

        @Override
        public void fillRange(int n, List list) {
            this.subList(0, this.nElems).fillRange(n, list);
        }

        @Override
        public void addRange(int n, int n2, Object object) {
            int n3 = this.nElems;
            ArrayLists.checkIndexRange(n3, n, n2);
            int n4 = n2 - n;
            int n5 = n3 + n4;
            this.ensureCapacity(n5);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return this.subList(0, this.nElems).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return this.subList(0, this.nElems).reduce(iFn, object);
        }

        @Override
        public Object longReduction(IFn.OLO oLO, Object object) {
            return this.subList(0, this.nElems).longReduction(oLO, object);
        }

        @Override
        public IntComparator indexComparator() {
            return LongArraySubList.indexComparator(this.data, 0, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return LongArraySubList.indexComparator(this.data, 0, comparator);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public void shuffle(Random random) {
            this.subList(0, this.nElems).shuffle(random);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return this.subList(0, this.nElems).binarySearch(object, comparator);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            return this.subList(0, this.nElems).sortIndirect(comparator);
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, n, n2, Casts.longCast(object));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.nElems);
            return Arrays.copyOfRange(this.data, n, n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOf(this.data, n);
        }

        public static LongArrayList wrap(long[] lArray, int n, IPersistentMap iPersistentMap) {
            if (lArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new LongArrayList(lArray, n, iPersistentMap);
        }

        public static LongArrayList wrap(long[] lArray, IPersistentMap iPersistentMap) {
            return new LongArrayList(lArray, lArray.length, iPersistentMap);
        }
    }

    public static class LongArraySubList
    implements ILongArrayList {
        public final long[] data;
        public final int sidx;
        public final int eidx;
        public final int nElems;
        public final IPersistentMap meta;

        public LongArraySubList(long[] lArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = lArray;
            this.sidx = n;
            this.eidx = n2;
            this.nElems = this.eidx - this.sidx;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.eidx);
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx));
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        static void setLong(long[] lArray, int n, int n2, int n3, long l) {
            n3 = ArrayLists.checkIndex(n3, n2) + n;
            lArray[n3] = l;
        }

        @Override
        public void setLong(int n, long l) {
            LongArraySubList.setLong(this.data, this.sidx, this.nElems, n, l);
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            long[] lArray = this.data;
            int n = this.sidx;
            int n2 = this.nElems;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = lArray[i + n];
            }
            return objectArray;
        }

        @Override
        public long[] toLongArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        public static IntComparator indexComparator(final long[] lArray, final int n, final Comparator comparator) {
            if (comparator == null) {
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return Long.compare(lArray[n3 + n], lArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Long.compare(lArray[n], lArray[n2]);
                    }
                };
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return longComparator.compare(lArray[n3 + n], lArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return longComparator.compare(lArray[n], lArray[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n3, int n2) {
                    return comparator.compare(lArray[n3 + n], lArray[n2 + n]);
                }
            };
        }

        @Override
        public IntComparator indexComparator() {
            return LongArraySubList.indexComparator(this.data, this.sidx, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return LongArraySubList.indexComparator(this.data, this.sidx, comparator);
        }

        public static LongComparator toLongComparator(final Comparator comparator) {
            if (comparator instanceof LongComparator) {
                return (LongComparator)comparator;
            }
            return new LongComparator(){

                public int compare(long l, long l2) {
                    return comparator.compare(l, l2);
                }
            };
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                LongArrays.parallelQuickSort((long[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                LongArrays.parallelQuickSort((long[])this.data, (int)this.sidx, (int)this.eidx, (LongComparator)LongArraySubList.toLongComparator(comparator));
            }
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            int n = this.size();
            int[] nArray = ArrayLists.iarange(0, n, 1);
            if (n < 2) {
                return nArray;
            }
            if (comparator == null) {
                LongArrays.parallelQuickSortIndirect((int[])nArray, (long[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])nArray, (IntComparator)this.indexComparator(comparator));
            }
            return nArray;
        }

        @Override
        public void shuffle(Random random) {
            LongArrays.shuffle((long[])this.data, (int)this.sidx, (int)this.eidx, (Random)random);
        }

        public static LongComparator asLongComparator(Comparator comparator) {
            if (comparator instanceof LongComparator) {
                return (LongComparator)comparator;
            }
            return null;
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            long l = Casts.longCast(object);
            LongComparator longComparator = LongArraySubList.asLongComparator(comparator);
            if (comparator == null || longComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), longComparator == null ? LongArrays.binarySearch((long[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (long)l) : LongArrays.binarySearch((long[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (long)l, (LongComparator)longComparator));
            }
            return ILongArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public void longForEach(LongConsumer longConsumer) {
            int n = this.eidx;
            long[] lArray = this.data;
            for (int i = this.sidx; i < n; ++i) {
                longConsumer.accept(lArray[i]);
            }
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, Casts.longCast(object));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class IntArrayList
    implements ILongArrayList {
        int[] data;
        int nElems;
        IPersistentMap meta;

        public IntArrayList(int[] nArray, int n, IPersistentMap iPersistentMap) {
            this.data = nArray;
            this.nElems = n;
        }

        public IntArrayList(int n) {
            this(new int[n], 0, null);
        }

        public IntArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOf(this.data, this.nElems));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public void setLong(int n, long l) {
            IntArraySubList.setLong(this.data, 0, this.nElems, n, l);
        }

        public int capacity() {
            return this.data.length;
        }

        public int[] ensureCapacity(int n) {
            int[] nArray = this.data;
            if (n >= nArray.length) {
                nArray = this.data = Arrays.copyOf(nArray, n < 100000 ? n * 2 : (int)((double)n * 1.5));
            }
            return nArray;
        }

        @Override
        public void addLong(long l) {
            int n = RT.intCast((long)l);
            int n2 = this.nElems;
            int[] nArray = this.ensureCapacity(n2 + 1);
            nArray[n2] = n;
            this.nElems = n2 + 1;
        }

        @Override
        public void add(int n, Object object) {
            if ((n = ArrayLists.wrapCheckIndex(n, this.nElems)) == this.nElems) {
                this.add(object);
                return;
            }
            int n2 = RT.intCast((long)Casts.longCast(object));
            int n3 = this.nElems;
            int[] nArray = this.ensureCapacity(n3 + 1);
            System.arraycopy(nArray, n, nArray, n + 1, n3 - n);
            nArray[n] = n2;
            this.nElems = n3 + 1;
        }

        @Override
        public boolean addAllReducible(Object object) {
            int n = this.size();
            if (object instanceof RandomAccess) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return false;
                }
                int n2 = list.size();
                this.ensureCapacity(n2 + n);
                this.nElems += n2;
                this.fillRange(n, list);
            } else {
                ILongArrayList.super.addAllReducible(object);
            }
            return n != this.size();
        }

        @Override
        public boolean addAll(int n, Collection<? extends Object> collection) {
            n = ArrayLists.wrapCheckIndex(n, this.nElems);
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = collection.size();
            int n3 = this.size();
            int n4 = n + n2;
            this.ensureCapacity(n2 + n3);
            this.nElems += n2;
            System.arraycopy(this.data, n, this.data, n4, n3 - n);
            if (collection instanceof List) {
                this.fillRange(n, (List)collection);
            } else {
                int n5 = n;
                for (Object object : collection) {
                    this.set(n5, object);
                    ++n5;
                }
            }
            return true;
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return this.subList(0, this.nElems).toArray();
        }

        @Override
        public int[] toIntArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void fillRange(int n, int n2, Object object) {
            this.subList(0, this.nElems).fillRange(n, n2, object);
        }

        @Override
        public void fillRange(int n, List list) {
            this.subList(0, this.nElems).fillRange(n, list);
        }

        @Override
        public void addRange(int n, int n2, Object object) {
            int n3 = this.nElems;
            ArrayLists.checkIndexRange(n3, n, n2);
            int n4 = n2 - n;
            int n5 = n3 + n4;
            this.ensureCapacity(n5);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n);
            this.fillRange(n, n2, object);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return this.subList(0, this.nElems).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return this.subList(0, this.nElems).reduce(iFn, object);
        }

        public Object longReduction(IFn.OLO oLO, long l) {
            return this.subList(0, this.nElems).longReduction(oLO, l);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public void shuffle(Random random) {
            this.subList(0, this.nElems).shuffle(random);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            return this.subList(0, this.nElems).sortIndirect(comparator);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return this.subList(0, this.nElems).binarySearch(object, comparator);
        }

        @Override
        public IntComparator indexComparator() {
            return IntArraySubList.indexComparator(this.data, 0, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return IntArraySubList.indexComparator(this.data, 0, comparator);
        }

        @Override
        public Object longReduction(IFn.OLO oLO, Object object) {
            int n = this.nElems;
            int[] nArray = this.data;
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                object = oLO.invokePrim(object, (long)nArray[i]);
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, n, n2, RT.intCast((long)Casts.longCast(object)));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.size());
            return Arrays.copyOfRange(this.data, n, n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOf(this.data, n);
        }

        public static IntArrayList wrap(int[] nArray, int n, IPersistentMap iPersistentMap) {
            if (nArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new IntArrayList(nArray, n, iPersistentMap);
        }

        public static IntArrayList wrap(int[] nArray, IPersistentMap iPersistentMap) {
            return new IntArrayList(nArray, nArray.length, iPersistentMap);
        }
    }

    public static class IntArraySubList
    implements ILongArrayList {
        public final int[] data;
        public final int sidx;
        public final int eidx;
        public final int nElems;
        public final IPersistentMap meta;

        public IntArraySubList(int[] nArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = nArray;
            this.sidx = n;
            this.eidx = n2;
            this.nElems = this.eidx - this.sidx;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.eidx));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.eidx);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        static void setLong(int[] nArray, int n, int n2, int n3, long l) {
            int n4 = RT.intCast((long)l);
            n3 = ArrayLists.checkIndex(n3, n2) + n;
            nArray[n3] = n4;
        }

        @Override
        public void setLong(int n, long l) {
            IntArraySubList.setLong(this.data, this.sidx, this.nElems, n, l);
        }

        @Override
        public LongMutList subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return (LongMutList)ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int[] nArray = this.data;
            int n = this.sidx;
            int n2 = this.nElems;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = nArray[i + n];
            }
            return objectArray;
        }

        @Override
        public int[] toIntArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        public static IntComparator indexComparator(final int[] nArray, final int n, final Comparator comparator) {
            if (comparator == null) {
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return Integer.compare(nArray[n3 + n], nArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return Integer.compare(nArray[n], nArray[n2]);
                    }
                };
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                if (n != 0) {
                    return new IntComparator(){

                        public int compare(int n3, int n2) {
                            return longComparator.compare((long)nArray[n3 + n], (long)nArray[n2 + n]);
                        }
                    };
                }
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return longComparator.compare((long)nArray[n], (long)nArray[n2]);
                    }
                };
            }
            return new IntComparator(){

                public int compare(int n3, int n2) {
                    return comparator.compare(nArray[n3 + n], nArray[n2 + n]);
                }
            };
        }

        @Override
        public IntComparator indexComparator() {
            return IntArraySubList.indexComparator(this.data, this.sidx, null);
        }

        @Override
        public IntComparator indexComparator(Comparator comparator) {
            return IntArraySubList.indexComparator(this.data, this.sidx, comparator);
        }

        public static IntComparator toIntComparator(final Comparator comparator) {
            if (comparator instanceof IntComparator) {
                return (IntComparator)comparator;
            }
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return comparator.compare(n, n2);
                }
            };
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                IntArrays.parallelQuickSort((int[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])this.data, (int)this.sidx, (int)this.eidx, (IntComparator)IntArraySubList.toIntComparator(comparator));
            }
        }

        @Override
        public void shuffle(Random random) {
            IntArrays.shuffle((int[])this.data, (int)this.sidx, (int)this.eidx, (Random)random);
        }

        public static IntComparator asIntComparator(Comparator comparator) {
            if (comparator instanceof IntComparator) {
                return (IntComparator)comparator;
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                return new IntComparator(){

                    public int compare(int n, int n2) {
                        return longComparator.compare((long)n, (long)n2);
                    }
                };
            }
            return null;
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            int n = RT.intCast((long)Casts.longCast(object));
            IntComparator intComparator = IntArraySubList.asIntComparator(comparator);
            if (comparator == null || intComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), intComparator == null ? IntArrays.binarySearch((int[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (int)n) : IntArrays.binarySearch((int[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (int)n, (IntComparator)intComparator));
            }
            return ILongArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public int[] sortIndirect(Comparator comparator) {
            int n = this.size();
            int[] nArray = ArrayLists.iarange(0, n, 1);
            if (n < 2) {
                return nArray;
            }
            if (comparator == null) {
                IntArrays.parallelQuickSortIndirect((int[])nArray, (int[])this.data, (int)this.sidx, (int)this.eidx);
            } else {
                IntArrays.parallelQuickSort((int[])nArray, (IntComparator)this.indexComparator(comparator));
            }
            return nArray;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return ILongArrayList.super.reduce(iFn, object);
        }

        @Override
        public Object longReduction(IFn.OLO oLO, Object object) {
            int n = this.eidx;
            int[] nArray = this.data;
            for (int i = this.sidx; i < n && !RT.isReduced((Object)object); ++i) {
                object = oLO.invokePrim(object, (long)nArray[i]);
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, RT.intCast((long)Casts.longCast(object)));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.size());
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class ShortArraySubList
    implements ILongArrayList {
        public final short[] data;
        public final int sidx;
        public final int dlen;
        public final IPersistentMap meta;

        public ShortArraySubList(short[] sArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = sArray;
            this.sidx = n;
            this.dlen = n2;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.sidx + this.dlen));
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.sidx + this.dlen);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.dlen;
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx];
        }

        @Override
        public void setLong(int n, long l) {
            this.data[ArrayLists.checkIndex((int)n, (int)this.dlen) + this.sidx] = RT.shortCast((long)Casts.longCast(l));
        }

        @Override
        public IntComparator indexComparator() {
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return Short.compare(data[n + sidx], data[n2 + sidx]);
                }
            };
        }

        @Override
        public LongMutList subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return (LongMutList)ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.sidx + this.dlen, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.data[i + this.sidx];
            }
            return objectArray;
        }

        @Override
        public void sort(Comparator comparator) {
            if (comparator == null) {
                Arrays.sort(this.data, this.sidx, this.sidx + this.dlen);
            } else {
                Object[] objectArray = this.toArray();
                Arrays.sort(objectArray, comparator);
                short[] sArray = this.data;
                int n = this.size();
                int n2 = this.sidx;
                for (int i = 0; i < n; ++i) {
                    sArray[i + n2] = (Short)objectArray[i];
                }
            }
        }

        @Override
        public void shuffle(Random random) {
            ShortArrays.shuffle((short[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen), (Random)random);
        }

        public static ShortComparator asShortComparator(Comparator comparator) {
            if (comparator instanceof ShortComparator) {
                return (ShortComparator)comparator;
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                return new ShortComparator(){

                    public int compare(short s, short s2) {
                        return longComparator.compare((long)s, (long)s2);
                    }
                };
            }
            return null;
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            short s = RT.shortCast((long)Casts.longCast(object));
            ShortComparator shortComparator = ShortArraySubList.asShortComparator(comparator);
            if (comparator == null || shortComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), shortComparator == null ? ShortArrays.binarySearch((short[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (short)s) : ShortArrays.binarySearch((short[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (short)s, (ShortComparator)shortComparator));
            }
            return ILongArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public Object longReduction(IFn.OLO oLO, Object object) {
            int n = this.sidx + this.dlen;
            short[] sArray = this.data;
            for (int i = this.sidx; i < n && !RT.isReduced((Object)object); ++i) {
                object = oLO.invokePrim(object, (long)sArray[i]);
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, RT.shortCast((long)Casts.longCast(object)));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            ArrayLists.checkIndex(n, this.size());
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class ByteArraySubList
    implements ILongArrayList {
        public final byte[] data;
        public final int dlen;
        public final int sidx;
        public final IPersistentMap meta;

        public ByteArraySubList(byte[] byArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = byArray;
            this.sidx = n;
            this.dlen = n2;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.sidx + this.dlen);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.dlen;
        }

        @Override
        public Byte get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx];
        }

        @Override
        public long getLong(int n) {
            return this.data[ArrayLists.checkIndex(n, this.dlen) + this.sidx];
        }

        @Override
        public void setLong(int n, long l) {
            this.data[ArrayLists.checkIndex((int)n, (int)this.dlen) + this.sidx] = RT.byteCast((long)l);
        }

        @Override
        public IMutList cloneList() {
            return ArrayLists.toList(Arrays.copyOfRange(this.data, this.sidx, this.sidx + this.dlen));
        }

        @Override
        public IntComparator indexComparator() {
            return new IntComparator(){

                public int compare(int n, int n2) {
                    return Byte.compare(data[n + sidx], data[n2 + sidx]);
                }
            };
        }

        @Override
        public LongMutList subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return (LongMutList)ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return new ByteArraySubList(this.data, this.sidx, this.sidx + this.dlen, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            int n = this.size();
            Object[] objectArray = new Object[this.size()];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.data[i + this.sidx];
            }
            return objectArray;
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                Arrays.sort(this.data, this.sidx, this.sidx + this.dlen);
            } else {
                ILongArrayList.super.sort(comparator);
            }
        }

        @Override
        public void shuffle(Random random) {
            ByteArrays.shuffle((byte[])this.data, (int)this.sidx, (int)(this.sidx + this.dlen), (Random)random);
        }

        public static ByteComparator asByteComparator(Comparator comparator) {
            if (comparator instanceof ByteComparator) {
                return (ByteComparator)comparator;
            }
            if (comparator instanceof LongComparator) {
                final LongComparator longComparator = (LongComparator)comparator;
                return new ByteComparator(){

                    public int compare(byte by, byte by2) {
                        return longComparator.compare((long)by, (long)by2);
                    }
                };
            }
            return null;
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            byte by = RT.byteCast((long)Casts.longCast(object));
            ByteComparator byteComparator = ByteArraySubList.asByteComparator(comparator);
            if (comparator == null || byteComparator != null) {
                return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), byteComparator == null ? ByteArrays.binarySearch((byte[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (byte)by) : ByteArrays.binarySearch((byte[])this.data, (int)this.sidx, (int)(this.sidx + this.size()), (byte)by, (ByteComparator)byteComparator));
            }
            return ILongArrayList.super.binarySearch(object, comparator);
        }

        @Override
        public Object longReduction(IFn.OLO oLO, Object object) {
            int n = this.sidx + this.dlen;
            byte[] byArray = this.data;
            for (int i = this.sidx; i < n && !RT.isReduced((Object)object); ++i) {
                object = oLO.invokePrim(object, (long)byArray[i]);
            }
            return object;
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, RT.byteCast((long)Casts.longCast(object)));
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static class ObjectArrayList
    implements IArrayList {
        Object[] data;
        int nElems;
        IPersistentMap meta;

        public ObjectArrayList(Object[] objectArray, int n, IPersistentMap iPersistentMap) {
            this.data = objectArray;
            this.nElems = n;
        }

        public ObjectArrayList(int n) {
            this(new Object[n], 0, null);
        }

        public ObjectArrayList() {
            this(4);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, 0, this.nElems);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems)];
        }

        @Override
        public Object set(int n, Object object) {
            n = ArrayLists.checkIndex(n, this.nElems);
            Object object2 = this.data[n];
            this.data[n] = object;
            return object2;
        }

        public int capacity() {
            return this.data.length;
        }

        @Override
        public Object[] ensureCapacity(int n) {
            Object[] objectArray = this.data;
            if (n >= objectArray.length) {
                this.data = Arrays.copyOf(objectArray, ArrayLists.newArrayLen(n));
                objectArray = this.data;
            }
            return objectArray;
        }

        @Override
        public boolean add(Object object) {
            int n = this.nElems;
            Object[] objectArray = this.ensureCapacity(n + 1);
            objectArray[n] = object;
            this.nElems = n + 1;
            return true;
        }

        @Override
        public void add(int n, Object object) {
            if ((n = ArrayLists.checkIndex(n, this.nElems)) == this.nElems) {
                this.add(object);
                return;
            }
            int n2 = this.nElems;
            Object[] objectArray = this.ensureCapacity(n2 + 1);
            System.arraycopy(objectArray, n, objectArray, n + 1, n2 - n);
            objectArray[n] = object;
            this.nElems = n2 + 1;
        }

        @Override
        public boolean addAllReducible(Object object) {
            int n = this.size();
            if (object instanceof RandomAccess) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return false;
                }
                int n2 = list.size();
                this.ensureCapacity(n2 + n);
                this.nElems += n2;
                this.fillRange(n, list);
            } else {
                IArrayList.super.addAllReducible(object);
            }
            return n != this.size();
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n, n2, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            this.meta = iPersistentMap;
            return this;
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.data, this.nElems);
        }

        @Override
        public void removeRange(int n, int n2) {
            ArrayLists.checkIndexRange(this.nElems, n, n2);
            System.arraycopy(this.data, n, this.data, n2, this.nElems - n2);
            Arrays.fill(this.data, n2, this.nElems, null);
            this.nElems -= n2 - n;
        }

        @Override
        public Object reduce(IFn iFn) {
            return this.subList(0, this.nElems).reduce(iFn);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return this.subList(0, this.nElems).reduce(iFn, object);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            this.subList(0, this.nElems).sort(comparator);
        }

        @Override
        public void shuffle(Random random) {
            this.subList(0, this.nElems).shuffle(random);
        }

        @Override
        public void forEach(Consumer consumer) {
            int n = this.nElems;
            Object[] objectArray = this.data;
            for (int i = 0; i < n; ++i) {
                consumer.accept(objectArray[i]);
            }
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.nElems, n, n2);
            Arrays.fill(this.data, n, n2, object);
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            return Arrays.copyOfRange(this.data, n, n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOf(this.data, n);
        }

        public static ObjectArrayList wrap(Object[] objectArray, int n, IPersistentMap iPersistentMap) {
            if (objectArray.length < n) {
                throw new RuntimeException("Array len less than required");
            }
            return new ObjectArrayList(objectArray, n, iPersistentMap);
        }

        public static ObjectArrayList wrap(Object[] objectArray, IPersistentMap iPersistentMap) {
            return new ObjectArrayList(objectArray, objectArray.length, iPersistentMap);
        }
    }

    public static class ObjectArraySubList
    implements IArrayList {
        public final Object[] data;
        public final int sidx;
        public final int eidx;
        public final int nElems;
        public final IPersistentMap meta;

        public ObjectArraySubList(Object[] objectArray, int n, int n2, IPersistentMap iPersistentMap) {
            this.data = objectArray;
            this.sidx = n;
            this.eidx = n2;
            this.nElems = this.eidx - this.sidx;
            this.meta = iPersistentMap;
        }

        public boolean isCompatible(Object object) {
            return object instanceof Object[];
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public ArraySection getArraySection() {
            return new ArraySection(this.data, this.sidx, this.eidx);
        }

        @Override
        public Class containedType() {
            return this.data.getClass().getComponentType();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.data[ArrayLists.checkIndex(n, this.nElems) + this.sidx];
        }

        @Override
        public Object set(int n, Object object) {
            n = ArrayLists.checkIndex(n, this.nElems) + this.sidx;
            Object object2 = this.data[n];
            this.data[n] = object;
            return object2;
        }

        @Override
        public IMutList<Object> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.size());
            return ArrayLists.toList(this.data, n + this.sidx, n2 + this.sidx, this.meta());
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public IObj withMeta(IPersistentMap iPersistentMap) {
            return ArrayLists.toList(this.data, this.sidx, this.eidx, iPersistentMap);
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOfRange(this.data, this.sidx, this.eidx);
        }

        @Override
        public void sort(Comparator<? super Object> comparator) {
            if (comparator == null) {
                Arrays.sort(this.data, this.sidx, this.eidx);
            } else {
                Arrays.sort(this.data, this.sidx, this.eidx, comparator);
            }
        }

        @Override
        public void shuffle(Random random) {
            ObjectArrays.shuffle((Object[])this.data, (int)this.sidx, (int)this.eidx, (Random)random);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return ArrayLists.fixSubArrayBinarySearch(this.sidx, this.size(), comparator == null ? ObjectArrays.binarySearch((Object[])this.data, (int)this.sidx, (int)this.eidx, (Object)object) : ObjectArrays.binarySearch((Object[])this.data, (int)this.sidx, (int)this.eidx, (Object)object, (Comparator)comparator));
        }

        @Override
        public void forEach(Consumer consumer) {
            int n = this.eidx;
            Object[] objectArray = this.data;
            for (int i = this.sidx; i < n; ++i) {
                consumer.accept(objectArray[i]);
            }
        }

        @Override
        public void fill(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            Arrays.fill(this.data, this.sidx + n, this.sidx + n2, object);
        }

        @Override
        public Object copyOfRange(int n, int n2) {
            return Arrays.copyOfRange(this.data, this.sidx + n, this.sidx + n2);
        }

        @Override
        public Object copyOf(int n) {
            return Arrays.copyOfRange(this.data, this.sidx, this.sidx + n);
        }
    }

    public static interface IDoubleArrayList
    extends DoubleMutList,
    ArrayOwner,
    TypedList,
    ArrayPersistentVector {
        @Override
        default public Class containedType() {
            return this.getArraySection().array.getClass().getComponentType();
        }

        @Override
        default public IPersistentVector unsafeImmut() {
            return ImmutList.create(true, this.meta(), (Object[])this.getArraySection().array);
        }

        @Override
        default public List immutShuffle(Random random) {
            return ArrayLists.immutShuffleDefault(this, random);
        }

        @Override
        default public List immutSort(Comparator comparator) {
            return ArrayLists.immutSortDefault(this, comparator);
        }

        @Override
        default public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            this.fill(n, n2, object);
        }

        @Override
        default public void fillRange(int n, List list) {
            ArraySection arraySection = this.getArraySection();
            if (!ArrayLists.fillRangeArrayCopy(arraySection.array, arraySection.sidx, arraySection.eidx, this.containedType(), n, list)) {
                DoubleMutList.super.fillRange(n, list);
            }
        }

        @Override
        default public Object toNativeArray() {
            return this.copyOf(this.size());
        }

        default public Object ensureCapacity(int n) {
            throw new RuntimeException("unimplemented");
        }
    }

    public static interface ILongArrayList
    extends LongMutList,
    ArrayOwner,
    TypedList,
    ArrayPersistentVector {
        @Override
        default public Class containedType() {
            return this.getArraySection().array.getClass().getComponentType();
        }

        @Override
        default public IPersistentVector unsafeImmut() {
            return ImmutList.create(true, this.meta(), (Object[])this.getArraySection().array);
        }

        @Override
        default public List immutShuffle(Random random) {
            return ArrayLists.immutShuffleDefault(this, random);
        }

        @Override
        default public List immutSort(Comparator comparator) {
            return ArrayLists.immutSortDefault(this, comparator);
        }

        @Override
        default public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            this.fill(n, n2, object);
        }

        @Override
        default public void fillRange(int n, List list) {
            ArraySection arraySection = this.getArraySection();
            if (!ArrayLists.fillRangeArrayCopy(arraySection.array, arraySection.sidx, arraySection.eidx, this.containedType(), n, list)) {
                LongMutList.super.fillRange(n, list);
            }
        }

        @Override
        default public Object reduce(IFn iFn, Object object) {
            return LongMutList.super.reduce(iFn, object);
        }

        @Override
        default public Object toNativeArray() {
            return this.copyOf(this.size());
        }

        default public Object ensureCapacity(int n) {
            throw new RuntimeException("unimplemented");
        }
    }

    public static interface IArrayList
    extends IMutList<Object>,
    ArrayOwner,
    TypedList,
    ArrayPersistentVector {
        @Override
        default public Class containedType() {
            return this.getArraySection().array.getClass().getComponentType();
        }

        @Override
        default public IPersistentVector unsafeImmut() {
            return ImmutList.create(true, this.meta(), (Object[])this.getArraySection().array);
        }

        @Override
        default public List immutShuffle(Random random) {
            return ArrayLists.immutShuffleDefault(this, random);
        }

        @Override
        default public List immutSort(Comparator comparator) {
            return ArrayLists.immutSortDefault(this, comparator);
        }

        @Override
        default public void fillRange(int n, int n2, Object object) {
            ArrayLists.checkIndexRange(this.size(), n, n2);
            this.fill(n, n2, object);
        }

        @Override
        default public void fillRange(int n, List list) {
            ArraySection arraySection = this.getArraySection();
            if (!ArrayLists.fillRangeArrayCopy(arraySection.array, arraySection.sidx, arraySection.eidx, this.containedType(), n, list)) {
                int n2 = list.size() + n;
                int n3 = 0;
                while (n < n2) {
                    this.set(n, list.get(n3));
                    ++n;
                    ++n3;
                }
            }
        }

        default public Object[] ensureCapacity(int n) {
            throw new RuntimeException("unimplemented");
        }
    }

    public static interface ArrayPersistentVector
    extends IMutList<Object>,
    IPersistentVector {
        public IPersistentVector unsafeImmut();

        @Override
        default public boolean equiv(Object object) {
            return IMutList.super.equiv(object);
        }

        @Override
        default public IPersistentVector cons(Object object) {
            return this.immut().cons(object);
        }

        default public IPersistentVector assocN(int n, Object object) {
            return this.immut().assocN(n, object);
        }

        @Override
        default public int length() {
            return this.size();
        }

        @Override
        default public Associative assoc(Object object, Object object2) {
            return this.immut().assoc(object, object2);
        }

        default public IPersistentStack pop() {
            int n = this.size();
            if (n == 0) {
                throw new RuntimeException("Can't pop empty vector");
            }
            if (n == 1) {
                return ImmutList.EMPTY.withMeta(this.meta());
            }
            return this.immut().pop();
        }

        default public Object peek() {
            int n = this.size();
            if (n == 0) {
                return null;
            }
            return this.get(n - 1);
        }

        @Override
        default public ImmutList empty() {
            return ImmutList.EMPTY.withMeta(this.meta());
        }
    }

    public static interface ArrayOwner {
        public ArraySection getArraySection();

        public void fill(int var1, int var2, Object var3);

        public Object copyOfRange(int var1, int var2);

        public Object copyOf(int var1);
    }
}

