/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.Keyword;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.PersistentArrayMap;
import ham_fisted.Reducible;
import java.util.function.DoubleConsumer;

public final class Sum
implements DoubleConsumer,
Reducible,
IDeref {
    public static final Keyword sumKwd = Keyword.intern(null, (String)"sum");
    public static final Keyword nElemsKwd = Keyword.intern(null, (String)"n-elems");
    public double d0;
    public double d1;
    public double simpleSum;
    public long nElems;

    public void sumWithCompensation(double d) {
        double d2 = d - this.d1;
        double d3 = this.d0;
        double d4 = d3 + d2;
        this.d1 = d4 - d3 - d2;
        this.d0 = d4;
    }

    public double computeFinalSum() {
        double d = this.d0 + this.d1;
        if (Double.isNaN(d) && Double.isInfinite(this.simpleSum)) {
            return this.simpleSum;
        }
        return d;
    }

    public Sum(double d, double d2, double d3, long l) {
        this.d0 = d;
        this.d1 = d2;
        this.simpleSum = d3;
        this.nElems = l;
    }

    public Sum() {
        this(0.0, 0.0, 0.0, 0L);
    }

    @Override
    public void accept(double d) {
        this.sumWithCompensation(d);
        this.simpleSum += d;
        ++this.nElems;
    }

    public void merge(Sum sum) {
        long l = this.nElems;
        this.accept(sum.computeFinalSum());
        this.nElems = l + sum.nElems;
    }

    @Override
    public Sum reduce(Reducible reducible) {
        Sum sum = new Sum(this.d0, this.d1, this.simpleSum, this.nElems);
        sum.merge((Sum)reducible);
        return sum;
    }

    public Object deref() {
        return new PersistentArrayMap(BitmapTrieCommon.defaultHashProvider, sumKwd, this.computeFinalSum(), nElemsKwd, this.nElems, null);
    }

    public static class SimpleSum
    implements DoubleConsumer,
    IDeref,
    Reducible {
        double simpleSum;

        public SimpleSum() {
            this.simpleSum = 0.0;
        }

        public SimpleSum(SimpleSum simpleSum) {
            this.simpleSum = simpleSum.simpleSum;
        }

        @Override
        public void accept(double d) {
            this.simpleSum += d;
        }

        @Override
        public SimpleSum reduce(Reducible reducible) {
            SimpleSum simpleSum = new SimpleSum(this);
            simpleSum.accept(((SimpleSum)reducible).simpleSum);
            return simpleSum;
        }

        public Object deref() {
            return this.simpleSum;
        }
    }
}

