/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import ham_fisted.IMutList;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;

public class RandomAccessSpliterator<E>
implements Spliterator<E> {
    private final List<E> list;
    private final int sidx;
    private int eidx;
    int curIdx;

    RandomAccessSpliterator(List<E> list, int n, int n2) {
        assert (list instanceof RandomAccess);
        this.list = list;
        this.sidx = n;
        this.eidx = n2;
        this.curIdx = n;
    }

    RandomAccessSpliterator(List<E> list) {
        this(list, 0, list.size());
    }

    @Override
    public Spliterator<E> trySplit() {
        int n = (this.eidx - this.sidx) / 2;
        RandomAccessSpliterator<E> randomAccessSpliterator = new RandomAccessSpliterator<E>(this.list, n, this.eidx);
        this.eidx = n;
        return randomAccessSpliterator;
    }

    @Override
    public long estimateSize() {
        return this.eidx - this.sidx;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> consumer) {
        boolean bl;
        if (consumer == null) {
            throw new NullPointerException();
        }
        boolean bl2 = bl = this.curIdx < this.eidx;
        if (bl) {
            consumer.accept(this.list.get(this.curIdx));
            ++this.curIdx;
        }
        return bl;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> consumer) {
        IMutList iMutList;
        int n = this.eidx;
        if (this.list instanceof IMutList) {
            iMutList = (IMutList)this.list;
            if (consumer instanceof DoubleConsumer) {
                DoubleConsumer doubleConsumer = (DoubleConsumer)((Object)consumer);
                for (int i = this.curIdx; i < n; ++i) {
                    doubleConsumer.accept(iMutList.getDouble(i));
                }
                this.curIdx = this.eidx;
                return;
            }
            if (consumer instanceof LongConsumer) {
                LongConsumer longConsumer = (LongConsumer)((Object)consumer);
                for (int i = this.curIdx; i < n; ++i) {
                    longConsumer.accept(iMutList.getLong(i));
                }
                this.curIdx = this.eidx;
                return;
            }
        }
        iMutList = this.list;
        for (int i = this.curIdx; i < n; ++i) {
            consumer.accept(iMutList.get(i));
        }
        this.curIdx = this.eidx;
    }

    @Override
    public int characteristics() {
        return 17488;
    }
}

