/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.RT;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ChunkedList;
import ham_fisted.DoubleMutList;
import ham_fisted.IMutList;
import ham_fisted.LongMutList;
import ham_fisted.TypedList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class ConstList
implements IMutList<Object>,
TypedList {
    public final long nElems;
    public final Object value;
    public final IPersistentMap meta;

    public ConstList(long l, Object object, IPersistentMap iPersistentMap) {
        this.nElems = l;
        this.value = object;
        this.meta = iPersistentMap;
    }

    @Override
    public IMutList cloneList() {
        return this;
    }

    @Override
    public Class containedType() {
        return this.value != null ? this.value.getClass() : Object.class;
    }

    public static ConstList create(long l, Object object, IPersistentMap iPersistentMap) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof Character) {
            return new LongConstList(l, Casts.longCast(object), iPersistentMap);
        }
        if (object instanceof Double || object instanceof Float) {
            return new DoubleConstList(l, Casts.doubleCast(object), iPersistentMap);
        }
        return new ConstList(l, object, iPersistentMap);
    }

    @Override
    public int size() {
        return RT.intCast((long)this.nElems);
    }

    @Override
    public Object get(int n) {
        return this.value;
    }

    public ConstList subList(long l, long l2) {
        ChunkedList.sublistCheck(l, l2, this.nElems);
        return ConstList.create(l2 - l, this.value, this.meta);
    }

    @Override
    public ConstList subList(int n, int n2) {
        return this.subList((long)n, (long)n2);
    }

    public void sort(Comparable comparable) {
    }

    public ConstList immutSort(Comparable comparable) {
        return this;
    }

    public ConstList ImmutSort() {
        return this;
    }

    @Override
    public ConstList reverse() {
        return this;
    }

    public int[] sortIndirect() {
        return ArrayLists.iarange(0, this.size(), 1);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Arrays.fill(objectArray, this.value);
        return objectArray;
    }

    @Override
    public int[] toIntArray() {
        int n = RT.intCast((long)Casts.longCast(this.value));
        int[] nArray = new int[this.size()];
        Arrays.fill(nArray, n);
        return nArray;
    }

    @Override
    public long[] toLongArray() {
        long l = Casts.longCast(this.value);
        long[] lArray = new long[this.size()];
        Arrays.fill(lArray, l);
        return lArray;
    }

    @Override
    public double[] toDoubleArray() {
        double d = Casts.doubleCast(this.value);
        double[] dArray = new double[this.size()];
        Arrays.fill(dArray, d);
        return dArray;
    }

    @Override
    public ConstList reindex(int[] nArray) {
        return ConstList.create(nArray.length, this.value, this.meta);
    }

    @Override
    public List immutShuffle(Random random) {
        return this;
    }

    @Override
    public IntComparator indexComparator(Comparator comparator) {
        return new IntComparator(){

            public int compare(int n, int n2) {
                return 0;
            }
        };
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public ConstList withMeta(IPersistentMap iPersistentMap) {
        return ConstList.create(this.nElems, this.value, iPersistentMap);
    }

    public static class DoubleConstList
    extends ConstList
    implements DoubleMutList {
        public final double lval;

        public DoubleConstList(long l, double d, IPersistentMap iPersistentMap) {
            super(l, d, iPersistentMap);
            this.lval = d;
        }

        @Override
        public Class containedType() {
            return Double.TYPE;
        }

        @Override
        public double getDouble(int n) {
            return this.lval;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return DoubleMutList.super.reduce(iFn, object);
        }

        @Override
        public Object longReduction(IFn.OLO oLO, Object object) {
            return DoubleMutList.super.longReduction(oLO, object);
        }
    }

    public static class LongConstList
    extends ConstList
    implements LongMutList {
        public final long lval;

        public LongConstList(long l, long l2, IPersistentMap iPersistentMap) {
            super(l, l2, iPersistentMap);
            this.lval = l2;
        }

        @Override
        public Class containedType() {
            return Long.TYPE;
        }

        @Override
        public long getLong(int n) {
            return this.lval;
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return LongMutList.super.reduce(iFn, object);
        }

        @Override
        public Object doubleReduction(IFn.ODO oDO, Object object) {
            return LongMutList.super.doubleReduction(oDO, object);
        }
    }
}

