/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import ham_fisted.IndexedConsumer;
import ham_fisted.IndexedDoubleConsumer;
import ham_fisted.IndexedLongConsumer;
import ham_fisted.Reducible;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;

public class Consumers {
    public static IndexedDoubleConsumer asIndexedDoubleConsumer(Object object) {
        if (object instanceof IndexedDoubleConsumer) {
            return (IndexedDoubleConsumer)object;
        }
        return null;
    }

    public static IndexedLongConsumer asIndexedLongConsumer(Object object) {
        if (object instanceof IndexedLongConsumer) {
            return (IndexedLongConsumer)object;
        }
        return null;
    }

    public static IndexedConsumer asIndexedConsumer(Object object) {
        if (object instanceof IndexedConsumer) {
            return (IndexedConsumer)object;
        }
        return null;
    }

    public static DoubleConsumer toDoubleConsumer(long l, IndexedDoubleConsumer indexedDoubleConsumer) {
        return new IndexedDoubleConsumerConverter(l, indexedDoubleConsumer);
    }

    public static LongConsumer toLongConsumer(long l, IndexedLongConsumer indexedLongConsumer) {
        return new IndexedLongConsumerConverter(l, indexedLongConsumer);
    }

    public static Consumer toConsumer(long l, IndexedConsumer indexedConsumer) {
        return new IndexedConsumerConverter(l, indexedConsumer);
    }

    public static DoubleConsumer map(final DoubleUnaryOperator doubleUnaryOperator, final DoubleConsumer doubleConsumer) {
        return new IDerefDoubleConsumer(){

            @Override
            public void accept(double d) {
                doubleConsumer.accept(doubleUnaryOperator.applyAsDouble(d));
            }

            public Object deref() {
                return ((IDeref)doubleConsumer).deref();
            }
        };
    }

    public static LongConsumer map(final LongUnaryOperator longUnaryOperator, final LongConsumer longConsumer) {
        return new IDerefLongConsumer(){

            @Override
            public void accept(long l) {
                longConsumer.accept(longUnaryOperator.applyAsLong(l));
            }

            public Object deref() {
                return ((IDeref)longConsumer).deref();
            }
        };
    }

    public static Consumer map(final Function function, final Consumer consumer) {
        return new IDerefConsumer(){

            public void accept(Object object) {
                consumer.accept(function.apply(object));
            }

            public Object deref() {
                return ((IDeref)consumer).deref();
            }
        };
    }

    public static IndexedDoubleConsumer map(final DoubleUnaryOperator doubleUnaryOperator, final IndexedDoubleConsumer indexedDoubleConsumer) {
        return new IDerefIndexedDoubleConsumer(){

            @Override
            public void accept(long l, double d) {
                indexedDoubleConsumer.accept(l, doubleUnaryOperator.applyAsDouble(d));
            }

            public Object deref() {
                return ((IDeref)indexedDoubleConsumer).deref();
            }
        };
    }

    public static IndexedLongConsumer map(final LongUnaryOperator longUnaryOperator, final IndexedLongConsumer indexedLongConsumer) {
        return new IDerefIndexedLongConsumer(){

            @Override
            public void accept(long l, long l2) {
                indexedLongConsumer.accept(l, longUnaryOperator.applyAsLong(l2));
            }

            public Object deref() {
                return ((IDeref)indexedLongConsumer).deref();
            }
        };
    }

    public static IndexedConsumer map(final Function function, final IndexedConsumer indexedConsumer) {
        return new IDerefIndexedConsumer(){

            @Override
            public void accept(long l, Object object) {
                indexedConsumer.accept(l, function.apply(object));
            }

            public Object deref() {
                return ((IDeref)indexedConsumer).deref();
            }
        };
    }

    public static DoubleConsumer filter(final DoublePredicate doublePredicate, final DoubleConsumer doubleConsumer) {
        return new IDerefDoubleConsumer(){

            @Override
            public void accept(double d) {
                if (doublePredicate.test(d)) {
                    doubleConsumer.accept(d);
                }
            }

            public Object deref() {
                return ((IDeref)doubleConsumer).deref();
            }
        };
    }

    public static LongConsumer filter(final LongPredicate longPredicate, final LongConsumer longConsumer) {
        return new IDerefLongConsumer(){

            @Override
            public void accept(long l) {
                if (longPredicate.test(l)) {
                    longConsumer.accept(l);
                }
            }

            public Object deref() {
                return ((IDeref)longConsumer).deref();
            }
        };
    }

    public static Consumer filter(final Predicate predicate, final Consumer consumer) {
        return new IDerefConsumer(){

            public void accept(Object object) {
                if (predicate.test(object)) {
                    consumer.accept(object);
                }
            }

            public Object deref() {
                return ((IDeref)consumer).deref();
            }
        };
    }

    public static IndexedDoubleConsumer filter(final DoublePredicate doublePredicate, final IndexedDoubleConsumer indexedDoubleConsumer) {
        return new IDerefIndexedDoubleConsumer(){

            @Override
            public void accept(long l, double d) {
                if (doublePredicate.test(d)) {
                    indexedDoubleConsumer.accept(l, d);
                }
            }

            public Object deref() {
                return ((IDeref)indexedDoubleConsumer).deref();
            }
        };
    }

    public static IndexedLongConsumer filter(final LongPredicate longPredicate, final IndexedLongConsumer indexedLongConsumer) {
        return new IDerefIndexedLongConsumer(){

            @Override
            public void accept(long l, long l2) {
                if (longPredicate.test(l2)) {
                    indexedLongConsumer.accept(l, l2);
                }
            }

            public Object deref() {
                return ((IDeref)indexedLongConsumer).deref();
            }
        };
    }

    public static IndexedConsumer filter(final Predicate predicate, final IndexedConsumer indexedConsumer) {
        return new IDerefIndexedConsumer(){

            @Override
            public void accept(long l, Object object) {
                if (predicate.test(object)) {
                    indexedConsumer.accept(l, object);
                }
            }

            public Object deref() {
                return ((IDeref)indexedConsumer).deref();
            }
        };
    }

    public static class IncConsumer
    implements Consumer,
    Reducible,
    IDeref {
        long nElems;

        public void accept(Object object) {
            ++this.nElems;
        }

        @Override
        public IncConsumer reduce(Reducible reducible) {
            this.nElems += ((IncConsumer)reducible).nElems;
            return this;
        }

        public Object deref() {
            return this.nElems;
        }
    }

    public static final class IndexedConsumerConverter
    implements IDerefConsumer {
        long idx;
        public final IndexedConsumer c;

        public IndexedConsumerConverter(long l, IndexedConsumer indexedConsumer) {
            this.idx = l;
            this.c = indexedConsumer;
        }

        public void accept(Object object) {
            this.c.accept(this.idx, object);
            ++this.idx;
        }

        public Object deref() {
            return ((IDeref)this.c).deref();
        }
    }

    public static final class IndexedLongConsumerConverter
    implements IDerefLongConsumer {
        long idx;
        public final IndexedLongConsumer c;

        public IndexedLongConsumerConverter(long l, IndexedLongConsumer indexedLongConsumer) {
            this.idx = l;
            this.c = indexedLongConsumer;
        }

        @Override
        public void accept(long l) {
            this.c.accept(this.idx, l);
            ++this.idx;
        }

        public Object deref() {
            return ((IDeref)this.c).deref();
        }
    }

    public static final class IndexedDoubleConsumerConverter
    implements IDerefDoubleConsumer {
        long idx;
        public final IndexedDoubleConsumer c;

        public IndexedDoubleConsumerConverter(long l, IndexedDoubleConsumer indexedDoubleConsumer) {
            this.idx = l;
            this.c = indexedDoubleConsumer;
        }

        @Override
        public void accept(double d) {
            this.c.accept(this.idx, d);
            ++this.idx;
        }

        public Object deref() {
            return ((IDeref)this.c).deref();
        }
    }

    public static interface IDerefIndexedConsumer
    extends IDeref,
    IndexedConsumer {
    }

    public static interface IDerefIndexedLongConsumer
    extends IDeref,
    IndexedLongConsumer {
    }

    public static interface IDerefIndexedDoubleConsumer
    extends IDeref,
    IndexedDoubleConsumer {
    }

    public static interface IDerefConsumer
    extends IDeref,
    Consumer {
    }

    public static interface IDerefLongConsumer
    extends IDeref,
    LongConsumer {
    }

    public static interface IDerefDoubleConsumer
    extends IDeref,
    DoubleConsumer {
    }
}

