/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.ITransientVector;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.ChunkedList;
import ham_fisted.CljHash;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.ImmutList;
import ham_fisted.ImmutValues;
import ham_fisted.Transformables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.function.BiFunction;

public class MutList<E>
implements IMutList<E>,
ChunkedList.ChunkedListOwner,
Cloneable,
ITransientVector,
ImmutValues {
    final ChunkedList data;

    public MutList() {
        this.data = new ChunkedList();
    }

    public MutList(int n) {
        this.data = new ChunkedList(n);
    }

    public MutList(ChunkedList chunkedList) {
        this.data = new ChunkedList(chunkedList, false);
    }

    public MutList(MutList<E> mutList) {
        this(mutList.data.clone(0, mutList.data.nElems, 0, true));
    }

    @SafeVarargs
    public static <E> MutList<E> create(boolean bl, IPersistentMap iPersistentMap, E ... EArray) {
        return new MutList<E>(ChunkedList.create(bl, iPersistentMap, EArray));
    }

    @Override
    public final ChunkedList.ChunkedListSection getChunkedList() {
        return new ChunkedList.ChunkedListSection(this.data.data, 0, this.data.nElems);
    }

    public final MutList<E> clone() {
        return new MutList<E>(this);
    }

    @Override
    public final MutList<E> cloneList() {
        return this.clone();
    }

    @Override
    public final boolean add(E e) {
        this.data.add(e);
        return true;
    }

    @Override
    public final void add(int n, E e) {
        this.data.add(e, n);
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        return this.addAllReducible(collection);
    }

    @Override
    public final boolean addAllReducible(Object set) {
        if (set instanceof Map) {
            set = ((Map)((Object)set)).entrySet();
        }
        int n = this.size();
        if (set instanceof ChunkedList.ChunkedListOwner) {
            ChunkedList.ChunkedListSection chunkedListSection = ((ChunkedList.ChunkedListOwner)((Object)set)).getChunkedList();
            int n2 = this.data.nElems;
            int n3 = chunkedListSection.startidx;
            int n4 = chunkedListSection.endidx - n3;
            int n5 = n2 + n4;
            this.data.enlarge(n5);
            this.data.nElems = n5;
            Object[][] objectArray = this.data.data;
            Object[][] objectArray2 = chunkedListSection.data;
            while (n2 < n5) {
                int n6 = n2 / 32;
                int n7 = n3 / 32;
                int n8 = n5 - n2;
                int n9 = n2 % 32;
                int n10 = n3 % 32;
                int n11 = Math.min(n8, Math.min(32 - n9, 32 - n10));
                System.arraycopy(objectArray2[n7], n10, objectArray[n6], n9, n11);
                n2 += n11;
                n3 += n11;
            }
        } else if (set instanceof IReduceInit) {
            final ChunkedList chunkedList = this.data;
            if (set instanceof RandomAccess || set instanceof Counted) {
                int n12;
                int n13 = n12 = set instanceof RandomAccess ? ((List)((Object)set)).size() : ((Counted)set).count();
                if (n12 == 0) {
                    return false;
                }
                chunkedList.enlarge(n + n12);
                chunkedList.nElems = n + n12;
                chunkedList.fillRangeReduce(n, set);
            } else {
                ((IReduceInit)set).reduce((IFn)new IFnDef(){

                    @Override
                    public Object invoke(Object object, Object object2) {
                        chunkedList.add(object2);
                        return this;
                    }
                }, (Object)this);
            }
        } else if (set instanceof RandomAccess) {
            List list = (List)((Object)set);
            int n14 = list.size();
            this.data.enlarge(n14 + n);
            int n15 = n;
            this.data.nElems = n15 + n14;
            Object[][] objectArray = this.data.data;
            int n16 = 0;
            while (n16 < n14) {
                Object[] objectArray3 = objectArray[n15 / 32];
                int n17 = n15 % 32;
                int n18 = Math.min(objectArray3.length - n17, n14 - n16);
                int n19 = 0;
                while (n19 < n18) {
                    objectArray3[n17] = list.get(n16);
                    ++n19;
                    ++n17;
                    ++n16;
                }
                n15 += n18;
            }
        } else {
            if (!(set instanceof Iterable)) {
                throw new RuntimeException("Object must either be instance of IReduceInit or java.util.Iterable");
            }
            ((Iterable)set).forEach((? super T object) -> this.add(object));
        }
        return n != this.size();
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (n == this.data.nElems) {
            return this.addAll(collection);
        }
        this.indexCheck(n);
        if (!(collection instanceof RandomAccess)) {
            ArrayList<E> arrayList = new ArrayList<E>();
            arrayList.addAll(collection);
            collection = arrayList;
        }
        int n2 = collection.size();
        this.data.widen(n, n + n2);
        for (E e : collection) {
            this.data.setValue(n++, e);
        }
        return true;
    }

    @Override
    public final void clear() {
        this.data.clear();
    }

    @Override
    public final boolean contains(Object object) {
        return this.data.contains(0, this.data.nElems, object);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        return this.data.containsAll(0, this.data.nElems, collection);
    }

    final int indexCheck(int n) {
        return ChunkedList.indexCheck(0, this.data.nElems, n);
    }

    final int indexCheck(long l) {
        return ChunkedList.indexCheck(0, this.data.nElems, (int)l);
    }

    final int wrapIndexCheck(int n) {
        return ChunkedList.wrapIndexCheck(0, this.data.nElems, n);
    }

    @Override
    public final E set(int n, E e) {
        return (E)this.data.setValueRV(this.indexCheck(n), e);
    }

    @Override
    public final E get(int n) {
        return (E)this.data.getValue(this.indexCheck(n));
    }

    @Override
    public final int indexOf(Object object) {
        return this.data.indexOf(0, this.data.nElems, object);
    }

    @Override
    public final boolean isEmpty() {
        return this.data.nElems == 0;
    }

    @Override
    public final Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public final IMutList<E> subList(int n, int n2) {
        ChunkedList.sublistCheck(n, n2, this.size());
        return new SubMutList(n, n2, this.data);
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        return this.data.listIterator(n, this.data.nElems, null);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public final int lastIndexOf(Object object) {
        return this.data.lastIndexOf(0, this.data.nElems, object);
    }

    @Override
    public final E remove(int n) {
        Object object = this.data.getValue(n);
        this.data.shorten(n, n + 1);
        return (E)object;
    }

    public void fillRange(int n, int n2, Object object) {
        this.indexCheck(n);
        if (n2 < n || n2 > this.data.nElems) {
            throw new RuntimeException("End index out of range: " + String.valueOf(n2));
        }
        this.data.fillRange(n, n2, object);
    }

    public void fillRange(int n, List list) {
        this.indexCheck(n);
        int n2 = list.size();
        if (n2 < n || n2 > this.data.nElems) {
            throw new RuntimeException("End index out of range: " + String.valueOf(n2));
        }
        this.data.fillRangeReduce(n, list);
    }

    public void addRange(int n, int n2, Object object) {
        this.indexCheck(n);
        this.data.addRange(n, n2, object);
    }

    public void removeRange(int n, int n2) {
        this.indexCheck(n);
        if (n2 == n) {
            return;
        }
        if (n2 < n || n2 > this.data.nElems) {
            throw new RuntimeException("End index out of range: " + String.valueOf(n2));
        }
        this.data.shorten(n, n2);
    }

    @Override
    public final boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.remove(n);
        }
        return n != -1;
    }

    @Override
    public final boolean retainAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final boolean removeAll(Collection collection) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        return this.data.fillArray(Arrays.copyOf(TArray, this.data.nElems));
    }

    @Override
    public final Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public final int size() {
        return this.data.nElems;
    }

    public final int capacity() {
        return this.data.capacity;
    }

    @Override
    public final Object nth(int n) {
        return this.data.getValue(this.wrapIndexCheck(n));
    }

    @Override
    public final Object nth(int n, Object object) {
        if (n < 0) {
            n += this.data.nElems;
        }
        return n < this.data.nElems && n > -1 ? this.data.getValue(n) : object;
    }

    @Override
    public final Object invoke(Object object) {
        return this.nth(RT.intCast((Object)object));
    }

    @Override
    public final Object invoke(Object object, Object object2) {
        return this.nth(RT.intCast((Object)object), object2);
    }

    @Override
    public final int count() {
        return this.data.size();
    }

    @Override
    public final Object reduce(IFn iFn) {
        return this.data.reduce(0, this.data.nElems, iFn);
    }

    @Override
    public final Object reduce(IFn iFn, Object object) {
        return this.data.reduce(0, this.data.nElems, iFn, object);
    }

    @Override
    public final Object kvreduce(IFn iFn, Object object) {
        return this.data.kvreduce(0, this.data.nElems, iFn, object);
    }

    @Override
    public final ISeq seq() {
        return this.data.seq(0, this.data.nElems);
    }

    @Override
    public final ISeq rseq() {
        return this.data.rseq(0, this.data.nElems);
    }

    @Override
    public final int hashCode() {
        return this.data.hasheq(0, this.data.nElems);
    }

    @Override
    public final int hasheq() {
        return this.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return this.equiv(object);
    }

    @Override
    public final boolean equiv(Object object) {
        return CljHash.listEquiv(this, object);
    }

    public final String toString() {
        return Transformables.sequenceToString(this);
    }

    @Override
    public IPersistentMap meta() {
        return this.data.meta();
    }

    @Override
    public MutList<E> withMeta(IPersistentMap iPersistentMap) {
        return new MutList<E>(this.data.withMeta(iPersistentMap));
    }

    public final MutList<E> assocN(int n, Object object) {
        if (n == this.data.nElems) {
            this.add(object);
        }
        this.set(this.indexCheck(n), object);
        return this;
    }

    public final MutList<E> pop() {
        if (this.data.nElems == 0) {
            throw new RuntimeException("Cannot pop empty vector.");
        }
        this.remove(this.data.nElems - 1);
        return this;
    }

    @Override
    public final MutList<E> assoc(Object object, Object object2) {
        if (!Util.isInteger((Object)object)) {
            throw new RuntimeException("Vectors must have integer keys");
        }
        return this.assocN(RT.intCast((Object)object), object2);
    }

    public final MutList<E> conj(Object object) {
        this.add(object);
        return this;
    }

    @Override
    public final Object valAt(Object object) {
        return this.valAt(object, null);
    }

    @Override
    public final Object valAt(Object object, Object object2) {
        int n;
        if (Util.isInteger((Object)object) && (n = RT.intCast((Object)object)) >= 0 && n < this.data.nElems) {
            return this.data.getValue(n);
        }
        return object2;
    }

    public ImmutList persistent() {
        return new ImmutList(0, this.data.nElems, this.data);
    }

    @Override
    public ImmutList immutUpdateValues(BiFunction biFunction) {
        return this.persistent().immutUpdateValues(biFunction);
    }

    @Override
    public ImmutList immutUpdateValue(Object object, IFn iFn) {
        return this.persistent().immutUpdateValue(object, iFn);
    }

    public static class SubMutList<E>
    implements IMutList<E>,
    ChunkedList.ChunkedListOwner,
    Cloneable {
        final int startidx;
        final int nElems;
        final ChunkedList data;

        SubMutList(int n, int n2, ChunkedList chunkedList) {
            this.startidx = n;
            this.nElems = n2 - n;
            this.data = chunkedList;
        }

        @Override
        public final ChunkedList.ChunkedListSection getChunkedList() {
            return new ChunkedList.ChunkedListSection(this.data.data, this.startidx, this.startidx + this.nElems);
        }

        public final MutList<E> clone() {
            return new MutList(this.data.clone(this.startidx, this.startidx + this.nElems));
        }

        @Override
        public final MutList<E> cloneList() {
            return this.clone();
        }

        final int indexCheck(int n) {
            return ChunkedList.indexCheck(this.startidx, this.nElems, n);
        }

        final int wrapIndexCheck(int n) {
            return ChunkedList.wrapIndexCheck(this.startidx, this.nElems, n);
        }

        @Override
        public final int size() {
            return this.nElems;
        }

        @Override
        public final boolean isEmpty() {
            return this.nElems == 0;
        }

        @Override
        public final E set(int n, E e) {
            return (E)this.data.setValueRV(this.indexCheck(n), e);
        }

        @Override
        public final E get(int n) {
            return (E)this.data.getValue(this.indexCheck(n));
        }

        @Override
        public final int indexOf(Object object) {
            return this.data.indexOf(this.startidx, this.startidx + this.nElems, object);
        }

        @Override
        public final int lastIndexOf(Object object) {
            return this.data.lastIndexOf(this.startidx, this.startidx + this.nElems, object);
        }

        @Override
        public final boolean contains(Object object) {
            return this.data.contains(this.startidx, this.startidx + this.nElems, object);
        }

        @Override
        public final boolean containsAll(Collection<?> collection) {
            return this.data.containsAll(this.startidx, this.startidx + this.nElems, collection);
        }

        @Override
        public final Iterator<E> iterator() {
            return this.data.iterator(this.startidx, this.startidx + this.nElems);
        }

        @Override
        public final ListIterator<E> listIterator(int n) {
            return this.data.listIterator(this.indexCheck(n), this.startidx + this.nElems, null);
        }

        @Override
        public final ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public final IMutList<E> subList(int n, int n2) {
            ChunkedList.sublistCheck(n, n2, this.nElems);
            return new SubMutList<E>(n + this.startidx, n2 + this.startidx, this.data);
        }

        @Override
        public final Object[] toArray() {
            return this.data.toArray(this.startidx, this.startidx + this.nElems);
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            return this.data.fillArray(this.startidx, this.startidx + this.nElems, Arrays.copyOf(TArray, this.nElems));
        }

        @Override
        public final Object nth(int n) {
            return this.data.getValue(this.wrapIndexCheck(n));
        }

        @Override
        public final Object nth(int n, Object object) {
            if (n < 0) {
                n += this.data.nElems;
            }
            return n < this.data.nElems && n > -1 ? this.data.getValue(n + this.startidx) : object;
        }

        @Override
        public final Object invoke(Object object) {
            return this.nth(RT.intCast((Object)object));
        }

        @Override
        public final Object invoke(Object object, Object object2) {
            return this.nth(RT.intCast((Object)object), object2);
        }

        @Override
        public final int count() {
            return this.nElems;
        }

        @Override
        public final Object reduce(IFn iFn) {
            return this.data.reduce(this.startidx, this.startidx + this.nElems, iFn);
        }

        @Override
        public final Object reduce(IFn iFn, Object object) {
            return this.data.reduce(this.startidx, this.startidx + this.nElems, iFn, object);
        }

        @Override
        public final Object kvreduce(IFn iFn, Object object) {
            return this.data.kvreduce(this.startidx, this.startidx + this.nElems, iFn, object);
        }

        @Override
        public void fillRange(long l, long l2, Object object) {
            int n = this.indexCheck((int)l);
            if (l2 < l || l2 > (long)this.nElems) {
                throw new RuntimeException("End index out of range: " + String.valueOf(l2));
            }
            this.data.fillRange(n, (int)(l2 + (long)this.startidx), object);
        }

        @Override
        public void fillRange(long l, List list) {
            int n = this.indexCheck((int)l);
            int n2 = (int)l + list.size();
            if (n2 > this.nElems) {
                throw new RuntimeException("End index out of range: " + String.valueOf(n2));
            }
            this.data.fillRangeReduce(n, list);
        }

        @Override
        public final int hashCode() {
            return this.data.hasheq(this.startidx, this.startidx + this.nElems);
        }

        @Override
        public final int hasheq() {
            return this.hashCode();
        }

        public final String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public final boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public final boolean equiv(Object object) {
            return CljHash.listEquiv(this, object);
        }

        @Override
        public final ISeq seq() {
            return this.data.seq(this.startidx, this.startidx + this.nElems);
        }

        @Override
        public final ISeq rseq() {
            return this.data.rseq(this.startidx, this.startidx + this.nElems);
        }

        @Override
        public IPersistentMap meta() {
            return this.data.meta();
        }

        @Override
        public SubMutList<E> withMeta(IPersistentMap iPersistentMap) {
            return new SubMutList<E>(this.startidx, this.startidx + this.nElems, this.data.withMeta(iPersistentMap));
        }
    }
}

