/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IKVReduce;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMapIterable;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.MapEquivalence;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Seqable;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.CljHash;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.LeafNode;
import ham_fisted.MapData;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class MapBase<K, V>
implements Map<K, V>,
ITypedReduce,
IFnDef,
IHashEq,
ILookup,
Counted,
IMeta,
IMapIterable,
IKVReduce,
MapEquivalence,
Iterable,
Seqable {
    MapData ht;
    Set<Map.Entry<K, V>> entrySet;
    Set<K> keySet;

    public MapBase(MapData mapData) {
        this.ht = mapData;
    }

    @Override
    public int size() {
        return this.ht.size();
    }

    public int count() {
        return this.ht.size();
    }

    public MapBase<K, V> clone() {
        return new MapBase<K, V>(this.ht.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = (StringBuilder)this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                StringBuilder stringBuilder = (StringBuilder)object;
                LeafNode leafNode = (LeafNode)object2;
                if (stringBuilder.length() > 2) {
                    stringBuilder.append(",");
                }
                return stringBuilder.append(leafNode.k).append(" ").append(leafNode.v);
            }
        }, new StringBuilder().append("{"));
        return stringBuilder.append("}").toString();
    }

    @Override
    public final int hashCode() {
        return CljHash.mapHashcode(this);
    }

    public final int hasheq() {
        return this.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        return CljHash.mapEquiv(this, object);
    }

    public final boolean equiv(Object object) {
        return this.equals(object);
    }

    @Override
    public V get(Object object) {
        return (V)this.ht.get(object);
    }

    @Override
    public V getOrDefault(Object object, V v) {
        return (V)this.ht.getOrDefault(object, v);
    }

    @Override
    public V put(K k, V v) {
        return (V)this.ht.put(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Reductions.serialReduction(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object2;
                ((Map)object).put(entry.getKey(), entry.getValue());
                return object;
            }
        }, this, map);
    }

    @Override
    public boolean isEmpty() {
        return this.ht.isEmpty();
    }

    @Override
    public void clear() {
        this.ht.clear();
    }

    @Override
    public V remove(Object object) {
        BitmapTrieCommon.Box box = new BitmapTrieCommon.Box();
        this.ht.remove(object, box);
        return (V)box.obj;
    }

    MapBase<K, V> mutAssoc(K k, V v) {
        this.ht.mutAssoc(k, v);
        return this;
    }

    MapBase<K, V> mutDissoc(K k) {
        this.ht.mutDissoc(k);
        return this;
    }

    MapBase<K, V> mutUpdateValue(K k, IFn iFn) {
        this.ht.mutUpdateValue(k, iFn);
        return this;
    }

    MapBase<K, V> mutUpdateValues(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        this.ht.mutUpdateValues(biFunction);
        return this;
    }

    MapBase<K, V> mutConj(Object object) {
        if (object instanceof IPersistentVector) {
            IPersistentVector iPersistentVector = (IPersistentVector)object;
            if (iPersistentVector.count() != 2) {
                throw new RuntimeException("Vector length != 2 during conj");
            }
            return this.mutAssoc(iPersistentVector.nth(0), iPersistentVector.nth(1));
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return this.mutAssoc(entry.getKey(), entry.getValue());
        }
        Iterator iterator = ((Iterable)object).iterator();
        MapBase<Object, Object> mapBase = this;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            mapBase = mapBase.mutAssoc(entry.getKey(), entry.getValue());
        }
        return mapBase;
    }

    final V applyMapping(K k, BitmapTrieCommon.ILeaf iLeaf, Object object) {
        if (object == null) {
            this.ht.remove(k, new BitmapTrieCommon.Box());
        } else {
            iLeaf.val(object);
        }
        return (V)object;
    }

    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException("Compute function cannot be null");
        }
        return (V)this.ht.compute(k, biFunction);
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        int n = this.ht.size();
        BitmapTrieCommon.ILeaf iLeaf = this.ht.getOrCreate(k);
        try {
            return this.applyMapping(k, iLeaf, iLeaf.val() == null ? function.apply(k) : iLeaf.val());
        }
        catch (Exception exception) {
            if (n != this.ht.size()) {
                this.remove(k);
            }
            throw exception;
        }
    }

    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        BitmapTrieCommon.ILeaf iLeaf = this.ht.getNode(k);
        if (iLeaf == null || iLeaf.val() == null) {
            return null;
        }
        Object object = iLeaf.val();
        return this.applyMapping(k, iLeaf, biFunction.apply(k, object));
    }

    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        if (v == null || biFunction == null) {
            throw new NullPointerException("Neither value nor remapping function may be null");
        }
        return (V)this.ht.merge(k, v, biFunction);
    }

    @Override
    public void forEach(final BiConsumer<? super K, ? super V> biConsumer) {
        this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                biConsumer.accept(iLeaf.key(), iLeaf.val());
                return biConsumer;
            }
        }, biConsumer);
    }

    @Override
    public void replaceAll(final BiFunction<? super K, ? super V, ? extends V> biFunction) {
        this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                iLeaf.val(biFunction.apply(iLeaf.key(), iLeaf.val()));
                return biFunction;
            }
        }, biFunction);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.ht.containsKey(object);
    }

    @Override
    public boolean containsValue(final Object object) {
        return (Boolean)this.ht.reduce(BitmapTrieCommon.valIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object3, Object object2) {
                if (Objects.equals(object2, object)) {
                    return new Reduced((Object)true);
                }
                return false;
            }
        }, false);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public final Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    Iterator iterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return this.ht.iterator(function);
    }

    public Iterator iterator() {
        return this.entrySet().iterator();
    }

    public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }

    public Iterator keyIterator() {
        return this.ht.iterator(BitmapTrieCommon.keyIterFn);
    }

    public Iterator valIterator() {
        return this.ht.iterator(BitmapTrieCommon.valIterFn);
    }

    Spliterator spliterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return this.ht.spliterator(function);
    }

    Object reduce(Function<BitmapTrieCommon.ILeaf, Object> function, IFn iFn, Object object) {
        return this.ht.reduce(function, iFn, object);
    }

    public Object reduce(IFn iFn, Object object) {
        return ((IReduceInit)this.entrySet()).reduce(iFn, object);
    }

    @Override
    public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this.entrySet(), parallelOptions);
    }

    public Object kvreduce(final IFn iFn, Object object) {
        return this.ht.reduce(BitmapTrieCommon.identityIterFn, new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                BitmapTrieCommon.ILeaf iLeaf = (BitmapTrieCommon.ILeaf)object2;
                return iFn.invoke(object, iLeaf.key(), iLeaf.val());
            }
        }, object);
    }

    public final IMapEntry entryAt(Object object) {
        LeafNode leafNode = (LeafNode)this.ht.getNode(object);
        return leafNode == null ? null : new MapEntry(leafNode.key(), leafNode.val());
    }

    public Object valAt(Object object) {
        return this.get(object);
    }

    public Object valAt(Object object, Object object2) {
        return this.getOrDefault(object, object2);
    }

    @Override
    public final Object invoke(Object object) {
        return this.get(object);
    }

    @Override
    public final Object invoke(Object object, Object object2) {
        return this.getOrDefault(object, object2);
    }

    public ISeq seq() {
        return RT.chunkIteratorSeq((Iterator)this.iterator());
    }

    public IPersistentMap meta() {
        return this.ht.meta();
    }

    class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements ITypedReduce<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return MapBase.this.size();
        }

        @Override
        public final void clear() {
            MapBase.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            Iterator iterator = MapBase.this.iterator(BitmapTrieCommon.identityIterFn);
            return iterator;
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
            ITypedReduce.super.forEach(consumer);
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return MapBase.this.spliterator(BitmapTrieCommon.identityIterFn);
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            BitmapTrieCommon.ILeaf iLeaf = MapBase.this.ht.getNode(k);
            return iLeaf != null && Objects.equals(iLeaf.key(), k) && Objects.equals(iLeaf.val(), entry.getValue());
        }

        public Object reduce(IFn iFn, Object object) {
            return MapBase.this.reduce(BitmapTrieCommon.identityIterFn, iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }
    }

    class KeySet<K>
    extends AbstractSet<K>
    implements ITypedReduce<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return MapBase.this.size();
        }

        @Override
        public final void clear() {
            MapBase.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            Iterator iterator = MapBase.this.iterator(BitmapTrieCommon.keyIterFn);
            return iterator;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return MapBase.this.spliterator(BitmapTrieCommon.keyIterFn);
        }

        @Override
        public final boolean contains(Object object) {
            return MapBase.this.ht.getNode(object) != null;
        }

        public Object reduce(IFn iFn, Object object) {
            return MapBase.this.reduce(BitmapTrieCommon.keyIterFn, iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer<? super K> consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    class ValueCollection<V>
    extends AbstractCollection<V>
    implements ITypedReduce<V> {
        ValueCollection() {
        }

        @Override
        public final int size() {
            return MapBase.this.size();
        }

        @Override
        public final void clear() {
            MapBase.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            Iterator iterator = MapBase.this.iterator(BitmapTrieCommon.valIterFn);
            return iterator;
        }

        @Override
        public final Spliterator<V> spliterator() {
            return MapBase.this.spliterator(BitmapTrieCommon.valIterFn);
        }

        public Object reduce(IFn iFn, Object object) {
            return MapBase.this.reduce(BitmapTrieCommon.valIterFn, iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this, parallelOptions);
        }

        @Override
        public void forEach(final Consumer<? super V> consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }
}

