/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IFn;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.IMutList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

final class LeafNode
implements BitmapTrieCommon.INode,
BitmapTrieCommon.ILeaf,
Map.Entry,
IMutList {
    public final BitmapTrieCommon.TrieBase owner;
    public final int hashcode;
    public final Object k;
    Object v;
    LeafNode nextNode;

    public LeafNode(BitmapTrieCommon.TrieBase trieBase, Object object, int n, Object object2, LeafNode leafNode) {
        this.owner = trieBase;
        this.hashcode = n;
        this.k = object;
        this.v = object2;
        this.nextNode = leafNode;
        trieBase.inc();
    }

    public LeafNode(BitmapTrieCommon.TrieBase trieBase, Object object, int n, Object object2) {
        this(trieBase, object, n, object2, null);
    }

    public LeafNode(BitmapTrieCommon.TrieBase trieBase, Object object, int n) {
        this(trieBase, object, n, null, null);
    }

    public LeafNode(BitmapTrieCommon.TrieBase trieBase, LeafNode leafNode) {
        this.owner = trieBase;
        this.hashcode = leafNode.hashcode;
        this.k = leafNode.k;
        this.v = leafNode.v;
        this.nextNode = leafNode.nextNode;
    }

    @Override
    public final LeafNode clone(BitmapTrieCommon.TrieBase trieBase) {
        trieBase = trieBase == null ? this.owner : trieBase;
        return new LeafNode(trieBase, this.k, this.hashcode, this.v, this.nextNode != null ? this.nextNode.clone(trieBase) : null);
    }

    @Override
    public final LeafNode valueClone(BitmapTrieCommon.TrieBase trieBase, Iterator iterator) {
        trieBase = trieBase == null ? this.owner : trieBase;
        return new LeafNode(trieBase, this.k, this.hashcode, iterator.next(), this.nextNode != null ? this.nextNode.valueClone(trieBase, iterator) : null);
    }

    public final LeafNode setOwner(BitmapTrieCommon.TrieBase trieBase) {
        if (this.owner == trieBase) {
            return this;
        }
        return new LeafNode(trieBase, this);
    }

    public final void append(LeafNode leafNode) {
        if (this.nextNode == null) {
            this.nextNode = leafNode;
        } else {
            this.nextNode.append(leafNode);
        }
    }

    @Override
    public final int countLeaves() {
        return this.nextNode != null ? 1 + this.nextNode.countLeaves() : 1;
    }

    @Override
    public final Object key() {
        return this.k;
    }

    @Override
    public final Object val() {
        return this.v;
    }

    @Override
    public final Object val(Object object) {
        Object object2 = this.v;
        this.v = object;
        return object2;
    }

    public final Object getKey() {
        return this.k;
    }

    public final Object getValue() {
        return this.v;
    }

    public final Object setValue(Object object) {
        Object object2 = this.v;
        this.v = object;
        return object2;
    }

    @Override
    public final int size() {
        return 2;
    }

    @Override
    public final Object get(int n) {
        if (n == 0) {
            return this.k;
        }
        if (n == 1) {
            return this.v;
        }
        throw new RuntimeException("Index out of range.");
    }

    public final LeafNode getOrCreate(Object object, int n) {
        LeafNode leafNode;
        if (this.owner.equals(this.k, object)) {
            return this;
        }
        if (this.nextNode != null) {
            return this.nextNode.getOrCreate(object, n);
        }
        this.nextNode = leafNode = new LeafNode(this.owner, object, n);
        return leafNode;
    }

    public final LeafNode get(Object object) {
        if (this.owner.equals(this.k, object)) {
            return this;
        }
        if (this.nextNode != null) {
            return this.nextNode.get(object);
        }
        return null;
    }

    @Override
    public final LeafNode get(Object object, int n) {
        if (n == this.hashcode) {
            return this.get(object);
        }
        return null;
    }

    public final LeafNode remove(Object object, BitmapTrieCommon.Box box) {
        if (this.owner.equals(object, this.k)) {
            this.owner.dec();
            if (box != null) {
                box.obj = this.v;
            }
            return this.nextNode;
        }
        if (this.nextNode != null) {
            this.nextNode = this.nextNode.remove(object, box);
        }
        return this;
    }

    public final LeafNode assoc(BitmapTrieCommon.TrieBase trieBase, Object object, int n, Object object2) {
        LeafNode leafNode = this.setOwner(trieBase);
        if (trieBase.equals(object, this.k)) {
            leafNode.v = object2;
        } else {
            leafNode.nextNode = leafNode.nextNode != null ? leafNode.nextNode.assoc(trieBase, object, n, object2) : new LeafNode(trieBase, object, n, object2);
        }
        return leafNode;
    }

    @Override
    public final LeafNode immutUpdate(BitmapTrieCommon.TrieBase trieBase, BiFunction biFunction) {
        LeafNode leafNode = this.setOwner(trieBase);
        leafNode.val(biFunction.apply(leafNode.k, leafNode.v));
        leafNode.nextNode = leafNode.nextNode != null ? leafNode.nextNode.immutUpdate(trieBase, biFunction) : null;
        return leafNode;
    }

    @Override
    public final LeafNode immutUpdate(BitmapTrieCommon.TrieBase trieBase, Object object, int n, IFn iFn) {
        LeafNode leafNode = this.setOwner(trieBase);
        if (trieBase.equals(this.k, object)) {
            leafNode.v = iFn.invoke(leafNode.v);
            leafNode.nextNode = this.nextNode;
            return leafNode;
        }
        leafNode.nextNode = this.nextNode != null ? this.nextNode.immutUpdate(trieBase, object, n, iFn) : new LeafNode(trieBase, object, n, iFn.invoke(null));
        return leafNode;
    }

    public final LeafNode union(BitmapTrieCommon.TrieBase trieBase, Object object, Object object2, BiFunction biFunction) {
        LeafNode leafNode = this.setOwner(trieBase);
        if (this.owner.equals(object, this.k)) {
            leafNode.v = biFunction.apply(leafNode.v, object2);
        } else {
            leafNode.nextNode = this.nextNode != null ? this.nextNode.union(trieBase, object, object2, biFunction) : new LeafNode(trieBase, object, this.hashcode, object2);
        }
        return leafNode;
    }

    public final LeafNode dissoc(BitmapTrieCommon.TrieBase trieBase, Object object) {
        LeafNode leafNode;
        if (this.owner.equals(this.k, object)) {
            trieBase.dec();
            return this.nextNode;
        }
        if (this.nextNode != null && (leafNode = this.nextNode.dissoc(trieBase, this.k)) != this.nextNode) {
            LeafNode leafNode2 = this.setOwner(trieBase);
            leafNode2.nextNode = leafNode;
            return leafNode2;
        }
        return this;
    }

    @Override
    public final BitmapTrieCommon.INode dissoc(BitmapTrieCommon.TrieBase trieBase, Object object, int n) {
        if (this.hashcode == n) {
            return this.dissoc(trieBase, this.k);
        }
        return this;
    }

    @Override
    public final BitmapTrieCommon.LeafNodeIterator iterator() {
        return new LFIter(this);
    }

    public void print(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("leafNode - " + String.valueOf(this.k) + ": " + String.valueOf(this.v));
        ++n;
        if (this.nextNode != null) {
            this.nextNode.print(n);
        }
    }

    @Override
    public Object reduce(IFn iFn, Object object) {
        LeafNode leafNode = this;
        while (leafNode != null && !RT.isReduced((Object)object)) {
            object = iFn.invoke(object, (Object)leafNode);
            leafNode = leafNode.nextNode;
        }
        return object;
    }

    static class LFIter
    implements BitmapTrieCommon.LeafNodeIterator {
        LeafNode curNode;

        LFIter(LeafNode leafNode) {
            this.curNode = leafNode;
        }

        @Override
        public boolean hasNext() {
            return this.curNode != null;
        }

        @Override
        public LeafNode nextLeaf() {
            if (this.curNode == null) {
                throw new NoSuchElementException();
            }
            LeafNode leafNode = this.curNode;
            this.curNode = leafNode.nextNode;
            return leafNode;
        }
    }
}

