/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.HashTable;
import ham_fisted.IMutList;
import ham_fisted.MapData;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;

public class ArrayMap
implements MapData {
    BitmapTrieCommon.HashProvider hp;
    Object[] kvs;
    int length;
    IPersistentMap meta;

    public ArrayMap(BitmapTrieCommon.HashProvider hashProvider, Object[] objectArray, int n, IPersistentMap iPersistentMap) {
        this.hp = hashProvider;
        this.kvs = objectArray;
        this.meta = iPersistentMap;
        this.length = n;
    }

    public ArrayMap(BitmapTrieCommon.HashProvider hashProvider, Object[] objectArray) {
        this(hashProvider, objectArray, objectArray.length / 2, null);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public ArrayMap clone() {
        return new ArrayMap(this.hp, (Object[])this.kvs.clone(), this.length, this.meta);
    }

    @Override
    public ArrayMap shallowClone() {
        return this.clone();
    }

    public int index(Object object) {
        BitmapTrieCommon.HashProvider hashProvider = this.hp;
        int n = this.length;
        Object[] objectArray = this.kvs;
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            Object object2 = objectArray[n2];
            if (object2 != object && !hashProvider.equals(object2, object)) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public MapData withMeta(IPersistentMap iPersistentMap) {
        return new ArrayMap(this.hp, this.kvs, this.length, iPersistentMap);
    }

    @Override
    public BitmapTrieCommon.ILeaf getOrCreate(Object object) {
        int n = this.index(object);
        if (n != -1) {
            return new ArrayLeaf(this.kvs, n);
        }
        int n2 = this.kvs.length;
        int n3 = this.length;
        int n4 = n2;
        if (n2 == n3 * 2) {
            n4 = Math.max(4, n2 * 2);
        }
        n = n3 * 2;
        ++this.length;
        this.kvs = Arrays.copyOf(this.kvs, n4);
        this.kvs[n] = object;
        return new ArrayLeaf(this.kvs, n);
    }

    @Override
    public BitmapTrieCommon.ILeaf getNode(Object object) {
        int n = this.index(object);
        return n != -1 ? new ArrayLeaf(this.kvs, n) : null;
    }

    @Override
    public Object get(Object object) {
        int n = this.index(object);
        return n != -1 ? this.kvs[n + 1] : null;
    }

    @Override
    public Object getOrDefault(Object object, Object object2) {
        int n = this.index(object);
        return n != -1 ? this.kvs[n + 1] : object2;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.index(object) != -1;
    }

    @Override
    public void clear() {
        this.length = 0;
        Arrays.fill(this.kvs, null);
    }

    void backfill(int n) {
        int n2 = this.length--;
        int n3 = n2 * 2 - 1;
        for (int i = n; i < n3; ++i) {
            this.kvs[i] = this.kvs[i + 1];
        }
        this.kvs[n3] = null;
        this.kvs[n3 - 1] = null;
    }

    @Override
    public void remove(Object object, BitmapTrieCommon.Box box) {
        int n = this.index(object);
        if (n != -1) {
            if (box != null) {
                box.obj = this.kvs[n + 1];
            }
            this.backfill(n);
        }
    }

    public HashTable toMap() {
        int n = this.length;
        Object[] objectArray = this.kvs;
        HashTable hashTable = new HashTable(this.hp, 0.75f, (int)((double)n / 0.75), 0, null, this.meta);
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            hashTable.put(objectArray[n2], objectArray[n2 + 1]);
        }
        return hashTable;
    }

    MapData assocAt(int n, Object object, Object object2) {
        if (n == -1) {
            if (this.length == 8) {
                HashTable hashTable = this.toMap();
                hashTable.put(object, object2);
                return hashTable;
            }
            n = this.length * 2;
            ++this.length;
            if (n + 1 >= this.kvs.length) {
                this.kvs = Arrays.copyOf(this.kvs, this.kvs.length * 2);
            }
            this.kvs[n] = object;
            this.kvs[n + 1] = object2;
            return this;
        }
        this.kvs[n + 1] = object2;
        return this;
    }

    @Override
    public MapData mutAssoc(Object object, Object object2) {
        return this.assocAt(this.index(object), object, object2);
    }

    @Override
    public void mutDissoc(Object object) {
        int n = this.index(object);
        if (n != -1) {
            this.backfill(n);
        }
    }

    @Override
    public MapData mutUpdateValue(Object object, IFn iFn) {
        int n;
        return this.assocAt(n, object, (n = this.index(object)) == -1 ? iFn.invoke(null) : iFn.invoke(this.kvs[n + 1]));
    }

    @Override
    public void mutUpdateValues(BiFunction biFunction) {
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2 + 1;
            this.kvs[n2] = biFunction.apply(this.kvs[n2 - 1], this.kvs[n2]);
        }
    }

    @Override
    public Object reduce(Function<BitmapTrieCommon.ILeaf, Object> function, IFn iFn, Object object) {
        block7: {
            int n = this.length;
            if (function == BitmapTrieCommon.keyIterFn) break block7;
            if (function == BitmapTrieCommon.valIterFn) {
                for (int i = 0; i < n; ++i) {
                    if (!RT.isReduced((Object)(object = iFn.invoke(object, this.kvs[i * 2 + 1])))) continue;
                    return ((IDeref)object).deref();
                }
            } else if (function == BitmapTrieCommon.entryIterFn || function == BitmapTrieCommon.identityIterFn) {
                for (int i = 0; i < n; ++i) {
                    if (!RT.isReduced((Object)(object = iFn.invoke(object, (Object)new ArrayLeaf(this.kvs, i * 2))))) continue;
                    return ((IDeref)object).deref();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!RT.isReduced((Object)(object = iFn.invoke(object, function.apply(new ArrayLeaf(this.kvs, i * 2)))))) continue;
                    return ((IDeref)object).deref();
                }
            }
        }
        return object;
    }

    public IntFunction classifyLf(Function<BitmapTrieCommon.ILeaf, Object> function) {
        Object[] objectArray = this.kvs;
        if (function == BitmapTrieCommon.keyIterFn) {
            return n -> objectArray[n * 2];
        }
        if (function == BitmapTrieCommon.valIterFn) {
            return n -> objectArray[n * 2 + 1];
        }
        if (function == BitmapTrieCommon.identityIterFn || function == BitmapTrieCommon.entryIterFn) {
            return n -> new ArrayLeaf(objectArray, n * 2);
        }
        return n -> function.apply(new ArrayLeaf(objectArray, n * 2));
    }

    @Override
    public Iterator iterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new IndexIter(this.length, this.classifyLf(function));
    }

    @Override
    public Spliterator spliterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new IndexSpliterator(this.classifyLf(function), this.length);
    }

    @Override
    public BitmapTrieCommon.HashProvider hashProvider() {
        return this.hp;
    }

    static class IndexSpliterator
    implements Spliterator,
    IReduceInit {
        final IntFunction lf;
        int sidx;
        int eidx;

        public IndexSpliterator(IntFunction intFunction, int n) {
            this.lf = intFunction;
            this.sidx = 0;
            this.eidx = n;
        }

        public IndexSpliterator(IntFunction intFunction, int n, int n2) {
            this.lf = intFunction;
            this.sidx = n;
            this.eidx = n2;
        }

        @Override
        public long estimateSize() {
            return this.eidx - this.sidx;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        public Spliterator trySplit() {
            if (this.estimateSize() < 8L) {
                return null;
            }
            int n = this.eidx;
            int n2 = (int)(this.estimateSize() / 2L);
            this.eidx = this.sidx + n2;
            return new IndexSpliterator(this.lf, this.eidx, n);
        }

        public boolean tryAdvance(Consumer consumer) {
            if (this.sidx < this.eidx) {
                consumer.accept(this.lf.apply(this.sidx));
                ++this.sidx;
                return true;
            }
            return false;
        }

        public Object reduce(IFn iFn, Object object) {
            int n = this.eidx;
            for (int i = this.sidx; i < n; ++i) {
                if (!RT.isReduced((Object)(object = iFn.invoke(object, this.lf.apply(i))))) continue;
                return ((IDeref)object).deref();
            }
            return object;
        }
    }

    static class IndexIter
    implements Iterator {
        final int l;
        int idx;
        final IntFunction lf;

        public IndexIter(int n, IntFunction intFunction) {
            this.l = n;
            this.idx = 0;
            this.lf = intFunction;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.l;
        }

        public Object next() {
            Object r = this.lf.apply(this.idx);
            ++this.idx;
            return r;
        }
    }

    static class ArrayLeaf
    implements BitmapTrieCommon.ILeaf,
    Map.Entry,
    IMutList {
        final Object[] kvs;
        final int kidx;

        public ArrayLeaf(Object[] objectArray, int n) {
            this.kvs = objectArray;
            this.kidx = n;
        }

        @Override
        public Object key() {
            return this.kvs[this.kidx];
        }

        public Object getKey() {
            return this.kvs[this.kidx];
        }

        @Override
        public Object val() {
            return this.kvs[this.kidx + 1];
        }

        public Object getValue() {
            return this.kvs[this.kidx + 1];
        }

        public Object setValue(Object object) {
            return this.val(object);
        }

        @Override
        public Object val(Object object) {
            Object object2 = this.kvs[this.kidx + 1];
            this.kvs[this.kidx + 1] = object;
            return object2;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int n) {
            if (n == 0) {
                return this.kvs[this.kidx];
            }
            if (n == 1) {
                return this.kvs[this.kidx + 1];
            }
            throw new RuntimeException("Index out of range");
        }
    }
}

