/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.Casts;
import ham_fisted.IntegerOps;
import ham_fisted.LongLeafNode;
import ham_fisted.MapData;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class LongHashTable
implements BitmapTrieCommon.TrieBase,
MapData {
    static final BitmapTrieCommon.HashProvider hp = BitmapTrieCommon.equalHashProvider;
    int capacity;
    int mask;
    int length;
    int threshold;
    float loadFactor;
    LongLeafNode[] data;
    IPersistentMap meta;

    public LongHashTable(float f, int n, int n2, LongLeafNode[] longLeafNodeArray, IPersistentMap iPersistentMap) {
        this.loadFactor = f;
        this.capacity = IntegerOps.nextPow2(Math.max(4, n));
        this.mask = this.capacity - 1;
        this.length = n2;
        this.data = longLeafNodeArray == null ? new LongLeafNode[this.capacity] : longLeafNodeArray;
        this.meta = iPersistentMap;
        this.threshold = (int)((float)this.capacity * f);
    }

    public static int longHash(long l) {
        return IntegerOps.mixhash(Long.hashCode(l));
    }

    @Override
    public BitmapTrieCommon.HashProvider hashProvider() {
        return hp;
    }

    @Override
    public int hash(Object object) {
        return LongHashTable.longHash(Casts.longCast(object));
    }

    @Override
    public boolean equals(Object object, Object object2) {
        return hp.equals(object, object2);
    }

    @Override
    public void inc() {
        ++this.length;
    }

    @Override
    public void dec() {
        --this.length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public LongHashTable shallowClone() {
        return new LongHashTable(this.loadFactor, this.capacity, this.length, (LongLeafNode[])this.data.clone(), this.meta);
    }

    @Override
    public LongHashTable clone() {
        LongHashTable longHashTable = this.shallowClone();
        longHashTable.length = 0;
        int n = longHashTable.data.length;
        LongLeafNode[] longLeafNodeArray = longHashTable.data;
        for (int i = 0; i < n; ++i) {
            LongLeafNode longLeafNode = longLeafNodeArray[i];
            if (longLeafNode == null) continue;
            longLeafNodeArray[i] = longLeafNode.clone(longHashTable);
        }
        return longHashTable;
    }

    Object checkResize(Object object) {
        if (this.length >= this.threshold) {
            int n = this.capacity * 2;
            LongLeafNode[] longLeafNodeArray = new LongLeafNode[n];
            LongLeafNode[] longLeafNodeArray2 = this.data;
            int n2 = longLeafNodeArray2.length;
            int n3 = n - 1;
            for (int i = 0; i < n2; ++i) {
                LongLeafNode longLeafNode = longLeafNodeArray2[i];
                if (longLeafNode == null) continue;
                longLeafNodeArray2[i] = null;
                if (longLeafNode.nextNode == null) {
                    longLeafNodeArray[longLeafNode.hashcode & n3] = longLeafNode;
                    continue;
                }
                LongLeafNode longLeafNode2 = null;
                LongLeafNode longLeafNode3 = null;
                LongLeafNode longLeafNode4 = null;
                LongLeafNode longLeafNode5 = null;
                while (longLeafNode != null) {
                    LongLeafNode longLeafNode6 = longLeafNode;
                    longLeafNode = longLeafNode.nextNode;
                    if ((longLeafNode6.hashcode & n2) == 0) {
                        if (longLeafNode3 == null) {
                            longLeafNode2 = longLeafNode6;
                        } else {
                            longLeafNode3.nextNode = longLeafNode6;
                        }
                        longLeafNode3 = longLeafNode6;
                        continue;
                    }
                    if (longLeafNode5 == null) {
                        longLeafNode4 = longLeafNode6;
                    } else {
                        longLeafNode5.nextNode = longLeafNode6;
                    }
                    longLeafNode5 = longLeafNode6;
                }
                if (longLeafNode2 != null) {
                    longLeafNode3.nextNode = null;
                    longLeafNodeArray[i] = longLeafNode2;
                }
                if (longLeafNode4 == null) continue;
                longLeafNode5.nextNode = null;
                longLeafNodeArray[i + n2] = longLeafNode4;
            }
            this.capacity = n;
            this.threshold = (int)((float)n * this.loadFactor);
            this.mask = n3;
            this.data = longLeafNodeArray;
        }
        return object;
    }

    @Override
    public LongLeafNode getOrCreate(Object object) {
        long l = Casts.longCast(object);
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        BitmapTrieCommon.HashProvider hashProvider = hp;
        LongLeafNode longLeafNode = null;
        LongLeafNode longLeafNode2 = this.data[n2];
        while (longLeafNode2 != null) {
            longLeafNode = longLeafNode2;
            if (longLeafNode2.k == l) {
                return longLeafNode2;
            }
            longLeafNode2 = longLeafNode2.nextNode;
        }
        if (longLeafNode != null) {
            return (LongLeafNode)this.checkResize(longLeafNode.getOrCreate(l, n));
        }
        this.data[n2] = longLeafNode = new LongLeafNode(this, l, n, null, null);
        return (LongLeafNode)this.checkResize(longLeafNode);
    }

    public Object put(long l, Object object) {
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        BitmapTrieCommon.HashProvider hashProvider = hp;
        LongLeafNode longLeafNode = null;
        LongLeafNode longLeafNode2 = this.data[n2];
        while (longLeafNode2 != null) {
            longLeafNode = longLeafNode2;
            if (longLeafNode2.k == l) {
                Object object2 = longLeafNode2.v;
                longLeafNode2.v = object;
                return object2;
            }
            longLeafNode2 = longLeafNode2.nextNode;
        }
        longLeafNode2 = new LongLeafNode(this, l, n, object, null);
        if (longLeafNode != null) {
            longLeafNode.nextNode = longLeafNode2;
        } else {
            this.data[n2] = longLeafNode2;
        }
        return this.checkResize(null);
    }

    public LongLeafNode getNode(long l) {
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = this.data[n2];
        while (longLeafNode != null) {
            if (longLeafNode.k == l) {
                return longLeafNode;
            }
            longLeafNode = longLeafNode.nextNode;
        }
        return null;
    }

    @Override
    public LongLeafNode getNode(Object object) {
        return this.getNode(Casts.longCast(object));
    }

    @Override
    public Object getOrDefault(Object object, Object object2) {
        long l = Casts.longCast(object);
        LongLeafNode longLeafNode = this.data[LongHashTable.longHash(l) & this.mask];
        while (longLeafNode != null) {
            if (longLeafNode.k == l) {
                return longLeafNode.v;
            }
            longLeafNode = longLeafNode.nextNode;
        }
        return object2;
    }

    @Override
    public Object get(Object object) {
        long l = Casts.longCast(object);
        LongLeafNode longLeafNode = this.data[LongHashTable.longHash(l) & this.mask];
        while (longLeafNode != null) {
            if (longLeafNode.k == l) {
                return longLeafNode.v;
            }
            longLeafNode = longLeafNode.nextNode;
        }
        return null;
    }

    @Override
    public Object compute(Object object, BiFunction biFunction) {
        long l = Casts.longCast(object);
        BitmapTrieCommon.HashProvider hashProvider = hp;
        int n = LongHashTable.longHash(l);
        LongLeafNode[] longLeafNodeArray = this.data;
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = longLeafNodeArray[n2];
        LongLeafNode longLeafNode2 = null;
        while (longLeafNode != null && longLeafNode.k != l) {
            longLeafNode2 = longLeafNode;
            longLeafNode = longLeafNode.nextNode;
        }
        Object r = biFunction.apply(l, longLeafNode == null ? null : longLeafNode.v);
        if (longLeafNode != null) {
            if (r != null) {
                longLeafNode.v = r;
            } else {
                this.remove(l, null);
            }
        } else if (r != null) {
            LongLeafNode longLeafNode3 = new LongLeafNode(this, l, n, r, null);
            if (longLeafNode2 != null) {
                longLeafNode2.nextNode = longLeafNode3;
            } else {
                longLeafNodeArray[n2] = longLeafNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    @Override
    public Object computeIfAbsent(Object object, Function function) {
        long l = Casts.longCast(object);
        int n = LongHashTable.longHash(l);
        LongLeafNode[] longLeafNodeArray = this.data;
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = longLeafNodeArray[n2];
        LongLeafNode longLeafNode2 = null;
        while (longLeafNode != null && longLeafNode.k != l) {
            longLeafNode2 = longLeafNode;
            longLeafNode = longLeafNode.nextNode;
        }
        if (longLeafNode != null) {
            return longLeafNode.v;
        }
        Object r = function.apply(l);
        if (r != null) {
            LongLeafNode longLeafNode3 = new LongLeafNode(this, l, n, r, null);
            if (longLeafNode2 != null) {
                longLeafNode2.nextNode = longLeafNode3;
            } else {
                longLeafNodeArray[n2] = longLeafNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    @Override
    public Object merge(Object object, Object object2, BiFunction biFunction) {
        Object object3;
        long l = Casts.longCast(object);
        BitmapTrieCommon.HashProvider hashProvider = hp;
        int n = LongHashTable.longHash(l);
        LongLeafNode[] longLeafNodeArray = this.data;
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = longLeafNodeArray[n2];
        LongLeafNode longLeafNode2 = null;
        while (longLeafNode != null && longLeafNode.k != l) {
            longLeafNode2 = longLeafNode;
            longLeafNode = longLeafNode.nextNode;
        }
        Object object4 = object3 = longLeafNode == null ? object2 : biFunction.apply(longLeafNode.v, object2);
        if (longLeafNode != null) {
            if (object3 != null) {
                longLeafNode.v = object3;
            } else {
                this.remove(l, null);
            }
        } else if (object3 != null) {
            LongLeafNode longLeafNode3 = new LongLeafNode(this, l, n, object3, null);
            if (longLeafNode2 != null) {
                longLeafNode2.nextNode = longLeafNode3;
            } else {
                longLeafNodeArray[n2] = longLeafNode3;
            }
            this.checkResize(null);
        }
        return object3;
    }

    public LongHashTable union(LongHashTable longHashTable, BiFunction biFunction, boolean bl) {
        LongHashTable longHashTable2 = bl ? this.shallowClone() : this;
        LongLeafNode[] longLeafNodeArray = longHashTable.data;
        int n = longLeafNodeArray.length;
        LongLeafNode[] longLeafNodeArray2 = longHashTable2.data;
        int n2 = longHashTable2.mask;
        BitmapTrieCommon.HashProvider hashProvider = hp;
        for (int i = 0; i < n; ++i) {
            LongLeafNode longLeafNode = longLeafNodeArray[i];
            while (longLeafNode != null) {
                LongLeafNode longLeafNode2;
                int n3 = longLeafNode.hashcode & n2;
                long l = longLeafNode.k;
                LongLeafNode longLeafNode3 = longLeafNode2 = longLeafNodeArray2[n3];
                while (longLeafNode3 != null && longLeafNode3.k != l) {
                    longLeafNode3 = longLeafNode3.nextNode;
                }
                if (longLeafNode3 != null) {
                    longLeafNodeArray2[n3] = longLeafNode2.assoc(longHashTable2, longLeafNode.k, longLeafNode.hashcode, biFunction.apply(longLeafNode3.v, longLeafNode.v));
                } else {
                    longLeafNodeArray2[n3] = longLeafNode2 != null ? longLeafNode2.assoc(longHashTable2, longLeafNode.k, longLeafNode.hashcode, longLeafNode.v) : new LongLeafNode(longHashTable2, l, longLeafNode.hashcode, longLeafNode.v, null);
                    longHashTable2.checkResize(null);
                    n2 = longHashTable2.mask;
                    longLeafNodeArray2 = longHashTable2.data;
                }
                longLeafNode = longLeafNode.nextNode;
            }
        }
        return longHashTable2;
    }

    public LongHashTable intersection(LongHashTable longHashTable, BiFunction biFunction, boolean bl) {
        LongHashTable longHashTable2 = bl ? this.shallowClone() : this;
        LongLeafNode[] longLeafNodeArray = longHashTable.data;
        int n = longHashTable.mask;
        LongLeafNode[] longLeafNodeArray2 = longHashTable2.data;
        int n2 = longLeafNodeArray2.length;
        BitmapTrieCommon.HashProvider hashProvider = hp;
        for (int i = 0; i < n2; ++i) {
            LongLeafNode longLeafNode = longLeafNodeArray2[i];
            while (longLeafNode != null) {
                LongLeafNode longLeafNode2 = longLeafNode;
                longLeafNode = longLeafNode.nextNode;
                int n3 = longLeafNode2.hashcode & n;
                LongLeafNode longLeafNode3 = longLeafNodeArray[n3];
                long l = longLeafNode2.k;
                while (longLeafNode3 != null && longLeafNode3.k != l) {
                    longLeafNode3 = longLeafNode3.nextNode;
                }
                longLeafNodeArray2[i] = longLeafNode3 != null ? longLeafNodeArray2[i].assoc(longHashTable2, longLeafNode3.k, longLeafNode3.hashcode, biFunction.apply(longLeafNode2.v, longLeafNode3.v)) : longLeafNodeArray2[i].dissoc(longHashTable2, longLeafNode2.k);
            }
        }
        return longHashTable2;
    }

    public LongHashTable difference(LongHashTable longHashTable, boolean bl) {
        LongHashTable longHashTable2 = bl ? this.shallowClone() : this;
        LongLeafNode[] longLeafNodeArray = longHashTable.data;
        int n = longLeafNodeArray.length;
        LongLeafNode[] longLeafNodeArray2 = longHashTable2.data;
        int n2 = longHashTable2.mask;
        BitmapTrieCommon.HashProvider hashProvider = hp;
        for (int i = 0; i < n; ++i) {
            LongLeafNode longLeafNode = longLeafNodeArray[i];
            while (longLeafNode != null) {
                int n3 = longLeafNode.hashcode & n2;
                long l = longLeafNode.k;
                LongLeafNode longLeafNode2 = longLeafNodeArray2[n3];
                while (longLeafNode2 != null && longLeafNode2.k != l) {
                    longLeafNode2 = longLeafNode2.nextNode;
                }
                if (longLeafNode2 != null) {
                    longLeafNodeArray2[n3] = longLeafNodeArray2[n3].dissoc(longHashTable2, longLeafNode2.k);
                }
                longLeafNode = longLeafNode.nextNode;
            }
        }
        return longHashTable2;
    }

    @Override
    public void remove(Object object, BitmapTrieCommon.Box box) {
        long l = Casts.longCast(object);
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = this.data[n2];
        if (longLeafNode != null) {
            this.data[n2] = longLeafNode.remove(l, box);
        }
    }

    @Override
    public void clear() {
        this.length = 0;
        Arrays.fill(this.data, null);
    }

    @Override
    public LongHashTable mutAssoc(Object object, Object object2) {
        long l = Casts.longCast(object);
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = this.data[n2];
        LongLeafNode longLeafNode2 = longLeafNode != null ? longLeafNode.assoc(this, l, n, object2) : new LongLeafNode(this, l, n, object2, null);
        this.data[n2] = longLeafNode2;
        this.checkResize(null);
        return this;
    }

    @Override
    public LongHashTable mutDissoc(Object object) {
        long l = Casts.longCast(object);
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = this.data[n2];
        if (longLeafNode != null) {
            this.data[n2] = longLeafNode.dissoc(this, l);
        }
        return this;
    }

    @Override
    public Object reduce(Function<BitmapTrieCommon.ILeaf, Object> function, IFn iFn, Object object) {
        for (LongLeafNode longLeafNode : this.data) {
            while (longLeafNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(longLeafNode))))) {
                    return ((IDeref)object).deref();
                }
                longLeafNode = longLeafNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public void mutUpdateValues(BiFunction biFunction) {
        for (LongLeafNode longLeafNode : this.data) {
            var2_2[var4_4] = longLeafNode.immutUpdate(this, biFunction);
        }
    }

    @Override
    public LongHashTable mutUpdateValue(Object object, IFn iFn) {
        long l = Casts.longCast(object);
        int n = LongHashTable.longHash(l);
        int n2 = n & this.mask;
        LongLeafNode longLeafNode = this.data[n2];
        LongLeafNode longLeafNode2 = longLeafNode != null ? longLeafNode.immutUpdate(this, l, n, iFn) : new LongLeafNode(this, l, n, iFn.invoke(null));
        this.data[n2] = longLeafNode2;
        this.checkResize(null);
        return this;
    }

    @Override
    public Iterator iterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new HTIter(this.data, function);
    }

    @Override
    public Spliterator spliterator(Function<BitmapTrieCommon.ILeaf, Object> function) {
        return new HTSpliterator(this.data, this.length, function);
    }

    @Override
    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public LongHashTable withMeta(IPersistentMap iPersistentMap) {
        LongHashTable longHashTable = this.shallowClone();
        longHashTable.meta = iPersistentMap;
        return longHashTable;
    }

    static class HTIter
    implements Iterator {
        final LongLeafNode[] d;
        final Function<BitmapTrieCommon.ILeaf, Object> fn;
        LongLeafNode l;
        int idx;
        final int dlen;

        HTIter(LongLeafNode[] longLeafNodeArray, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.d = longLeafNodeArray;
            this.fn = function;
            this.l = null;
            this.idx = 0;
            this.dlen = this.d.length;
            this.advance();
        }

        void advance() {
            if (this.l != null) {
                this.l = this.l.nextNode;
            }
            if (this.l == null) {
                while (this.idx < this.dlen && this.l == null) {
                    this.l = this.d[this.idx];
                    ++this.idx;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.l != null;
        }

        public Object next() {
            LongLeafNode longLeafNode = this.l;
            this.advance();
            return this.fn.apply(longLeafNode);
        }
    }

    static class HTSpliterator
    implements Spliterator,
    IReduceInit {
        final LongLeafNode[] d;
        final Function<BitmapTrieCommon.ILeaf, Object> fn;
        int sidx;
        int eidx;
        int estimateSize;
        LongLeafNode l;

        public HTSpliterator(LongLeafNode[] longLeafNodeArray, int n, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.d = longLeafNodeArray;
            this.fn = function;
            this.sidx = 0;
            this.eidx = longLeafNodeArray.length;
            this.estimateSize = n;
            this.l = null;
        }

        public HTSpliterator(LongLeafNode[] longLeafNodeArray, int n, int n2, int n3, Function<BitmapTrieCommon.ILeaf, Object> function) {
            this.d = longLeafNodeArray;
            this.fn = function;
            this.sidx = n;
            this.eidx = n2;
            this.estimateSize = n3;
            this.l = null;
        }

        public HTSpliterator trySplit() {
            int n = this.eidx - this.sidx;
            if (n > 4) {
                int n2 = n / 2;
                int n3 = this.eidx;
                this.eidx = this.sidx + n2;
                this.estimateSize /= 2;
                return new HTSpliterator(this.d, this.eidx, n3, this.estimateSize, this.fn);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        @Override
        public long estimateSize() {
            return this.estimateSize;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        public boolean tryAdvance(Consumer consumer) {
            if (this.l != null) {
                consumer.accept(this.fn.apply(this.l));
                this.l = this.l.nextNode;
                return true;
            }
            while (this.sidx < this.eidx) {
                LongLeafNode longLeafNode = this.d[this.sidx];
                if (longLeafNode != null) {
                    consumer.accept(this.fn.apply(longLeafNode));
                    this.l = longLeafNode.nextNode;
                    return true;
                }
                ++this.sidx;
            }
            return false;
        }

        public Object reduce(IFn iFn, Object object) {
            LongLeafNode[] longLeafNodeArray = this.d;
            int n = this.eidx;
            Function<BitmapTrieCommon.ILeaf, Object> function = this.fn;
            for (int i = this.sidx; i < n; ++i) {
                LongLeafNode longLeafNode = longLeafNodeArray[i];
                while (longLeafNode != null) {
                    if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(longLeafNode))))) {
                        return ((IDeref)object).deref();
                    }
                    longLeafNode = longLeafNode.nextNode;
                }
            }
            return object;
        }
    }

    static interface Owner {
        public LongHashTable getLongHashTable();
    }
}

