/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.RT;
import clojure.lang.Sequential;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class BatchReducer
implements IFnDef.O,
ITypedReduce,
Sequential,
Iterable {
    final IFn batchSrc;
    List batchData;
    int idx;
    int nElems;

    public BatchReducer(IFn iFn) {
        this.batchSrc = iFn;
        this.batchData = null;
        this.idx = 0;
        this.nElems = 0;
    }

    public Object reduce(IFn iFn, Object object) {
        List list = this.batchData;
        int n = this.idx;
        int n2 = this.nElems;
        do {
            if (n != n2) continue;
            list = (List)this.batchSrc.invoke();
            n = 0;
            n2 = list.size();
        } while (!RT.isReduced((Object)(object = iFn.invoke(object, list.get(n++)))));
        this.batchData = list;
        this.idx = n;
        this.nElems = n2;
        return ((IDeref)object).deref();
    }

    @Override
    public Object invoke() {
        if (this.idx == this.nElems) {
            this.batchData = (List)this.batchSrc.invoke();
            this.idx = 0;
            this.nElems = this.batchData.size();
        }
        return this.batchData.get(this.idx++);
    }

    public Iterator iterator() {
        final BatchReducer batchReducer = this;
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return true;
            }

            public Object next() {
                return batchReducer.invoke();
            }
        };
    }

    public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }
}

