/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

public final class IntegerOps {
    public static final int nextPow2(int n) {
        int n2 = Integer.highestOneBit(n);
        if (n == n2) {
            return n;
        }
        return n2 << 1;
    }

    public static final int mask(int n, int n2) {
        return n2 >>> n & 0x1F;
    }

    public static final int bitpos(int n, int n2) {
        return 1 << IntegerOps.mask(n, n2);
    }

    public static final int index(int n, int n2) {
        return Integer.bitCount(n & n2 - 1);
    }

    public static final int incShift(int n) {
        return n + 5;
    }

    public static final int checkedIncShift(int n) {
        if (n >= 30) {
            throw new RuntimeException("Invalid shift amount - already at max shift - " + String.valueOf(n));
        }
        return n + 5;
    }

    public static final int mixhash(int n) {
        return n ^ n >>> 16;
    }

    public static final int mixhash(Object object) {
        return object == null ? 0 : IntegerOps.mixhash(object.hashCode());
    }

    public static final int highBits(int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            n3 |= 1 << i;
        }
        return n3;
    }
}

