/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.CljHash;
import ham_fisted.HBNode;
import ham_fisted.IFnDef;
import ham_fisted.IMap;
import ham_fisted.ITypedReduce;
import ham_fisted.IntegerOps;
import ham_fisted.ParallelOptions;
import ham_fisted.PersistentHashMap;
import ham_fisted.Reductions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class HashMap
implements IMap,
IMeta,
BitmapTrieCommon.MapSet {
    int capacity;
    int mask;
    int length;
    int threshold;
    float loadFactor;
    HBNode[] data;
    IPersistentMap meta;

    public HashMap(float f, int n, int n2, HBNode[] hBNodeArray, IPersistentMap iPersistentMap) {
        this.loadFactor = f;
        this.capacity = IntegerOps.nextPow2(Math.max(4, n));
        this.mask = this.capacity - 1;
        this.length = n2;
        this.data = hBNodeArray == null ? new HBNode[this.capacity] : hBNodeArray;
        this.threshold = (int)((float)this.capacity * f);
        this.meta = iPersistentMap;
    }

    public HashMap() {
        this(0.75f, 0, 0, null, null);
    }

    public HashMap(IPersistentMap iPersistentMap) {
        this(0.75f, 0, 0, null, iPersistentMap);
    }

    public HashMap(HashMap hashMap, IPersistentMap iPersistentMap) {
        this.loadFactor = hashMap.loadFactor;
        this.capacity = hashMap.capacity;
        this.mask = hashMap.mask;
        this.length = hashMap.length;
        this.data = hashMap.data;
        this.threshold = hashMap.threshold;
        this.meta = iPersistentMap;
    }

    protected int hash(Object object) {
        return object == null ? 0 : (object instanceof IHashEq ? ((IHashEq)object).hasheq() : IntegerOps.mixhash(object.hashCode()));
    }

    protected boolean equals(Object object, Object object2) {
        return object == object2 ? true : (object == null || object2 == null ? false : CljHash.nonNullEquiv(object, object2));
    }

    protected HBNode newNode(Object object, int n, Object object2) {
        return new HBNode(this, object, n, object2, null);
    }

    protected void inc(HBNode hBNode) {
        ++this.length;
    }

    protected void dec(HBNode hBNode) {
        --this.length;
    }

    protected void modify(HBNode hBNode) {
    }

    public HashMap shallowClone() {
        return new HashMap(this.loadFactor, this.capacity, this.length, (HBNode[])this.data.clone(), this.meta);
    }

    public HashMap clone() {
        int n = this.data.length;
        HBNode[] hBNodeArray = new HBNode[n];
        HashMap hashMap = new HashMap(this.loadFactor, this.capacity, this.length, hBNodeArray, this.meta);
        for (int i = 0; i < n; ++i) {
            HBNode hBNode = this.data[i];
            if (hBNode == null) continue;
            hBNodeArray[i] = hBNode.clone(hashMap);
        }
        return hashMap;
    }

    @Override
    public int hashCode() {
        return this.hasheq();
    }

    public int hasheq() {
        return CljHash.mapHashcode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this.equiv(object);
    }

    public boolean equiv(Object object) {
        return CljHash.mapEquiv(this, object);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = (StringBuilder)this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                StringBuilder stringBuilder = (StringBuilder)object;
                Map.Entry entry = (Map.Entry)object2;
                if (stringBuilder.length() > 2) {
                    stringBuilder.append(",");
                }
                return stringBuilder.append(entry.getKey()).append(" ").append(entry.getValue());
            }
        }, new StringBuilder().append("{"));
        return stringBuilder.append("}").toString();
    }

    Object checkResize(Object object) {
        if (this.length >= this.threshold) {
            int n = this.capacity * 2;
            HBNode[] hBNodeArray = new HBNode[n];
            HBNode[] hBNodeArray2 = this.data;
            int n2 = hBNodeArray2.length;
            int n3 = n - 1;
            for (int i = 0; i < n2; ++i) {
                HBNode hBNode = hBNodeArray2[i];
                if (hBNode == null) continue;
                hBNodeArray2[i] = null;
                if (hBNode.nextNode == null) {
                    hBNodeArray[hBNode.hashcode & n3] = hBNode;
                    continue;
                }
                HBNode hBNode2 = null;
                HBNode hBNode3 = null;
                HBNode hBNode4 = null;
                HBNode hBNode5 = null;
                while (hBNode != null) {
                    HBNode hBNode6 = hBNode.setOwner(this);
                    hBNode = hBNode.nextNode;
                    if ((hBNode6.hashcode & n2) == 0) {
                        if (hBNode3 == null) {
                            hBNode2 = hBNode6;
                        } else {
                            hBNode3.nextNode = hBNode6;
                        }
                        hBNode3 = hBNode6;
                        continue;
                    }
                    if (hBNode5 == null) {
                        hBNode4 = hBNode6;
                    } else {
                        hBNode5.nextNode = hBNode6;
                    }
                    hBNode5 = hBNode6;
                }
                if (hBNode2 != null) {
                    hBNode3.nextNode = null;
                    hBNodeArray[i] = hBNode2;
                }
                if (hBNode4 == null) continue;
                hBNode5.nextNode = null;
                hBNodeArray[i + n2] = hBNode4;
            }
            this.capacity = n;
            this.threshold = (int)((float)n * this.loadFactor);
            this.mask = n3;
            this.data = hBNodeArray;
        }
        return object;
    }

    public Object put(Object object, Object object2) {
        int n = this.hash(object);
        int n2 = n & this.mask;
        HBNode hBNode = null;
        HBNode hBNode2 = this.data[n2];
        while (hBNode2 != null) {
            hBNode = hBNode2;
            if (hBNode2.k == object || this.equals(hBNode2.k, object)) {
                Object object3 = hBNode2.v;
                hBNode2.v = object2;
                this.modify(hBNode2);
                return object3;
            }
            hBNode2 = hBNode2.nextNode;
        }
        hBNode2 = this.newNode(object, n, object2);
        if (hBNode != null) {
            hBNode.nextNode = hBNode2;
        } else {
            this.data[n2] = hBNode2;
        }
        return this.checkResize(null);
    }

    public Object getOrDefault(Object object, Object object2) {
        HBNode hBNode = this.data[this.hash(object) & this.mask];
        while (hBNode != null) {
            Object object3 = hBNode.k;
            if (object3 == object || this.equals(object3, object)) {
                return hBNode.v;
            }
            hBNode = hBNode.nextNode;
        }
        return object2;
    }

    public Object get(Object object) {
        HBNode hBNode = this.data[this.hash(object) & this.mask];
        while (hBNode != null) {
            Object object2 = hBNode.k;
            if (object2 == object || this.equals(object2, object)) {
                return hBNode.v;
            }
            hBNode = hBNode.nextNode;
        }
        return null;
    }

    public IMapEntry entryAt(Object object) {
        HBNode hBNode = this.data[this.hash(object) & this.mask];
        while (hBNode != null) {
            Object object2 = hBNode.k;
            if (object2 == object || this.equals(object2, object)) {
                return MapEntry.create((Object)hBNode.k, (Object)hBNode.v);
            }
            hBNode = hBNode.nextNode;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        HBNode hBNode = this.data[this.hash(object) & this.mask];
        while (hBNode != null) {
            Object object2 = hBNode.k;
            if (object2 == object || this.equals(object2, object)) {
                return true;
            }
            hBNode = hBNode.nextNode;
        }
        return false;
    }

    public Object compute(Object object, BiFunction biFunction) {
        int n = this.hash(object);
        HBNode[] hBNodeArray = this.data;
        int n2 = n & this.mask;
        HBNode hBNode = hBNodeArray[n2];
        HBNode hBNode2 = null;
        while (hBNode != null && hBNode.k != object && !this.equals(hBNode.k, object)) {
            hBNode2 = hBNode;
            hBNode = hBNode.nextNode;
        }
        Object r = biFunction.apply(object, hBNode == null ? null : hBNode.v);
        if (hBNode != null) {
            if (r != null) {
                hBNode.v = r;
                this.modify(hBNode);
            } else {
                this.remove(object, null);
            }
        } else if (r != null) {
            HBNode hBNode3 = this.newNode(object, n, r);
            if (hBNode2 != null) {
                hBNode2.nextNode = hBNode3;
            } else {
                hBNodeArray[n2] = hBNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    public Object computeIfAbsent(Object object, Function function) {
        int n = this.hash(object);
        HBNode[] hBNodeArray = this.data;
        int n2 = n & this.mask;
        HBNode hBNode = hBNodeArray[n2];
        HBNode hBNode2 = null;
        while (hBNode != null && hBNode.k != object && !this.equals(hBNode.k, object)) {
            hBNode2 = hBNode;
            hBNode = hBNode.nextNode;
        }
        if (hBNode != null) {
            return hBNode.v;
        }
        Object r = function.apply(object);
        if (r != null) {
            HBNode hBNode3 = this.newNode(object, n, r);
            if (hBNode2 != null) {
                hBNode2.nextNode = hBNode3;
            } else {
                hBNodeArray[n2] = hBNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    public Object remove(Object object) {
        HBNode hBNode = null;
        int n = this.hash(object) & this.mask;
        HBNode hBNode2 = this.data[n];
        while (hBNode2 != null) {
            Object object2 = hBNode2.k;
            if (object2 == object || this.equals(object2, object)) {
                this.dec(hBNode2);
                if (hBNode != null) {
                    hBNode.nextNode = hBNode2.nextNode;
                } else {
                    this.data[n] = hBNode2.nextNode;
                }
                return hBNode2.getValue();
            }
            hBNode = hBNode2;
            hBNode2 = hBNode2.nextNode;
        }
        return null;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            HBNode hBNode = this.data[i];
            while (hBNode != null) {
                this.dec(hBNode);
                hBNode = hBNode.nextNode;
            }
        }
        this.length = 0;
        Arrays.fill(this.data, null);
    }

    public Object reduce(IFn iFn, Object object) {
        for (HBNode hBNode : this.data) {
            while (hBNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, (Object)hBNode)))) {
                    return ((IDeref)object).deref();
                }
                hBNode = hBNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this.entrySet(), parallelOptions);
    }

    public void replaceAll(BiFunction biFunction) {
        int n = this.data.length;
        for (int i = 0; i < n; ++i) {
            HBNode hBNode = null;
            HBNode hBNode2 = this.data[i];
            while (hBNode2 != null) {
                Object r = biFunction.apply(hBNode2.k, hBNode2.v);
                if (r != null) {
                    hBNode2.v = r;
                    hBNode = hBNode2;
                } else {
                    this.dec(hBNode2);
                    if (hBNode != null) {
                        hBNode.nextNode = hBNode2.nextNode;
                    } else {
                        this.data[i] = hBNode2.nextNode;
                    }
                }
                hBNode2 = hBNode2.nextNode;
            }
        }
    }

    @Override
    public HashMap union(BitmapTrieCommon.MapSet mapSet, BiFunction biFunction) {
        if (!(mapSet instanceof HashMap)) {
            throw new RuntimeException("Accelerated union must have same type on both sides");
        }
        HashMap hashMap = (HashMap)mapSet;
        HashMap hashMap2 = this.shallowClone();
        HBNode[] hBNodeArray = hashMap.data;
        int n = hBNodeArray.length;
        HBNode[] hBNodeArray2 = hashMap2.data;
        int n2 = hashMap2.mask;
        for (int i = 0; i < n; ++i) {
            HBNode hBNode = hBNodeArray[i];
            while (hBNode != null) {
                HBNode hBNode2;
                int n3 = hBNode.hashcode & n2;
                Object object = hBNode.k;
                HBNode hBNode3 = hBNode2 = hBNodeArray2[n3];
                while (hBNode3 != null && hBNode3.k != object && !this.equals(hBNode3.k, object)) {
                    hBNode3 = hBNode3.nextNode;
                }
                if (hBNode3 != null) {
                    hBNodeArray2[n3] = hBNode2.assoc(hashMap2, hBNode.k, hBNode.hashcode, biFunction.apply(hBNode3.v, hBNode.v));
                } else {
                    hBNodeArray2[n3] = hBNode2 != null ? hBNode2.assoc(hashMap2, hBNode.k, hBNode.hashcode, hBNode.v) : hashMap2.newNode(object, hBNode.hashcode, hBNode.v);
                    hashMap2.checkResize(null);
                    n2 = hashMap2.mask;
                    hBNodeArray2 = hashMap2.data;
                }
                hBNode = hBNode.nextNode;
            }
        }
        return hashMap2;
    }

    @Override
    public HashMap intersection(BitmapTrieCommon.MapSet mapSet, BiFunction biFunction) {
        if (!(mapSet instanceof HashMap)) {
            throw new RuntimeException("Accelerated union must have same type on both sides");
        }
        HashMap hashMap = (HashMap)mapSet;
        HashMap hashMap2 = this.shallowClone();
        HBNode[] hBNodeArray = hashMap.data;
        int n = hashMap.mask;
        HBNode[] hBNodeArray2 = hashMap2.data;
        int n2 = hBNodeArray2.length;
        for (int i = 0; i < n2; ++i) {
            HBNode hBNode = hBNodeArray2[i];
            while (hBNode != null) {
                HBNode hBNode2 = hBNode;
                hBNode = hBNode.nextNode;
                int n3 = hBNode2.hashcode & n;
                HBNode hBNode3 = hBNodeArray[n3];
                Object object = hBNode2.k;
                while (hBNode3 != null && hBNode3.k != object && !this.equals(hBNode3.k, object)) {
                    hBNode3 = hBNode3.nextNode;
                }
                hBNodeArray2[i] = hBNode3 != null ? hBNodeArray2[i].assoc(hashMap2, hBNode3.k, hBNode3.hashcode, biFunction.apply(hBNode2.v, hBNode3.v)) : hBNodeArray2[i].dissoc(hashMap2, hBNode2.k);
            }
        }
        return new PersistentHashMap(hashMap2);
    }

    @Override
    public PersistentHashMap difference(BitmapTrieCommon.MapSet mapSet) {
        if (!(mapSet instanceof HashMap)) {
            throw new RuntimeException("Accelerated union must have same type on both sides");
        }
        HashMap hashMap = (HashMap)mapSet;
        HashMap hashMap2 = this.shallowClone();
        HBNode[] hBNodeArray = hashMap.data;
        int n = hBNodeArray.length;
        HBNode[] hBNodeArray2 = hashMap2.data;
        int n2 = hashMap2.mask;
        for (int i = 0; i < n; ++i) {
            HBNode hBNode = hBNodeArray[i];
            while (hBNode != null) {
                int n3 = hBNode.hashcode & n2;
                Object object = hBNode.k;
                HBNode hBNode2 = hBNodeArray2[n3];
                while (hBNode2 != null && hBNode2.k != object && !this.equals(hBNode2.k, object)) {
                    hBNode2 = hBNode2.nextNode;
                }
                if (hBNode2 != null) {
                    hBNodeArray2[n3] = hBNodeArray2[n3].dissoc(hashMap2, hBNode2.k);
                }
                hBNode = hBNode.nextNode;
            }
        }
        return new PersistentHashMap(hashMap2);
    }

    public IPersistentMap meta() {
        return this.meta;
    }

    @Override
    public Iterator iterator(Function<Map.Entry, Object> function) {
        return new HTIter(this.data, function);
    }

    @Override
    public Spliterator spliterator(Function<Map.Entry, Object> function) {
        return new HTSpliterator(this.data, this.length, function);
    }

    static class HTSpliterator
    implements Spliterator,
    ITypedReduce {
        final HBNode[] d;
        final Function<Map.Entry, Object> fn;
        int sidx;
        int eidx;
        int estimateSize;
        HBNode l;

        public HTSpliterator(HBNode[] hBNodeArray, int n, Function<Map.Entry, Object> function) {
            this.d = hBNodeArray;
            this.fn = function;
            this.sidx = 0;
            this.eidx = hBNodeArray.length;
            this.estimateSize = n;
            this.l = null;
        }

        public HTSpliterator(HBNode[] hBNodeArray, int n, int n2, int n3, Function<Map.Entry, Object> function) {
            this.d = hBNodeArray;
            this.fn = function;
            this.sidx = n;
            this.eidx = n2;
            this.estimateSize = n3;
            this.l = null;
        }

        public HTSpliterator trySplit() {
            int n = this.eidx - this.sidx;
            if (n > 4) {
                int n2 = n / 2;
                int n3 = this.eidx;
                this.eidx = this.sidx + n2;
                this.estimateSize /= 2;
                return new HTSpliterator(this.d, this.eidx, n3, this.estimateSize, this.fn);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        @Override
        public long estimateSize() {
            return this.estimateSize;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        public boolean tryAdvance(Consumer consumer) {
            if (this.l != null) {
                consumer.accept(this.fn.apply(this.l));
                this.l = this.l.nextNode;
                return true;
            }
            while (this.sidx < this.eidx) {
                HBNode hBNode = this.d[this.sidx];
                if (hBNode != null) {
                    consumer.accept(this.fn.apply(hBNode));
                    this.l = hBNode.nextNode;
                    return true;
                }
                ++this.sidx;
            }
            return false;
        }

        public Object reduce(IFn iFn, Object object) {
            HBNode[] hBNodeArray = this.d;
            int n = this.eidx;
            Function<Map.Entry, Object> function = this.fn;
            for (int i = this.sidx; i < n; ++i) {
                HBNode hBNode = hBNodeArray[i];
                while (hBNode != null) {
                    if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(hBNode))))) {
                        return ((IDeref)object).deref();
                    }
                    hBNode = hBNode.nextNode;
                }
            }
            return object;
        }
    }

    static class HTIter
    implements Iterator {
        final HBNode[] d;
        final Function<Map.Entry, Object> fn;
        HBNode l;
        int idx;
        final int dlen;

        HTIter(HBNode[] hBNodeArray, Function<Map.Entry, Object> function) {
            this.d = hBNodeArray;
            this.fn = function;
            this.l = null;
            this.idx = 0;
            this.dlen = this.d.length;
            this.advance();
        }

        void advance() {
            if (this.l != null) {
                this.l = this.l.nextNode;
            }
            if (this.l == null) {
                while (this.idx < this.dlen && this.l == null) {
                    this.l = this.d[this.idx];
                    ++this.idx;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.l != null;
        }

        public Object next() {
            HBNode hBNode = this.l;
            this.advance();
            return this.fn.apply(hBNode);
        }
    }
}

