/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Counted;
import clojure.lang.IEditableCollection;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.ITransientMap;
import clojure.lang.Indexed;
import ham_fisted.APersistentMapBase;
import ham_fisted.ArrayMap;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.HashTable;
import ham_fisted.ImmutHashTable;
import ham_fisted.ImmutValues;
import ham_fisted.MapData;
import ham_fisted.MutArrayMap;
import ham_fisted.TransientArrayMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ImmutArrayMap
extends APersistentMapBase
implements IEditableCollection,
IPersistentMap,
IObj,
ImmutValues {
    public ImmutArrayMap(BitmapTrieCommon.HashProvider hashProvider) {
        super(new ArrayMap(hashProvider, new Object[4], 0, null));
    }

    public ImmutArrayMap(ArrayMap arrayMap) {
        super(arrayMap);
    }

    public IPersistentMap cons(Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return this.assoc(entry.getKey(), entry.getValue());
        }
        if (object instanceof Indexed) {
            Indexed indexed = (Indexed)object;
            if (2 != ((Counted)object).count()) {
                throw new RuntimeException("Vector length != 2");
            }
            return this.assoc(indexed.nth(0), indexed.nth(1));
        }
        ITransientMap iTransientMap = this.asTransient();
        for (Map.Entry entry : (Iterable)object) {
            iTransientMap = iTransientMap.assoc(entry.getKey(), entry.getValue());
        }
        return iTransientMap.persistent();
    }

    public IPersistentMap assoc(Object object, Object object2) {
        ArrayMap arrayMap = (ArrayMap)this.ht;
        MapData mapData = arrayMap.assocAt(arrayMap.index(object), object, object2, true);
        return mapData instanceof ArrayMap ? new ImmutArrayMap((ArrayMap)mapData) : new ImmutHashTable((HashTable)mapData);
    }

    public IPersistentMap assocEx(Object object, Object object2) {
        ArrayMap arrayMap = (ArrayMap)this.ht;
        int n = arrayMap.index(object);
        if (n != -1) {
            throw new RuntimeException("Key already in map: " + String.valueOf(object));
        }
        MapData mapData = arrayMap.assocAt(n, object, object2, true);
        return mapData instanceof ArrayMap ? new ImmutArrayMap((ArrayMap)mapData) : new ImmutHashTable((HashTable)mapData);
    }

    public ImmutArrayMap without(Object object) {
        ArrayMap arrayMap = (ArrayMap)this.ht;
        return new ImmutArrayMap((ArrayMap)arrayMap.shallowClone().mutDissoc(object));
    }

    public ImmutArrayMap empty() {
        return new ImmutArrayMap(this.ht.hashProvider());
    }

    public ITransientMap asTransient() {
        if (this.isEmpty()) {
            return new MutArrayMap(((ArrayMap)this.ht).shallowClone());
        }
        return new TransientArrayMap(((ArrayMap)this.ht).shallowClone());
    }

    @Override
    public ImmutHashTable immutUpdateValues(BiFunction biFunction) {
        return (ImmutHashTable)((ImmutValues)this.asTransient()).immutUpdateValues(biFunction);
    }

    @Override
    public ImmutHashTable immutUpdateValue(Object object, IFn iFn) {
        return (ImmutHashTable)((ImmutValues)this.asTransient()).immutUpdateValue(object, iFn);
    }

    public ImmutArrayMap withMeta(IPersistentMap iPersistentMap) {
        if (iPersistentMap == this.meta()) {
            return this;
        }
        return new ImmutArrayMap((ArrayMap)this.ht.withMeta(iPersistentMap));
    }
}

