/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.RT;
import ham_fisted.BitmapTrieCommon;
import ham_fisted.HBNode;
import ham_fisted.HashMap;
import ham_fisted.LinkedHashNode;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LinkedHashMap
extends HashMap {
    LinkedHashNode firstLink;
    LinkedHashNode lastLink;

    public LinkedHashMap(IPersistentMap iPersistentMap) {
        super(iPersistentMap);
    }

    public LinkedHashMap() {
        this(null);
    }

    @Override
    protected HBNode newNode(Object object, int n, Object object2) {
        return new LinkedHashNode(this, object, n, object2, null);
    }

    @Override
    protected void inc(HBNode hBNode) {
        super.inc(hBNode);
        LinkedHashNode linkedHashNode = (LinkedHashNode)hBNode;
        if (this.lastLink == null) {
            this.lastLink = linkedHashNode;
        }
        linkedHashNode.prevLink = this.firstLink;
        if (this.firstLink != null) {
            this.firstLink.nextLink = linkedHashNode;
        }
        this.firstLink = linkedHashNode;
    }

    protected static void removeLink(LinkedHashNode linkedHashNode) {
        if (linkedHashNode.prevLink != null) {
            linkedHashNode.prevLink.nextLink = linkedHashNode.nextLink;
        }
        if (linkedHashNode.nextLink != null) {
            linkedHashNode.nextLink.prevLink = linkedHashNode.prevLink;
        }
    }

    @Override
    protected void dec(HBNode hBNode) {
        super.dec(hBNode);
        LinkedHashNode linkedHashNode = (LinkedHashNode)hBNode;
        if (linkedHashNode == this.firstLink) {
            this.firstLink = linkedHashNode.prevLink;
        }
        if (linkedHashNode == this.lastLink) {
            this.lastLink = linkedHashNode.nextLink;
        }
        LinkedHashMap.removeLink(linkedHashNode);
        linkedHashNode.prevLink = null;
        linkedHashNode.nextLink = null;
    }

    @Override
    protected void modify(HBNode hBNode) {
        LinkedHashNode linkedHashNode = (LinkedHashNode)hBNode;
        if (this.firstLink != linkedHashNode) {
            LinkedHashMap.removeLink(linkedHashNode);
            if (linkedHashNode == this.lastLink) {
                this.lastLink = linkedHashNode.nextLink;
            }
            linkedHashNode.prevLink = this.firstLink;
            linkedHashNode.nextLink = null;
            if (this.firstLink != null) {
                this.firstLink.nextLink = linkedHashNode;
            }
            linkedHashNode.prevLink = this.firstLink;
            this.firstLink = linkedHashNode;
        }
    }

    @Override
    public Iterator iterator(Function<Map.Entry, Object> function) {
        return new LinkedIter(function, this.lastLink);
    }

    @Override
    public Object reduce(IFn iFn, Object object) {
        LinkedHashNode linkedHashNode = this.lastLink;
        while (linkedHashNode != null) {
            if (RT.isReduced((Object)(object = iFn.invoke(object, (Object)linkedHashNode)))) {
                return ((IDeref)object).deref();
            }
            linkedHashNode = linkedHashNode.nextLink;
        }
        return object;
    }

    @Override
    public LinkedHashMap union(BitmapTrieCommon.MapSet mapSet, BiFunction biFunction) {
        if (!(mapSet instanceof HashMap)) {
            throw new RuntimeException("Accelerated union must have same type on both sides");
        }
        LinkedHashMap linkedHashMap = (LinkedHashMap)mapSet;
        LinkedHashMap linkedHashMap2 = this;
        LinkedHashNode linkedHashNode = linkedHashMap.lastLink;
        while (linkedHashNode != null) {
            HBNode[] hBNodeArray = linkedHashMap.data;
            int n = hBNodeArray.length;
            HBNode[] hBNodeArray2 = linkedHashMap2.data;
            int n2 = linkedHashMap2.mask;
            int n3 = linkedHashNode.hashcode & n2;
            Object object = linkedHashNode.k;
            HBNode hBNode = hBNodeArray2[n3];
            HBNode hBNode2 = null;
            while (hBNode != null && hBNode.k != object && !this.equals(hBNode.k, object)) {
                hBNode2 = hBNode;
                hBNode = hBNode.nextNode;
            }
            if (hBNode != null) {
                hBNode.v = biFunction.apply(hBNode.v, linkedHashNode.v);
            } else {
                HBNode hBNode3 = this.newNode(linkedHashNode.k, linkedHashNode.hashcode, linkedHashNode.v);
                if (hBNode2 != null) {
                    hBNode2.nextNode = hBNode3;
                } else {
                    hBNodeArray2[n3] = hBNode3;
                }
                linkedHashMap2.checkResize(null);
                n2 = linkedHashMap2.mask;
                hBNodeArray2 = linkedHashMap2.data;
            }
            linkedHashNode = linkedHashNode.nextLink;
        }
        return linkedHashMap2;
    }

    public static class LinkedIter
    implements Iterator {
        LinkedHashNode current;
        Function<Map.Entry, Object> fn;

        public LinkedIter(Function<Map.Entry, Object> function, LinkedHashNode linkedHashNode) {
            this.current = linkedHashNode;
            this.fn = function;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.fn.apply(this.current);
            this.current = this.current.nextLink;
            return object;
        }
    }
}

