/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IMeta;
import clojure.lang.IPersistentMap;
import clojure.lang.RT;
import ham_fisted.CljHash;
import ham_fisted.HashNode;
import ham_fisted.ITypedReduce;
import ham_fisted.IntegerOps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public class HashBase
implements IMeta {
    int capacity;
    int mask;
    int length;
    int threshold;
    float loadFactor;
    HashNode[] data;
    IPersistentMap meta;

    public HashBase(float f, int n, int n2, HashNode[] hashNodeArray, IPersistentMap iPersistentMap) {
        this.loadFactor = f;
        this.capacity = IntegerOps.nextPow2(Math.max(4, n));
        this.mask = this.capacity - 1;
        this.length = n2;
        this.data = hashNodeArray == null ? new HashNode[this.capacity] : hashNodeArray;
        this.threshold = (int)((float)this.capacity * f);
        this.meta = iPersistentMap;
    }

    public HashBase(HashBase hashBase, IPersistentMap iPersistentMap) {
        this.loadFactor = hashBase.loadFactor;
        this.capacity = hashBase.capacity;
        this.mask = hashBase.mask;
        this.length = hashBase.length;
        this.data = hashBase.data;
        this.threshold = hashBase.threshold;
        this.meta = iPersistentMap;
    }

    public int size() {
        return this.length;
    }

    public int count() {
        return this.length;
    }

    protected int hash(Object object) {
        return object == null ? 0 : (object instanceof IHashEq ? ((IHashEq)object).hasheq() : IntegerOps.mixhash(object.hashCode()));
    }

    protected boolean equals(Object object, Object object2) {
        return object == object2 ? true : (object == null || object2 == null ? false : CljHash.nonNullEquiv(object, object2));
    }

    protected void inc(HashNode hashNode) {
        ++this.length;
    }

    protected void dec(HashNode hashNode) {
        --this.length;
    }

    protected void modify(HashNode hashNode) {
    }

    protected HashNode newNode(Object object, int n, Object object2) {
        return new HashNode(this, object, n, object2, null);
    }

    Object checkResize(Object object) {
        if (this.length >= this.threshold) {
            int n = this.capacity * 2;
            HashNode[] hashNodeArray = new HashNode[n];
            HashNode[] hashNodeArray2 = this.data;
            int n2 = hashNodeArray2.length;
            int n3 = n - 1;
            for (int i = 0; i < n2; ++i) {
                HashNode hashNode = hashNodeArray2[i];
                if (hashNode == null) continue;
                hashNodeArray2[i] = null;
                if (hashNode.nextNode == null) {
                    hashNodeArray[hashNode.hashcode & n3] = hashNode;
                    continue;
                }
                HashNode hashNode2 = null;
                HashNode hashNode3 = null;
                HashNode hashNode4 = null;
                HashNode hashNode5 = null;
                while (hashNode != null) {
                    HashNode hashNode6 = hashNode.setOwner(this);
                    hashNode = hashNode.nextNode;
                    if ((hashNode6.hashcode & n2) == 0) {
                        if (hashNode3 == null) {
                            hashNode2 = hashNode6;
                        } else {
                            hashNode3.nextNode = hashNode6;
                        }
                        hashNode3 = hashNode6;
                        continue;
                    }
                    if (hashNode5 == null) {
                        hashNode4 = hashNode6;
                    } else {
                        hashNode5.nextNode = hashNode6;
                    }
                    hashNode5 = hashNode6;
                }
                if (hashNode2 != null) {
                    hashNode3.nextNode = null;
                    hashNodeArray[i] = hashNode2;
                }
                if (hashNode4 == null) continue;
                hashNode5.nextNode = null;
                hashNodeArray[i + n2] = hashNode4;
            }
            this.capacity = n;
            this.threshold = (int)((float)n * this.loadFactor);
            this.mask = n3;
            this.data = hashNodeArray;
        }
        return object;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            HashNode hashNode = this.data[i];
            while (hashNode != null) {
                this.dec(hashNode);
                hashNode = hashNode.nextNode;
            }
        }
        this.length = 0;
        Arrays.fill(this.data, null);
    }

    public IPersistentMap meta() {
        return this.meta;
    }

    final boolean containsNodeKey(Object object) {
        HashNode hashNode = this.data[this.hash(object) & this.mask];
        while (hashNode != null) {
            Object object2 = hashNode.k;
            if (object2 == object || this.equals(object2, object)) {
                return true;
            }
            hashNode = hashNode.nextNode;
        }
        return false;
    }

    static class HTSpliterator
    implements Spliterator,
    ITypedReduce {
        final HashNode[] d;
        final Function<Map.Entry, Object> fn;
        int sidx;
        int eidx;
        int estimateSize;
        HashNode l;

        public HTSpliterator(HashNode[] hashNodeArray, int n, Function<Map.Entry, Object> function) {
            this.d = hashNodeArray;
            this.fn = function;
            this.sidx = 0;
            this.eidx = hashNodeArray.length;
            this.estimateSize = n;
            this.l = null;
        }

        public HTSpliterator(HashNode[] hashNodeArray, int n, int n2, int n3, Function<Map.Entry, Object> function) {
            this.d = hashNodeArray;
            this.fn = function;
            this.sidx = n;
            this.eidx = n2;
            this.estimateSize = n3;
            this.l = null;
        }

        public HTSpliterator trySplit() {
            int n = this.eidx - this.sidx;
            if (n > 4) {
                int n2 = n / 2;
                int n3 = this.eidx;
                this.eidx = this.sidx + n2;
                this.estimateSize /= 2;
                return new HTSpliterator(this.d, this.eidx, n3, this.estimateSize, this.fn);
            }
            return null;
        }

        @Override
        public int characteristics() {
            return 1089;
        }

        @Override
        public long estimateSize() {
            return this.estimateSize;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        public boolean tryAdvance(Consumer consumer) {
            if (this.l != null) {
                consumer.accept(this.fn.apply(this.l));
                this.l = this.l.nextNode;
                return true;
            }
            while (this.sidx < this.eidx) {
                HashNode hashNode = this.d[this.sidx];
                if (hashNode != null) {
                    consumer.accept(this.fn.apply(hashNode));
                    this.l = hashNode.nextNode;
                    return true;
                }
                ++this.sidx;
            }
            return false;
        }

        public Object reduce(IFn iFn, Object object) {
            HashNode[] hashNodeArray = this.d;
            int n = this.eidx;
            Function<Map.Entry, Object> function = this.fn;
            for (int i = this.sidx; i < n; ++i) {
                HashNode hashNode = hashNodeArray[i];
                while (hashNode != null) {
                    if (RT.isReduced((Object)(object = iFn.invoke(object, function.apply(hashNode))))) {
                        return ((IDeref)object).deref();
                    }
                    hashNode = hashNode.nextNode;
                }
            }
            return object;
        }
    }

    static class HTIter
    implements Iterator {
        final HashNode[] d;
        final Function<Map.Entry, Object> fn;
        HashNode l;
        int idx;
        final int dlen;

        HTIter(HashNode[] hashNodeArray, Function<Map.Entry, Object> function) {
            this.d = hashNodeArray;
            this.fn = function;
            this.l = null;
            this.idx = 0;
            this.dlen = this.d.length;
            this.advance();
        }

        void advance() {
            if (this.l != null) {
                this.l = this.l.nextNode;
            }
            if (this.l == null) {
                while (this.idx < this.dlen && this.l == null) {
                    this.l = this.d[this.idx];
                    ++this.idx;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.l != null;
        }

        public Object next() {
            HashNode hashNode = this.l;
            this.advance();
            return this.fn.apply(hashNode);
        }
    }
}

