/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IKVReduce;
import clojure.lang.ILookup;
import clojure.lang.IMapIterable;
import clojure.lang.ISeq;
import clojure.lang.MapEquivalence;
import clojure.lang.RT;
import clojure.lang.Seqable;
import ham_fisted.IFnDef;
import ham_fisted.ITypedReduce;
import ham_fisted.ParallelOptions;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface IMap
extends Map,
ITypedReduce,
ILookup,
IFnDef,
Iterable,
IMapIterable,
Counted,
MapEquivalence,
IKVReduce,
Seqable {
    public Iterator iterator(Function<Map.Entry, Object> var1);

    default public Spliterator spliterator(Function<Map.Entry, Object> function) {
        throw new RuntimeException("Unimplemented");
    }

    default public Iterator keyIterator() {
        return this.iterator(entry -> entry.getKey());
    }

    default public Iterator valIterator() {
        return this.iterator(entry -> entry.getValue());
    }

    default public Iterator entryIterator() {
        return this.iterator(entry -> entry);
    }

    default public Iterator iterator() {
        return this.entryIterator();
    }

    default public void putAll(Map map) {
        map.forEach(new BiConsumer(){

            public void accept(Object object, Object object2) {
                IMap.this.put(object, object2);
            }
        });
    }

    @Override
    default public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    default public Object valAt(Object object) {
        return this.get(object);
    }

    default public Object valAt(Object object, Object object2) {
        return this.getOrDefault(object, object2);
    }

    @Override
    default public Object invoke(Object object) {
        return this.get(object);
    }

    @Override
    default public Object invoke(Object object, Object object2) {
        return this.getOrDefault(object, object2);
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void forEach(Consumer consumer) {
        ITypedReduce.super.forEach(consumer);
    }

    default public int count() {
        return this.size();
    }

    default public Object kvreduce(final IFn iFn, Object object) {
        return this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object2;
                return iFn.invoke(object, entry.getKey(), entry.getValue());
            }
        }, object);
    }

    default public ISeq seq() {
        return RT.chunkIteratorSeq((Iterator)this.iterator());
    }

    default public Set keySet() {
        return new MapKeySet(this);
    }

    default public Set entrySet() {
        return new MapEntrySet(this);
    }

    default public Collection values() {
        return new ValueCollection(this);
    }

    public static class ValueCollection
    extends AbstractCollection
    implements ITypedReduce,
    Counted {
        public final IMap data;

        public ValueCollection(IMap iMap) {
            this.data = iMap;
        }

        @Override
        public final int size() {
            return this.data.size();
        }

        public int count() {
            return this.data.size();
        }

        @Override
        public final void clear() {
            this.data.clear();
        }

        @Override
        public final Iterator iterator() {
            return this.data.valIterator();
        }

        @Override
        public final Spliterator spliterator() {
            return this.data.spliterator(entry -> entry.getValue());
        }

        public static IFn wrapRfn(final IFn iFn) {
            return new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return iFn.invoke(object, ((Map.Entry)object2).getValue());
                }
            };
        }

        public Object reduce(IFn iFn, Object object) {
            return this.data.reduce(ValueCollection.wrapRfn(iFn), object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return this.data.parallelReduction(iFn, ValueCollection.wrapRfn(iFn2), iFn3, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }
    }

    public static class MapEntrySet
    extends AbstractSet
    implements ITypedReduce,
    IFnDef,
    Counted {
        public final IMap data;

        public MapEntrySet(IMap iMap) {
            this.data = iMap;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        public int count() {
            return this.data.size();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.data.get(entry), entry.getValue());
        }

        @Override
        public Iterator iterator() {
            return this.data.entryIterator();
        }

        @Override
        public Spliterator spliterator() {
            return this.data.spliterator(entry -> entry);
        }

        @Override
        public void clear() {
            this.data.clear();
        }

        public Object reduce(IFn iFn, Object object) {
            return this.data.reduce(iFn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return this.data.parallelReduction(iFn, iFn2, iFn3, parallelOptions);
        }

        @Override
        public void forEach(Consumer consumer) {
            this.data.forEach(consumer);
        }

        @Override
        public Object invoke(Object object) {
            return this.contains(object);
        }
    }

    public static class MapKeySet
    extends AbstractSet
    implements ITypedReduce,
    IFnDef,
    Counted {
        public final IMap data;

        public MapKeySet(IMap iMap) {
            this.data = iMap;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        public int count() {
            return this.data.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.data.containsKey(object);
        }

        @Override
        public Iterator iterator() {
            return this.data.keyIterator();
        }

        @Override
        public Spliterator spliterator() {
            return this.data.spliterator(entry -> entry.getKey());
        }

        @Override
        public void clear() {
            this.data.clear();
        }

        static IFn wrapRfn(final IFn iFn) {
            return new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return iFn.invoke(object, ((Map.Entry)object2).getKey());
                }
            };
        }

        public Object reduce(IFn iFn, Object object) {
            return this.data.reduce(MapKeySet.wrapRfn(iFn), object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return this.data.parallelReduction(iFn, MapKeySet.wrapRfn(iFn2), iFn3, parallelOptions);
        }

        @Override
        public void forEach(final Consumer consumer) {
            this.reduce(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    consumer.accept(object2);
                    return consumer;
                }
            }, consumer);
        }

        @Override
        public Object invoke(Object object) {
            return this.data.containsKey(object) ? object : null;
        }
    }
}

