/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.java.api.Clojure;
import clojure.lang.ArraySeq;
import clojure.lang.Box;
import clojure.lang.Delay;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import clojure.lang.Util;
import ham_fisted.ArrayLists;
import ham_fisted.Casts;
import ham_fisted.ForkJoinPatterns;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.ITypedReduce;
import ham_fisted.LazyChunkedSeq;
import ham_fisted.MapFn;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoublePredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Transformables {
    public static final Delay toIterableDelay = new Delay((IFn)new IFnDef(){

        @Override
        public Object invoke() {
            return ((IDeref)Clojure.var((Object)"ham-fisted.protocols", (Object)"->iterable")).deref();
        }
    });
    static final HashMap<Class, BiFunction<IFn, IFn, IFn>> mappingReducer = new HashMap();

    public static final Iterable toIterable(Object object) {
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        return (Iterable)((IFn)toIterableDelay.deref()).invoke(object);
    }

    public static boolean truthy(Object object) {
        return Casts.booleanCast(object);
    }

    public static IFn toReductionFn(Object object) {
        if (object instanceof IFn) {
            return (IFn)object;
        }
        if (object instanceof IFn.OLO) {
            final IFn.OLO oLO = (IFn.OLO)object;
            return new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return oLO.invokePrim(object, Casts.longCast(object2));
                }
            };
        }
        if (object instanceof IFn.ODO) {
            final IFn.ODO oDO = (IFn.ODO)object;
            return new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return oDO.invokePrim(object, Casts.doubleCast(object2));
                }
            };
        }
        throw new RuntimeException("Unrecognised function type: " + String.valueOf(object.getClass()));
    }

    public static IFn.OLO toLongReductionFn(Object object) {
        if (object instanceof IFnDef.OLO) {
            return (IFn.OLO)object;
        }
        if (object instanceof IFnDef.ODO) {
            final IFn.ODO oDO = (IFn.ODO)object;
            return new IFnDef.OLO(){

                public Object invokePrim(Object object, long l) {
                    return oDO.invokePrim(object, (double)l);
                }
            };
        }
        final IFn iFn = (IFn)object;
        return new IFnDef.OLO(){

            public Object invokePrim(Object object, long l) {
                return iFn.invoke(object, (Object)l);
            }
        };
    }

    public static IFn.ODO toDoubleReductionFn(Object object) {
        if (object instanceof IFn.ODO) {
            return (IFn.ODO)object;
        }
        if (object instanceof IFnDef.OLO) {
            final IFn.OLO oLO = (IFn.OLO)object;
            return new IFnDef.ODO(){

                public Object invokePrim(Object object, double d) {
                    return oLO.invokePrim(object, Casts.longCast(d));
                }
            };
        }
        final IFn iFn = (IFn)object;
        return new IFnDef.ODO(){

            public Object invokePrim(Object object, double d) {
                return iFn.invoke(object, (Object)d);
            }
        };
    }

    public static int iterCount(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public static IFn mapReducer(final IFn iFn, final IFn iFn2) {
        return new IFnDef(){

            @Override
            public Object invoke() {
                return iFn.invoke();
            }

            @Override
            public Object invoke(Object object) {
                return iFn.invoke(object);
            }

            @Override
            public Object invoke(Object object, Object object2) {
                return iFn.invoke(object, iFn2.invoke(object2));
            }

            public Object applyTo(Object object) {
                return iFn.invoke(RT.first((Object)object), iFn2.applyTo(RT.next((Object)object)));
            }
        };
    }

    public static IFn longMapReducer(final IFn iFn, final IFn iFn2) {
        final IFn.OLO oLO = (IFn.OLO)iFn;
        if (iFn2 instanceof IFn.OL) {
            final IFn.OL oL = (IFn.OL)iFn2;
            return new IFnDef(){

                @Override
                public Object invoke() {
                    return iFn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return iFn.invoke(object);
                }

                @Override
                public Object invoke(Object object, Object object2) {
                    return oLO.invokePrim(object, oL.invokePrim(object2));
                }

                public Object applyTo(Object object) {
                    return iFn.invoke(RT.first((Object)object), iFn2.applyTo(RT.next((Object)object)));
                }
            };
        }
        if (iFn2 instanceof IFn.LL) {
            final IFn.LL lL = (IFn.LL)iFn2;
            return new Reductions.LongAccum(){

                @Override
                public Object invoke() {
                    return iFn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return iFn.invoke(object);
                }

                public Object invokePrim(Object object, long l) {
                    return oLO.invokePrim(object, lL.invokePrim(l));
                }

                public Object applyTo(Object object) {
                    return iFn.invoke(RT.first((Object)object), iFn2.applyTo(RT.next((Object)object)));
                }
            };
        }
        final IFn.DL dL = (IFn.DL)iFn2;
        return new Reductions.DoubleAccum(){

            @Override
            public Object invoke() {
                return iFn.invoke();
            }

            @Override
            public Object invoke(Object object) {
                return iFn.invoke(object);
            }

            public Object invokePrim(Object object, double d) {
                return oLO.invokePrim(object, dL.invokePrim(d));
            }

            public Object applyTo(Object object) {
                return iFn.invoke(RT.first((Object)object), iFn2.applyTo(RT.next((Object)object)));
            }
        };
    }

    public static IFn typedMapReducer(final IFn iFn, final IFn iFn2) {
        Class<?>[] classArray = iFn2.getClass().getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            BiFunction<IFn, IFn, IFn> biFunction = mappingReducer.get(classArray[i]);
            if (biFunction == null) continue;
            return biFunction.apply(iFn, iFn2);
        }
        return new IFnDef(){

            @Override
            public Object invoke() {
                return iFn.invoke();
            }

            @Override
            public Object invoke(Object object) {
                return iFn.invoke(object);
            }

            @Override
            public Object invoke(Object object, Object object2) {
                return iFn.invoke(object, iFn2.invoke(object2));
            }

            public Object applyTo(Object object) {
                return iFn.invoke(RT.first((Object)object), iFn2.applyTo(RT.next((Object)object)));
            }
        };
    }

    public static Object singleMapReduce(Object object, IFn iFn, IFn iFn2, Object object2) {
        return Reductions.serialReduction(Transformables.typedMapReducer(iFn, iFn2), object2, object);
    }

    public static boolean seqEquiv(Seqable seqable, Object object) {
        ISeq iSeq = seqable.seq();
        if (iSeq != null) {
            return iSeq.equiv(object);
        }
        return (object instanceof Sequential || object instanceof List) && RT.seq((Object)object) == null;
    }

    public static int seqHashCode(Seqable seqable) {
        ISeq iSeq = seqable.seq();
        if (iSeq == null) {
            return 1;
        }
        return Util.hash((Object)iSeq);
    }

    static void appendObjects(StringBuilder stringBuilder, Collection collection) {
        boolean bl = true;
        for (Object e : collection) {
            if (!bl) {
                stringBuilder.append(" ");
            }
            bl = false;
            stringBuilder.append(e == null ? "nil" : e.toString());
        }
    }

    public static String sequenceToString(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection instanceof RandomAccess) {
            List list = (List)collection;
            int n = list.size();
            stringBuilder.append("[");
            if (n < 50) {
                Transformables.appendObjects(stringBuilder, list);
            } else {
                Transformables.appendObjects(stringBuilder, list.subList(0, 20));
                stringBuilder.append(" ... ");
                Transformables.appendObjects(stringBuilder, list.subList(n - 20, n));
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("(");
            int n = 0;
            for (Object e : collection) {
                if (n >= 50) {
                    stringBuilder.append(" ...");
                    break;
                }
                if (n > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(e == null ? "nil" : e.toString());
                ++n;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    static {
        mappingReducer.put(IFn.LD.class, (iFn, iFn2) -> {
            IFn.ODO oDO = Transformables.toDoubleReductionFn(iFn);
            IFn.LD lD = (IFn.LD)iFn2;
            return new IFnDef.OLO(){
                final /* synthetic */ IFn val$rfn;
                final /* synthetic */ IFn.ODO val$rr;
                final /* synthetic */ IFn.LD val$mfn;
                final /* synthetic */ IFn val$mapFn;
                {
                    this.val$rfn = iFn;
                    this.val$rr = oDO;
                    this.val$mfn = lD;
                    this.val$mapFn = iFn2;
                }

                @Override
                public Object invoke() {
                    return this.val$rfn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return this.val$rfn.invoke(object);
                }

                public Object invokePrim(Object object, long l) {
                    return this.val$rr.invokePrim(object, this.val$mfn.invokePrim(l));
                }

                public Object applyTo(Object object) {
                    return this.val$rfn.invoke(RT.first((Object)object), this.val$mapFn.applyTo(RT.next((Object)object)));
                }
            };
        });
        mappingReducer.put(IFnDef.LD.class, mappingReducer.get(IFn.LD.class));
        mappingReducer.put(IFn.OD.class, (iFn, iFn2) -> {
            IFn.ODO oDO = Transformables.toDoubleReductionFn(iFn);
            IFn.OD oD = (IFn.OD)iFn2;
            return new IFnDef.OOO(){
                final /* synthetic */ IFn val$rfn;
                final /* synthetic */ IFn.ODO val$rr;
                final /* synthetic */ IFn.OD val$mfn;
                final /* synthetic */ IFn val$mapFn;
                {
                    this.val$rfn = iFn;
                    this.val$rr = oDO;
                    this.val$mfn = oD;
                    this.val$mapFn = iFn2;
                }

                @Override
                public Object invoke() {
                    return this.val$rfn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return this.val$rfn.invoke(object);
                }

                @Override
                public Object invoke(Object object, Object object2) {
                    return this.val$rr.invokePrim(object, this.val$mfn.invokePrim(object2));
                }

                public Object applyTo(Object object) {
                    return this.val$rfn.invoke(RT.first((Object)object), this.val$mapFn.applyTo(RT.next((Object)object)));
                }
            };
        });
        mappingReducer.put(IFnDef.OD.class, mappingReducer.get(IFn.OD.class));
        mappingReducer.put(IFn.DD.class, (iFn, iFn2) -> {
            IFn.ODO oDO = Transformables.toDoubleReductionFn(iFn);
            IFn.DD dD = (IFn.DD)iFn2;
            return new IFnDef.ODO(){
                final /* synthetic */ IFn val$rfn;
                final /* synthetic */ IFn.ODO val$rr;
                final /* synthetic */ IFn.DD val$mfn;
                final /* synthetic */ IFn val$mapFn;
                {
                    this.val$rfn = iFn;
                    this.val$rr = oDO;
                    this.val$mfn = dD;
                    this.val$mapFn = iFn2;
                }

                @Override
                public Object invoke() {
                    return this.val$rfn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return this.val$rfn.invoke(object);
                }

                public Object invokePrim(Object object, double d) {
                    return this.val$rr.invokePrim(object, this.val$mfn.invokePrim(d));
                }

                public Object applyTo(Object object) {
                    return this.val$rfn.invoke(RT.first((Object)object), this.val$mapFn.applyTo(RT.next((Object)object)));
                }
            };
        });
        mappingReducer.put(IFnDef.DD.class, mappingReducer.get(IFn.DD.class));
        mappingReducer.put(IFn.OL.class, (iFn, iFn2) -> {
            IFn.OLO oLO = Transformables.toLongReductionFn(iFn);
            IFn.OL oL = (IFn.OL)iFn2;
            return new IFnDef(){
                final /* synthetic */ IFn val$rfn;
                final /* synthetic */ IFn.OLO val$rr;
                final /* synthetic */ IFn.OL val$mfn;
                final /* synthetic */ IFn val$mapFn;
                {
                    this.val$rfn = iFn;
                    this.val$rr = oLO;
                    this.val$mfn = oL;
                    this.val$mapFn = iFn2;
                }

                @Override
                public Object invoke() {
                    return this.val$rfn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return this.val$rfn.invoke(object);
                }

                @Override
                public Object invoke(Object object, Object object2) {
                    return this.val$rr.invokePrim(object, this.val$mfn.invokePrim(object2));
                }

                public Object applyTo(Object object) {
                    return this.val$rfn.invoke(RT.first((Object)object), this.val$mapFn.applyTo(RT.next((Object)object)));
                }
            };
        });
        mappingReducer.put(IFnDef.OL.class, mappingReducer.get(IFn.OL.class));
        mappingReducer.put(IFn.DL.class, (iFn, iFn2) -> {
            IFn.OLO oLO = Transformables.toLongReductionFn(iFn);
            IFn.DL dL = (IFn.DL)iFn2;
            return new IFnDef.ODO(){
                final /* synthetic */ IFn val$rfn;
                final /* synthetic */ IFn.OLO val$rr;
                final /* synthetic */ IFn.DL val$mfn;
                final /* synthetic */ IFn val$mapFn;
                {
                    this.val$rfn = iFn;
                    this.val$rr = oLO;
                    this.val$mfn = dL;
                    this.val$mapFn = iFn2;
                }

                @Override
                public Object invoke() {
                    return this.val$rfn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return this.val$rfn.invoke(object);
                }

                public Object invokePrim(Object object, double d) {
                    return this.val$rr.invokePrim(object, this.val$mfn.invokePrim(d));
                }

                public Object applyTo(Object object) {
                    return this.val$rfn.invoke(RT.first((Object)object), this.val$mapFn.applyTo(RT.next((Object)object)));
                }
            };
        });
        mappingReducer.put(IFnDef.DL.class, mappingReducer.get(IFn.DL.class));
        mappingReducer.put(IFn.LL.class, (iFn, iFn2) -> {
            IFn.OLO oLO = Transformables.toLongReductionFn(iFn);
            IFn.LL lL = (IFn.LL)iFn2;
            return new IFnDef.OLO(){
                final /* synthetic */ IFn val$rfn;
                final /* synthetic */ IFn.OLO val$rr;
                final /* synthetic */ IFn.LL val$mfn;
                final /* synthetic */ IFn val$mapFn;
                {
                    this.val$rfn = iFn;
                    this.val$rr = oLO;
                    this.val$mfn = lL;
                    this.val$mapFn = iFn2;
                }

                @Override
                public Object invoke() {
                    return this.val$rfn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return this.val$rfn.invoke(object);
                }

                public Object invokePrim(Object object, long l) {
                    return this.val$rr.invokePrim(object, this.val$mfn.invokePrim(l));
                }

                public Object applyTo(Object object) {
                    return this.val$rfn.invoke(RT.first((Object)object), this.val$mapFn.applyTo(RT.next((Object)object)));
                }
            };
        });
        mappingReducer.put(IFnDef.LL.class, mappingReducer.get(IFn.LL.class));
    }

    public static class CachingList
    implements IMutList {
        final List src;
        final Object[] dataCache;
        final BitSet cachedIndexes;
        final IPersistentMap meta;
        int _hash;

        public CachingList(List list, IPersistentMap iPersistentMap) {
            this.src = list;
            this.meta = iPersistentMap;
            this.dataCache = new Object[list.size()];
            this.cachedIndexes = new BitSet();
        }

        CachingList(CachingList cachingList, IPersistentMap iPersistentMap) {
            this.src = cachingList.src;
            this.dataCache = cachingList.dataCache;
            this.cachedIndexes = cachingList.cachedIndexes;
            this.meta = iPersistentMap;
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int hasheq() {
            if (this._hash == 0) {
                this._hash = IMutList.super.hasheq();
            }
            return this._hash;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(int n) {
            BitSet bitSet = this.cachedIndexes;
            synchronized (bitSet) {
                if (this.cachedIndexes.get(n)) {
                    return this.dataCache[n];
                }
                Object e = this.src.get(n);
                this.dataCache[n] = e;
                this.cachedIndexes.set(n);
                return e;
            }
        }

        @Override
        public int size() {
            return this.src.size();
        }

        @Override
        public CachingList withMeta(IPersistentMap iPersistentMap) {
            return new CachingList(this, iPersistentMap);
        }
    }

    public static class CachingIterable
    extends AbstractCollection
    implements Seqable {
        final Iterable src;
        final IPersistentMap meta;
        AtomicReference<ISeq> seq;

        public CachingIterable(Iterable iterable, IPersistentMap iPersistentMap) {
            this.src = iterable;
            this.meta = iPersistentMap;
            this.seq = new AtomicReference();
        }

        CachingIterable(CachingIterable cachingIterable, IPersistentMap iPersistentMap) {
            this.src = cachingIterable.src;
            this.meta = iPersistentMap;
            this.seq = cachingIterable.seq;
        }

        public ISeq seq() {
            return this.seq.updateAndGet(new UnaryOperator<ISeq>(){

                @Override
                public ISeq apply(ISeq iSeq) {
                    if (iSeq != null) {
                        return iSeq;
                    }
                    return src instanceof Seqable ? ((Seqable)src).seq() : LazyChunkedSeq.chunkIteratorSeq(src.iterator());
                }
            });
        }

        @Override
        public Iterator iterator() {
            return ((Collection)this.seq()).iterator();
        }

        @Override
        public int size() {
            return ((Collection)this.seq()).size();
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public CachingIterable withMeta(IPersistentMap iPersistentMap) {
            return new CachingIterable(this.src, iPersistentMap);
        }
    }

    public static class IndexedMapper
    extends AbstractCollection
    implements IterableSeq {
        final IFn mapFn;
        final Object src;
        final IPersistentMap meta;

        public IndexedMapper(IFn iFn, Object object, IPersistentMap iPersistentMap) {
            this.mapFn = iFn;
            this.src = object;
            this.meta = iPersistentMap;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            return Transformables.iterCount(Transformables.toIterable(this.src).iterator());
        }

        MapIterable mapper() {
            return new MapIterable(new CountingFn(this.mapFn), this.meta, this.src);
        }

        public Iterator iterator() {
            return this.mapper().iterator();
        }

        public Object reduce(IFn iFn, Object object) {
            return this.mapper().reduce(iFn, object);
        }

        @Override
        public IMapable map(final IFn iFn) {
            final IFn iFn2 = this.mapFn;
            return new IndexedMapper(new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return iFn.invoke(iFn2.invoke(object, object2));
                }
            }, this.src, this.meta);
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public IObj withMeta(IPersistentMap iPersistentMap) {
            return new IndexedMapper(this.mapFn, this.src, this.meta);
        }

        public static class CountingFn
        implements IFnDef {
            long cnt = 0L;
            final IFn mapFn;

            public CountingFn(IFn iFn) {
                this.mapFn = iFn;
            }

            @Override
            public Object invoke(Object object) {
                return this.mapFn.invoke((Object)this.cnt++, object);
            }
        }
    }

    public static class MapList
    implements IMutList,
    IMapable {
        final int nElems;
        final List[] lists;
        final IFn fn;
        final IPersistentMap meta;
        final IFn.LO getter;

        public MapList(IFn iFn, IPersistentMap iPersistentMap, List ... listArray) {
            final int n = listArray.length;
            if (n == 0) {
                this.nElems = 0;
            } else {
                int n2 = listArray[0].size();
                for (int i = 1; i < n; ++i) {
                    n2 = Math.min(n2, listArray[i].size());
                }
                this.nElems = n2;
            }
            this.lists = listArray;
            this.fn = iFn;
            this.meta = iPersistentMap;
            IFnDef.LO lO = null;
            final List[] listArray2 = this.lists;
            switch (n) {
                case 1: {
                    lO = new IFnDef.LO(){

                        public Object invokePrim(long l) {
                            return fn.invoke(listArray2[0].get((int)l));
                        }
                    };
                    break;
                }
                case 2: {
                    lO = new IFnDef.LO(){

                        public Object invokePrim(long l) {
                            return fn.invoke(listArray2[0].get((int)l), listArray2[1].get((int)l));
                        }
                    };
                    break;
                }
                case 3: {
                    lO = new IFnDef.LO(){

                        public Object invokePrim(long l) {
                            int n = (int)l;
                            return fn.invoke(listArray2[0].get(n), listArray2[1].get(n), listArray2[2].get(n));
                        }
                    };
                    break;
                }
                case 4: {
                    lO = new IFnDef.LO(){

                        public Object invokePrim(long l) {
                            int n = (int)l;
                            return fn.invoke(listArray2[0].get(n), listArray2[1].get(n), listArray2[2].get(n), listArray2[3].get(n));
                        }
                    };
                    break;
                }
                default: {
                    lO = new IFnDef.LO(){

                        public Object invokePrim(long l) {
                            int n2 = (int)l;
                            Object[] objectArray = new Object[n];
                            for (int i = 0; i < n; ++i) {
                                objectArray[i] = lists[i].get(n2);
                            }
                            return fn.applyTo((ISeq)ArraySeq.create((Object[])objectArray));
                        }
                    };
                }
            }
            this.getter = lO;
        }

        public MapList(MapList mapList, IPersistentMap iPersistentMap) {
            this.nElems = mapList.nElems;
            this.lists = mapList.lists;
            this.fn = mapList.fn;
            this.getter = mapList.getter;
            this.meta = iPersistentMap;
        }

        public static IMutList create(IFn iFn, IPersistentMap iPersistentMap, List ... listArray) {
            if (listArray.length == 1) {
                return new SingleMapList(iFn, iPersistentMap, listArray[0]);
            }
            if (listArray.length == 2) {
                return new DualMapList(iFn, iPersistentMap, listArray[0], listArray[1]);
            }
            return new MapList(iFn, iPersistentMap, listArray);
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            if (n < 0) {
                n += this.nElems;
            }
            if (n < 0 || n >= this.nElems) {
                throw new RuntimeException("Index out of range.");
            }
            return this.getter.invokePrim((long)n);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            int n = this.nElems;
            List[] listArray = this.lists;
            int n2 = listArray.length;
            switch (n2) {
                case 1: {
                    return Reductions.serialReduction(Transformables.mapReducer(iFn, this.fn), object, listArray[0]);
                }
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.invoke(this.lists[0].get(i), this.lists[1].get(i)))))) continue;
                        return ((IDeref)object).deref();
                    }
                    return object;
                }
                case 3: {
                    for (int i = 0; i < n; ++i) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.invoke(this.lists[0].get(i), this.lists[1].get(i), this.lists[2].get(i)))))) continue;
                        return ((IDeref)object).deref();
                    }
                    return object;
                }
                case 4: {
                    for (int i = 0; i < n; ++i) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.invoke(this.lists[0].get(i), this.lists[1].get(i), this.lists[2].get(i), this.lists[3].get(i)))))) continue;
                        return ((IDeref)object).deref();
                    }
                    return object;
                }
            }
            Object[] objectArray = new Object[n2];
            ArraySeq arraySeq = ArraySeq.create((Object[])objectArray);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    objectArray[j] = this.lists[j].get(i);
                }
                if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.applyTo((ISeq)arraySeq))))) continue;
                return ((IDeref)object).deref();
            }
            return object;
        }

        @Override
        public IMutList subList(int n, int n2) {
            int n3 = this.size();
            if (n < 0 || n >= n3) {
                throw new RuntimeException("Start index out of range.");
            }
            if (n2 < n || n2 > n3) {
                throw new RuntimeException("End index out of range.");
            }
            int n4 = this.lists.length;
            List[] listArray = new List[n4];
            for (int i = 0; i < n4; ++i) {
                listArray[i] = this.lists[i].subList(n, n2);
            }
            return new MapList(this.fn, this.meta(), listArray);
        }

        @Override
        public MapList map(IFn iFn) {
            return new MapList(MapFn.create(this.fn, iFn), this.meta(), this.lists);
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public MapList withMeta(IPersistentMap iPersistentMap) {
            return new MapList(this, iPersistentMap);
        }
    }

    public static class DualMapList
    implements IMutList,
    IMapable {
        final int nElems;
        final List lhs;
        final List rhs;
        final IFn fn;
        final IPersistentMap meta;

        public DualMapList(IFn iFn, IPersistentMap iPersistentMap, List list, List list2) {
            this.nElems = Math.min(list.size(), list2.size());
            this.lhs = list;
            this.rhs = list2;
            this.fn = iFn;
            this.meta = iPersistentMap;
        }

        public DualMapList(DualMapList dualMapList, IPersistentMap iPersistentMap) {
            this.nElems = dualMapList.nElems;
            this.lhs = dualMapList.lhs;
            this.rhs = dualMapList.rhs;
            this.fn = dualMapList.fn;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.fn.invoke(this.lhs.get(n), this.rhs.get(n));
        }

        @Override
        public DualMapList subList(int n, int n2) {
            return new DualMapList(this.fn, this.meta, this.lhs.subList(n, n2), this.rhs.subList(n, n2));
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public DualMapList withMeta(IPersistentMap iPersistentMap) {
            return new DualMapList(this, iPersistentMap);
        }

        @Override
        public DualMapList map(IFn iFn) {
            return new DualMapList(MapFn.create(this.fn, iFn), this.meta, this.lhs, this.rhs);
        }
    }

    public static class SingleMapList
    implements IMutList,
    IMapable {
        final int nElems;
        final List list;
        final IFn fn;
        final IPersistentMap meta;

        public SingleMapList(IFn iFn, IPersistentMap iPersistentMap, List list) {
            this.nElems = list.size();
            this.list = list;
            this.fn = iFn;
            this.meta = iPersistentMap;
        }

        public SingleMapList(SingleMapList singleMapList, IPersistentMap iPersistentMap) {
            this.nElems = singleMapList.nElems;
            this.list = singleMapList.list;
            this.fn = singleMapList.fn;
            this.meta = iPersistentMap;
        }

        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return this.nElems;
        }

        @Override
        public Object get(int n) {
            return this.fn.invoke(this.list.get(n));
        }

        @Override
        public SingleMapList subList(int n, int n2) {
            return new SingleMapList(this.fn, this.meta, this.list.subList(n, n2));
        }

        @Override
        public IPersistentMap meta() {
            return this.meta;
        }

        @Override
        public SingleMapList withMeta(IPersistentMap iPersistentMap) {
            return new SingleMapList(this, iPersistentMap);
        }

        @Override
        public SingleMapList map(IFn iFn) {
            return new SingleMapList(MapFn.create(this.fn, iFn), this.meta, this.list);
        }

        @Override
        public Object reduce(IFn iFn, Object object) {
            return Transformables.singleMapReduce(this.list, iFn, this.fn, object);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelReduction(iFn, Transformables.typedMapReducer(iFn2, this.fn), iFn3, this.list, parallelOptions);
        }
    }

    public static class CatIterable
    extends AbstractCollection
    implements IterableSeq {
        final Iterable[] data;
        public final IPersistentMap meta;
        public final ParallelOptions.CatParallelism parallelism;

        public CatIterable(IPersistentMap iPersistentMap, ParallelOptions.CatParallelism catParallelism, Iterable iterable) {
            this.data = new Iterable[]{iterable};
            this.meta = iPersistentMap;
            this.parallelism = catParallelism;
        }

        public CatIterable(IPersistentMap iPersistentMap, Iterable[] iterableArray) {
            this.data = iterableArray;
            this.meta = iPersistentMap;
            this.parallelism = null;
        }

        public CatIterable(Iterable iterable) {
            this.data = new Iterable[]{iterable};
            this.meta = null;
            this.parallelism = null;
        }

        public CatIterable(CatIterable catIterable, IPersistentMap iPersistentMap) {
            this.data = catIterable.data;
            this.meta = iPersistentMap;
            this.parallelism = catIterable.parallelism;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public int size() {
            return Transformables.iterCount(this.iterator());
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public Iterator iterator() {
            return new CatIterator(ArrayLists.toList(this.data).iterator());
        }

        @Override
        public IMapable cat(Iterable iterable) {
            int n = this.data.length;
            Iterable[] iterableArray = Arrays.copyOf(this.data, n + 1);
            iterableArray[n] = iterable;
            return new CatIterable(this.meta(), iterableArray);
        }

        @Override
        public ISeq seq() {
            return LazyChunkedSeq.chunkIteratorSeq(this.iterator());
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public CatIterable withMeta(IPersistentMap iPersistentMap) {
            return new CatIterable(this, iPersistentMap);
        }

        @Override
        public Object reduce(IFn iFn) {
            return Reductions.iterReduce(this, iFn);
        }

        public static IFn catReducer(final IFn iFn) {
            if (iFn instanceof IFn.OLO) {
                final IFn.OLO oLO = (IFn.OLO)iFn;
                return new IFnDef.OLO(){

                    public Object invokePrim(Object object, long l) {
                        return RT.isReduced((Object)(object = oLO.invokePrim(object, l))) ? new Reduced(object) : object;
                    }
                };
            }
            if (iFn instanceof IFn.ODO) {
                final IFn.ODO oDO = (IFn.ODO)iFn;
                return new IFnDef.ODO(){

                    public Object invokePrim(Object object, double d) {
                        return RT.isReduced((Object)(object = oDO.invokePrim(object, d))) ? new Reduced(object) : object;
                    }
                };
            }
            return new IFnDef(){

                @Override
                public Object invoke(Object object, Object object2) {
                    return RT.isReduced((Object)(object = iFn.invoke(object, object2))) ? new Reduced(object) : object;
                }
            };
        }

        public Object reduce(IFn iFn, Object object) {
            int n = this.data.length;
            Iterable[] iterableArray = this.data;
            IFn iFn2 = CatIterable.catReducer(iFn);
            for (int i = 0; i < n && !RT.isReduced((Object)object); ++i) {
                Iterable iterable = iterableArray[i];
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext() && !RT.isReduced((Object)object)) {
                    object = Reductions.serialReduction(iFn2, object, iterator.next());
                }
            }
            return Reductions.unreduce(object);
        }

        Object preduceSeqwise(final IFn iFn, final IFn iFn2, IFn iFn3, Object object, ParallelOptions parallelOptions) {
            Iterable iterable = new Iterable(){

                public Iterator iterator() {
                    return new CatIterIter(ArrayLists.toList(data).iterator());
                }
            };
            Iterable iterable2 = ForkJoinPatterns.pmap(parallelOptions, new IFnDef(){

                @Override
                public Object invoke(Object object) {
                    return Reductions.serialReduction(iFn2, iFn.invoke(), object);
                }
            }, ArrayLists.toList(new Object[]{iterable}));
            if (parallelOptions.unmergedResult) {
                return iterable2;
            }
            return Reductions.serialReduction(iFn3, object, iterable2);
        }

        @Override
        public Object parallelReduction(final IFn iFn, IFn iFn2, final IFn iFn3, final ParallelOptions parallelOptions) {
            int n = this.data.length;
            Iterable[] iterableArray = this.data;
            Object object = iFn.invoke();
            final IFn iFn4 = CatIterable.catReducer(iFn2);
            ParallelOptions.CatParallelism catParallelism = this.parallelism != null ? this.parallelism : parallelOptions.catParallelism;
            switch (catParallelism) {
                case ELEMWISE: {
                    Iterable iterable = new Iterable(){

                        public Iterator iterator() {
                            return new CatIterIter(ArrayLists.toList(data).iterator());
                        }
                    };
                    MapIterable mapIterable = new MapIterable(new IFnDef(){

                        @Override
                        public Object invoke(Object object) {
                            return Reductions.parallelReduction(iFn, iFn4, iFn3, object, parallelOptions);
                        }
                    }, null, iterable);
                    if (parallelOptions.unmergedResult) {
                        object = new CatIterable(mapIterable);
                        break;
                    }
                    object = Reductions.iterableMerge(parallelOptions, iFn3, mapIterable);
                    break;
                }
                case SEQWISE: {
                    object = this.preduceSeqwise(iFn, iFn4, iFn3, object, parallelOptions);
                }
            }
            return Reductions.unreduce(object);
        }

        @Override
        public Object[] toArray() {
            return ArrayLists.toArray(this);
        }

        static class CatIterator
        implements Iterator {
            Iterator gpIter;
            Iterator parentIter;
            Iterator curIter;

            CatIterator(Iterator iterator) {
                this.gpIter = iterator;
                this.parentIter = null;
                this.curIter = null;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.curIter != null && this.curIter.hasNext();
            }

            public Object next() {
                Object e = this.curIter.next();
                if (!this.curIter.hasNext()) {
                    this.advance();
                }
                return e;
            }

            boolean advanceParent() {
                if (this.hasNext()) {
                    return true;
                }
                while (this.parentIter != null && this.parentIter.hasNext()) {
                    Iterable iterable = Transformables.toIterable(this.parentIter.next());
                    this.curIter = iterable != null ? iterable.iterator() : null;
                    if (!this.hasNext()) continue;
                    return true;
                }
                this.parentIter = null;
                this.curIter = null;
                return false;
            }

            void advance() {
                if (this.hasNext()) {
                    return;
                }
                if (this.advanceParent()) {
                    return;
                }
                while (this.gpIter != null && this.gpIter.hasNext()) {
                    this.parentIter = null;
                    Iterable iterable = (Iterable)this.gpIter.next();
                    if (iterable != null) {
                        this.parentIter = iterable.iterator();
                    }
                    if (!this.advanceParent()) continue;
                    return;
                }
                this.gpIter = null;
                this.parentIter = null;
                this.curIter = null;
            }
        }

        static class CatIterIter
        implements Iterator {
            Iterator gpIter;
            Iterator parentIter;

            CatIterIter(Iterator iterator) {
                this.gpIter = iterator;
                this.parentIter = null;
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.parentIter != null && this.parentIter.hasNext();
            }

            public Object next() {
                Object e = this.parentIter.next();
                if (!this.parentIter.hasNext()) {
                    this.advance();
                }
                return e;
            }

            void advance() {
                if (this.hasNext()) {
                    return;
                }
                while (this.gpIter != null && this.gpIter.hasNext()) {
                    this.parentIter = null;
                    Iterable iterable = (Iterable)this.gpIter.next();
                    if (iterable != null) {
                        this.parentIter = iterable.iterator();
                    }
                    if (!this.hasNext()) continue;
                    return;
                }
                this.gpIter = null;
                this.parentIter = null;
            }
        }
    }

    public static class FilterIterable
    extends AbstractCollection
    implements IterableSeq {
        final IFn pred;
        final Object src;
        final IPersistentMap meta;

        public FilterIterable(IFn iFn, IPersistentMap iPersistentMap, Object object) {
            this.pred = iFn;
            this.src = object;
            this.meta = iPersistentMap;
        }

        public FilterIterable(FilterIterable filterIterable, IPersistentMap iPersistentMap) {
            this.pred = filterIterable.pred;
            this.src = filterIterable.src;
            this.meta = iPersistentMap;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean isEmpty() {
            return this.seq() == null;
        }

        @Override
        public int size() {
            return Transformables.iterCount(this.iterator());
        }

        public Iterator iterator() {
            return new FilterIterator(Transformables.toIterable(this.src).iterator(), this.pred);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public ISeq seq() {
            return LazyChunkedSeq.chunkIteratorSeq(this.iterator());
        }

        @Override
        public IMapable filter(IFn iFn) {
            return new FilterIterable(PredFn.create(this.pred, iFn), this.meta(), this.src);
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public FilterIterable withMeta(IPersistentMap iPersistentMap) {
            return new FilterIterable(this, iPersistentMap);
        }

        public static IFn typedReducer(final IFn iFn, final IFn iFn2) {
            if (iFn2 instanceof LongPredicate) {
                final LongPredicate longPredicate = (LongPredicate)iFn2;
                final IFn.OLO oLO = Transformables.toLongReductionFn(iFn);
                return new Reductions.LongAccum(){

                    @Override
                    public Object invoke() {
                        return iFn.invoke();
                    }

                    @Override
                    public Object invoke(Object object) {
                        return iFn.invoke(object);
                    }

                    public Object invokePrim(Object object, long l) {
                        return longPredicate.test(l) ? oLO.invokePrim(object, l) : object;
                    }
                };
            }
            if (iFn2 instanceof IFn.LO) {
                final IFn.LO lO = (IFn.LO)iFn2;
                final IFn.OLO oLO = Transformables.toLongReductionFn(iFn);
                return new Reductions.LongAccum(){

                    @Override
                    public Object invoke() {
                        return iFn.invoke();
                    }

                    @Override
                    public Object invoke(Object object) {
                        return iFn.invoke(object);
                    }

                    public Object invokePrim(Object object, long l) {
                        return Transformables.truthy(lO.invokePrim(l)) ? oLO.invokePrim(object, l) : object;
                    }
                };
            }
            if (iFn2 instanceof DoublePredicate) {
                final DoublePredicate doublePredicate = (DoublePredicate)iFn2;
                final IFn.ODO oDO = Transformables.toDoubleReductionFn(iFn);
                return new Reductions.DoubleAccum(){

                    @Override
                    public Object invoke() {
                        return iFn.invoke();
                    }

                    @Override
                    public Object invoke(Object object) {
                        return iFn.invoke(object);
                    }

                    public Object invokePrim(Object object, double d) {
                        return doublePredicate.test(d) ? oDO.invokePrim(object, d) : object;
                    }
                };
            }
            if (iFn2 instanceof IFn.DO) {
                final IFn.DO dO = (IFn.DO)iFn2;
                final IFn.ODO oDO = Transformables.toDoubleReductionFn(iFn);
                return new Reductions.DoubleAccum(){

                    @Override
                    public Object invoke() {
                        return iFn.invoke();
                    }

                    @Override
                    public Object invoke(Object object) {
                        return iFn.invoke(object);
                    }

                    public Object invokePrim(Object object, double d) {
                        return Transformables.truthy(dO.invokePrim(d)) ? oDO.invokePrim(object, d) : object;
                    }
                };
            }
            if (iFn2 instanceof Predicate) {
                final Predicate predicate = (Predicate)iFn2;
                return new IFnDef(){

                    @Override
                    public Object invoke() {
                        return iFn.invoke();
                    }

                    @Override
                    public Object invoke(Object object) {
                        return iFn.invoke(object);
                    }

                    @Override
                    public Object invoke(Object object, Object object2) {
                        return predicate.test(object2) ? iFn.invoke(object, object2) : object;
                    }
                };
            }
            return new IFnDef(){

                @Override
                public Object invoke() {
                    return iFn.invoke();
                }

                @Override
                public Object invoke(Object object) {
                    return iFn.invoke(object);
                }

                @Override
                public Object invoke(Object object, Object object2) {
                    return Transformables.truthy(iFn2.invoke(object2)) ? iFn.invoke(object, object2) : object;
                }
            };
        }

        public Object reduce(IFn iFn, Object object) {
            return Reductions.serialReduction(FilterIterable.typedReducer(iFn, this.pred), object, this.src);
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            return Reductions.parallelReduction(iFn, FilterIterable.typedReducer(iFn2, this.pred), iFn3, this.src, parallelOptions);
        }

        @Override
        public Object[] toArray() {
            return ArrayLists.toArray(this);
        }

        static class FilterIterator
        implements Iterator {
            final Iterator iter;
            final IFn pred;
            Box nextObj = new Box(null);

            public FilterIterator(Iterator iterator, IFn iFn) {
                this.iter = iterator;
                this.pred = iFn;
                this.advance();
            }

            void advance() {
                while (this.iter.hasNext()) {
                    Object e = this.iter.next();
                    if (!Transformables.truthy(this.pred.invoke(e))) continue;
                    this.nextObj.val = e;
                    return;
                }
                this.nextObj = null;
            }

            @Override
            public boolean hasNext() {
                return this.nextObj != null;
            }

            public Object next() {
                if (this.nextObj == null) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextObj.val;
                this.advance();
                return object;
            }
        }
    }

    public static class PredFn
    implements IFnDef {
        final IFn srcPred;
        final IFn dstPred;

        static IFn create(IFn iFn, IFn iFn2) {
            if (iFn instanceof IFnDef.LongPredicate && iFn2 instanceof IFnDef.LongPredicate) {
                final IFnDef.LongPredicate longPredicate = (IFnDef.LongPredicate)iFn;
                final IFnDef.LongPredicate longPredicate2 = (IFnDef.LongPredicate)iFn2;
                return new IFnDef.LongPredicate(){

                    @Override
                    public boolean test(long l) {
                        return longPredicate.test(l) && longPredicate2.test(l);
                    }
                };
            }
            if (iFn instanceof IFn.LO && iFn2 instanceof IFn.LO) {
                final IFn.LO lO = (IFn.LO)iFn;
                final IFn.LO lO2 = (IFn.LO)iFn2;
                return new IFnDef.LO(){

                    public Object invokePrim(long l) {
                        return Transformables.truthy(lO.invokePrim(l)) && Transformables.truthy(lO2.invokePrim(l));
                    }
                };
            }
            if (iFn instanceof IFnDef.DoublePredicate && iFn2 instanceof IFnDef.DoublePredicate) {
                final IFnDef.DoublePredicate doublePredicate = (IFnDef.DoublePredicate)iFn;
                final IFnDef.DoublePredicate doublePredicate2 = (IFnDef.DoublePredicate)iFn2;
                return new IFnDef.DoublePredicate(){

                    @Override
                    public boolean test(double d) {
                        return doublePredicate.test(d) && doublePredicate2.test(d);
                    }
                };
            }
            if (iFn instanceof IFn.DO && iFn2 instanceof IFn.DO) {
                final IFn.DO dO = (IFn.DO)iFn;
                final IFn.DO dO2 = (IFn.DO)iFn2;
                return new IFnDef.DO(){

                    public Object invokePrim(double d) {
                        return Transformables.truthy(dO.invokePrim(d)) && Transformables.truthy(dO2.invokePrim(d));
                    }
                };
            }
            if (iFn instanceof IFnDef.Predicate && iFn2 instanceof IFnDef.Predicate) {
                final IFnDef.Predicate predicate = (IFnDef.Predicate)iFn;
                final IFnDef.Predicate predicate2 = (IFnDef.Predicate)iFn2;
                return new IFnDef.Predicate(){

                    public boolean test(Object object) {
                        return predicate.test(object) && predicate2.test(object);
                    }
                };
            }
            return new PredFn(iFn, iFn2);
        }

        public PredFn(IFn iFn, IFn iFn2) {
            this.srcPred = iFn;
            this.dstPred = iFn2;
        }

        @Override
        public Object invoke(Object object) {
            return Transformables.truthy(this.srcPred.invoke(object)) && Transformables.truthy(this.dstPred.invoke(object));
        }
    }

    public static class MapIterable
    extends AbstractCollection
    implements IterableSeq {
        final Object[] iterables;
        final IFn fn;
        final IPersistentMap meta;

        public MapIterable(IFn iFn, IPersistentMap iPersistentMap, Object ... objectArray) {
            this.fn = iFn;
            this.meta = iPersistentMap;
            this.iterables = objectArray;
        }

        public static MapIterable createSingle(IFn iFn, IPersistentMap iPersistentMap, Object object) {
            return new MapIterable(iFn, iPersistentMap, object);
        }

        public MapIterable(MapIterable mapIterable, IPersistentMap iPersistentMap) {
            this.fn = mapIterable.fn;
            this.iterables = mapIterable.iterables;
            this.meta = iPersistentMap;
        }

        @Override
        public String toString() {
            return Transformables.sequenceToString(this);
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            return Transformables.iterCount(this.iterator());
        }

        public Iterator iterator() {
            final int n = this.iterables.length;
            switch (n) {
                case 1: {
                    return new SingleIterator(this.fn, Transformables.toIterable(this.iterables[0]).iterator());
                }
                case 2: {
                    return new DualIterator(this.fn, Transformables.toIterable(this.iterables[0]).iterator(), Transformables.toIterable(this.iterables[1]).iterator());
                }
            }
            final Iterator[] iteratorArray = new Iterator[n];
            for (int i = 0; i < n; ++i) {
                iteratorArray[i] = Transformables.toIterable(this.iterables[i]).iterator();
            }
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    for (int i = 0; i < n; ++i) {
                        if (iteratorArray[i].hasNext()) continue;
                        return false;
                    }
                    return true;
                }

                public Object next() {
                    switch (n) {
                        case 3: {
                            return fn.invoke(iteratorArray[0].next(), iteratorArray[1].next(), iteratorArray[2].next());
                        }
                        case 4: {
                            return fn.invoke(iteratorArray[0].next(), iteratorArray[1].next(), iteratorArray[2].next(), iteratorArray[3].next());
                        }
                    }
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = iteratorArray[i].next();
                    }
                    return fn.applyTo((ISeq)ArraySeq.create((Object[])objectArray));
                }
            };
        }

        @Override
        public ISeq seq() {
            return LazyChunkedSeq.chunkIteratorSeq(this.iterator());
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        @Override
        public MapIterable map(IFn iFn) {
            return new MapIterable(MapFn.create(this.fn, iFn), this.meta(), this.iterables);
        }

        public IPersistentMap meta() {
            return this.meta;
        }

        public MapIterable withMeta(IPersistentMap iPersistentMap) {
            return new MapIterable(this, iPersistentMap);
        }

        public Object reduce(IFn iFn, Object object) {
            int n;
            int n2 = this.iterables.length;
            if (n2 == 1) {
                return Transformables.singleMapReduce(this.iterables[0], iFn, this.fn, object);
            }
            Iterator[] iteratorArray = new Iterator[n2];
            for (n = 0; n < n2; ++n) {
                iteratorArray[n] = Transformables.toIterable(this.iterables[n]).iterator();
            }
            switch (this.iterables.length) {
                case 2: {
                    Iterator iterator = iteratorArray[0];
                    Iterator iterator2 = iteratorArray[1];
                    while (iterator.hasNext() && iterator2.hasNext()) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.invoke(iterator.next(), iterator2.next()))))) continue;
                        return ((IDeref)object).deref();
                    }
                    break;
                }
                case 3: {
                    Iterator iterator = iteratorArray[0];
                    Iterator iterator3 = iteratorArray[1];
                    Iterator iterator4 = iteratorArray[2];
                    while (iterator.hasNext() && iterator3.hasNext() && iterator4.hasNext()) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.invoke(iterator.next(), iterator3.next(), iterator4.next()))))) continue;
                        return ((IDeref)object).deref();
                    }
                    break;
                }
                case 4: {
                    Iterator iterator = iteratorArray[0];
                    Iterator iterator5 = iteratorArray[1];
                    Iterator iterator6 = iteratorArray[2];
                    Iterator iterator7 = iteratorArray[3];
                    while (iterator.hasNext() && iterator5.hasNext() && iterator6.hasNext() && iterator7.hasNext()) {
                        if (!RT.isReduced((Object)(object = iFn.invoke(object, this.fn.invoke(iterator.next(), iterator5.next(), iterator6.next(), iterator7.next()))))) continue;
                        return ((IDeref)object).deref();
                    }
                    break;
                }
                default: {
                    n = 1;
                    for (int i = 0; i < n2 && n != 0; ++i) {
                        n = n != 0 && iteratorArray[i].hasNext() ? 1 : 0;
                    }
                    if (n == 0) break;
                    Object[] objectArray = new Object[n2];
                    ArraySeq arraySeq = ArraySeq.create((Object[])objectArray);
                    while (n != 0) {
                        int n3;
                        for (n3 = 0; n3 < n2 && n != 0; ++n3) {
                            objectArray[n3] = iteratorArray[n3].next();
                        }
                        if (RT.isReduced((Object)(object = iFn.invoke(object, this.fn.applyTo((ISeq)arraySeq))))) {
                            return ((IDeref)object).deref();
                        }
                        for (n3 = 0; n3 < n2 && n != 0; ++n3) {
                            n = n != 0 && iteratorArray[n3].hasNext() ? 1 : 0;
                        }
                    }
                    break block0;
                }
            }
            return object;
        }

        @Override
        public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
            if (this.iterables.length == 1) {
                return Reductions.parallelReduction(iFn, Transformables.typedMapReducer(iFn2, this.fn), iFn3, this.iterables[0], parallelOptions);
            }
            return Reductions.serialParallelReduction(iFn, iFn2, parallelOptions, this);
        }

        @Override
        public Object[] toArray() {
            return ArrayLists.toArray(this);
        }

        static class SingleIterator
        implements Iterator {
            final Iterator iter;
            final IFn fn;

            public SingleIterator(IFn iFn, Iterator iterator) {
                this.iter = iterator;
                this.fn = iFn;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.fn.invoke(this.iter.next());
            }
        }

        static class DualIterator
        implements Iterator {
            final Iterator lhs;
            final Iterator rhs;
            final IFn fn;

            public DualIterator(IFn iFn, Iterator iterator, Iterator iterator2) {
                this.lhs = iterator;
                this.rhs = iterator2;
                this.fn = iFn;
            }

            @Override
            public boolean hasNext() {
                return this.lhs.hasNext() && this.rhs.hasNext();
            }

            public Object next() {
                return this.fn.invoke(this.lhs.next(), this.rhs.next());
            }
        }
    }

    public static interface IterableSeq
    extends Collection,
    Seqable,
    IMapable,
    ITypedReduce,
    IHashEq,
    Sequential,
    IPersistentCollection {
        default public int hasheq() {
            return Murmur3.hashOrdered((Iterable)this);
        }

        default public boolean equiv(Object object) {
            return Transformables.seqEquiv(this, object);
        }

        default public int count() {
            long l = 0L;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++l;
                iterator.next();
            }
            return RT.intCast((long)l);
        }

        default public IPersistentCollection cons(Object object) {
            return RT.cons((Object)object, (Object)this.seq());
        }

        default public IPersistentCollection empty() {
            return PersistentList.EMPTY;
        }

        default public void forEach(Consumer consumer) {
            ITypedReduce.super.forEach(consumer);
        }

        default public ISeq seq() {
            return LazyChunkedSeq.chunkIteratorSeq(this.iterator());
        }
    }

    public static interface IMapable
    extends Iterable,
    IObj {
        default public IMapable map(IFn iFn) {
            return new MapIterable(iFn, this.meta(), this);
        }

        default public IMapable filter(IFn iFn) {
            return new FilterIterable(iFn, this.meta(), this);
        }

        default public IMapable cat(Iterable iterable) {
            return new CatIterable(this.meta(), new Iterable[]{ArrayLists.toList(new Iterable[]{this}), iterable});
        }
    }
}

