/*
 * Decompiled with CFR 0.152.
 */
package ham_fisted;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import ham_fisted.Casts;
import ham_fisted.CljHash;
import ham_fisted.IFnDef;
import ham_fisted.IMap;
import ham_fisted.LongHashBase;
import ham_fisted.LongHashNode;
import ham_fisted.MapSetOps;
import ham_fisted.ParallelOptions;
import ham_fisted.Reductions;
import ham_fisted.UpdateValues;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LongHashMap
extends LongHashBase
implements IMap,
MapSetOps,
UpdateValues {
    Set keySet = null;

    public LongHashMap(float f, int n, int n2, LongHashNode[] longHashNodeArray, IPersistentMap iPersistentMap) {
        super(f, n, n2, longHashNodeArray, iPersistentMap);
    }

    public LongHashMap() {
        this(0.75f, 0, 0, null, null);
    }

    public LongHashMap(IPersistentMap iPersistentMap) {
        this(0.75f, 0, 0, null, iPersistentMap);
    }

    public LongHashMap(LongHashMap longHashMap, IPersistentMap iPersistentMap) {
        super(longHashMap, iPersistentMap);
    }

    public LongHashMap shallowClone() {
        return new LongHashMap(this.loadFactor, this.capacity, this.length, (LongHashNode[])this.data.clone(), this.meta);
    }

    public LongHashMap clone() {
        int n = this.data.length;
        LongHashNode[] longHashNodeArray = new LongHashNode[n];
        LongHashMap longHashMap = new LongHashMap(this.loadFactor, this.capacity, this.length, longHashNodeArray, this.meta);
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = this.data[i];
            if (longHashNode == null) continue;
            longHashNodeArray[i] = longHashNode.clone(longHashMap);
        }
        return longHashMap;
    }

    @Override
    public int hashCode() {
        return this.hasheq();
    }

    public int hasheq() {
        return CljHash.mapHashcode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this.equiv(object);
    }

    public boolean equiv(Object object) {
        return CljHash.mapEquiv(this, object);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = (StringBuilder)this.reduce(new IFnDef(){

            @Override
            public Object invoke(Object object, Object object2) {
                StringBuilder stringBuilder = (StringBuilder)object;
                Map.Entry entry = (Map.Entry)object2;
                if (stringBuilder.length() > 2) {
                    stringBuilder.append(",");
                }
                return stringBuilder.append(entry.getKey()).append(" ").append(entry.getValue());
            }
        }, new StringBuilder().append("{"));
        return stringBuilder.append("}").toString();
    }

    public Object put(Object object, Object object2) {
        long l = Casts.longCast(object);
        int n = LongHashMap.hash(l);
        int n2 = n & this.mask;
        LongHashNode longHashNode = null;
        LongHashNode longHashNode2 = this.data[n2];
        while (longHashNode2 != null) {
            longHashNode = longHashNode2;
            if (longHashNode2.k == l || LongHashMap.equals(longHashNode2.k, l)) {
                Object object3 = longHashNode2.v;
                longHashNode2.v = object2;
                this.modify(longHashNode2);
                return object3;
            }
            longHashNode2 = longHashNode2.nextNode;
        }
        longHashNode2 = this.newNode(l, n, object2);
        if (longHashNode != null) {
            longHashNode.nextNode = longHashNode2;
        } else {
            this.data[n2] = longHashNode2;
        }
        return this.checkResize(null);
    }

    @Override
    public void putAll(Map map) {
        LongHashNode[] longHashNodeArray = this.data;
        int n = this.mask;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            long l = Casts.longCast(entry2.getKey());
            int n2 = LongHashMap.hash(l);
            int n3 = n2 & n;
            LongHashNode longHashNode = longHashNodeArray[n3];
            while (longHashNode != null && l != longHashNode.k) {
                longHashNode = longHashNode.nextNode;
            }
            if (longHashNode != null) {
                longHashNode.v = entry2.getValue();
                continue;
            }
            LongHashNode longHashNode2 = this.newNode(l, n2, entry2.getValue());
            longHashNode2.nextNode = longHashNodeArray[n3];
            longHashNodeArray[n3] = longHashNode2;
            this.checkResize(null);
            longHashNodeArray = this.data;
            n = this.mask;
        }
    }

    public Object getOrDefault(Object object, Object object2) {
        if (object instanceof Number) {
            long l = Casts.longCast(object);
            LongHashNode longHashNode = this.data[LongHashMap.hash(l) & this.mask];
            while (longHashNode != null) {
                if (longHashNode.k == l) {
                    return longHashNode.v;
                }
                longHashNode = longHashNode.nextNode;
            }
        }
        return object2;
    }

    public Object get(Object object) {
        if (object instanceof Number) {
            long l = Casts.longCast(object);
            LongHashNode longHashNode = this.data[LongHashMap.hash(l) & this.mask];
            while (longHashNode != null) {
                if (longHashNode.k == l) {
                    return longHashNode.v;
                }
                longHashNode = longHashNode.nextNode;
            }
        }
        return null;
    }

    public IMapEntry entryAt(Object object) {
        if (object instanceof Number) {
            long l = Casts.longCast(object);
            LongHashNode longHashNode = this.data[LongHashMap.hash(l) & this.mask];
            while (longHashNode != null) {
                if (longHashNode.k == l) {
                    return MapEntry.create((Object)longHashNode.k, (Object)longHashNode.v);
                }
                longHashNode = longHashNode.nextNode;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsNodeKey(object);
    }

    public Object compute(Object object, BiFunction biFunction) {
        long l = Casts.longCast(object);
        int n = LongHashMap.hash(l);
        LongHashNode[] longHashNodeArray = this.data;
        int n2 = n & this.mask;
        LongHashNode longHashNode = longHashNodeArray[n2];
        LongHashNode longHashNode2 = null;
        while (longHashNode != null && longHashNode.k != l && !LongHashMap.equals(longHashNode.k, l)) {
            longHashNode2 = longHashNode;
            longHashNode = longHashNode.nextNode;
        }
        Object r = biFunction.apply(l, longHashNode == null ? null : longHashNode.v);
        if (longHashNode != null) {
            if (r != null) {
                longHashNode.v = r;
                this.modify(longHashNode);
            } else {
                this.remove(l, null);
            }
        } else if (r != null) {
            LongHashNode longHashNode3 = this.newNode(l, n, r);
            if (longHashNode2 != null) {
                longHashNode2.nextNode = longHashNode3;
            } else {
                longHashNodeArray[n2] = longHashNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    public Object computeIfAbsent(Object object, Function function) {
        long l = Casts.longCast(object);
        int n = LongHashMap.hash(l);
        LongHashNode[] longHashNodeArray = this.data;
        int n2 = n & this.mask;
        LongHashNode longHashNode = longHashNodeArray[n2];
        LongHashNode longHashNode2 = null;
        while (longHashNode != null && longHashNode.k != l && !LongHashMap.equals(longHashNode.k, l)) {
            longHashNode2 = longHashNode;
            longHashNode = longHashNode.nextNode;
        }
        if (longHashNode != null) {
            return longHashNode.v;
        }
        Object r = function.apply(l);
        if (r != null) {
            LongHashNode longHashNode3 = this.newNode(l, n, r);
            if (longHashNode2 != null) {
                longHashNode2.nextNode = longHashNode3;
            } else {
                longHashNodeArray[n2] = longHashNode3;
            }
            this.checkResize(null);
        }
        return r;
    }

    public Object remove(Object object) {
        long l = Casts.longCast(object);
        int n = LongHashMap.hash(l) & this.mask;
        LongHashNode longHashNode = null;
        LongHashNode longHashNode2 = this.data[n];
        while (longHashNode2 != null) {
            if (longHashNode2.k == l) {
                this.dec(longHashNode2);
                if (longHashNode != null) {
                    longHashNode.nextNode = longHashNode2.nextNode;
                } else {
                    this.data[n] = longHashNode2.nextNode;
                }
                return longHashNode2.getValue();
            }
            longHashNode = longHashNode2;
            longHashNode2 = longHashNode2.nextNode;
        }
        return null;
    }

    public Object reduce(IFn iFn, Object object) {
        int n = this.data.length;
        LongHashNode[] longHashNodeArray = this.data;
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = longHashNodeArray[i];
            while (longHashNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, (Object)longHashNode)))) {
                    return ((IDeref)object).deref();
                }
                longHashNode = longHashNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public Object kvreduce(IFn iFn, Object object) {
        int n = this.data.length;
        LongHashNode[] longHashNodeArray = this.data;
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = longHashNodeArray[i];
            while (longHashNode != null) {
                if (RT.isReduced((Object)(object = iFn.invoke(object, (Object)longHashNode.k, longHashNode.v)))) {
                    return ((IDeref)object).deref();
                }
                longHashNode = longHashNode.nextNode;
            }
        }
        return object;
    }

    @Override
    public Object parallelReduction(IFn iFn, IFn iFn2, IFn iFn3, ParallelOptions parallelOptions) {
        return Reductions.parallelCollectionReduction(iFn, iFn2, iFn3, this.entrySet(), parallelOptions);
    }

    public void replaceAll(BiFunction biFunction) {
        int n = this.data.length;
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = null;
            LongHashNode longHashNode2 = this.data[i];
            while (longHashNode2 != null) {
                Object r = biFunction.apply(longHashNode2.k, longHashNode2.v);
                if (r != null) {
                    longHashNode2.v = r;
                    longHashNode = longHashNode2;
                } else {
                    this.dec(longHashNode2);
                    if (longHashNode != null) {
                        longHashNode.nextNode = longHashNode2.nextNode;
                    } else {
                        this.data[i] = longHashNode2.nextNode;
                    }
                }
                longHashNode2 = longHashNode2.nextNode;
            }
        }
    }

    @Override
    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = IMap.super.keySet();
        }
        return this.keySet;
    }

    public static LongHashMap union(LongHashMap longHashMap, Map map, BiFunction biFunction) {
        LongHashNode[] longHashNodeArray = longHashMap.data;
        int n = longHashMap.mask;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            LongHashNode longHashNode;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            long l = Casts.longCast(entry2.getKey());
            int n2 = LongHashMap.hash(l);
            int n3 = n2 & n;
            LongHashNode longHashNode2 = longHashNode = longHashNodeArray[n3];
            while (longHashNode2 != null && longHashNode2.k != l) {
                if (LongHashMap.equals(longHashNode2.k, l)) break;
                longHashNode2 = longHashNode2.nextNode;
            }
            if (longHashNode2 != null) {
                longHashNodeArray[n3] = longHashNode.assoc(longHashMap, l, n2, biFunction.apply(longHashNode2.v, entry2.getValue()));
                continue;
            }
            longHashNodeArray[n3] = longHashNode != null ? longHashNode.assoc(longHashMap, l, n2, entry2.getValue()) : longHashMap.newNode(l, n2, entry2.getValue());
            longHashMap.checkResize(null);
            n = longHashMap.mask;
            longHashNodeArray = longHashMap.data;
        }
        return longHashMap;
    }

    @Override
    public LongHashMap union(Map map, BiFunction biFunction) {
        return LongHashMap.union(this, map, biFunction);
    }

    static LongHashMap intersection(LongHashMap longHashMap, Map map, BiFunction biFunction) {
        LongHashNode[] longHashNodeArray = longHashMap.data;
        int n = longHashNodeArray.length;
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = longHashNodeArray[i];
            while (longHashNode != null) {
                LongHashNode longHashNode2 = longHashNode;
                longHashNode = longHashNode.nextNode;
                Object v = map.get(longHashNode2.k);
                longHashNodeArray[i] = v != null ? longHashNodeArray[i].assoc(longHashMap, longHashNode2.k, longHashNode2.hashcode, biFunction.apply(longHashNode2.v, v)) : longHashNodeArray[i].dissoc(longHashMap, longHashNode2.k);
            }
        }
        return longHashMap;
    }

    @Override
    public LongHashMap intersection(Map map, BiFunction biFunction) {
        return LongHashMap.intersection(this, map, biFunction);
    }

    public static LongHashMap intersection(LongHashMap longHashMap, Set set) {
        LongHashNode[] longHashNodeArray = longHashMap.data;
        int n = longHashNodeArray.length;
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = longHashNodeArray[i];
            while (longHashNode != null) {
                LongHashNode longHashNode2 = longHashNode;
                long l = longHashNode2.k;
                longHashNode = longHashNode.nextNode;
                if (set.contains(l)) continue;
                longHashNodeArray[i] = longHashNodeArray[i].dissoc(longHashMap, l);
            }
        }
        return longHashMap;
    }

    @Override
    public LongHashMap intersection(Set set) {
        return LongHashMap.intersection(this, set);
    }

    static LongHashMap difference(LongHashMap longHashMap, Collection collection) {
        LongHashNode[] longHashNodeArray = longHashMap.data;
        int n = longHashMap.mask;
        for (Object e : collection) {
            long l = Casts.longCast(e);
            int n2 = LongHashMap.hash(l);
            int n3 = n2 & n;
            LongHashNode longHashNode = longHashNodeArray[n3];
            while (longHashNode != null && longHashNode.k != l) {
                longHashNode = longHashNode.nextNode;
            }
            if (longHashNode == null) continue;
            longHashNodeArray[n3] = longHashNodeArray[n3].dissoc(longHashMap, longHashNode.k);
        }
        return longHashMap;
    }

    @Override
    public LongHashMap difference(Collection collection) {
        return LongHashMap.difference(this, collection);
    }

    static LongHashMap updateValues(LongHashMap longHashMap, BiFunction biFunction) {
        LongHashNode[] longHashNodeArray = longHashMap.data;
        int n = longHashNodeArray.length;
        for (int i = 0; i < n; ++i) {
            LongHashNode longHashNode = longHashNodeArray[i];
            while (longHashNode != null) {
                LongHashNode longHashNode2 = longHashNode;
                longHashNode = longHashNode.nextNode;
                Object r = biFunction.apply(longHashNode2.k, longHashNode2.v);
                longHashNodeArray[i] = r == null ? longHashNodeArray[i].dissoc(longHashMap, longHashNode2.k) : longHashNodeArray[i].assoc(longHashMap, longHashNode2.k, longHashNode2.hashcode, r);
            }
        }
        return longHashMap;
    }

    @Override
    public LongHashMap updateValues(BiFunction biFunction) {
        return LongHashMap.updateValues(this, biFunction);
    }

    static LongHashMap updateValue(LongHashMap longHashMap, Object object, Function function) {
        long l = Casts.longCast(object);
        int n = LongHashMap.hash(l);
        int n2 = n & longHashMap.mask;
        LongHashNode[] longHashNodeArray = longHashMap.data;
        LongHashNode longHashNode = longHashNodeArray[n2];
        while (longHashNode != null && longHashNode.k != l) {
            longHashNode = longHashNode.nextNode;
        }
        Object r = longHashNode != null ? function.apply(longHashNode.v) : function.apply(null);
        LongHashNode longHashNode2 = longHashNodeArray[n2] = r == null ? longHashNodeArray[n2].dissoc(longHashMap, l) : longHashNodeArray[n2].assoc(longHashMap, l, n, r);
        if (r != null && longHashNode == null) {
            longHashMap.checkResize(null);
        }
        return longHashMap;
    }

    @Override
    public LongHashMap updateValue(Object object, Function function) {
        return this.updateValue(this, function);
    }

    @Override
    public Iterator iterator(Function<Map.Entry, Object> function) {
        return new LongHashBase.HTIter(this.data, function);
    }

    @Override
    public Spliterator spliterator(Function<Map.Entry, Object> function) {
        return new LongHashBase.HTSpliterator(this.data, this.length, function);
    }
}

